/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.content.IntentFilter;
import android.content.UriRelativeFilter;
import android.content.UriRelativeFilterGroup;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedIntentInfoUtils {
    private static final String TAG = "PackageParsing";
    public static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedIntentInfoImpl> parseIntentInfo(String className, ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean allowGlobs, boolean allowAutoVerify, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        ParsedIntentInfoImpl intentInfo = new ParsedIntentInfoImpl();
        IntentFilter intentFilter = intentInfo.getIntentFilter();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestIntentFilter);
        try {
            intentFilter.setPriority(sa.getInt(2, 0));
            intentFilter.setOrder(sa.getInt(3, 0));
            TypedValue v = sa.peekValue(0);
            if (v != null) {
                intentInfo.setLabelRes(v.resourceId);
                if (v.resourceId == 0) {
                    intentInfo.setNonLocalizedLabel(v.coerceToString());
                }
            }
            if (ParsingPackageUtils.sUseRoundIcon) {
                intentInfo.setIcon(sa.getResourceId(7, 0));
            }
            if (intentInfo.getIcon() == 0) {
                intentInfo.setIcon(sa.getResourceId(1, 0));
            }
            if (allowAutoVerify) {
                intentFilter.setAutoVerify(sa.getBoolean(6, false));
            }
        }
        finally {
            sa.recycle();
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedIntentInfo> result;
            String nodeName;
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            switch (nodeName = parser.getName()) {
                case "action": {
                    String value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                    if (value == null) {
                        result = input.error("No value supplied for <android:name>");
                        break;
                    }
                    if (value.isEmpty()) {
                        intentFilter.addAction(value);
                        result = input.deferError("No value supplied for <android:name>", 151163173L);
                        break;
                    }
                    intentFilter.addAction(value);
                    result = input.success(null);
                    break;
                }
                case "category": {
                    String value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                    if (value == null) {
                        result = input.error("No value supplied for <android:name>");
                        break;
                    }
                    if (value.isEmpty()) {
                        intentFilter.addCategory(value);
                        result = input.deferError("No value supplied for <android:name>", 151163173L);
                        break;
                    }
                    intentFilter.addCategory(value);
                    result = input.success(null);
                    break;
                }
                case "data": {
                    result = ParsedIntentInfoUtils.parseData(intentInfo, res, parser, allowGlobs, input);
                    break;
                }
                case "uri-relative-filter-group": {
                    if (Flags.relativeReferenceIntentFilters()) {
                        result = ParsedIntentInfoUtils.parseRelRefGroup(intentInfo, pkg, res, parser, allowGlobs, input);
                        break;
                    }
                }
                default: {
                    result = ParsingUtils.unknownTag("<intent-filter>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        intentInfo.setHasDefault(intentFilter.hasCategory("android.intent.category.DEFAULT"));
        return input.success(intentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
    private static ParseResult<ParsedIntentInfo> parseRelRefGroup(ParsedIntentInfo intentInfo, ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean allowGlobs, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        UriRelativeFilterGroup group;
        IntentFilter intentFilter = intentInfo.getIntentFilter();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUriRelativeFilterGroup);
        try {
            int action = 0;
            if (!sa.getBoolean(0, true)) {
                action = 1;
            }
            group = new UriRelativeFilterGroup(action);
        }
        finally {
            sa.recycle();
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedIntentInfo> result;
            String nodeName;
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            switch (nodeName = parser.getName()) {
                case "data": {
                    result = ParsedIntentInfoUtils.parseRelRefGroupData(group, res, parser, allowGlobs, input);
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<uri-relative-filter-group>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (group.getUriRelativeFilters().size() > 0) {
            intentFilter.addUriRelativeFilterGroup(group);
        }
        return input.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
    private static ParseResult<ParsedIntentInfo> parseRelRefGroupData(UriRelativeFilterGroup group, Resources res, XmlResourceParser parser, boolean allowGlobs, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestData);
        try {
            String str = sa.getNonConfigurationString(4, 0);
            if (str != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(0, 0, str));
            }
            if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(0, 1, str));
            }
            if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathPattern not allowed here; path must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(0, 2, str));
            }
            if ((str = sa.getNonConfigurationString(14, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathAdvancedPattern not allowed here; path must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(0, 3, str));
            }
            if ((str = sa.getNonConfigurationString(12, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(0, 4, str));
            }
            if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(2, 0, str));
            }
            if ((str = sa.getNonConfigurationString(21, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(2, 1, str));
            }
            if ((str = sa.getNonConfigurationString(22, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("fragmentPattern not allowed here; fragment must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(2, 2, str));
            }
            if ((str = sa.getNonConfigurationString(23, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("fragmentAdvancedPattern not allowed here; fragment must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(2, 3, str));
            }
            if ((str = sa.getNonConfigurationString(24, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(2, 4, str));
            }
            if ((str = sa.getNonConfigurationString(16, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(1, 0, str));
            }
            if ((str = sa.getNonConfigurationString(17, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(1, 1, str));
            }
            if ((str = sa.getNonConfigurationString(18, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("queryPattern not allowed here; query must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(1, 2, str));
            }
            if ((str = sa.getNonConfigurationString(19, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("queryAdvancedPattern not allowed here; query must be literal");
                    return parseResult;
                }
                group.addUriRelativeFilter(new UriRelativeFilter(1, 3, str));
            }
            if ((str = sa.getNonConfigurationString(20, 0)) != null) {
                group.addUriRelativeFilter(new UriRelativeFilter(1, 4, str));
            }
            ParseResult<Object> parseResult = input.success(null);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsedIntentInfo> parseData(ParsedIntentInfo intentInfo, Resources resources, XmlResourceParser parser, boolean allowGlobs, ParseInput input) {
        IntentFilter intentFilter = intentInfo.getIntentFilter();
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestData);
        try {
            String str = sa.getNonConfigurationString(0, 0);
            if (str != null) {
                try {
                    intentFilter.addDataType(str);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error(((Object)e).toString());
                    sa.recycle();
                    return parseResult;
                }
            }
            if ((str = sa.getNonConfigurationString(11, 0)) != null) {
                intentFilter.addMimeGroup(str);
            }
            if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                intentFilter.addDataScheme(str);
            }
            if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                intentFilter.addDataSchemeSpecificPart(str, 0);
            }
            if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                intentFilter.addDataSchemeSpecificPart(str, 1);
            }
            if ((str = sa.getNonConfigurationString(10, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> e = input.error("sspPattern not allowed here; ssp must be literal");
                    return e;
                }
                intentFilter.addDataSchemeSpecificPart(str, 2);
            }
            if ((str = sa.getNonConfigurationString(15, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> e = input.error("sspAdvancedPattern not allowed here; ssp must be literal");
                    return e;
                }
                intentFilter.addDataSchemeSpecificPart(str, 3);
            }
            if ((str = sa.getNonConfigurationString(13, 0)) != null) {
                intentFilter.addDataSchemeSpecificPart(str, 4);
            }
            String host = sa.getNonConfigurationString(2, 0);
            String port = sa.getNonConfigurationString(3, 0);
            if (host != null) {
                intentFilter.addDataAuthority(host, port);
            }
            if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                intentFilter.addDataPath(str, 0);
            }
            if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                intentFilter.addDataPath(str, 1);
            }
            if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathPattern not allowed here; path must be literal");
                    return parseResult;
                }
                intentFilter.addDataPath(str, 2);
            }
            if ((str = sa.getNonConfigurationString(14, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathAdvancedPattern not allowed here; path must be literal");
                    return parseResult;
                }
                intentFilter.addDataPath(str, 3);
            }
            if ((str = sa.getNonConfigurationString(12, 0)) != null) {
                intentFilter.addDataPath(str, 4);
            }
            ParseResult<Object> parseResult = input.success(null);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }
}

