/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import com.android.internal.pm.pkg.component.ParsedMainComponentImpl;
import com.android.internal.pm.pkg.component.ParsedService;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ParsedServiceImpl
extends ParsedMainComponentImpl
implements ParsedService,
Parcelable {
    private int foregroundServiceType;
    @Nullable
    private String permission;
    @NonNull
    public static final Parcelable.Creator<ParsedServiceImpl> CREATOR = new Parcelable.Creator<ParsedServiceImpl>(){

        @Override
        public ParsedServiceImpl createFromParcel(Parcel source) {
            return new ParsedServiceImpl(source);
        }

        public ParsedServiceImpl[] newArray(int size) {
            return new ParsedServiceImpl[size];
        }
    };

    public ParsedServiceImpl(ParsedServiceImpl other) {
        super(other);
        this.foregroundServiceType = other.foregroundServiceType;
        this.permission = other.permission;
    }

    public ParsedMainComponent setPermission(String permission2) {
        this.permission = TextUtils.isEmpty(permission2) ? null : permission2.intern();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Service{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.foregroundServiceType);
        PackageImpl.sForInternedString.parcel(this.permission, dest, flags);
    }

    public ParsedServiceImpl() {
    }

    protected ParsedServiceImpl(Parcel in) {
        super(in);
        this.foregroundServiceType = in.readInt();
        this.permission = PackageImpl.sForInternedString.unparcel(in);
    }

    public ParsedServiceImpl(int foregroundServiceType, @Nullable String permission2) {
        this.foregroundServiceType = foregroundServiceType;
        this.permission = permission2;
    }

    @Override
    public int getForegroundServiceType() {
        return this.foregroundServiceType;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @NonNull
    public ParsedServiceImpl setForegroundServiceType(int value) {
        this.foregroundServiceType = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

