/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.WindowConfiguration;
import android.app.jank.AppJankStats;
import android.app.jank.JankTracker;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.InputQueue;
import android.view.InsetsState;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.PendingInsetsController;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewRootImpl;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowCallbacks;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.window.DesktopModeFlags;
import com.android.internal.graphics.drawable.BackgroundBlurDrawable;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.policy.DecorContext;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.policy.WearGestureInterceptionDetector;
import com.android.internal.view.FloatingActionMode;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.StandaloneActionMode;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.BackgroundFallback;
import com.android.internal.widget.floatingtoolbar.FloatingToolbar;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DecorView
extends FrameLayout
implements RootViewSurfaceTaker,
WindowCallbacks {
    private static final String TAG = "DecorView";
    private static final boolean DEBUG_MEASURE = false;
    private static final boolean SWEEP_OPEN_MENU = false;
    public static final int DECOR_SHADOW_FOCUSED_HEIGHT_IN_DIP = 20;
    public static final int DECOR_SHADOW_UNFOCUSED_HEIGHT_IN_DIP = 5;
    private static final int SCRIM_LIGHT = -419430401;
    private static final int SCRIM_ALPHA = -872415232;
    public static final ColorViewAttributes STATUS_BAR_COLOR_VIEW_ATTRIBUTES = new ColorViewAttributes(0x4000000, 48, 3, 5, "android:status:background", 16908335, WindowInsets.Type.statusBars());
    public static final ColorViewAttributes NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES = new ColorViewAttributes(0x8000000, 80, 5, 3, "android:navigation:background", 16908336, WindowInsets.Type.navigationBars());
    private static final ViewOutlineProvider PIP_OUTLINE_PROVIDER = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view, Outline outline) {
            outline.setRect(0, 0, view.getWidth(), view.getHeight());
            outline.setAlpha(1.0f);
        }
    };
    private boolean mAllowUpdateElevation = false;
    private boolean mElevationAdjustedForStack = false;
    private boolean mIsInPictureInPictureMode;
    private ViewOutlineProvider mLastOutlineProvider;
    int mDefaultOpacity = -1;
    private final int mFeatureId;
    private final Rect mDrawingBounds = new Rect();
    private final Rect mBackgroundPadding = new Rect();
    private final Rect mFramePadding = new Rect();
    private final Rect mFrameOffsets = new Rect();
    private boolean mChanging;
    private Drawable mMenuBackground;
    private boolean mWatchingForMenu;
    private int mDownY;
    ActionMode mPrimaryActionMode;
    private ActionMode mFloatingActionMode;
    private ActionBarContextView mPrimaryActionModeView;
    private int mActionModeViewInternalPaddingLeft;
    private int mActionModeViewInternalPaddingTop;
    private int mActionModeViewInternalPaddingRight;
    private int mActionModeViewInternalPaddingBottom;
    private PopupWindow mPrimaryActionModePopup;
    private Runnable mShowPrimaryActionModePopup;
    private ViewTreeObserver.OnPreDrawListener mFloatingToolbarPreDrawListener;
    private View mFloatingActionModeOriginatingView;
    private FloatingToolbar mFloatingToolbar;
    private ObjectAnimator mFadeAnim;
    private View mStatusGuard;
    private final ColorViewState mStatusColorViewState = new ColorViewState(STATUS_BAR_COLOR_VIEW_ATTRIBUTES);
    private final ColorViewState mNavigationColorViewState = new ColorViewState(NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES);
    private final Interpolator mShowInterpolator;
    private final Interpolator mHideInterpolator;
    private final int mBarEnterExitDuration;
    final boolean mForceWindowDrawsBarBackgrounds;
    private final int mSemiTransparentBarColor;
    private final BackgroundFallback mBackgroundFallback = new BackgroundFallback();
    private int mLastTopInset = 0;
    @UnsupportedAppUsage
    private int mLastBottomInset = 0;
    @UnsupportedAppUsage
    private int mLastRightInset = 0;
    @UnsupportedAppUsage
    private int mLastLeftInset = 0;
    private WindowInsets mLastInsets = null;
    private boolean mLastHasTopStableInset = false;
    private boolean mLastHasBottomStableInset = false;
    private boolean mLastHasRightStableInset = false;
    private boolean mLastHasLeftStableInset = false;
    private int mLastWindowFlags = 0;
    private int mLastForceConsumingTypes = 0;
    private boolean mLastForceConsumingOpaqueCaptionBar = false;
    private int mLastSuppressScrimTypes = 0;
    private int mRootScrollY = 0;
    @UnsupportedAppUsage
    private PhoneWindow mWindow;
    ViewGroup mContentRoot;
    private Rect mTempRect;
    private boolean mWindowResizeCallbacksAdded = false;
    private Drawable mOriginalBackgroundDrawable;
    private Drawable mLastOriginalBackgroundDrawable;
    private BackgroundBlurDrawable mBackgroundBlurDrawable;
    private BackgroundBlurDrawable mLastBackgroundBlurDrawable;
    @Nullable
    private Drawable mPendingWindowBackground;
    String mLogTag = "DecorView";
    private final Rect mFloatingInsets = new Rect();
    private boolean mApplyFloatingVerticalInsets = false;
    private boolean mApplyFloatingHorizontalInsets = false;
    private final Paint mLegacyNavigationBarBackgroundPaint = new Paint();
    private Insets mBackgroundInsets = Insets.NONE;
    private Insets mLastBackgroundInsets = Insets.NONE;
    private boolean mDrawLegacyNavigationBarBackground;
    private boolean mDrawLegacyNavigationBarBackgroundHandled;
    private PendingInsetsController mPendingInsetsController = new PendingInsetsController();
    private int mOriginalBackgroundBlurRadius = 0;
    private int mBackgroundBlurRadius = 0;
    private boolean mCrossWindowBlurEnabled;
    private final ViewTreeObserver.OnPreDrawListener mBackgroundBlurOnPreDrawListener = () -> {
        this.updateBackgroundBlurCorners();
        return true;
    };
    private Consumer<Boolean> mCrossWindowBlurEnabledListener;
    private final WearGestureInterceptionDetector mWearGestureInterceptionDetector;
    @Nullable
    private AppJankStatsCallback mAppJankStatsCallback;

    DecorView(Context context, int featureId, PhoneWindow window, WindowManager.LayoutParams params) {
        super(context);
        this.mFeatureId = featureId;
        this.mShowInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mHideInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mBarEnterExitDuration = context.getResources().getInteger(17695129);
        this.mForceWindowDrawsBarBackgrounds = context.getResources().getBoolean(17891767) && params.type != 2011 && context.getApplicationInfo().targetSdkVersion >= 24;
        this.mSemiTransparentBarColor = context.getResources().getColor(17171414, null);
        this.setWindow(window);
        this.updateLogTag(params);
        this.mLegacyNavigationBarBackgroundPaint.setColor(-16777216);
        this.mWearGestureInterceptionDetector = WearGestureInterceptionDetector.isEnabled(context) ? new WearGestureInterceptionDetector(context, this) : null;
    }

    void setBackgroundFallback(@Nullable Drawable fallbackDrawable) {
        this.mBackgroundFallback.setDrawable(fallbackDrawable);
        this.setWillNotDraw(this.getBackground() == null && !this.mBackgroundFallback.hasFallback());
    }

    @Nullable
    public Drawable getBackgroundFallback() {
        return this.mBackgroundFallback.getDrawable();
    }

    @Nullable
    View getStatusBarBackgroundView() {
        return this.mStatusColorViewState.view;
    }

    @Nullable
    View getNavigationBarBackgroundView() {
        return this.mNavigationColorViewState.view;
    }

    @Override
    public void onDraw(Canvas c) {
        super.onDraw(c);
        this.mBackgroundFallback.draw(this, this.mContentRoot, c, this.mWindow.mContentParent, this.mStatusColorViewState.view, this.mNavigationColorViewState.view);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean isDown;
        int keyCode = event.getKeyCode();
        int action = event.getAction();
        boolean bl = isDown = action == 0;
        if (isDown && event.getRepeatCount() == 0) {
            boolean handled;
            if (this.mWindow.mPanelChordingKey > 0 && this.mWindow.mPanelChordingKey != keyCode && (handled = this.dispatchKeyShortcutEvent(event))) {
                return true;
            }
            if (this.mWindow.mPreparedPanel != null && this.mWindow.mPreparedPanel.isOpen && this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, keyCode, event, 0)) {
                return true;
            }
        }
        if (!this.mWindow.isDestroyed()) {
            boolean handled;
            Window.Callback cb = this.mWindow.getCallback();
            boolean bl2 = handled = cb != null && this.mFeatureId < 0 ? cb.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
            if (handled) {
                return true;
            }
        }
        return isDown ? this.mWindow.onKeyDown(this.mFeatureId, event.getKeyCode(), event) : this.mWindow.onKeyUp(this.mFeatureId, event.getKeyCode(), event);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent ev) {
        boolean handled;
        if (this.mWindow.mPreparedPanel != null && (handled = this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
            if (this.mWindow.mPreparedPanel != null) {
                this.mWindow.mPreparedPanel.isHandled = true;
            }
            return true;
        }
        Window.Callback cb = this.mWindow.getCallback();
        boolean bl = handled = cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchKeyShortcutEvent(ev) : super.dispatchKeyShortcutEvent(ev);
        if (handled) {
            return true;
        }
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        if (st != null && this.mWindow.mPreparedPanel == null) {
            this.mWindow.preparePanel(st, ev);
            handled = this.mWindow.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
            st.isPrepared = false;
            if (handled) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.interceptBackProgress(ev)) {
            return true;
        }
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTouchEvent(ev) : super.dispatchTouchEvent(ev);
    }

    private boolean interceptBackProgress(MotionEvent ev) {
        if (!Flags.interceptMotionFromMoveToCancel()) {
            return false;
        }
        ViewRootImpl viewRootImpl = this.getViewRootImpl();
        if (viewRootImpl == null) {
            return false;
        }
        viewRootImpl.getOnBackInvokedDispatcher().onMotionEvent(ev);
        if (!viewRootImpl.getOnBackInvokedDispatcher().isBackGestureInProgress()) {
            return false;
        }
        if (!viewRootImpl.getOnBackInvokedDispatcher().isInterceptedMotionEvent()) {
            viewRootImpl.getOnBackInvokedDispatcher().setMotionEventIntercepted();
            ev.setAction(3);
            return false;
        }
        return true;
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTrackballEvent(ev) : super.dispatchTrackballEvent(ev);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchGenericMotionEvent(ev) : super.dispatchGenericMotionEvent(ev);
    }

    public boolean superDispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4) {
            int action = event.getAction();
            if (this.mPrimaryActionMode != null) {
                if (action == 1) {
                    this.mPrimaryActionMode.finish();
                }
                return true;
            }
        }
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        return this.getViewRootImpl() != null && this.getViewRootImpl().dispatchUnhandledKeyEvent(event);
    }

    public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
        return super.dispatchKeyShortcutEvent(event);
    }

    public boolean superDispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    public boolean superDispatchTrackballEvent(MotionEvent event) {
        return super.dispatchTrackballEvent(event);
    }

    public boolean superDispatchGenericMotionEvent(MotionEvent event) {
        return super.dispatchGenericMotionEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.onInterceptTouchEvent(event);
    }

    private boolean isOutOfInnerBounds(int x, int y) {
        return x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight();
    }

    private boolean isOutOfBounds(int x, int y) {
        return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        int y;
        int x;
        int action = event.getAction();
        if (this.mFeatureId >= 0 && action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
            this.mWindow.closePanel(this.mFeatureId);
            return true;
        }
        ViewRootImpl viewRootImpl = this.getViewRootImpl();
        if (!Flags.interceptMotionFromMoveToCancel() && viewRootImpl != null) {
            viewRootImpl.getOnBackInvokedDispatcher().onMotionEvent(event);
            if (viewRootImpl.getOnBackInvokedDispatcher().isBackGestureInProgress()) {
                return true;
            }
        }
        if (viewRootImpl != null && this.mWearGestureInterceptionDetector != null) {
            boolean intercepting;
            boolean wasIntercepting = this.mWearGestureInterceptionDetector.isIntercepting();
            if (wasIntercepting != (intercepting = this.mWearGestureInterceptionDetector.onInterceptTouchEvent(event))) {
                viewRootImpl.updateDecorViewGestureInterception(intercepting);
            }
            if (intercepting) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        if ((this.mFeatureId == 0 || this.mFeatureId == 6 || this.mFeatureId == 2 || this.mFeatureId == 5) && this.getChildCount() == 1) {
            this.getChildAt(0).sendAccessibilityEvent(eventType);
        } else {
            super.sendAccessibilityEvent(eventType);
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && cb.dispatchPopulateAccessibilityEvent(event)) {
            return true;
        }
        return super.dispatchPopulateAccessibilityEventInternal(event);
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        if (changed) {
            Drawable bg;
            Rect drawingBounds = this.mDrawingBounds;
            this.getDrawingRect(drawingBounds);
            Drawable fg = this.getForeground();
            if (fg != null) {
                Rect frameOffsets = this.mFrameOffsets;
                drawingBounds.left += frameOffsets.left;
                drawingBounds.top += frameOffsets.top;
                drawingBounds.right -= frameOffsets.right;
                drawingBounds.bottom -= frameOffsets.bottom;
                fg.setBounds(drawingBounds);
                Rect framePadding = this.mFramePadding;
                drawingBounds.left += framePadding.left - frameOffsets.left;
                drawingBounds.top += framePadding.top - frameOffsets.top;
                drawingBounds.right -= framePadding.right - frameOffsets.right;
                drawingBounds.bottom -= framePadding.bottom - frameOffsets.bottom;
            }
            if ((bg = super.getBackground()) != null) {
                bg.setBounds(drawingBounds);
            }
        }
        return changed;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Resources res = this.getContext().getResources();
        DisplayMetrics metrics = res.getDisplayMetrics();
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean fixedWidth = false;
        this.mApplyFloatingHorizontalInsets = false;
        if (widthMode == Integer.MIN_VALUE) {
            TypedValue tvw;
            TypedValue typedValue = tvw = isPortrait ? this.mWindow.mFixedWidthMinor : this.mWindow.mFixedWidthMajor;
            if (tvw != null && tvw.type != 0) {
                int w = tvw.type == 5 ? (int)tvw.getDimension(metrics) : (tvw.type == 6 ? (int)tvw.getFraction(metrics.widthPixels, metrics.widthPixels) : 0);
                int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
                if (w > 0) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(w, widthSize), 0x40000000);
                    fixedWidth = true;
                } else {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(widthSize - this.mFloatingInsets.left - this.mFloatingInsets.right, Integer.MIN_VALUE);
                    this.mApplyFloatingHorizontalInsets = true;
                }
            }
        }
        this.mApplyFloatingVerticalInsets = false;
        if (heightMode == Integer.MIN_VALUE) {
            TypedValue tvh;
            TypedValue typedValue = tvh = isPortrait ? this.mWindow.mFixedHeightMajor : this.mWindow.mFixedHeightMinor;
            if (tvh != null && tvh.type != 0) {
                int h = tvh.type == 5 ? (int)tvh.getDimension(metrics) : (tvh.type == 6 ? (int)tvh.getFraction(metrics.heightPixels, metrics.heightPixels) : 0);
                int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
                if (h > 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(h, heightSize), 0x40000000);
                } else if ((this.mWindow.getAttributes().flags & 0x100) == 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(heightSize - this.mFloatingInsets.top - this.mFloatingInsets.bottom, Integer.MIN_VALUE);
                    this.mApplyFloatingVerticalInsets = true;
                }
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
            int min;
            TypedValue tv = isPortrait ? this.mWindow.mMinWidthMinor : this.mWindow.mMinWidthMajor;
            float availableWidth = TypedValue.applyDimension(1, res.getConfiguration().screenWidthDp, metrics);
            if (tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction(availableWidth, availableWidth) : 0))) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(min, 0x40000000);
                measure = true;
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mApplyFloatingVerticalInsets) {
            this.offsetTopAndBottom(this.mFloatingInsets.top);
        }
        if (this.mApplyFloatingHorizontalInsets) {
            this.offsetLeftAndRight(this.mFloatingInsets.left);
        }
        this.updateElevation();
        this.mAllowUpdateElevation = true;
        if (changed && this.mDrawLegacyNavigationBarBackground) {
            this.getViewRootImpl().requestInvalidateRootRenderNode();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mMenuBackground != null) {
            this.mMenuBackground.draw(canvas);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return this.showContextMenuForChildInternal(originalView, Float.NaN, Float.NaN);
    }

    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        return this.showContextMenuForChildInternal(originalView, x, y);
    }

    private boolean showContextMenuForChildInternal(View originalView, float x, float y) {
        if (this.mWindow.mContextMenuHelper != null) {
            this.mWindow.mContextMenuHelper.dismiss();
            this.mWindow.mContextMenuHelper = null;
        }
        PhoneWindow.PhoneWindowMenuCallback callback = this.mWindow.mContextMenuCallback;
        if (this.mWindow.mContextMenu == null) {
            this.mWindow.mContextMenu = new ContextMenuBuilder(this.getContext());
            this.mWindow.mContextMenu.setCallback(callback);
        } else {
            this.mWindow.mContextMenu.clearAll();
        }
        boolean isPopup = !Float.isNaN(x) && !Float.isNaN(y);
        MenuHelper helper = isPopup ? this.mWindow.mContextMenu.showPopup(originalView.getContext(), originalView, x, y) : this.mWindow.mContextMenu.showDialog(originalView, originalView.getWindowToken());
        if (helper != null) {
            callback.setShowDialogForSubmenu(!isPopup);
            helper.setPresenterCallback(callback);
        }
        this.mWindow.mContextMenuHelper = helper;
        return helper != null;
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return this.startActionModeForChild(originalView, callback, 0);
    }

    @Override
    public ActionMode startActionModeForChild(View child, ActionMode.Callback callback, int type) {
        return this.startActionMode(child, callback, type);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.startActionMode(callback, 0);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        return this.startActionMode(this, callback, type);
    }

    private ActionMode startActionMode(View originatingView, ActionMode.Callback callback, int type) {
        ActionMode mode;
        ActionModeCallback2Wrapper wrappedCallback;
        block16: {
            wrappedCallback = new ActionModeCallback2Wrapper(callback);
            mode = null;
            if (this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
                try {
                    mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback, type);
                }
                catch (AbstractMethodError ame) {
                    if (type != 0) break block16;
                    try {
                        mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
            }
        }
        if (mode != null) {
            if (mode.getType() == 0) {
                this.cleanupPrimaryActionMode();
                this.mPrimaryActionMode = mode;
            } else if (mode.getType() == 1) {
                if (this.mFloatingActionMode != null) {
                    this.mFloatingActionMode.finish();
                }
                this.mFloatingActionMode = mode;
            }
        } else {
            mode = this.createActionMode(type, wrappedCallback, originatingView);
            if (mode != null && wrappedCallback.onCreateActionMode(mode, mode.getMenu())) {
                this.setHandledActionMode(mode);
            } else {
                mode = null;
            }
        }
        if (mode != null && this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
            try {
                this.mWindow.getCallback().onActionModeStarted(mode);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return mode;
    }

    private void cleanupPrimaryActionMode() {
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.finish();
            this.mPrimaryActionMode = null;
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
        }
    }

    private void cleanupFloatingActionModeViews() {
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        if (this.mFloatingActionModeOriginatingView != null) {
            if (this.mFloatingToolbarPreDrawListener != null) {
                this.mFloatingActionModeOriginatingView.getViewTreeObserver().removeOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
                this.mFloatingToolbarPreDrawListener = null;
            }
            this.mFloatingActionModeOriginatingView = null;
        }
    }

    void startChanging() {
        this.mChanging = true;
    }

    void finishChanging() {
        this.mChanging = false;
        this.drawableChanged();
    }

    public void setWindowBackground(Drawable drawable2) {
        if (this.mWindow == null) {
            this.mPendingWindowBackground = drawable2;
            return;
        }
        if (this.mOriginalBackgroundDrawable != drawable2) {
            this.mOriginalBackgroundDrawable = drawable2;
            this.updateBackgroundDrawable();
            if (this.mWindow.mEdgeToEdgeEnforced && !this.mWindow.mNavigationBarColorSpecified && drawable2 instanceof ColorDrawable) {
                int color2 = ((ColorDrawable)drawable2).getColor();
                boolean lightBar = Color.valueOf(color2).luminance() > 0.5f;
                this.getWindowInsetsController().setSystemBarsAppearance(lightBar ? 512 : 0, 512);
                this.mWindow.mNavigationBarColor = color2;
                this.updateColorViews(null, false);
            }
            if (drawable2 != null) {
                drawable2.getPadding(this.mBackgroundPadding);
            } else if (this.mWindow.mBackgroundDrawable != null) {
                this.mWindow.mBackgroundDrawable.getPadding(this.mBackgroundPadding);
            } else if (this.mWindow.mBackgroundFallbackDrawable != null) {
                this.mWindow.mBackgroundFallbackDrawable.getPadding(this.mBackgroundPadding);
            } else {
                this.mBackgroundPadding.setEmpty();
            }
            if (!View.sBrokenWindowBackground) {
                this.drawableChanged();
            }
        }
    }

    @Override
    public void setBackgroundDrawable(Drawable background) {
        this.setWindowBackground(background);
    }

    public void setWindowFrame(Drawable drawable2) {
        if (this.getForeground() != drawable2) {
            this.setForeground(drawable2);
            if (drawable2 != null) {
                drawable2.getPadding(this.mFramePadding);
            } else {
                this.mFramePadding.setEmpty();
            }
            this.drawableChanged();
        }
    }

    @Override
    public void onWindowSystemUiVisibilityChanged(int visible) {
        this.updateColorViews(null, true);
        if (!Flags.actionModeEdgeToEdge() && this.mStatusGuard != null && this.mStatusGuard.getVisibility() == 0) {
            this.updateStatusGuardColor();
        }
    }

    @Override
    public void onSystemBarAppearanceChanged(int appearance) {
        this.updateColorViews(null, true);
        if (this.mWindow != null) {
            this.mWindow.dispatchOnSystemBarAppearanceChanged(appearance);
        }
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        this.mFloatingInsets.setEmpty();
        if ((attrs.flags & 0x100) == 0) {
            if (attrs.height == -2) {
                this.mFloatingInsets.top = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.bottom = insets.getSystemWindowInsetBottom();
                insets = insets.inset(0, insets.getSystemWindowInsetTop(), 0, insets.getSystemWindowInsetBottom());
            }
            if (this.mWindow.getAttributes().width == -2) {
                this.mFloatingInsets.left = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.right = insets.getSystemWindowInsetBottom();
                insets = insets.inset(insets.getSystemWindowInsetLeft(), 0, insets.getSystemWindowInsetRight(), 0);
            }
        }
        this.mFrameOffsets.set(insets.getSystemWindowInsetsAsRect());
        insets = this.updateColorViews(insets, true);
        insets = this.updateActionModeInsets(insets);
        if (this.getForeground() != null) {
            this.drawableChanged();
        }
        return insets;
    }

    @Override
    public boolean isTransitionGroup() {
        return false;
    }

    public static boolean isNavBarToRightEdge(int bottomInset, int rightInset) {
        return bottomInset == 0 && rightInset > 0;
    }

    public static boolean isNavBarToLeftEdge(int bottomInset, int leftInset) {
        return bottomInset == 0 && leftInset > 0;
    }

    public static int getNavBarSize(int bottomInset, int rightInset, int leftInset) {
        return DecorView.isNavBarToRightEdge(bottomInset, rightInset) ? rightInset : (DecorView.isNavBarToLeftEdge(bottomInset, leftInset) ? leftInset : bottomInset);
    }

    public static void getNavigationBarRect(int canvasWidth, int canvasHeight, Rect systemBarInsets, Rect outRect, float scale) {
        int bottomInset = (int)((float)systemBarInsets.bottom * scale);
        int leftInset = (int)((float)systemBarInsets.left * scale);
        int rightInset = (int)((float)systemBarInsets.right * scale);
        int size = DecorView.getNavBarSize(bottomInset, rightInset, leftInset);
        if (DecorView.isNavBarToRightEdge(bottomInset, rightInset)) {
            outRect.set(canvasWidth - size, 0, canvasWidth, canvasHeight);
        } else if (DecorView.isNavBarToLeftEdge(bottomInset, leftInset)) {
            outRect.set(0, 0, size, canvasHeight);
        } else {
            outRect.set(0, canvasHeight - size, canvasWidth, canvasHeight);
        }
    }

    WindowInsets updateColorViews(WindowInsets insets, boolean animate) {
        Insets consumedInsets;
        boolean consumingOpaqueCaptionBar;
        boolean hideStatusBar;
        boolean consumingNavBar;
        boolean isImeWindow;
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        int sysUiVisibility = attrs.systemUiVisibility | this.getWindowSystemUiVisibility();
        ViewRootImpl viewRoot = this.getViewRootImpl();
        WindowInsetsController controller = this.getWindowInsetsController();
        int requestedVisibleTypes = controller.getRequestedVisibleTypes();
        int appearance = viewRoot != null ? viewRoot.mWindowAttributes.insetsFlags.appearance : controller.getSystemBarsAppearance();
        boolean bl = isImeWindow = this.mWindow.getAttributes().type == 2011;
        if (!this.mWindow.mIsFloating || isImeWindow) {
            boolean statusBarNeedsLeftInset;
            boolean disallowAnimate = !this.isLaidOut();
            disallowAnimate |= ((this.mLastWindowFlags ^ attrs.flags) & Integer.MIN_VALUE) != 0;
            this.mLastWindowFlags = attrs.flags;
            if (insets != null) {
                this.mLastInsets = insets;
                this.mLastForceConsumingTypes = insets.getForceConsumingTypes();
                this.mLastForceConsumingOpaqueCaptionBar = insets.isForceConsumingOpaqueCaptionBar();
                boolean clearsCompatInsets = InsetsState.clearsCompatInsets(attrs.type, attrs.flags, this.getResources().getConfiguration().windowConfiguration.getActivityType(), this.mLastForceConsumingTypes);
                int compatInsetsTypes = WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout();
                Insets stableBarInsets = insets.getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
                Insets systemInsets = clearsCompatInsets ? Insets.NONE : Insets.min(insets.getInsets(compatInsetsTypes), stableBarInsets);
                this.mLastTopInset = systemInsets.top;
                this.mLastBottomInset = systemInsets.bottom;
                this.mLastRightInset = systemInsets.right;
                this.mLastLeftInset = systemInsets.left;
                boolean hasTopStableInset = stableBarInsets.top != 0;
                disallowAnimate |= hasTopStableInset != this.mLastHasTopStableInset;
                this.mLastHasTopStableInset = hasTopStableInset;
                boolean hasBottomStableInset = stableBarInsets.bottom != 0;
                disallowAnimate |= hasBottomStableInset != this.mLastHasBottomStableInset;
                this.mLastHasBottomStableInset = hasBottomStableInset;
                boolean hasRightStableInset = stableBarInsets.right != 0;
                disallowAnimate |= hasRightStableInset != this.mLastHasRightStableInset;
                this.mLastHasRightStableInset = hasRightStableInset;
                boolean hasLeftStableInset = stableBarInsets.left != 0;
                disallowAnimate |= hasLeftStableInset != this.mLastHasLeftStableInset;
                this.mLastHasLeftStableInset = hasLeftStableInset;
                this.mLastSuppressScrimTypes = insets.getSuppressScrimTypes();
            }
            boolean navBarToRightEdge = DecorView.isNavBarToRightEdge(this.mLastBottomInset, this.mLastRightInset);
            boolean navBarToLeftEdge = DecorView.isNavBarToLeftEdge(this.mLastBottomInset, this.mLastLeftInset);
            int navBarSize = DecorView.getNavBarSize(this.mLastBottomInset, this.mLastRightInset, this.mLastLeftInset);
            this.updateColorViewInt(this.mNavigationColorViewState, this.calculateNavigationBarColor(appearance), this.mWindow.mNavigationBarDividerColor, navBarSize, navBarToRightEdge || navBarToLeftEdge, navBarToLeftEdge, 0, animate && !disallowAnimate, this.mForceWindowDrawsBarBackgrounds, requestedVisibleTypes);
            boolean oldDrawLegacy = this.mDrawLegacyNavigationBarBackground;
            boolean bl2 = this.mDrawLegacyNavigationBarBackground = ((requestedVisibleTypes | this.mLastForceConsumingTypes) & WindowInsets.Type.navigationBars()) != 0 && (this.mWindow.getAttributes().flags & Integer.MIN_VALUE) == 0 && navBarSize > 0;
            if (oldDrawLegacy != this.mDrawLegacyNavigationBarBackground) {
                this.mDrawLegacyNavigationBarBackgroundHandled = this.mWindow.onDrawLegacyNavigationBarBackgroundChanged(this.mDrawLegacyNavigationBarBackground);
                if (viewRoot != null) {
                    viewRoot.requestInvalidateRootRenderNode();
                }
            }
            boolean statusBarNeedsRightInset = navBarToRightEdge && this.mNavigationColorViewState.present;
            boolean bl3 = statusBarNeedsLeftInset = navBarToLeftEdge && this.mNavigationColorViewState.present;
            int statusBarSideInset = statusBarNeedsRightInset ? this.mLastRightInset : (statusBarNeedsLeftInset ? this.mLastLeftInset : 0);
            int statusBarColor = this.calculateStatusBarColor(appearance);
            this.updateColorViewInt(this.mStatusColorViewState, statusBarColor, 0, this.mLastTopInset, false, statusBarNeedsLeftInset, statusBarSideInset, animate && !disallowAnimate, this.mForceWindowDrawsBarBackgrounds, requestedVisibleTypes);
        }
        int consumingTypes = 0;
        boolean hideNavigation = (sysUiVisibility & 2) != 0 || (requestedVisibleTypes & WindowInsets.Type.navigationBars()) == 0;
        boolean decorFitsSystemWindows = this.mWindow.mDecorFitsSystemWindows;
        boolean fitsNavBar = (sysUiVisibility & 0x200) == 0 && decorFitsSystemWindows && !hideNavigation;
        boolean forceConsumingNavBar = (this.mForceWindowDrawsBarBackgrounds || this.mDrawLegacyNavigationBarBackgroundHandled) && (attrs.flags & Integer.MIN_VALUE) == 0 && fitsNavBar || (this.mLastForceConsumingTypes & WindowInsets.Type.navigationBars()) != 0 && hideNavigation;
        boolean bl4 = consumingNavBar = (attrs.flags & Integer.MIN_VALUE) != 0 && fitsNavBar || forceConsumingNavBar;
        if (consumingNavBar) {
            consumingTypes |= WindowInsets.Type.navigationBars();
        }
        boolean fullscreen = (sysUiVisibility & 4) != 0 || (attrs.flags & 0x400) != 0;
        boolean bl5 = hideStatusBar = fullscreen || (requestedVisibleTypes & WindowInsets.Type.statusBars()) == 0;
        if ((sysUiVisibility & 0x400) == 0 && decorFitsSystemWindows && (attrs.flags & 0x100) == 0 && (attrs.flags & 0x10000) == 0 && this.mForceWindowDrawsBarBackgrounds && this.mLastTopInset != 0 || (this.mLastForceConsumingTypes & WindowInsets.Type.statusBars()) != 0 && hideStatusBar) {
            consumingTypes |= WindowInsets.Type.statusBars();
        }
        boolean hideCaptionBar = fullscreen || (requestedVisibleTypes & WindowInsets.Type.captionBar()) == 0;
        boolean consumingCaptionBar = DesktopModeFlags.ENABLE_CAPTION_COMPAT_INSET_FORCE_CONSUMPTION.isTrue() && (this.mLastForceConsumingTypes & WindowInsets.Type.captionBar()) != 0 && hideCaptionBar;
        boolean isOpaqueCaptionBar = com.android.internal.hidden_from_bootclasspath.android.view.flags.Flags.customizableWindowHeaders() && (appearance & 0x80) == 0;
        boolean bl6 = consumingOpaqueCaptionBar = DesktopModeFlags.ENABLE_CAPTION_COMPAT_INSET_FORCE_CONSUMPTION_ALWAYS.isTrue() && this.mLastForceConsumingOpaqueCaptionBar && isOpaqueCaptionBar;
        if (consumingCaptionBar || consumingOpaqueCaptionBar) {
            consumingTypes |= WindowInsets.Type.captionBar();
        }
        Insets insets2 = consumedInsets = this.mLastInsets != null ? this.mLastInsets.getInsets(consumingTypes) : Insets.NONE;
        if (this.mContentRoot != null && this.mContentRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mContentRoot.getLayoutParams();
            if (lp.topMargin != consumedInsets.top || lp.rightMargin != consumedInsets.right || lp.bottomMargin != consumedInsets.bottom || lp.leftMargin != consumedInsets.left) {
                lp.topMargin = consumedInsets.top;
                lp.rightMargin = consumedInsets.right;
                lp.bottomMargin = consumedInsets.bottom;
                lp.leftMargin = consumedInsets.left;
                this.mContentRoot.setLayoutParams(lp);
                if (insets == null) {
                    this.requestApplyInsets();
                }
            }
            if (insets != null && !Insets.NONE.equals(consumedInsets)) {
                insets = insets.inset(consumedInsets);
            }
        }
        this.mBackgroundInsets = forceConsumingNavBar && !hideNavigation && !this.mDrawLegacyNavigationBarBackgroundHandled ? Insets.of(this.mLastLeftInset, 0, this.mLastRightInset, this.mLastBottomInset) : Insets.NONE;
        this.updateBackgroundDrawable();
        return insets;
    }

    private void updateBackgroundDrawable() {
        if (this.mBackgroundInsets == null) {
            this.mBackgroundInsets = Insets.NONE;
        }
        if (this.mBackgroundInsets.equals(this.mLastBackgroundInsets) && this.mBackgroundBlurDrawable == this.mLastBackgroundBlurDrawable && this.mLastOriginalBackgroundDrawable == this.mOriginalBackgroundDrawable) {
            return;
        }
        Drawable destDrawable = this.mOriginalBackgroundDrawable;
        if (this.mBackgroundBlurDrawable != null) {
            destDrawable = new LayerDrawable(new Drawable[]{this.mBackgroundBlurDrawable, this.mOriginalBackgroundDrawable});
        }
        if (destDrawable != null && !this.mBackgroundInsets.equals(Insets.NONE)) {
            destDrawable = new InsetDrawable(this, destDrawable, this.mBackgroundInsets.left, this.mBackgroundInsets.top, this.mBackgroundInsets.right, this.mBackgroundInsets.bottom){

                @Override
                public boolean getPadding(Rect padding) {
                    return this.getDrawable().getPadding(padding);
                }
            };
        }
        super.setBackgroundDrawable(destDrawable);
        this.mLastBackgroundInsets = this.mBackgroundInsets;
        this.mLastBackgroundBlurDrawable = this.mBackgroundBlurDrawable;
        this.mLastOriginalBackgroundDrawable = this.mOriginalBackgroundDrawable;
    }

    private void updateBackgroundBlurCorners() {
        if (this.mBackgroundBlurDrawable == null) {
            return;
        }
        float cornerRadius = 0.0f;
        if (this.mBackgroundBlurRadius != 0 && this.mOriginalBackgroundDrawable != null) {
            Outline outline = new Outline();
            this.mOriginalBackgroundDrawable.getOutline(outline);
            cornerRadius = outline.mMode == 1 ? outline.getRadius() : 0.0f;
        }
        this.mBackgroundBlurDrawable.setCornerRadius(cornerRadius);
    }

    private void updateBackgroundBlurRadius() {
        if (this.getViewRootImpl() == null) {
            return;
        }
        int n = this.mBackgroundBlurRadius = this.mCrossWindowBlurEnabled && this.mWindow.isTranslucent() ? this.mOriginalBackgroundBlurRadius : 0;
        if (this.mBackgroundBlurDrawable == null && this.mBackgroundBlurRadius > 0) {
            this.mBackgroundBlurDrawable = this.getViewRootImpl().createBackgroundBlurDrawable();
            this.updateBackgroundDrawable();
        }
        if (this.mBackgroundBlurDrawable != null) {
            this.mBackgroundBlurDrawable.setBlurRadius(this.mBackgroundBlurRadius);
        }
    }

    void setBackgroundBlurRadius(int blurRadius) {
        this.mOriginalBackgroundBlurRadius = blurRadius;
        if (blurRadius > 0) {
            if (this.mCrossWindowBlurEnabledListener == null) {
                this.mCrossWindowBlurEnabledListener = enabled -> {
                    this.mCrossWindowBlurEnabled = enabled;
                    this.updateBackgroundBlurRadius();
                };
                Executor executor = Looper.myLooper() == Looper.getMainLooper() ? this.getContext().getMainExecutor() : new HandlerExecutor(new Handler(Looper.myLooper()));
                this.getContext().getSystemService(WindowManager.class).addCrossWindowBlurEnabledListener(executor, this.mCrossWindowBlurEnabledListener);
                this.getViewTreeObserver().addOnPreDrawListener(this.mBackgroundBlurOnPreDrawListener);
            } else {
                this.updateBackgroundBlurRadius();
            }
        } else if (this.mCrossWindowBlurEnabledListener != null) {
            this.updateBackgroundBlurRadius();
            this.removeBackgroundBlurDrawable();
        }
    }

    void removeBackgroundBlurDrawable() {
        if (this.mCrossWindowBlurEnabledListener != null) {
            this.getContext().getSystemService(WindowManager.class).removeCrossWindowBlurEnabledListener(this.mCrossWindowBlurEnabledListener);
            this.mCrossWindowBlurEnabledListener = null;
        }
        this.getViewTreeObserver().removeOnPreDrawListener(this.mBackgroundBlurOnPreDrawListener);
        this.mBackgroundBlurDrawable = null;
        this.updateBackgroundDrawable();
    }

    @Override
    public Drawable getBackground() {
        return this.mOriginalBackgroundDrawable;
    }

    private int calculateStatusBarColor(int appearance) {
        return DecorView.calculateBarColor(this.mWindow.getAttributes().flags, 0x4000000, this.mSemiTransparentBarColor, this.mWindow.mStatusBarColor, appearance, 8, this.mWindow.mEnsureStatusBarContrastWhenTransparent && (this.mLastSuppressScrimTypes & WindowInsets.Type.statusBars()) == 0, false);
    }

    private int calculateNavigationBarColor(int appearance) {
        return DecorView.calculateBarColor(this.mWindow.getAttributes().flags, 0x8000000, this.mSemiTransparentBarColor, this.mWindow.mNavigationBarColor, appearance, 16, this.mWindow.mEnsureNavigationBarContrastWhenTransparent && (this.mLastSuppressScrimTypes & WindowInsets.Type.navigationBars()) == 0, this.mWindow.mEdgeToEdgeEnforced);
    }

    public static int calculateBarColor(int flags, int translucentFlag, int semiTransparentBarColor, int barColor, int appearance, int lightAppearanceFlag, boolean ensuresContrast, boolean movesBarColorToScrim) {
        if ((flags & translucentFlag) != 0) {
            return semiTransparentBarColor;
        }
        if ((flags & Integer.MIN_VALUE) == 0) {
            return -16777216;
        }
        if (ensuresContrast) {
            int alpha = Color.alpha(barColor);
            if (alpha == 0) {
                boolean light = (appearance & lightAppearanceFlag) != 0;
                return light ? -419430401 : semiTransparentBarColor;
            }
            if (movesBarColorToScrim) {
                return barColor & 0xFFFFFF | 0xCC000000;
            }
        } else if (movesBarColorToScrim) {
            return 0;
        }
        return barColor;
    }

    private int getCurrentColor(ColorViewState state) {
        if (state.visible) {
            return state.color;
        }
        return 0;
    }

    private void updateColorViewInt(final ColorViewState state, int color2, int dividerColor, int size, boolean verticalBar, boolean seascape, int sideMargin, boolean animate, boolean force, int requestedVisibleTypes) {
        int resolvedGravity;
        int resolvedWidth;
        int type = state.attributes.insetsType;
        state.present = state.attributes.isPresent((requestedVisibleTypes & type) != 0 || (this.mLastForceConsumingTypes & type) != 0, this.mWindow.getAttributes().flags, force);
        boolean show = state.attributes.isVisible(state.present, color2, this.mWindow.getAttributes().flags, force);
        boolean showView = show && size > 0;
        boolean visibilityChanged = false;
        View view = state.view;
        int resolvedHeight = verticalBar ? -1 : size;
        int n = resolvedWidth = verticalBar ? size : -1;
        int n2 = verticalBar ? (seascape ? state.attributes.seascapeGravity : state.attributes.horizontalGravity) : (resolvedGravity = state.attributes.verticalGravity);
        if (view == null) {
            if (showView) {
                state.view = view = new View(this.mContext);
                DecorView.setColor(view, color2, dividerColor, verticalBar, seascape);
                view.setTransitionName(state.attributes.transitionName);
                view.setId(state.attributes.id);
                visibilityChanged = true;
                view.setVisibility(4);
                state.targetVisibility = 0;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(resolvedWidth, resolvedHeight, resolvedGravity);
                if (seascape) {
                    lp.leftMargin = sideMargin;
                } else {
                    lp.rightMargin = sideMargin;
                }
                this.addView(view, lp);
                this.updateColorViewTranslations();
            }
        } else {
            int leftMargin;
            int vis = showView ? 0 : 4;
            visibilityChanged = state.targetVisibility != vis;
            state.targetVisibility = vis;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
            int rightMargin = seascape ? 0 : sideMargin;
            int n3 = leftMargin = seascape ? sideMargin : 0;
            if (lp.height != resolvedHeight || lp.width != resolvedWidth || lp.gravity != resolvedGravity || lp.rightMargin != rightMargin || lp.leftMargin != leftMargin) {
                lp.height = resolvedHeight;
                lp.width = resolvedWidth;
                lp.gravity = resolvedGravity;
                lp.rightMargin = rightMargin;
                lp.leftMargin = leftMargin;
                view.setLayoutParams(lp);
            }
            if (showView) {
                DecorView.setColor(view, color2, dividerColor, verticalBar, seascape);
            }
        }
        if (visibilityChanged) {
            view.animate().cancel();
            if (animate) {
                if (showView) {
                    if (view.getVisibility() != 0) {
                        view.setVisibility(0);
                        view.setAlpha(0.0f);
                    }
                    view.animate().alpha(1.0f).setInterpolator(this.mShowInterpolator).setDuration(this.mBarEnterExitDuration);
                } else {
                    view.animate().alpha(0.0f).setInterpolator(this.mHideInterpolator).setDuration(this.mBarEnterExitDuration).withEndAction(new Runnable(){

                        @Override
                        public void run() {
                            state.view.setAlpha(1.0f);
                            state.view.setVisibility(4);
                        }
                    });
                }
            } else {
                view.setAlpha(1.0f);
                view.setVisibility(showView ? 0 : 4);
            }
        }
        state.visible = show;
        state.color = color2;
    }

    private static void setColor(View v, int color2, int dividerColor, boolean verticalBar, boolean seascape) {
        if (dividerColor != 0) {
            Pair dir = (Pair)v.getTag();
            if (dir == null || (Boolean)dir.first != verticalBar || (Boolean)dir.second != seascape) {
                int size = Math.round(TypedValue.applyDimension(1, 1.0f, v.getContext().getResources().getDisplayMetrics()));
                InsetDrawable d = new InsetDrawable((Drawable)new ColorDrawable(color2), verticalBar && !seascape ? size : 0, !verticalBar ? size : 0, verticalBar && seascape ? size : 0, 0);
                v.setBackground(new LayerDrawable(new Drawable[]{new ColorDrawable(dividerColor), d}));
                v.setTag(new Pair<Boolean, Boolean>(verticalBar, seascape));
            } else {
                LayerDrawable d = (LayerDrawable)v.getBackground();
                InsetDrawable inset = (InsetDrawable)d.getDrawable(1);
                ((ColorDrawable)inset.getDrawable()).setColor(color2);
                ((ColorDrawable)d.getDrawable(0)).setColor(dividerColor);
            }
        } else {
            v.setTag(null);
            v.setBackgroundColor(color2);
        }
    }

    private void updateColorViewTranslations() {
        int rootScrollY = this.mRootScrollY;
        if (this.mStatusColorViewState.view != null) {
            this.mStatusColorViewState.view.setTranslationY(rootScrollY > 0 ? (float)rootScrollY : 0.0f);
        }
        if (this.mNavigationColorViewState.view != null) {
            this.mNavigationColorViewState.view.setTranslationY(rootScrollY < 0 ? (float)rootScrollY : 0.0f);
        }
    }

    private WindowInsets updateActionModeInsets(WindowInsets insets) {
        boolean showStatusGuard = false;
        if (this.mPrimaryActionModeView != null && this.mPrimaryActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mPrimaryActionModeView.getLayoutParams();
            boolean mlpChanged = false;
            if (this.mPrimaryActionModeView.isShown()) {
                boolean nonOverlay;
                boolean consumesSystemWindowInsetsTop;
                if (this.mTempRect == null) {
                    this.mTempRect = new Rect();
                }
                Rect rect = this.mTempRect;
                WindowInsets innerInsets = this.mWindow.mContentParent.computeSystemWindowInsets(insets, rect);
                if (Flags.actionModeEdgeToEdge()) {
                    Insets systemWindowInsets = innerInsets.getSystemWindowInsets();
                    Insets newMargin = innerInsets.getInsets(WindowInsets.Type.navigationBars());
                    if (mlp.leftMargin != newMargin.left || mlp.rightMargin != newMargin.right) {
                        mlpChanged = true;
                        mlp.leftMargin = newMargin.left;
                        mlp.rightMargin = newMargin.right;
                    }
                    this.mPrimaryActionModeView.setPadding(this.mActionModeViewInternalPaddingLeft + systemWindowInsets.left - newMargin.left, this.mActionModeViewInternalPaddingTop + systemWindowInsets.top, this.mActionModeViewInternalPaddingRight + systemWindowInsets.right - newMargin.right, this.mActionModeViewInternalPaddingBottom);
                    consumesSystemWindowInsetsTop = systemWindowInsets.top > 0;
                } else {
                    int newTopMargin = innerInsets.getSystemWindowInsetTop();
                    int newLeftMargin = innerInsets.getSystemWindowInsetLeft();
                    int newRightMargin = innerInsets.getSystemWindowInsetRight();
                    WindowInsets rootInsets = this.getRootWindowInsets();
                    int newGuardLeftMargin = rootInsets.getSystemWindowInsetLeft();
                    int newGuardRightMargin = rootInsets.getSystemWindowInsetRight();
                    if (mlp.topMargin != newTopMargin || mlp.leftMargin != newLeftMargin || mlp.rightMargin != newRightMargin) {
                        mlpChanged = true;
                        mlp.topMargin = newTopMargin;
                        mlp.leftMargin = newLeftMargin;
                        mlp.rightMargin = newRightMargin;
                    }
                    if (newTopMargin > 0 && this.mStatusGuard == null) {
                        this.mStatusGuard = new View(this.mContext);
                        this.mStatusGuard.setVisibility(8);
                        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, mlp.topMargin, 51);
                        lp.leftMargin = newGuardLeftMargin;
                        lp.rightMargin = newGuardRightMargin;
                        this.addView(this.mStatusGuard, this.indexOfChild(this.mStatusColorViewState.view), lp);
                    } else if (this.mStatusGuard != null) {
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mStatusGuard.getLayoutParams();
                        if (lp.height != mlp.topMargin || lp.leftMargin != newGuardLeftMargin || lp.rightMargin != newGuardRightMargin) {
                            lp.height = mlp.topMargin;
                            lp.leftMargin = newGuardLeftMargin;
                            lp.rightMargin = newGuardRightMargin;
                            this.mStatusGuard.setLayoutParams(lp);
                        }
                    }
                    boolean bl = showStatusGuard = this.mStatusGuard != null;
                    if (showStatusGuard && this.mStatusGuard.getVisibility() != 0) {
                        this.updateStatusGuardColor();
                    }
                    consumesSystemWindowInsetsTop = showStatusGuard;
                }
                boolean bl = nonOverlay = (this.mWindow.getLocalFeaturesPrivate() & 0x400) == 0;
                if (nonOverlay && consumesSystemWindowInsetsTop) {
                    insets = insets.inset(0, insets.getSystemWindowInsetTop(), 0, 0);
                }
            } else if (!(Flags.actionModeEdgeToEdge() || mlp.topMargin == 0 && mlp.leftMargin == 0 && mlp.rightMargin == 0)) {
                mlpChanged = true;
                mlp.topMargin = 0;
            }
            if (mlpChanged) {
                this.mPrimaryActionModeView.setLayoutParams(mlp);
            }
        }
        if (!Flags.actionModeEdgeToEdge() && this.mStatusGuard != null) {
            this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
        }
        return insets;
    }

    private void updateStatusGuardColor() {
        boolean lightStatusBar = (this.getWindowSystemUiVisibility() & 0x2000) != 0;
        this.mStatusGuard.setBackgroundColor(lightStatusBar ? this.mContext.getColor(17170985) : this.mContext.getColor(17170984));
    }

    public void updatePictureInPictureOutlineProvider(boolean isInPictureInPictureMode) {
        if (this.mIsInPictureInPictureMode == isInPictureInPictureMode) {
            return;
        }
        if (isInPictureInPictureMode) {
            Window.WindowControllerCallback callback = this.mWindow.getWindowControllerCallback();
            if (callback != null && callback.isTaskRoot()) {
                super.setOutlineProvider(PIP_OUTLINE_PROVIDER);
            }
        } else if (this.getOutlineProvider() != this.mLastOutlineProvider) {
            this.setOutlineProvider(this.mLastOutlineProvider);
        }
        this.mIsInPictureInPictureMode = isInPictureInPictureMode;
    }

    @Override
    public void setOutlineProvider(ViewOutlineProvider provider) {
        super.setOutlineProvider(provider);
        this.mLastOutlineProvider = provider;
    }

    private void drawableChanged() {
        if (this.mChanging) {
            return;
        }
        Rect framePadding = this.mFramePadding != null ? this.mFramePadding : new Rect();
        Rect backgroundPadding = this.mBackgroundPadding != null ? this.mBackgroundPadding : new Rect();
        this.setPadding(framePadding.left + backgroundPadding.left, framePadding.top + backgroundPadding.top, framePadding.right + backgroundPadding.right, framePadding.bottom + backgroundPadding.bottom);
        this.requestLayout();
        this.invalidate();
        int opacity = -1;
        WindowConfiguration winConfig = this.getResources().getConfiguration().windowConfiguration;
        boolean renderShadowsInCompositor = this.mWindow.mRenderShadowsInCompositor;
        if (winConfig.hasWindowShadow() && !renderShadowsInCompositor) {
            opacity = -3;
        } else {
            Drawable bg = this.getBackground();
            Drawable fg = this.getForeground();
            if (bg != null) {
                if (fg == null) {
                    opacity = bg.getOpacity();
                } else if (framePadding.left <= 0 && framePadding.top <= 0 && framePadding.right <= 0 && framePadding.bottom <= 0) {
                    int fop = fg.getOpacity();
                    int bop = bg.getOpacity();
                    opacity = fop == -1 || bop == -1 ? -1 : (fop == 0 ? bop : (bop == 0 ? fop : Drawable.resolveOpacity(fop, bop)));
                } else {
                    opacity = -3;
                }
            }
        }
        this.mDefaultOpacity = opacity;
        if (this.mFeatureId < 0) {
            this.mWindow.setDefaultWindowFormat(opacity);
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        Window.Callback cb;
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mWindow.hasFeature(0) && !hasWindowFocus && this.mWindow.mPanelChordingKey != 0) {
            this.mWindow.closePanel(0);
        }
        if ((cb = this.mWindow.getCallback()) != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        this.updateElevation();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onAttachedToWindow();
        }
        if (this.mFeatureId == -1) {
            this.mWindow.openPanelsAfterRestore();
        }
        if (!this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().addWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = true;
        }
        this.updateBackgroundBlurRadius();
        this.mWindow.onViewRootImplSet(this.getViewRootImpl());
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && this.mFeatureId < 0) {
            cb.onDetachedFromWindow();
        }
        if (this.mWindow.mDecorContentParent != null) {
            this.mWindow.mDecorContentParent.dismissPopups();
        }
        if (this.mPrimaryActionModePopup != null) {
            this.removeCallbacks(this.mShowPrimaryActionModePopup);
            if (this.mPrimaryActionModePopup.isShowing()) {
                this.mPrimaryActionModePopup.dismiss();
            }
            this.mPrimaryActionModePopup = null;
        }
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        this.removeBackgroundBlurDrawable();
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        if (st != null && st.menu != null && this.mFeatureId < 0) {
            st.menu.close();
        }
        if (this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().removeWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = false;
        }
        this.mPendingInsetsController.detach();
    }

    @Override
    public void onCloseSystemDialogs(String reason) {
        if (this.mFeatureId >= 0) {
            this.mWindow.closeAllPanels();
        }
    }

    @Override
    public SurfaceHolder.Callback2 willYouTakeTheSurface() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeSurfaceCallback : null;
    }

    @Override
    public InputQueue.Callback willYouTakeTheInputQueue() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeInputQueueCallback : null;
    }

    @Override
    public void setSurfaceType(int type) {
        this.mWindow.setType(type);
    }

    @Override
    public void setSurfaceFormat(int format) {
        this.mWindow.setFormat(format);
    }

    @Override
    public void setSurfaceKeepScreenOn(boolean keepOn) {
        if (keepOn) {
            this.mWindow.addFlags(128);
        } else {
            this.mWindow.clearFlags(128);
        }
    }

    @Override
    public void onRootViewScrollYChanged(int rootScrollY) {
        this.mRootScrollY = rootScrollY;
        this.updateColorViewTranslations();
    }

    @Override
    public PendingInsetsController providePendingInsetsController() {
        return this.mPendingInsetsController;
    }

    private ActionMode createActionMode(int type, ActionMode.Callback2 callback, View originatingView) {
        switch (type) {
            default: {
                return this.createStandaloneActionMode(callback);
            }
            case 1: 
        }
        return this.createFloatingActionMode(originatingView, callback);
    }

    private void setHandledActionMode(ActionMode mode) {
        if (mode.getType() == 0) {
            this.setHandledPrimaryActionMode(mode);
        } else if (mode.getType() == 1) {
            this.setHandledFloatingActionMode(mode);
        }
    }

    private ActionMode createStandaloneActionMode(ActionMode.Callback callback) {
        this.endOnGoingFadeAnimation();
        this.cleanupPrimaryActionMode();
        if (this.mPrimaryActionModeView == null || !this.mPrimaryActionModeView.isAttachedToWindow()) {
            if (this.mWindow.isFloating()) {
                Context actionBarContext;
                TypedValue outValue = new TypedValue();
                Resources.Theme baseTheme = this.mContext.getTheme();
                baseTheme.resolveAttribute(16843825, outValue, true);
                if (outValue.resourceId != 0) {
                    Resources.Theme actionBarTheme = this.mContext.getResources().newTheme();
                    actionBarTheme.setTo(baseTheme);
                    actionBarTheme.applyStyle(outValue.resourceId, true);
                    actionBarContext = new ContextThemeWrapper(this.mContext, 0);
                    actionBarContext.getTheme().setTo(actionBarTheme);
                } else {
                    actionBarContext = this.mContext;
                }
                this.mPrimaryActionModeView = new ActionBarContextView(actionBarContext);
                this.initializeActionModeViewInternalPadding();
                this.mPrimaryActionModePopup = new PopupWindow(actionBarContext, null, 17956872);
                this.mPrimaryActionModePopup.setWindowLayoutType(2);
                this.mPrimaryActionModePopup.setContentView(this.mPrimaryActionModeView);
                this.mPrimaryActionModePopup.setWidth(-1);
                actionBarContext.getTheme().resolveAttribute(16843499, outValue, true);
                int height = TypedValue.complexToDimensionPixelSize(outValue.data, actionBarContext.getResources().getDisplayMetrics());
                this.mPrimaryActionModeView.setContentHeight(height);
                this.mPrimaryActionModePopup.setHeight(-2);
                this.mShowPrimaryActionModePopup = new Runnable(){

                    @Override
                    public void run() {
                        DecorView.this.mPrimaryActionModePopup.showAtLocation(DecorView.this.mPrimaryActionModeView.getApplicationWindowToken(), 55, 0, 0);
                        DecorView.this.endOnGoingFadeAnimation();
                        if (DecorView.this.shouldAnimatePrimaryActionModeView()) {
                            DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
                            DecorView.this.mFadeAnim.addListener(new AnimatorListenerAdapter(){

                                @Override
                                public void onAnimationStart(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setVisibility(0);
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                                    DecorView.this.mFadeAnim = null;
                                }
                            });
                            DecorView.this.mFadeAnim.start();
                        } else {
                            DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                            DecorView.this.mPrimaryActionModeView.setVisibility(0);
                        }
                    }
                };
            } else {
                ViewStub stub = (ViewStub)this.findViewById(16908784);
                if (stub != null) {
                    this.mPrimaryActionModeView = (ActionBarContextView)stub.inflate();
                    this.initializeActionModeViewInternalPadding();
                    this.mPrimaryActionModePopup = null;
                }
            }
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
            StandaloneActionMode mode = new StandaloneActionMode(this.mPrimaryActionModeView.getContext(), this.mPrimaryActionModeView, callback, this.mPrimaryActionModePopup == null);
            return mode;
        }
        return null;
    }

    private void initializeActionModeViewInternalPadding() {
        this.mActionModeViewInternalPaddingLeft = this.mPrimaryActionModeView.getPaddingLeft();
        this.mActionModeViewInternalPaddingTop = this.mPrimaryActionModeView.getPaddingTop();
        this.mActionModeViewInternalPaddingRight = this.mPrimaryActionModeView.getPaddingRight();
        this.mActionModeViewInternalPaddingBottom = this.mPrimaryActionModeView.getPaddingBottom();
    }

    private void endOnGoingFadeAnimation() {
        if (this.mFadeAnim != null) {
            this.mFadeAnim.end();
        }
    }

    private void setHandledPrimaryActionMode(ActionMode mode) {
        this.endOnGoingFadeAnimation();
        this.mPrimaryActionMode = mode;
        this.mPrimaryActionMode.invalidate();
        this.mPrimaryActionModeView.initForMode(this.mPrimaryActionMode);
        if (this.mPrimaryActionModePopup != null) {
            this.post(this.mShowPrimaryActionModePopup);
        } else if (this.shouldAnimatePrimaryActionModeView()) {
            this.mFadeAnim = ObjectAnimator.ofFloat(this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
            this.mFadeAnim.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    DecorView.this.mPrimaryActionModeView.setVisibility(0);
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                    DecorView.this.mFadeAnim = null;
                }
            });
            this.mFadeAnim.start();
        } else {
            this.mPrimaryActionModeView.setAlpha(1.0f);
            this.mPrimaryActionModeView.setVisibility(0);
        }
        this.mPrimaryActionModeView.sendAccessibilityEvent(32);
    }

    boolean shouldAnimatePrimaryActionModeView() {
        return this.isLaidOut();
    }

    private ActionMode createFloatingActionMode(View originatingView, ActionMode.Callback2 callback) {
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.finish();
        }
        this.cleanupFloatingActionModeViews();
        this.mFloatingToolbar = new FloatingToolbar(this.mWindow);
        final FloatingActionMode mode = new FloatingActionMode(this.mContext, callback, originatingView, this.mFloatingToolbar);
        this.mFloatingActionModeOriginatingView = originatingView;
        this.mFloatingToolbarPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                mode.updateViewLocationInWindow();
                return true;
            }
        };
        return mode;
    }

    private void setHandledFloatingActionMode(ActionMode mode) {
        this.mFloatingActionMode = mode;
        this.mFloatingActionMode.invalidate();
        this.mFloatingActionModeOriginatingView.getViewTreeObserver().addOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
    }

    void setWindow(PhoneWindow phoneWindow) {
        this.mWindow = phoneWindow;
        Context context = this.getContext();
        if (context instanceof DecorContext) {
            DecorContext decorContext = (DecorContext)context;
            decorContext.setPhoneWindow(this.mWindow);
        }
        if (this.mPendingWindowBackground != null) {
            Drawable background = this.mPendingWindowBackground;
            this.mPendingWindowBackground = null;
            this.setWindowBackground(background);
        }
    }

    @Override
    public Resources getResources() {
        return this.getContext().getResources();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.initializeElevation();
        ViewRootImpl viewRootImpl = this.getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.getOnBackInvokedDispatcher().onConfigurationChanged(newConfig);
        }
    }

    @Override
    public void onMovedToDisplay(int displayId, Configuration config) {
        super.onMovedToDisplay(displayId, config);
        this.getContext().updateDisplay(displayId);
    }

    private boolean isFillingScreen(Configuration config) {
        boolean isFullscreen = config.windowConfiguration.getWindowingMode() == 1;
        return isFullscreen && 0 != ((this.getWindowSystemUiVisibility() | this.getSystemUiVisibility()) & 4);
    }

    void onResourcesLoaded(LayoutInflater inflater, int layoutResource) {
        View root = inflater.inflate(layoutResource, null);
        this.addView(root, 0, new ViewGroup.LayoutParams(-1, -1));
        this.mContentRoot = (ViewGroup)root;
        this.initializeElevation();
    }

    void clearContentView() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View v = this.getChildAt(i);
            if (v == this.mStatusColorViewState.view || v == this.mNavigationColorViewState.view || !Flags.actionModeEdgeToEdge() && v == this.mStatusGuard) continue;
            this.removeViewAt(i);
        }
    }

    @Override
    public void onWindowSizeIsChanging(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
    }

    @Override
    public void onWindowDragResizeStart(Rect initialBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        if (this.mWindow.isDestroyed()) {
            return;
        }
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    @Override
    public void onWindowDragResizeEnd() {
        this.updateColorViews(null, false);
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    @Override
    public boolean onContentDrawn(int offsetX, int offsetY, int sizeX, int sizeY) {
        return false;
    }

    @Override
    public void onRequestDraw(boolean reportNextDraw) {
        if (!reportNextDraw) {
            return;
        }
        if (this.isAttachedToWindow()) {
            this.getViewRootImpl().reportDrawFinish();
        }
    }

    @Override
    public void onPostDraw(RecordingCanvas canvas) {
        this.drawLegacyNavigationBarBackground(canvas);
    }

    private void drawLegacyNavigationBarBackground(RecordingCanvas canvas) {
        if (!this.mDrawLegacyNavigationBarBackground || this.mDrawLegacyNavigationBarBackgroundHandled) {
            return;
        }
        View v = this.mNavigationColorViewState.view;
        if (v == null) {
            return;
        }
        canvas.drawRect(v.getLeft(), v.getTop(), v.getRight(), v.getBottom(), this.mLegacyNavigationBarBackgroundPaint);
    }

    private void initializeElevation() {
        this.mAllowUpdateElevation = false;
        this.updateElevation();
    }

    private void updateElevation() {
        int windowingMode = this.getResources().getConfiguration().windowConfiguration.getWindowingMode();
        boolean renderShadowsInCompositor = this.mWindow.mRenderShadowsInCompositor;
        if (renderShadowsInCompositor) {
            return;
        }
        float elevation = 0.0f;
        boolean wasAdjustedForStack = this.mElevationAdjustedForStack;
        if (windowingMode == 5) {
            float f = elevation = this.hasWindowFocus() ? 20.0f : 5.0f;
            if (!this.mAllowUpdateElevation) {
                elevation = 20.0f;
            }
            elevation = this.dipToPx(elevation);
            this.mElevationAdjustedForStack = true;
        } else {
            this.mElevationAdjustedForStack = false;
        }
        if ((wasAdjustedForStack || this.mElevationAdjustedForStack) && this.getElevation() != elevation) {
            this.mWindow.setElevation(elevation);
        }
    }

    private float dipToPx(float dip) {
        return TypedValue.applyDimension(1, dip, this.getResources().getDisplayMetrics());
    }

    private static String getTitleSuffix(WindowManager.LayoutParams params) {
        if (params == null) {
            return "";
        }
        String[] split = params.getTitle().toString().split("\\.");
        if (split.length > 0) {
            return split[split.length - 1];
        }
        return "";
    }

    void updateLogTag(WindowManager.LayoutParams params) {
        this.mLogTag = "DecorView[" + DecorView.getTitleSuffix(params) + "]";
    }

    @Override
    public void requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int deviceId) {
        MenuBuilder menu2;
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        MenuBuilder menuBuilder = menu2 = st != null ? st.menu : null;
        if (!this.mWindow.isDestroyed() && this.mWindow.getCallback() != null) {
            this.mWindow.getCallback().onProvideKeyboardShortcuts(list, menu2, deviceId);
        }
    }

    @Override
    public void dispatchPointerCaptureChanged(boolean hasCapture) {
        super.dispatchPointerCaptureChanged(hasCapture);
        if (!this.mWindow.isDestroyed() && this.mWindow.getCallback() != null) {
            this.mWindow.getCallback().onPointerCaptureChanged(hasCapture);
        }
    }

    @Override
    public int getAccessibilityViewId() {
        return 0x7FFFFFFE;
    }

    @Override
    public WindowInsetsController getWindowInsetsController() {
        if (this.isAttachedToWindow()) {
            return super.getWindowInsetsController();
        }
        return this.mPendingInsetsController;
    }

    public void setAppJankStatsCallback(AppJankStatsCallback jankStatsReportedCallback) {
        this.mAppJankStatsCallback = jankStatsReportedCallback;
    }

    @Override
    @FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
    public void reportAppJankStats(@NonNull AppJankStats appJankStats) {
        JankTracker jankTracker;
        if (this.mAppJankStatsCallback != null && (jankTracker = this.mAppJankStatsCallback.getAppJankTracker()) != null) {
            jankTracker.mergeAppJankStats(appJankStats);
        }
    }

    @Override
    @Nullable
    public JankTracker getJankTracker() {
        if (this.mAppJankStatsCallback != null) {
            return this.mAppJankStatsCallback.getAppJankTracker();
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + DecorView.getTitleSuffix(this.mWindow.getAttributes()) + "]";
    }

    private static class ColorViewState {
        View view = null;
        int targetVisibility = 4;
        boolean present = false;
        boolean visible;
        int color;
        final ColorViewAttributes attributes;

        ColorViewState(ColorViewAttributes attributes) {
            this.attributes = attributes;
        }
    }

    public static class ColorViewAttributes {
        final int id;
        final int translucentFlag;
        final int verticalGravity;
        final int horizontalGravity;
        final int seascapeGravity;
        final String transitionName;
        final int insetsType;

        private ColorViewAttributes(int translucentFlag, int verticalGravity, int horizontalGravity, int seascapeGravity, String transitionName, int id2, int insetsType) {
            this.id = id2;
            this.translucentFlag = translucentFlag;
            this.verticalGravity = verticalGravity;
            this.horizontalGravity = horizontalGravity;
            this.seascapeGravity = seascapeGravity;
            this.transitionName = transitionName;
            this.insetsType = insetsType;
        }

        public boolean isPresent(boolean requestedVisible, int windowFlags, boolean force) {
            return requestedVisible && ((windowFlags & Integer.MIN_VALUE) != 0 || force);
        }

        public boolean isVisible(boolean present, int color2, int windowFlags, boolean force) {
            return present && Color.alpha(color2) != 0 && ((windowFlags & this.translucentFlag) == 0 || force);
        }

        public boolean isVisible(int requestedVisibleTypes, int color2, int windowFlags, boolean force) {
            boolean requestedVisible = (requestedVisibleTypes & this.insetsType) != 0;
            boolean present = this.isPresent(requestedVisible, windowFlags, force);
            return this.isVisible(present, color2, windowFlags, force);
        }
    }

    private class ActionModeCallback2Wrapper
    extends ActionMode.Callback2 {
        private final ActionMode.Callback mWrapped;

        public ActionModeCallback2Wrapper(ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onCreateActionMode(mode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            DecorView.this.requestFitSystemWindows();
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            boolean isFloating;
            boolean isPrimary;
            boolean isMncApp;
            this.mWrapped.onDestroyActionMode(mode);
            boolean bl = isMncApp = ((DecorView)DecorView.this).mContext.getApplicationInfo().targetSdkVersion >= 23;
            if (isMncApp) {
                isPrimary = mode == DecorView.this.mPrimaryActionMode;
                boolean bl2 = isFloating = mode == DecorView.this.mFloatingActionMode;
                if (!isPrimary && mode.getType() == 0) {
                    Log.e(DecorView.this.mLogTag, "Destroying unexpected ActionMode instance of TYPE_PRIMARY; " + mode + " was not the current primary action mode! Expected " + DecorView.this.mPrimaryActionMode);
                }
                if (!isFloating && mode.getType() == 1) {
                    Log.e(DecorView.this.mLogTag, "Destroying unexpected ActionMode instance of TYPE_FLOATING; " + mode + " was not the current floating action mode! Expected " + DecorView.this.mFloatingActionMode);
                }
            } else {
                isPrimary = mode.getType() == 0;
                boolean bl3 = isFloating = mode.getType() == 1;
            }
            if (isPrimary) {
                if (DecorView.this.mPrimaryActionModePopup != null) {
                    DecorView.this.removeCallbacks(DecorView.this.mShowPrimaryActionModePopup);
                }
                if (DecorView.this.mPrimaryActionModeView != null) {
                    DecorView.this.endOnGoingFadeAnimation();
                    final ActionBarContextView lastActionModeView = DecorView.this.mPrimaryActionModeView;
                    DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 1.0f, 0.0f);
                    DecorView.this.mFadeAnim.addListener(new Animator.AnimatorListener(){

                        @Override
                        public void onAnimationStart(Animator animation) {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (lastActionModeView == DecorView.this.mPrimaryActionModeView) {
                                lastActionModeView.setVisibility(8);
                                if (DecorView.this.mPrimaryActionModePopup != null) {
                                    DecorView.this.mPrimaryActionModePopup.dismiss();
                                }
                                lastActionModeView.killMode();
                                DecorView.this.mFadeAnim = null;
                                DecorView.this.requestApplyInsets();
                            }
                        }

                        @Override
                        public void onAnimationCancel(Animator animation) {
                        }

                        @Override
                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    DecorView.this.mFadeAnim.start();
                }
                DecorView.this.mPrimaryActionMode = null;
            } else if (isFloating) {
                DecorView.this.cleanupFloatingActionModeViews();
                DecorView.this.mFloatingActionMode = null;
            }
            if (DecorView.this.mWindow.getCallback() != null && !DecorView.this.mWindow.isDestroyed()) {
                try {
                    DecorView.this.mWindow.getCallback().onActionModeFinished(mode);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            DecorView.this.requestFitSystemWindows();
        }

        @Override
        public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
            if (this.mWrapped instanceof ActionMode.Callback2) {
                ((ActionMode.Callback2)this.mWrapped).onGetContentRect(mode, view, outRect);
            } else {
                super.onGetContentRect(mode, view, outRect);
            }
        }
    }

    public static interface AppJankStatsCallback {
        public JankTracker getAppJankTracker();
    }
}

