/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.tracing.perfetto.DataSourceParams;
import android.tracing.perfetto.InitArguments;
import android.tracing.perfetto.Producer;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.protolog.ProtoLogController;
import com.android.internal.protolog.ProtoLogDataSource;
import com.android.internal.protolog.ProtoLog_Delegate;
import com.android.internal.protolog.common.IProtoLog;
import com.android.internal.protolog.common.IProtoLogGroup;
import com.android.internal.protolog.common.LogLevel;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

@RavenwoodKeepWholeClass
public class ProtoLog {
    @Deprecated
    public static boolean REQUIRE_PROTOLOGTOOL = true;
    @NonNull
    private static final Object sDataSourceLock = new Object();
    private static ProtoLogDataSource sDataSource;
    @NonNull
    private static volatile ProtoLogController sController;

    public static void registerLogGroupInProcess(IProtoLogGroup ... groups) {
        sController.registerLogGroupInProcess(groups);
    }

    public static void init(IProtoLogGroup ... groups) {
        sController.init(groups);
    }

    public static void d(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.DEBUG, group, messageString, args);
    }

    public static void v(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.VERBOSE, group, messageString, args);
    }

    public static void i(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.INFO, group, messageString, args);
    }

    public static void w(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.WARN, group, messageString, args);
    }

    public static void e(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.ERROR, group, messageString, args);
    }

    public static void wtf(@NonNull IProtoLogGroup group, @NonNull String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.WTF, group, messageString, args);
    }

    public static boolean isEnabled(@NonNull IProtoLogGroup group, @NonNull LogLevel level) {
        return ProtoLog.sController.mProtoLogInstance.isEnabled(group, level);
    }

    @Nullable
    public static IProtoLog getSingleInstance() {
        return ProtoLog.sController.mProtoLogInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ProtoLogDataSource getSharedSingleInstanceDataSource() {
        Object object = sDataSourceLock;
        synchronized (object) {
            if (sDataSource == null) {
                Producer.init(InitArguments.DEFAULTS);
                sDataSource = new ProtoLogDataSource();
                DataSourceParams params = new DataSourceParams.Builder().setBufferExhaustedPolicy(0).build();
                sDataSource.register(params);
            }
            return sDataSource;
        }
    }

    private static void logStringMessage(@NonNull LogLevel logLevel, @NonNull IProtoLogGroup group, @NonNull String stringMessage, Object ... args) {
        IProtoLog instance = ProtoLog.sController.mProtoLogInstance;
        if (instance == null) {
            throw new IllegalStateException("Trying to use ProtoLog before it is initialized in this process.");
        }
        if (instance.isEnabled(group, logLevel)) {
            instance.log(logLevel, group, stringMessage, args);
        }
    }

    @VisibleForTesting
    public static void setControllerInstanceForTest(@NonNull ProtoLogController controller) {
        sController = controller;
    }

    @VisibleForTesting
    @NonNull
    public static ProtoLogController getControllerInstanceForTest() {
        return sController;
    }

    @RavenwoodReplace(reason="Always use the Log backend on ravenwood, not Perfetto")
    static boolean logOnlyToLogcat_Original() {
        return false;
    }

    @LayoutlibDelegate
    static boolean logOnlyToLogcat() {
        return ProtoLog_Delegate.logOnlyToLogcat();
    }

    static boolean logOnlyToLogcat$ravenwood() {
        return true;
    }

    static {
        sController = new ProtoLogController();
    }
}

