/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.ArraySet;
import android.util.EmptyArray;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;

@RavenwoodKeepWholeClass
public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    public static Object[] sCache = new Object[73];
    public static final File[] EMPTY_FILE = new File[0];

    private ArrayUtils() {
    }

    public static byte[] newUnpaddedByteArray(int minLen) {
        return (byte[])VMRuntime.getRuntime().newUnpaddedArray(Byte.TYPE, minLen);
    }

    public static char[] newUnpaddedCharArray(int minLen) {
        return (char[])VMRuntime.getRuntime().newUnpaddedArray(Character.TYPE, minLen);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int[] newUnpaddedIntArray(int minLen) {
        return (int[])VMRuntime.getRuntime().newUnpaddedArray(Integer.TYPE, minLen);
    }

    public static boolean[] newUnpaddedBooleanArray(int minLen) {
        return (boolean[])VMRuntime.getRuntime().newUnpaddedArray(Boolean.TYPE, minLen);
    }

    public static long[] newUnpaddedLongArray(int minLen) {
        return (long[])VMRuntime.getRuntime().newUnpaddedArray(Long.TYPE, minLen);
    }

    public static float[] newUnpaddedFloatArray(int minLen) {
        return (float[])VMRuntime.getRuntime().newUnpaddedArray(Float.TYPE, minLen);
    }

    public static Object[] newUnpaddedObjectArray(int minLen) {
        return (Object[])VMRuntime.getRuntime().newUnpaddedArray(Object.class, minLen);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static <T> T[] newUnpaddedArray(Class<T> clazz, int minLen) {
        return (Object[])VMRuntime.getRuntime().newUnpaddedArray(clazz, minLen);
    }

    public static byte[] newNonMovableByteArray(int length) {
        return (byte[])VMRuntime.getRuntime().newNonMovableArray(Byte.TYPE, length);
    }

    public static char[] newNonMovableCharArray(int length) {
        return (char[])VMRuntime.getRuntime().newNonMovableArray(Character.TYPE, length);
    }

    @RavenwoodReplace
    public static void zeroize(byte[] byArray) {
        OverrideMethod.invokeV("com.android.internal.util.ArrayUtils#zeroize([B)V", true, null);
    }

    public static void zeroize$ravenwood(byte[] array2) {
        if (array2 != null) {
            Arrays.fill(array2, (byte)0);
        }
    }

    @RavenwoodReplace
    public static void zeroize(char[] cArray) {
        OverrideMethod.invokeV("com.android.internal.util.ArrayUtils#zeroize([C)V", true, null);
    }

    public static void zeroize$ravenwood(char[] array2) {
        if (array2 != null) {
            Arrays.fill(array2, '\u0000');
        }
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length < length || array2.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    @UnsupportedAppUsage
    public static <T> T[] emptyArray(Class<T> kind) {
        if (kind == Object.class) {
            return EmptyArray.OBJECT;
        }
        int bucket = (kind.hashCode() & Integer.MAX_VALUE) % 73;
        Object cache = sCache[bucket];
        if (cache == null || cache.getClass().getComponentType() != kind) {
            ArrayUtils.sCache[bucket] = cache = Array.newInstance(kind, 0);
        }
        return (Object[])cache;
    }

    @NonNull
    public static <T> T[] emptyIfNull(@Nullable T[] items, Class<T> kind) {
        return items != null ? items : ArrayUtils.emptyArray(kind);
    }

    public static boolean isEmpty(@Nullable Collection<?> array2) {
        return array2 == null || array2.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @UnsupportedAppUsage
    public static <T> boolean isEmpty(@Nullable T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(@Nullable int[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(@Nullable long[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(@Nullable byte[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(@Nullable boolean[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static int size(@Nullable Object[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    public static int size(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static int size(@Nullable Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    @UnsupportedAppUsage
    public static <T> boolean contains(@Nullable T[] array2, T value) {
        return ArrayUtils.indexOf(array2, value) != -1;
    }

    @UnsupportedAppUsage
    public static <T> int indexOf(@Nullable T[] array2, T value) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (!Objects.equals(array2[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean containsAll(@Nullable T[] array2, T[] check) {
        if (check == null) {
            return true;
        }
        for (T checkItem : check) {
            if (ArrayUtils.contains(array2, checkItem)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAny(@Nullable T[] array2, T[] check) {
        if (check == null) {
            return false;
        }
        for (T checkItem : check) {
            if (!ArrayUtils.contains(array2, checkItem)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    public static boolean contains(@Nullable int[] array2, int value) {
        if (array2 == null) {
            return false;
        }
        for (int element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable long[] array2, long value) {
        if (array2 == null) {
            return false;
        }
        for (long element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable char[] array2, char value) {
        if (array2 == null) {
            return false;
        }
        for (char element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(@Nullable char[] array2, char[] check) {
        if (check == null) {
            return true;
        }
        for (char checkItem : check) {
            if (ArrayUtils.contains(array2, checkItem)) continue;
            return false;
        }
        return true;
    }

    public static long total(@Nullable long[] array2) {
        long total = 0L;
        if (array2 != null) {
            for (long value : array2) {
                total += value;
            }
        }
        return total;
    }

    @Deprecated
    public static int[] convertToIntArray(List<Integer> list) {
        int[] array2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    @NonNull
    public static int[] convertToIntArray(@NonNull ArraySet<Integer> set) {
        int size = set.size();
        int[] array2 = new int[size];
        for (int i = 0; i < size; ++i) {
            array2[i] = set.valueAt(i);
        }
        return array2;
    }

    @Nullable
    public static long[] convertToLongArray(@Nullable int[] intArray) {
        if (intArray == null) {
            return null;
        }
        long[] array2 = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            array2[i] = intArray[i];
        }
        return array2;
    }

    @NonNull
    public static <T> T[] concat(Class<T> kind, T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return ArrayUtils.createEmptyArray(kind);
        }
        int totalLength = 0;
        for (T[] item : arrays) {
            if (item == null) continue;
            totalLength += item.length;
        }
        if (totalLength == 0) {
            return ArrayUtils.createEmptyArray(kind);
        }
        Object[] all = (Object[])Array.newInstance(kind, totalLength);
        int pos = 0;
        for (T[] item : arrays) {
            if (item == null || item.length == 0) continue;
            System.arraycopy(item, 0, all, pos, item.length);
            pos += item.length;
        }
        return all;
    }

    @NonNull
    private static <T> T[] createEmptyArray(Class<T> kind) {
        if (kind == String.class) {
            return EmptyArray.STRING;
        }
        if (kind == Object.class) {
            return EmptyArray.OBJECT;
        }
        return (Object[])Array.newInstance(kind, 0);
    }

    @NonNull
    public static byte[] concat(byte[] ... arrays) {
        if (arrays == null) {
            return new byte[0];
        }
        int totalLength = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            totalLength += a.length;
        }
        byte[] result = new byte[totalLength];
        int pos = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            System.arraycopy(a, 0, result, pos, a.length);
            pos += a.length;
        }
        return result;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public static <T> T[] appendElement(Class<T> kind, @Nullable T[] array2, T element) {
        return ArrayUtils.appendElement(kind, array2, element, false);
    }

    @NonNull
    public static <T> T[] appendElement(Class<T> kind, @Nullable T[] array2, T element, boolean allowDuplicates) {
        Object[] result;
        int end;
        if (array2 != null) {
            if (!allowDuplicates && ArrayUtils.contains(array2, element)) {
                return array2;
            }
            end = array2.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array2, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @Nullable
    public static <T> T[] removeElement(Class<T> kind, @Nullable T[] array2, T element) {
        if (array2 != null) {
            if (!ArrayUtils.contains(array2, element)) {
                return array2;
            }
            int length = array2.length;
            for (int i = 0; i < length; ++i) {
                if (!Objects.equals(array2[i], element)) continue;
                if (length == 1) {
                    return null;
                }
                Object[] result = (Object[])Array.newInstance(kind, length - 1);
                System.arraycopy(array2, 0, result, 0, i);
                System.arraycopy(array2, i + 1, result, i, length - i - 1);
                return result;
            }
        }
        return array2;
    }

    @NonNull
    public static int[] appendInt(@Nullable int[] cur, int val, boolean allowDuplicates) {
        if (cur == null) {
            return new int[]{val};
        }
        int N2 = cur.length;
        if (!allowDuplicates) {
            for (int i = 0; i < N2; ++i) {
                if (cur[i] != val) continue;
                return cur;
            }
        }
        int[] ret = new int[N2 + 1];
        System.arraycopy(cur, 0, ret, 0, N2);
        ret[N2] = val;
        return ret;
    }

    @UnsupportedAppUsage
    @NonNull
    public static int[] appendInt(@Nullable int[] cur, int val) {
        return ArrayUtils.appendInt(cur, val, false);
    }

    @Nullable
    public static int[] removeInt(@Nullable int[] cur, int val) {
        if (cur == null) {
            return null;
        }
        int N2 = cur.length;
        for (int i = 0; i < N2; ++i) {
            if (cur[i] != val) continue;
            int[] ret = new int[N2 - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N2 - 1) {
                System.arraycopy(cur, i + 1, ret, i, N2 - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @Nullable
    public static String[] removeString(@Nullable String[] cur, String val) {
        if (cur == null) {
            return null;
        }
        int N2 = cur.length;
        for (int i = 0; i < N2; ++i) {
            if (!Objects.equals(cur[i], val)) continue;
            String[] ret = new String[N2 - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N2 - 1) {
                System.arraycopy(cur, i + 1, ret, i, N2 - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @NonNull
    public static long[] appendLong(@Nullable long[] cur, long val, boolean allowDuplicates) {
        if (cur == null) {
            return new long[]{val};
        }
        int N2 = cur.length;
        if (!allowDuplicates) {
            for (int i = 0; i < N2; ++i) {
                if (cur[i] != val) continue;
                return cur;
            }
        }
        long[] ret = new long[N2 + 1];
        System.arraycopy(cur, 0, ret, 0, N2);
        ret[N2] = val;
        return ret;
    }

    public static boolean[] appendBooleanDuplicatesAllowed(@Nullable boolean[] cur, boolean val) {
        if (cur == null) {
            return new boolean[]{val};
        }
        int N2 = cur.length;
        boolean[] ret = new boolean[N2 + 1];
        System.arraycopy(cur, 0, ret, 0, N2);
        ret[N2] = val;
        return ret;
    }

    @NonNull
    public static long[] appendLong(@Nullable long[] cur, long val) {
        return ArrayUtils.appendLong(cur, val, false);
    }

    @Nullable
    public static long[] removeLong(@Nullable long[] cur, long val) {
        if (cur == null) {
            return null;
        }
        int N2 = cur.length;
        for (int i = 0; i < N2; ++i) {
            if (cur[i] != val) continue;
            long[] ret = new long[N2 - 1];
            if (i > 0) {
                System.arraycopy(cur, 0, ret, 0, i);
            }
            if (i < N2 - 1) {
                System.arraycopy(cur, i + 1, ret, i, N2 - i - 1);
            }
            return ret;
        }
        return cur;
    }

    @Nullable
    public static long[] cloneOrNull(@Nullable long[] array2) {
        return array2 != null ? (long[])array2.clone() : null;
    }

    @Nullable
    public static <T> T[] cloneOrNull(@Nullable T[] array2) {
        return array2 != null ? (Object[])array2.clone() : null;
    }

    @Nullable
    public static <T> ArraySet<T> cloneOrNull(@Nullable ArraySet<T> array2) {
        return array2 != null ? new ArraySet<T>(array2) : null;
    }

    @NonNull
    public static <T> ArraySet<T> add(@Nullable ArraySet<T> cur, T val) {
        if (cur == null) {
            cur = new ArraySet();
        }
        cur.add(val);
        return cur;
    }

    @NonNull
    public static <T> ArraySet<T> addAll(@Nullable ArraySet<T> cur, @Nullable Collection<T> val) {
        if (cur == null) {
            cur = new ArraySet();
        }
        if (val != null) {
            cur.addAll(val);
        }
        return cur;
    }

    @Nullable
    public static <T> ArraySet<T> remove(@Nullable ArraySet<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    @NonNull
    public static <T> ArrayList<T> add(@Nullable ArrayList<T> cur, T val) {
        if (cur == null) {
            cur = new ArrayList();
        }
        cur.add(val);
        return cur;
    }

    @NonNull
    public static <T> ArrayList<T> add(@Nullable ArrayList<T> cur, int index, T val) {
        if (cur == null) {
            cur = new ArrayList();
        }
        cur.add(index, val);
        return cur;
    }

    @Nullable
    public static <T> ArrayList<T> remove(@Nullable ArrayList<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    public static <T> boolean contains(@Nullable Collection<T> cur, T val) {
        return cur != null ? cur.contains(val) : false;
    }

    @Nullable
    public static <T> T[] trimToSize(@Nullable T[] array2, int size) {
        if (array2 == null || size == 0) {
            return null;
        }
        if (array2.length == size) {
            return array2;
        }
        return Arrays.copyOf(array2, size);
    }

    public static <T> boolean referenceEquals(ArrayList<T> a, ArrayList<T> b) {
        if (a == b) {
            return true;
        }
        int sizeA = a.size();
        int sizeB = b.size();
        if (a == null || b == null || sizeA != sizeB) {
            return false;
        }
        boolean diff = false;
        for (int i = 0; i < sizeA && !diff; diff |= a.get(i) != b.get(i), ++i) {
        }
        return !diff;
    }

    public static <T> int unstableRemoveIf(@Nullable ArrayList<T> collection, @NonNull Predicate<T> predicate) {
        if (collection == null) {
            return 0;
        }
        int size = collection.size();
        int leftIdx = 0;
        for (int rightIdx = size - 1; leftIdx <= rightIdx; ++leftIdx, --rightIdx) {
            while (leftIdx < size && !predicate.test(collection.get(leftIdx))) {
                ++leftIdx;
            }
            while (rightIdx > leftIdx && predicate.test(collection.get(rightIdx))) {
                --rightIdx;
            }
            if (leftIdx >= rightIdx) break;
            Collections.swap(collection, leftIdx, rightIdx);
        }
        for (int i = size - 1; i >= leftIdx; --i) {
            collection.remove(i);
        }
        return size - leftIdx;
    }

    @NonNull
    public static int[] defeatNullable(@Nullable int[] val) {
        return val != null ? val : EmptyArray.INT;
    }

    @NonNull
    public static String[] defeatNullable(@Nullable String[] val) {
        return val != null ? val : EmptyArray.STRING;
    }

    @NonNull
    public static File[] defeatNullable(@Nullable File[] val) {
        return val != null ? val : EMPTY_FILE;
    }

    public static void checkBounds(int len, int index) {
        if (index < 0 || len <= index) {
            throw new ArrayIndexOutOfBoundsException("length=" + len + "; index=" + index);
        }
    }

    public static void throwsIfOutOfBounds(int len, int offset, int count) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative length: " + len);
        }
        if ((offset | count) < 0 || offset > len - count) {
            throw new ArrayIndexOutOfBoundsException("length=" + len + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    public static <T> T[] filterNotNull(T[] val, IntFunction<T[]> arrayConstructor) {
        int nullCount = 0;
        int size = ArrayUtils.size(val);
        for (int i = 0; i < size; ++i) {
            if (val[i] != null) continue;
            ++nullCount;
        }
        if (nullCount == 0) {
            return val;
        }
        T[] result = arrayConstructor.apply(size - nullCount);
        int outIdx = 0;
        for (int i = 0; i < size; ++i) {
            if (val[i] == null) continue;
            result[outIdx++] = val[i];
        }
        return result;
    }

    @Nullable
    public static <T> T[] filter(@Nullable T[] items, @NonNull IntFunction<T[]> arrayConstructor, @NonNull Predicate<T> predicate) {
        if (ArrayUtils.isEmpty(items)) {
            return items;
        }
        int matchesCount = 0;
        int size = ArrayUtils.size(items);
        boolean[] tests = new boolean[size];
        for (int i = 0; i < size; ++i) {
            tests[i] = predicate.test(items[i]);
            if (!tests[i]) continue;
            ++matchesCount;
        }
        if (matchesCount == items.length) {
            return items;
        }
        T[] result = arrayConstructor.apply(matchesCount);
        if (matchesCount == 0) {
            return result;
        }
        int outIdx = 0;
        for (int i = 0; i < size; ++i) {
            if (!tests[i]) continue;
            result[outIdx++] = items[i];
        }
        return result;
    }

    public static boolean startsWith(byte[] cur, byte[] val) {
        if (cur == null || val == null) {
            return false;
        }
        if (cur.length < val.length) {
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            if (cur[i] == val[i]) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T find(@Nullable T[] items, @NonNull Predicate<T> predicate) {
        if (ArrayUtils.isEmpty(items)) {
            return null;
        }
        for (T item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public static String deepToString(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass() == boolean[].class) {
                return Arrays.toString((boolean[])value);
            }
            if (value.getClass() == byte[].class) {
                return Arrays.toString((byte[])value);
            }
            if (value.getClass() == char[].class) {
                return Arrays.toString((char[])value);
            }
            if (value.getClass() == double[].class) {
                return Arrays.toString((double[])value);
            }
            if (value.getClass() == float[].class) {
                return Arrays.toString((float[])value);
            }
            if (value.getClass() == int[].class) {
                return Arrays.toString((int[])value);
            }
            if (value.getClass() == long[].class) {
                return Arrays.toString((long[])value);
            }
            if (value.getClass() == short[].class) {
                return Arrays.toString((short[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return String.valueOf(value);
    }

    @Nullable
    public static <T> T getOrNull(@Nullable T[] items, int i) {
        return items != null && items.length > i ? (T)items[i] : null;
    }

    @Nullable
    public static <T> T firstOrNull(T[] items) {
        return items.length > 0 ? (T)items[0] : null;
    }

    public static <T> List<T> toList(T[] array2) {
        ArrayList<T> list = new ArrayList<T>(array2.length);
        for (T item : array2) {
            list.add(item);
        }
        return list;
    }
}

