/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.Nullable;
import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.permission.PermissionManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodThrow;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.ParseUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.function.Predicate;

@RavenwoodKeepWholeClass
public class DumpUtils {
    public static final ComponentName[] CRITICAL_SECTION_COMPONENTS = new ComponentName[]{new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService")};
    private static final String TAG = "DumpUtils";
    private static final boolean DEBUG = false;

    private DumpUtils() {
    }

    public static void dumpAsync(Handler handler, final Dump dump, PrintWriter pw, final String prefix, long timeout) {
        final StringWriter sw = new StringWriter();
        if (handler.runWithScissors(new Runnable(){

            @Override
            public void run() {
                FastPrintWriter lpw = new FastPrintWriter(sw);
                dump.dump(lpw, prefix);
                ((PrintWriter)lpw).close();
            }
        }, timeout)) {
            pw.print(((Object)sw).toString());
        } else {
            pw.println("... timed out");
        }
    }

    private static void logMessage(PrintWriter pw, String msg) {
        pw.println(msg);
    }

    @RavenwoodThrow(blockedBy={PermissionManager.class})
    public static boolean checkDumpPermission(Context context, String tag, PrintWriter pw) {
        if (context.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.DUMP permission");
            return false;
        }
        return true;
    }

    @RavenwoodThrow(blockedBy={PermissionManager.class})
    public static boolean checkUsageStatsPermission(Context context, String tag, PrintWriter pw) {
        int uid = Binder.getCallingUid();
        switch (uid) {
            case 0: 
            case 1000: 
            case 1067: 
            case 2000: {
                return true;
            }
        }
        if (context.checkCallingOrSelfPermission("android.permission.PACKAGE_USAGE_STATS") != 0) {
            DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.PACKAGE_USAGE_STATS permission");
            return false;
        }
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        String[] pkgs = context.getPackageManager().getPackagesForUid(uid);
        if (pkgs != null) {
            for (String pkg : pkgs) {
                switch (appOps.noteOpNoThrow(43, uid, pkg)) {
                    case 0: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
            }
        }
        DumpUtils.logMessage(pw, "Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to android:get_usage_stats app-op not allowed");
        return false;
    }

    @RavenwoodThrow(blockedBy={PermissionManager.class})
    public static boolean checkDumpAndUsageStatsPermission(Context context, String tag, PrintWriter pw) {
        return DumpUtils.checkDumpPermission(context, tag, pw) && DumpUtils.checkUsageStatsPermission(context, tag, pw);
    }

    public static boolean isPlatformPackage(@Nullable String packageName) {
        return packageName != null && (packageName.equals("android") || packageName.startsWith("android.") || packageName.startsWith("com.android."));
    }

    public static boolean isPlatformPackage(@Nullable ComponentName cname) {
        return cname != null && DumpUtils.isPlatformPackage(cname.getPackageName());
    }

    public static boolean isPlatformPackage(@Nullable ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    public static boolean isNonPlatformPackage(@Nullable String packageName) {
        return packageName != null && !DumpUtils.isPlatformPackage(packageName);
    }

    public static boolean isNonPlatformPackage(@Nullable ComponentName cname) {
        return cname != null && DumpUtils.isNonPlatformPackage(cname.getPackageName());
    }

    public static boolean isNonPlatformPackage(@Nullable ComponentName.WithComponentName wcn) {
        return wcn != null && !DumpUtils.isPlatformPackage(wcn.getComponentName());
    }

    private static boolean isCriticalPackage(@Nullable ComponentName cname) {
        if (cname == null) {
            return false;
        }
        for (int i = 0; i < CRITICAL_SECTION_COMPONENTS.length; ++i) {
            if (!cname.equals(CRITICAL_SECTION_COMPONENTS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlatformCriticalPackage(@Nullable ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName()) && DumpUtils.isCriticalPackage(wcn.getComponentName());
    }

    public static boolean isPlatformNonCriticalPackage(@Nullable ComponentName.WithComponentName wcn) {
        return wcn != null && DumpUtils.isPlatformPackage(wcn.getComponentName()) && !DumpUtils.isCriticalPackage(wcn.getComponentName());
    }

    public static <TRec extends ComponentName.WithComponentName> Predicate<TRec> filterRecord(@Nullable String filterString) {
        if (TextUtils.isEmpty(filterString)) {
            return rec -> false;
        }
        if ("all".equals(filterString)) {
            return Objects::nonNull;
        }
        if ("all-platform".equals(filterString)) {
            return DumpUtils::isPlatformPackage;
        }
        if ("all-non-platform".equals(filterString)) {
            return DumpUtils::isNonPlatformPackage;
        }
        if ("all-platform-critical".equals(filterString)) {
            return DumpUtils::isPlatformCriticalPackage;
        }
        if ("all-platform-non-critical".equals(filterString)) {
            return DumpUtils::isPlatformNonCriticalPackage;
        }
        ComponentName filterCname = ComponentName.unflattenFromString(filterString);
        if (filterCname != null) {
            return rec -> rec != null && filterCname.equals(rec.getComponentName());
        }
        int id2 = ParseUtils.parseIntWithBase(filterString, 16, -1);
        return rec -> {
            ComponentName cn = rec.getComponentName();
            return id2 != -1 && System.identityHashCode(rec) == id2 || cn.flattenToString().toLowerCase().contains(filterString.toLowerCase());
        };
    }

    public static void dumpSparseArray(PrintWriter pw, String prefix, SparseArray<?> array2, String name) {
        DumpUtils.dumpSparseArray(pw, prefix, array2, name, null, null);
    }

    public static <T> void dumpSparseArrayValues(PrintWriter pw, String prefix, SparseArray<T> array2, String name) {
        DumpUtils.dumpSparseArray(pw, prefix, array2, name, (i, k) -> pw.printf("%s%s", prefix, prefix), null);
    }

    public static <T> void dumpSparseArray(PrintWriter pw, String prefix, SparseArray<T> array2, String name, @Nullable KeyDumper keyDumper, @Nullable ValueDumper<T> valueDumper) {
        int size = array2.size();
        if (size == 0) {
            pw.print(prefix);
            pw.print("No ");
            pw.print(name);
            pw.println("s");
            return;
        }
        pw.print(prefix);
        pw.print(size);
        pw.print(' ');
        pw.print(name);
        pw.println("(s):");
        String prefix2 = prefix + prefix;
        for (int i = 0; i < size; ++i) {
            int key = array2.keyAt(i);
            T value = array2.valueAt(i);
            if (keyDumper != null) {
                keyDumper.dump(i, key);
            } else {
                pw.print(prefix2);
                pw.print(i);
                pw.print(": ");
                pw.print(key);
                pw.print("->");
            }
            if (value == null) {
                pw.print("(null)");
            } else if (valueDumper != null) {
                valueDumper.dump(value);
            } else {
                pw.print(value);
            }
            pw.println();
        }
    }

    public static interface Dump {
        public void dump(PrintWriter var1, String var2);
    }

    public static interface KeyDumper {
        public void dump(int var1, int var2);
    }

    public static interface ValueDumper<T> {
        public void dump(T var1);
    }
}

