/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;

@RavenwoodKeepWholeClass
public class RingBuffer<T> {
    private final Supplier<T> mNewItem;
    private final T[] mBuffer;
    private long mCursor = 0L;

    @Deprecated
    public RingBuffer(Class<T> c, int capacity) {
        this(() -> RingBuffer.createNewItem(c), cap -> (Object[])Array.newInstance(c, cap), capacity);
    }

    private static Object createNewItem(Class c) {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public RingBuffer(Supplier<T> newItem, IntFunction<T[]> newBacking, int capacity) {
        Preconditions.checkArgumentPositive(capacity, "A RingBuffer cannot have 0 capacity");
        this.mBuffer = newBacking.apply(capacity);
        this.mNewItem = newItem;
    }

    public int size() {
        return (int)Math.min((long)this.mBuffer.length, this.mCursor);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.mBuffer[i] = null;
        }
        this.mCursor = 0L;
    }

    public void append(T t) {
        this.mBuffer[this.indexOf((long)this.mCursor++)] = t;
    }

    public T getNextSlot() {
        int nextSlotIdx;
        if (this.mBuffer[nextSlotIdx = this.indexOf(this.mCursor++)] == null) {
            this.mBuffer[nextSlotIdx] = this.mNewItem.get();
        }
        return this.mBuffer[nextSlotIdx];
    }

    public T[] toArray() {
        T[] out = Arrays.copyOf(this.mBuffer, this.size(), this.mBuffer.getClass());
        long inCursor = this.mCursor - 1L;
        int outIdx = out.length - 1;
        while (outIdx >= 0) {
            out[outIdx--] = this.mBuffer[this.indexOf(inCursor--)];
        }
        return out;
    }

    private int indexOf(long cursor) {
        return (int)Math.abs(cursor % (long)this.mBuffer.length);
    }
}

