/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.IOException;
import java.io.InputStream;

@RavenwoodKeepWholeClass
public class SizedInputStream
extends InputStream {
    private final InputStream mWrapped;
    private long mLength;

    public SizedInputStream(InputStream wrapped, long length) {
        this.mWrapped = wrapped;
        this.mLength = length;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mWrapped.close();
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int result = this.read(buffer, 0, 1);
        return result != -1 ? buffer[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int n;
        if (this.mLength <= 0L) {
            return -1;
        }
        if ((long)byteCount > this.mLength) {
            byteCount = (int)this.mLength;
        }
        if ((n = this.mWrapped.read(buffer, byteOffset, byteCount)) == -1) {
            if (this.mLength > 0L) {
                throw new IOException("Unexpected EOF; expected " + this.mLength + " more bytes");
            }
        } else {
            this.mLength -= (long)n;
        }
        return n;
    }
}

