/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import android.os.vibrator.BasicPwleSegment;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.PwleSegment;
import android.os.vibrator.StepSegment;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.hidden_from_bootclasspath.android.os.vibrator.Flags;
import com.android.internal.vibrator.persistence.SerializedAmplitudeStepWaveform;
import com.android.internal.vibrator.persistence.SerializedBasicEnvelopeEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.SerializedCompositionPrimitive;
import com.android.internal.vibrator.persistence.SerializedPredefinedEffect;
import com.android.internal.vibrator.persistence.SerializedVendorEffect;
import com.android.internal.vibrator.persistence.SerializedWaveformEnvelopeEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlSerializerException;
import com.android.internal.vibrator.persistence.XmlValidator;
import java.util.List;

public class LegacyVibrationEffectXmlSerializer {
    @NonNull
    public static XmlSerializedVibration<? extends VibrationEffect> serialize(@NonNull VibrationEffect vibration, int flags) throws XmlSerializerException {
        if (Flags.vendorVibrationEffects() && vibration instanceof VibrationEffect.VendorEffect) {
            VibrationEffect.VendorEffect vendorEffect = (VibrationEffect.VendorEffect)vibration;
            return LegacyVibrationEffectXmlSerializer.serializeVendorEffect(vendorEffect);
        }
        XmlValidator.checkSerializerCondition(vibration instanceof VibrationEffect.Composed, "Unsupported VibrationEffect type %s", vibration);
        VibrationEffect.Composed composed = (VibrationEffect.Composed)vibration;
        XmlValidator.checkSerializerCondition(!composed.getSegments().isEmpty(), "Unsupported empty VibrationEffect %s", vibration);
        VibrationEffectSegment firstSegment = composed.getSegments().get(0);
        if (firstSegment instanceof PrebakedSegment) {
            return LegacyVibrationEffectXmlSerializer.serializePredefinedEffect(composed, flags);
        }
        if (firstSegment instanceof PrimitiveSegment) {
            return LegacyVibrationEffectXmlSerializer.serializePrimitiveEffect(composed);
        }
        if (Flags.normalizedPwleEffects() && firstSegment instanceof PwleSegment) {
            return LegacyVibrationEffectXmlSerializer.serializeWaveformEnvelopeEffect(composed);
        }
        if (Flags.normalizedPwleEffects() && firstSegment instanceof BasicPwleSegment) {
            return LegacyVibrationEffectXmlSerializer.serializeBasicEnvelopeEffect(composed);
        }
        return LegacyVibrationEffectXmlSerializer.serializeWaveformEffect(composed);
    }

    private static SerializedComposedEffect serializePredefinedEffect(VibrationEffect.Composed effect, int flags) throws XmlSerializerException {
        List<VibrationEffectSegment> segments = effect.getSegments();
        XmlValidator.checkSerializerCondition(effect.getRepeatIndex() == -1, "Unsupported repeating predefined effect %s", effect);
        XmlValidator.checkSerializerCondition(segments.size() == 1, "Unsupported multiple segments in predefined effect %s", effect);
        return new SerializedComposedEffect(LegacyVibrationEffectXmlSerializer.serializePrebakedSegment(segments.get(0), flags));
    }

    private static SerializedVendorEffect serializeVendorEffect(VibrationEffect.VendorEffect effect) {
        return new SerializedVendorEffect(effect.getVendorData());
    }

    private static SerializedComposedEffect serializePrimitiveEffect(VibrationEffect.Composed effect) throws XmlSerializerException {
        List<VibrationEffectSegment> segments = effect.getSegments();
        XmlValidator.checkSerializerCondition(effect.getRepeatIndex() == -1, "Unsupported repeating primitive composition %s", effect);
        SerializedComposedEffect.SerializedSegment[] primitives = new SerializedComposedEffect.SerializedSegment[segments.size()];
        for (int i = 0; i < segments.size(); ++i) {
            primitives[i] = LegacyVibrationEffectXmlSerializer.serializePrimitiveSegment(segments.get(i));
        }
        return new SerializedComposedEffect(primitives);
    }

    private static SerializedComposedEffect serializeWaveformEnvelopeEffect(VibrationEffect.Composed effect) throws XmlSerializerException {
        SerializedWaveformEnvelopeEffect.Builder builder = new SerializedWaveformEnvelopeEffect.Builder();
        List<VibrationEffectSegment> segments = effect.getSegments();
        XmlValidator.checkSerializerCondition(effect.getRepeatIndex() == -1, "Unsupported repeating waveform envelope effect %s", effect);
        for (int i = 0; i < segments.size(); ++i) {
            XmlValidator.checkSerializerCondition(segments.get(i) instanceof PwleSegment, "Unsupported segment for waveform envelope effect %s", segments.get(i));
            PwleSegment segment = (PwleSegment)segments.get(i);
            if (i == 0 && segment.getStartFrequencyHz() != segment.getEndFrequencyHz()) {
                builder.setInitialFrequencyHz(segment.getStartFrequencyHz());
            }
            builder.addControlPoint(segment.getEndAmplitude(), segment.getEndFrequencyHz(), segment.getDuration());
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect serializeBasicEnvelopeEffect(VibrationEffect.Composed effect) throws XmlSerializerException {
        SerializedBasicEnvelopeEffect.Builder builder = new SerializedBasicEnvelopeEffect.Builder();
        List<VibrationEffectSegment> segments = effect.getSegments();
        XmlValidator.checkSerializerCondition(effect.getRepeatIndex() == -1, "Unsupported repeating basic envelope effect %s", effect);
        for (int i = 0; i < segments.size(); ++i) {
            XmlValidator.checkSerializerCondition(segments.get(i) instanceof BasicPwleSegment, "Unsupported segment for basic envelope effect %s", segments.get(i));
            BasicPwleSegment segment = (BasicPwleSegment)segments.get(i);
            if (i == 0 && segment.getStartSharpness() != segment.getEndSharpness()) {
                builder.setInitialSharpness(segment.getStartSharpness());
            }
            builder.addControlPoint(segment.getEndIntensity(), segment.getEndSharpness(), segment.getDuration());
        }
        return new SerializedComposedEffect(builder.build());
    }

    private static SerializedComposedEffect serializeWaveformEffect(VibrationEffect.Composed effect) throws XmlSerializerException {
        SerializedAmplitudeStepWaveform.Builder serializedWaveformBuilder = new SerializedAmplitudeStepWaveform.Builder();
        List<VibrationEffectSegment> segments = effect.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            XmlValidator.checkSerializerCondition(segments.get(i) instanceof StepSegment, "Unsupported segment for waveform effect %s", segments.get(i));
            StepSegment segment = (StepSegment)segments.get(i);
            if (effect.getRepeatIndex() == i) {
                serializedWaveformBuilder.setRepeatIndexToCurrentEntry();
            }
            XmlValidator.checkSerializerCondition(Float.compare(segment.getFrequencyHz(), 0.0f) == 0, "Unsupported segment with non-default frequency %f", Float.valueOf(segment.getFrequencyHz()));
            serializedWaveformBuilder.addDurationAndAmplitude(segment.getDuration(), LegacyVibrationEffectXmlSerializer.toAmplitudeInt(segment.getAmplitude()));
        }
        return new SerializedComposedEffect(serializedWaveformBuilder.build());
    }

    private static SerializedPredefinedEffect serializePrebakedSegment(VibrationEffectSegment segment, int flags) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segment instanceof PrebakedSegment, "Unsupported segment for predefined effect %s", segment);
        PrebakedSegment prebaked = (PrebakedSegment)segment;
        XmlConstants.PredefinedEffectName effectName = XmlConstants.PredefinedEffectName.findById(prebaked.getEffectId(), flags);
        XmlValidator.checkSerializerCondition(effectName != null, "Unsupported predefined effect id %s", prebaked.getEffectId());
        if ((flags & 1) == 0) {
            XmlValidator.checkSerializerCondition(prebaked.shouldFallback(), "Unsupported predefined effect with should fallback %s", prebaked.shouldFallback());
        }
        return new SerializedPredefinedEffect(effectName, prebaked.shouldFallback());
    }

    private static SerializedCompositionPrimitive serializePrimitiveSegment(VibrationEffectSegment segment) throws XmlSerializerException {
        XmlValidator.checkSerializerCondition(segment instanceof PrimitiveSegment, "Unsupported segment for primitive composition %s", segment);
        PrimitiveSegment primitive = (PrimitiveSegment)segment;
        XmlConstants.PrimitiveEffectName primitiveName = XmlConstants.PrimitiveEffectName.findById(primitive.getPrimitiveId());
        XmlValidator.checkSerializerCondition(primitiveName != null, "Unsupported primitive effect id %s", primitive.getPrimitiveId());
        XmlConstants.PrimitiveDelayType delayType = null;
        if (Flags.primitiveCompositionAbsoluteDelay()) {
            delayType = XmlConstants.PrimitiveDelayType.findByType(primitive.getDelayType());
            XmlValidator.checkSerializerCondition(delayType != null, "Unsupported primitive delay type %s", primitive.getDelayType());
        } else {
            XmlValidator.checkSerializerCondition(primitive.getDelayType() == 0, "Unsupported primitive delay type %s", primitive.getDelayType());
        }
        return new SerializedCompositionPrimitive(primitiveName, primitive.getScale(), primitive.getDelay(), delayType);
    }

    private static int toAmplitudeInt(float amplitude) {
        return Float.compare(amplitude, -1.0f) == 0 ? -1 : Math.round(amplitude * 255.0f);
    }
}

