/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibrationEffect;
import com.android.internal.vibrator.persistence.SerializedBasicEnvelopeEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.SerializedCompositionPrimitive;
import com.android.internal.vibrator.persistence.SerializedPredefinedEffect;
import com.android.internal.vibrator.persistence.SerializedWaveformEffectEntries;
import com.android.internal.vibrator.persistence.SerializedWaveformEnvelopeEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;

public class SerializedRepeatingEffect
implements SerializedComposedEffect.SerializedSegment {
    @Nullable
    private final SerializedComposedEffect mSerializedPreamble;
    @NonNull
    private final SerializedComposedEffect mSerializedRepeating;

    SerializedRepeatingEffect(@Nullable SerializedComposedEffect serializedPreamble, @NonNull SerializedComposedEffect serializedRepeating) {
        this.mSerializedPreamble = serializedPreamble;
        this.mSerializedRepeating = serializedRepeating;
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "repeating-effect");
        if (this.mSerializedPreamble != null) {
            serializer.startTag(XmlConstants.NAMESPACE, "preamble");
            this.mSerializedPreamble.writeContent(serializer);
            serializer.endTag(XmlConstants.NAMESPACE, "preamble");
        }
        serializer.startTag(XmlConstants.NAMESPACE, "repeating");
        this.mSerializedRepeating.writeContent(serializer);
        serializer.endTag(XmlConstants.NAMESPACE, "repeating");
        serializer.endTag(XmlConstants.NAMESPACE, "repeating-effect");
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        if (this.mSerializedPreamble != null) {
            composition.addEffect(VibrationEffect.createRepeatingEffect(this.mSerializedPreamble.deserialize(), this.mSerializedRepeating.deserialize()));
            return;
        }
        composition.addEffect(VibrationEffect.createRepeatingEffect(this.mSerializedRepeating.deserialize()));
    }

    public String toString() {
        return "SerializedRepeatingEffect{preamble=" + this.mSerializedPreamble + ", repeating=" + this.mSerializedRepeating + '}';
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedRepeatingEffect parseNext(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "repeating-effect");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
            Builder builder = new Builder();
            int outerDepth = parser.getDepth();
            boolean hasNestedTag = XmlReader.readNextTagWithin(parser, outerDepth);
            if (hasNestedTag && "preamble".equals(parser.getName())) {
                builder.setPreamble(Parser.parseEffect(parser, "preamble", flags));
                hasNestedTag = XmlReader.readNextTagWithin(parser, outerDepth);
            }
            XmlValidator.checkParserCondition(hasNestedTag, "Missing %s tag in %s", "repeating", "repeating-effect");
            builder.setRepeating(Parser.parseEffect(parser, "repeating", flags));
            XmlValidator.checkParserCondition(builder.hasRepeatingSegment(), "Unexpected %s tag with no repeating segment", "repeating-effect");
            XmlReader.readEndTag(parser, "repeating-effect", outerDepth);
            return builder.build();
        }

        private static SerializedComposedEffect parseEffect(TypedXmlPullParser parser, String tagName, int flags) throws XmlParserException, IOException {
            SerializedComposedEffect effect;
            XmlValidator.checkStartTag(parser, tagName);
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
            int vibrationTagDepth = parser.getDepth();
            XmlValidator.checkParserCondition(XmlReader.readNextTagWithin(parser, vibrationTagDepth), "Unsupported empty %s tag", tagName);
            switch (parser.getName()) {
                case "predefined-effect": {
                    effect = new SerializedComposedEffect(SerializedPredefinedEffect.Parser.parseNext(parser, flags));
                    break;
                }
                case "primitive-effect": {
                    effect = Parser.parsePrimitiveEffects(parser, vibrationTagDepth);
                    break;
                }
                case "waveform-entry": {
                    effect = Parser.parseWaveformEntries(parser, vibrationTagDepth);
                    break;
                }
                case "waveform-envelope-effect": {
                    effect = new SerializedComposedEffect(SerializedWaveformEnvelopeEffect.Parser.parseNext(parser, flags));
                    break;
                }
                case "basic-envelope-effect": {
                    effect = new SerializedComposedEffect(SerializedBasicEnvelopeEffect.Parser.parseNext(parser, flags));
                    break;
                }
                default: {
                    throw new XmlParserException("Unexpected tag " + parser.getName() + " in vibration tag " + tagName);
                }
            }
            XmlReader.readEndTag(parser, tagName, vibrationTagDepth);
            return effect;
        }

        private static SerializedComposedEffect parsePrimitiveEffects(TypedXmlPullParser parser, int vibrationTagDepth) throws IOException, XmlParserException {
            ArrayList<SerializedCompositionPrimitive> primitives = new ArrayList<SerializedCompositionPrimitive>();
            do {
                primitives.add(SerializedCompositionPrimitive.Parser.parseNext(parser));
            } while (XmlReader.readNextTagWithin(parser, vibrationTagDepth));
            return new SerializedComposedEffect(primitives.toArray(new SerializedComposedEffect.SerializedSegment[primitives.size()]));
        }

        private static SerializedComposedEffect parseWaveformEntries(TypedXmlPullParser parser, int vibrationTagDepth) throws IOException, XmlParserException {
            SerializedWaveformEffectEntries.Builder waveformBuilder = new SerializedWaveformEffectEntries.Builder();
            do {
                SerializedWaveformEffectEntries.Parser.parseWaveformEntry(parser, waveformBuilder);
            } while (XmlReader.readNextTagWithin(parser, vibrationTagDepth));
            XmlValidator.checkParserCondition(waveformBuilder.hasNonZeroDuration(), "Unexpected %s tag with total duration zero", "waveform-entry");
            return new SerializedComposedEffect(waveformBuilder.build());
        }
    }

    static class Builder {
        private SerializedComposedEffect mPreamble;
        private SerializedComposedEffect mRepeating;

        Builder() {
        }

        void setPreamble(SerializedComposedEffect effect) {
            this.mPreamble = effect;
        }

        void setRepeating(SerializedComposedEffect effect) {
            this.mRepeating = effect;
        }

        boolean hasRepeatingSegment() {
            return this.mRepeating != null;
        }

        SerializedRepeatingEffect build() {
            return new SerializedRepeatingEffect(this.mPreamble, this.mRepeating);
        }
    }
}

