/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.os.PersistableBundle;
import android.os.VibrationEffect;
import android.text.TextUtils;
import android.util.Base64;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlSerializedVibration;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

class SerializedVendorEffect
implements XmlSerializedVibration<VibrationEffect.VendorEffect> {
    @NonNull
    private final PersistableBundle mVendorData;

    SerializedVendorEffect(@NonNull PersistableBundle vendorData) {
        Objects.requireNonNull(vendorData);
        this.mVendorData = vendorData;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @NonNull
    public VibrationEffect.VendorEffect deserialize() {
        return (VibrationEffect.VendorEffect)VibrationEffect.createVendorEffect(this.mVendorData);
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "vibration-effect");
        this.writeContent(serializer);
        serializer.endTag(XmlConstants.NAMESPACE, "vibration-effect");
    }

    @Override
    public void writeContent(@NonNull TypedXmlSerializer serializer) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mVendorData.writeToStream(outputStream);
        serializer.startTag(XmlConstants.NAMESPACE, "vendor-effect");
        serializer.text(Base64.encodeToString(outputStream.toByteArray(), 2));
        serializer.endTag(XmlConstants.NAMESPACE, "vendor-effect");
    }

    public String toString() {
        return "SerializedVendorEffect{vendorData=" + this.mVendorData + '}';
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedVendorEffect parseNext(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
            PersistableBundle vendorData;
            XmlValidator.checkStartTag(parser, "vendor-effect");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
            XmlReader.readNextText(parser, "vendor-effect");
            try {
                String text = parser.getText().trim();
                XmlValidator.checkParserCondition(!text.isEmpty(), "Expected tag %s to have base64 representation of vendor data, got empty", "vendor-effect");
                vendorData = PersistableBundle.readFromStream(new ByteArrayInputStream(Base64.decode(text, 0)));
                XmlValidator.checkParserCondition(!vendorData.isEmpty(), "Expected tag %s to have non-empty vendor data, got empty bundle", "vendor-effect");
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new XmlParserException(TextUtils.formatSimple("Expected base64 representation of vendor data in tag %s, got %s", "vendor-effect", parser.getText()), e);
            }
            catch (IOException e) {
                throw new XmlParserException("Error reading vendor data from decoded bytes", e);
            }
            XmlReader.readEndTag(parser);
            return new SerializedVendorEffect(vendorData);
        }
    }
}

