/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.widget.ColoredIconHelper;
import com.android.internal.widget.LocalImageResolver;
import java.util.Objects;
import java.util.function.Consumer;

@RemoteViews.RemoteView
public class CachingIconView
extends ImageView {
    private String mLastPackage;
    private int mLastResId;
    private boolean mInternalSetDrawable;
    private boolean mForceHidden;
    private int mDesiredVisibility;
    private Consumer<Integer> mOnVisibilityChangedListener;
    private Consumer<Boolean> mOnForceHiddenChangedListener;
    private int mIconColor;
    private int mBackgroundColor;
    private boolean mWillBeForceHidden;
    private int mMaxDrawableWidth = -1;
    private int mMaxDrawableHeight = -1;

    public CachingIconView(Context context) {
        this(context, null, 0, 0);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CachingIconView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public CachingIconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CachingIconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            return;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CachingIconView, defStyleAttr, defStyleRes);
        this.mMaxDrawableWidth = ta.getDimensionPixelSize(0, -1);
        this.mMaxDrawableHeight = ta.getDimensionPixelSize(1, -1);
        ta.recycle();
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(@Nullable Icon icon) {
        if (!this.testAndSetCache(icon)) {
            this.mInternalSetDrawable = true;
            Drawable drawable2 = this.loadSizeRestrictedIcon(icon);
            if (drawable2 == null) {
                super.setImageIcon(icon);
            } else {
                super.setImageDrawable(drawable2);
            }
            this.mInternalSetDrawable = false;
        }
    }

    @Nullable
    Drawable loadSizeRestrictedIcon(@Nullable Icon icon) {
        return LocalImageResolver.resolveImage(icon, this.getContext(), this.mMaxDrawableWidth, this.mMaxDrawableHeight);
    }

    @Override
    public Runnable setImageIconAsync(@Nullable Icon icon) {
        this.resetCache();
        Drawable drawable2 = this.loadSizeRestrictedIcon(icon);
        if (drawable2 != null) {
            return () -> this.setImageDrawable(drawable2);
        }
        return super.setImageIconAsync(icon);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageResourceAsync")
    public void setImageResource(int resId) {
        if (!this.testAndSetCache(resId)) {
            this.mInternalSetDrawable = true;
            Drawable drawable2 = this.loadSizeRestrictedDrawable(resId);
            if (drawable2 == null) {
                super.setImageResource(resId);
            } else {
                super.setImageDrawable(drawable2);
            }
            this.mInternalSetDrawable = false;
        }
    }

    @Nullable
    private Drawable loadSizeRestrictedDrawable(int resId) {
        return LocalImageResolver.resolveImage(resId, this.getContext(), this.mMaxDrawableWidth, this.mMaxDrawableHeight);
    }

    @Override
    public Runnable setImageResourceAsync(int resId) {
        this.resetCache();
        Drawable drawable2 = this.loadSizeRestrictedDrawable(resId);
        if (drawable2 != null) {
            return () -> this.setImageDrawable(drawable2);
        }
        return super.setImageResourceAsync(resId);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(@Nullable Uri uri) {
        this.resetCache();
        Drawable drawable2 = this.loadSizeRestrictedUri(uri);
        if (drawable2 == null) {
            super.setImageURI(uri);
        } else {
            this.mInternalSetDrawable = true;
            super.setImageDrawable(drawable2);
            this.mInternalSetDrawable = false;
        }
    }

    @Nullable
    private Drawable loadSizeRestrictedUri(@Nullable Uri uri) {
        return LocalImageResolver.resolveImage(uri, this.getContext(), this.mMaxDrawableWidth, this.mMaxDrawableHeight);
    }

    @Override
    public Runnable setImageURIAsync(@Nullable Uri uri) {
        this.resetCache();
        Drawable drawable2 = this.loadSizeRestrictedUri(uri);
        if (drawable2 == null) {
            return super.setImageURIAsync(uri);
        }
        return () -> this.setImageDrawable(drawable2);
    }

    @Override
    public void setImageDrawable(@Nullable Drawable drawable2) {
        if (!this.mInternalSetDrawable) {
            this.resetCache();
        }
        super.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod
    public void setImageBitmap(Bitmap bm) {
        this.resetCache();
        super.setImageBitmap(bm);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetCache();
    }

    private synchronized boolean testAndSetCache(Icon icon) {
        if (icon != null && icon.getType() == 2) {
            String iconPackage = this.normalizeIconPackage(icon);
            boolean isCached = this.mLastResId != 0 && icon.getResId() == this.mLastResId && Objects.equals(iconPackage, this.mLastPackage);
            this.mLastPackage = iconPackage;
            this.mLastResId = icon.getResId();
            return isCached;
        }
        this.resetCache();
        return false;
    }

    private synchronized boolean testAndSetCache(int resId) {
        boolean isCached = resId == 0 || this.mLastResId == 0 ? false : resId == this.mLastResId && null == this.mLastPackage;
        this.mLastPackage = null;
        this.mLastResId = resId;
        return isCached;
    }

    private String normalizeIconPackage(Icon icon) {
        if (icon == null) {
            return null;
        }
        String pkg = icon.getResPackage();
        if (TextUtils.isEmpty(pkg)) {
            return null;
        }
        if (pkg.equals(this.mContext.getPackageName())) {
            return null;
        }
        return pkg;
    }

    private synchronized void resetCache() {
        this.mLastResId = 0;
        this.mLastPackage = null;
    }

    public void setForceHidden(boolean forceHidden) {
        if (forceHidden != this.mForceHidden) {
            this.mForceHidden = forceHidden;
            this.mWillBeForceHidden = false;
            this.updateVisibility();
            if (this.mOnForceHiddenChangedListener != null) {
                this.mOnForceHiddenChangedListener.accept(forceHidden);
            }
        }
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.mDesiredVisibility = visibility;
        this.updateVisibility();
    }

    private void updateVisibility() {
        int visibility;
        int n = visibility = this.mDesiredVisibility == 0 && this.mForceHidden ? 4 : this.mDesiredVisibility;
        if (this.mOnVisibilityChangedListener != null) {
            this.mOnVisibilityChangedListener.accept(visibility);
        }
        super.setVisibility(visibility);
    }

    public void setOnVisibilityChangedListener(Consumer<Integer> listener) {
        this.mOnVisibilityChangedListener = listener;
    }

    public void setOnForceHiddenChangedListener(Consumer<Boolean> listener) {
        this.mOnForceHiddenChangedListener = listener;
    }

    public boolean isForceHidden() {
        return this.mForceHidden;
    }

    @Override
    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
    }

    @RemotableViewMethod
    public void setOriginalIconColor(int color2) {
        boolean hasColor;
        this.mIconColor = color2;
        Drawable background = this.getBackground();
        Drawable icon = this.getDrawable();
        boolean bl = hasColor = color2 != 1;
        if (background == null) {
            if (hasColor && icon != null) {
                icon.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            }
        } else if (hasColor) {
            background.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            if (icon != null) {
                icon.mutate().setColorFilter(this.mBackgroundColor, PorterDuff.Mode.SRC_ATOP);
            }
        } else {
            background.mutate().setColorFilter(this.mBackgroundColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void setGrayedOut(boolean grayedOut) {
        Drawable drawable2 = this.getBackground();
        if (drawable2 == null) {
            drawable2 = this.getDrawable();
        }
        ColoredIconHelper.applyGrayTint(this.mContext, drawable2, grayedOut, this.mIconColor);
    }

    public int getOriginalIconColor() {
        return this.mIconColor;
    }

    public boolean willBeForceHidden() {
        return this.mWillBeForceHidden;
    }

    public void setWillBeForceHidden(boolean forceHidden) {
        this.mWillBeForceHidden = forceHidden;
    }

    public int getMaxDrawableWidth() {
        return this.mMaxDrawableWidth;
    }

    public int getMaxDrawableHeight() {
        return this.mMaxDrawableHeight;
    }
}

