/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PropertyInvalidatedCache;
import android.app.RemoteLockscreenValidationResult;
import android.app.RemoteLockscreenValidationSession;
import android.app.admin.DevicePolicyManager;
import android.app.admin.PasswordMetrics;
import android.app.trust.IStrongAuthTracker;
import android.app.trust.TrustManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.UserInfo;
import android.hardware.input.InputManagerGlobal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.view.InputDevice;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.internal.widget.flags.Flags;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.ICheckCredentialProgressCallback;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.IWeakEscrowTokenActivatedListener;
import com.android.internal.widget.IWeakEscrowTokenRemovedListener;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.VerifyCredentialResponse;
import com.google.android.collect.Lists;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LockPatternUtils {
    private static final String TAG = "LockPatternUtils";
    private static final boolean FRP_CREDENTIAL_ENABLED = true;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_LOCK_PASSWORD_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    public static final int CREDENTIAL_TYPE_NONE = -1;
    public static final int CREDENTIAL_TYPE_PATTERN = 1;
    public static final int CREDENTIAL_TYPE_PASSWORD_OR_PIN = 2;
    public static final int CREDENTIAL_TYPE_PIN = 3;
    public static final int CREDENTIAL_TYPE_PASSWORD = 4;
    public static final int PIN_LENGTH_UNAVAILABLE = -1;
    public static final int MIN_AUTO_PIN_REQUIREMENT_LENGTH = 6;
    public static final byte[] ENCRYPTED_REMOTE_CREDENTIALS_HEADER = "encrypted_remote_credentials".getBytes(StandardCharsets.UTF_8);
    public static final int VERIFY_FLAG_REQUEST_GK_PW_HANDLE = 1;
    public static final int VERIFY_FLAG_WRITE_REPAIR_MODE_PW = 2;
    public static final int USER_FRP = -9999;
    public static final int USER_REPAIR_MODE = -9998;
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static final String LOCK_PIN_ENHANCED_PRIVACY = "pin_enhanced_privacy";
    private static final String LOCK_SCREEN_DEVICE_OWNER_INFO = "lockscreen.device_owner_info";
    private static final String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    private static final String KNOWN_TRUST_AGENTS = "lockscreen.knowntrustagents";
    private static final String IS_TRUST_USUALLY_MANAGED = "lockscreen.istrustusuallymanaged";
    public static final String AUTO_PIN_CONFIRM = "lockscreen.auto_pin_confirm";
    public static final String CURRENT_LSKF_BASED_PROTECTOR_ID_KEY = "sp-handle";
    public static final String PASSWORD_HISTORY_DELIMITER = ",";
    private static final String GSI_RUNNING_PROP = "ro.gsid.image_running";
    @UnsupportedAppUsage
    private final Context mContext;
    @UnsupportedAppUsage
    private final ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private UserManager mUserManager;
    private final Handler mHandler;
    private final SparseLongArray mLockoutDeadlines = new SparseLongArray();
    private Boolean mHasSecureLockScreen;
    private final PropertyInvalidatedCache.QueryHandler<Integer, Integer> mCredentialTypeQuery = new PropertyInvalidatedCache.QueryHandler<Integer, Integer>(){

        @Override
        public Integer apply(Integer userHandle) {
            try {
                return LockPatternUtils.this.getLockSettings().getCredentialType(userHandle);
            }
            catch (RemoteException re) {
                Log.e(LockPatternUtils.TAG, "failed to get credential type", re);
                return -1;
            }
        }

        @Override
        public boolean shouldBypassCache(Integer userHandle) {
            return LockPatternUtils.isSpecialUserId(userHandle);
        }
    };
    private static final String CREDENTIAL_TYPE_API = "getCredentialType";
    private final PropertyInvalidatedCache<Integer, Integer> mCredentialTypeCache = new PropertyInvalidatedCache<Integer, Integer>(4, "system_server", "getCredentialType", "getCredentialType", this.mCredentialTypeQuery);

    public static String credentialTypeToString(int credentialType) {
        switch (credentialType) {
            case -1: {
                return "NONE";
            }
            case 1: {
                return "PATTERN";
            }
            case 3: {
                return "PIN";
            }
            case 4: {
                return "PASSWORD";
            }
        }
        return "UNKNOWN_" + credentialType;
    }

    public boolean isTrustUsuallyManaged(int userId) {
        if (!(this.mLockSettingsService instanceof ILockSettings.Stub)) {
            throw new IllegalStateException("May only be called by TrustManagerService. Use TrustManager.isTrustUsuallyManaged()");
        }
        try {
            return this.getLockSettings().getBoolean(IS_TRUST_USUALLY_MANAGED, false, userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setTrustUsuallyManaged(boolean managed, int userId) {
        try {
            this.getLockSettings().setBoolean(IS_TRUST_USUALLY_MANAGED, managed, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void userPresent(int userId) {
        try {
            this.getLockSettings().userPresent(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    private TrustManager getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e(TAG, "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    @UnsupportedAppUsage
    public LockPatternUtils(Context context) {
        this(context, null);
    }

    @VisibleForTesting
    public LockPatternUtils(Context context, ILockSettings lockSettings) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        Looper looper = Looper.myLooper();
        this.mHandler = looper != null ? new Handler(looper) : null;
        this.mLockSettingsService = lockSettings;
    }

    @UnsupportedAppUsage
    @VisibleForTesting
    public ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            ILockSettings service;
            this.mLockSettingsService = service = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    public int getRequestedMinimumPasswordLength(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, userId);
    }

    public int getMaximumPasswordLength(int quality) {
        return this.getDevicePolicyManager().getPasswordMaximumLength(quality);
    }

    public PasswordMetrics getRequestedPasswordMetrics(int userId) {
        return this.getRequestedPasswordMetrics(userId, false);
    }

    public PasswordMetrics getRequestedPasswordMetrics(int userId, boolean deviceWideOnly) {
        return this.getDevicePolicyManager().getPasswordMinimumMetrics(userId, deviceWideOnly);
    }

    private int getRequestedPasswordHistoryLength(int userId) {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, userId);
    }

    public int getRequestedPasswordComplexity(int userId) {
        return this.getRequestedPasswordComplexity(userId, false);
    }

    public int getRequestedPasswordComplexity(int userId, boolean deviceWideOnly) {
        return this.getDevicePolicyManager().getAggregatedPasswordComplexityForUser(userId, deviceWideOnly);
    }

    @UnsupportedAppUsage
    public void reportFailedPasswordAttempt(int userId) {
        if (LockPatternUtils.isSpecialUserId(this.mContext, userId, true)) {
            return;
        }
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        if (!com.android.internal.hidden_from_bootclasspath.android.security.Flags.shouldTrustManagerListenForPrimaryAuth()) {
            this.getTrustManager().reportUnlockAttempt(false, userId);
        }
    }

    @UnsupportedAppUsage
    public void reportSuccessfulPasswordAttempt(int userId) {
        if (LockPatternUtils.isSpecialUserId(this.mContext, userId, true)) {
            return;
        }
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(userId);
        if (!com.android.internal.hidden_from_bootclasspath.android.security.Flags.shouldTrustManagerListenForPrimaryAuth()) {
            this.getTrustManager().reportUnlockAttempt(true, userId);
        }
    }

    public void reportPasswordLockout(int timeoutMs, int userId) {
        if (LockPatternUtils.isSpecialUserId(this.mContext, userId, true)) {
            return;
        }
        this.getTrustManager().reportUnlockLockout(timeoutMs, userId);
    }

    public int getCurrentFailedPasswordAttempts(int userId) {
        if (LockPatternUtils.isSpecialUserId(this.mContext, userId, true)) {
            return 0;
        }
        return this.getDevicePolicyManager().getCurrentFailedPasswordAttempts(userId);
    }

    public int getMaximumFailedPasswordsForWipe(int userId) {
        if (LockPatternUtils.isSpecialUserId(this.mContext, userId, true)) {
            return 0;
        }
        return this.getDevicePolicyManager().getMaximumFailedPasswordsForWipe(null, userId);
    }

    public boolean writeRepairModeCredential(int userId) {
        this.throwIfCalledOnMainThread();
        try {
            return this.getLockSettings().writeRepairModeCredential(userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Failed to write repair mode credential", re);
            return false;
        }
    }

    @NonNull
    public VerifyCredentialResponse verifyCredential(@NonNull LockscreenCredential credential, int userId, int flags) {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyCredential(credential, userId, flags);
            if (response == null) {
                return VerifyCredentialResponse.OTHER_ERROR;
            }
            return response;
        }
        catch (RemoteException re) {
            Log.e(TAG, "failed to verify credential", re);
            return VerifyCredentialResponse.OTHER_ERROR;
        }
    }

    @NonNull
    public VerifyCredentialResponse verifyGatekeeperPasswordHandle(long gatekeeperPasswordHandle, long challenge, int userId) {
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyGatekeeperPasswordHandle(gatekeeperPasswordHandle, challenge, userId);
            if (response == null) {
                return VerifyCredentialResponse.OTHER_ERROR;
            }
            return response;
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to verify gatekeeper password", e);
            return VerifyCredentialResponse.OTHER_ERROR;
        }
    }

    public void removeGatekeeperPasswordHandle(long gatekeeperPasswordHandle) {
        try {
            this.getLockSettings().removeGatekeeperPasswordHandle(gatekeeperPasswordHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to remove gatekeeper password handle", e);
        }
    }

    public boolean checkCredential(@NonNull LockscreenCredential credential, int userId, @Nullable CheckCredentialProgressCallback progressCallback) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkCredential(credential, userId, this.wrapCallback(progressCallback));
            if (response == null) {
                return false;
            }
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            Log.e(TAG, "failed to check credential", re);
            return false;
        }
    }

    @NonNull
    public VerifyCredentialResponse verifyTiedProfileChallenge(@NonNull LockscreenCredential credential, int userId, int flags) {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyTiedProfileChallenge(credential, userId, flags);
            if (response == null) {
                return VerifyCredentialResponse.OTHER_ERROR;
            }
            return response;
        }
        catch (RemoteException re) {
            Log.e(TAG, "failed to verify tied profile credential", re);
            return VerifyCredentialResponse.OTHER_ERROR;
        }
    }

    public byte[] getPasswordHistoryHashFactor(@NonNull LockscreenCredential currentPassword, int userId) {
        try {
            return this.getLockSettings().getHashFactor(currentPassword, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get hash factor", e);
            return null;
        }
    }

    public boolean checkPasswordHistory(byte[] passwordToCheck, byte[] hashFactor, int userId) {
        if (passwordToCheck == null || passwordToCheck.length == 0) {
            Log.e(TAG, "checkPasswordHistory: empty password");
            return false;
        }
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userId);
        if (TextUtils.isEmpty(passwordHistory)) {
            return false;
        }
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength(userId);
        if (passwordHistoryLength == 0) {
            return false;
        }
        byte[] salt = this.getSalt(userId).getBytes();
        String legacyHash = LockscreenCredential.legacyPasswordToHash(passwordToCheck, salt);
        String passwordHash = LockscreenCredential.passwordToHistoryHash(passwordToCheck, salt, hashFactor);
        String[] history = passwordHistory.split(PASSWORD_HISTORY_DELIMITER);
        for (int i = 0; i < Math.min(passwordHistoryLength, history.length); ++i) {
            if (!history[i].equals(legacyHash) && !history[i].equals(passwordHash)) continue;
            return true;
        }
        return false;
    }

    public int getPinLength(int userId) {
        try {
            return this.getLockSettings().getPinLength(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not fetch PIN length " + e);
            return -1;
        }
    }

    public boolean refreshStoredPinLength(int userId) {
        try {
            return this.getLockSettings().refreshStoredPinLength(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not store PIN length on disk " + e);
            return false;
        }
    }

    @UnsupportedAppUsage
    public int getActivePasswordQuality(int userId) {
        return this.getKeyguardStoredPasswordQuality(userId);
    }

    public void resetKeyStore(int userId) {
        try {
            this.getLockSettings().resetKeyStore(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't reset keystore " + e);
        }
    }

    public void setLockScreenDisabled(boolean disable, int userId) {
        this.setBoolean(DISABLE_LOCKSCREEN_KEY, disable, userId);
    }

    @UnsupportedAppUsage
    public boolean isLockScreenDisabled(int userId) {
        if (this.isSecure(userId)) {
            return false;
        }
        boolean disabledByDefault = this.mContext.getResources().getBoolean(0x1110141);
        UserInfo userInfo = this.getUserManager().getUserInfo(userId);
        boolean isDemoUser = UserManager.isDeviceInDemoMode(this.mContext) && userInfo != null && userInfo.isDemo();
        return this.getBoolean(DISABLE_LOCKSCREEN_KEY, false, userId) || disabledByDefault || isDemoUser;
    }

    public void setAutoPinConfirm(boolean enabled, int userId) {
        this.setBoolean(AUTO_PIN_CONFIRM, enabled, userId);
    }

    public boolean isAutoPinConfirmEnabled(int userId) {
        return this.getBoolean(AUTO_PIN_CONFIRM, false, userId);
    }

    public static boolean isQualityAlphabeticPassword(int quality) {
        return quality >= 262144;
    }

    public static boolean isQualityNumericPin(int quality) {
        return quality == 131072 || quality == 196608;
    }

    public static int credentialTypeToPasswordQuality(int credentialType) {
        switch (credentialType) {
            case -1: {
                return 0;
            }
            case 1: {
                return 65536;
            }
            case 3: {
                return 131072;
            }
            case 4: {
                return 262144;
            }
        }
        throw new IllegalStateException("Unknown type: " + credentialType);
    }

    public static int pinOrPasswordQualityToCredentialType(int quality) {
        if (LockPatternUtils.isQualityAlphabeticPassword(quality)) {
            return 4;
        }
        if (LockPatternUtils.isQualityNumericPin(quality)) {
            return 3;
        }
        throw new IllegalArgumentException("Quality is neither Pin nor password: " + quality);
    }

    public boolean setLockCredential(@NonNull LockscreenCredential newCredential, @NonNull LockscreenCredential savedCredential, int userHandle) {
        if (!this.hasSecureLockScreen() && newCredential.getType() != -1) {
            throw new UnsupportedOperationException("This operation requires the lock screen feature.");
        }
        try {
            if (!this.getLockSettings().setLockCredential(newCredential, savedCredential, userHandle)) {
                return false;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Unable to save lock password", e);
        }
        return true;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setOwnerInfo(String info, int userId) {
        this.setString(LOCK_SCREEN_OWNER_INFO, info, userId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setOwnerInfoEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, enabled, userId);
    }

    @UnsupportedAppUsage
    public String getOwnerInfo(int userId) {
        return this.getString(LOCK_SCREEN_OWNER_INFO, userId);
    }

    public boolean isOwnerInfoEnabled(int userId) {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false, userId);
    }

    public void setDeviceOwnerInfo(String info) {
        if (info != null && info.isEmpty()) {
            info = null;
        }
        this.setString(LOCK_SCREEN_DEVICE_OWNER_INFO, info, 0);
    }

    public String getDeviceOwnerInfo() {
        return this.getString(LOCK_SCREEN_DEVICE_OWNER_INFO, 0);
    }

    public boolean isDeviceOwnerInfoEnabled() {
        return this.getDeviceOwnerInfo() != null;
    }

    @UnsupportedAppUsage
    public static boolean isDeviceEncryptionEnabled() {
        return StorageManager.isEncrypted();
    }

    public static boolean isFileEncryptionEnabled() {
        return StorageManager.isFileEncrypted();
    }

    @Deprecated
    @UnsupportedAppUsage
    public int getKeyguardStoredPasswordQuality(int userHandle) {
        return LockPatternUtils.credentialTypeToPasswordQuality(this.getCredentialTypeForUser(userHandle));
    }

    public void setSeparateProfileChallengeEnabled(int userHandle, boolean enabled, LockscreenCredential profilePassword) {
        if (!this.isCredentialShareableWithParent(userHandle)) {
            return;
        }
        try {
            this.getLockSettings().setSeparateProfileChallengeEnabled(userHandle, enabled, profilePassword);
            this.reportEnabledTrustAgentsChanged(userHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't update work profile challenge enabled");
        }
    }

    public boolean isSeparateProfileChallengeEnabled(int userHandle) {
        return this.isCredentialShareableWithParent(userHandle) && this.hasSeparateChallenge(userHandle);
    }

    public boolean isProfileWithUnifiedChallenge(int userHandle) {
        return this.isCredentialShareableWithParent(userHandle) && !this.hasSeparateChallenge(userHandle);
    }

    public boolean isManagedProfileWithUnifiedChallenge(int userHandle) {
        return this.isManagedProfile(userHandle) && !this.hasSeparateChallenge(userHandle);
    }

    private boolean hasSeparateChallenge(int userHandle) {
        try {
            return this.getLockSettings().getSeparateProfileChallengeEnabled(userHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't get separate profile challenge enabled");
            return false;
        }
    }

    private boolean isManagedProfile(int userHandle) {
        UserInfo info = this.getUserManager().getUserInfo(userHandle);
        return info != null && info.isManagedProfile();
    }

    private boolean isCredentialShareableWithParent(int userHandle) {
        try {
            return this.getUserManager().getUserProperties(UserHandle.of(userHandle)).isCredentialShareableWithParent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static List<LockPatternView.Cell> byteArrayToPattern(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = (byte)(bytes[i] - 49);
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static byte[] patternToByteArray(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return new byte[0];
        }
        int patternSize = pattern.size();
        byte[] res = ArrayUtils.newNonMovableByteArray(patternSize);
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn() + 49);
        }
        return res;
    }

    private String getSalt(int userId) {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt, userId);
                Log.v(TAG, "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public static void invalidateCredentialTypeCache() {
        PropertyInvalidatedCache.invalidateCache("system_server", CREDENTIAL_TYPE_API);
    }

    public int getCredentialTypeForUser(int userHandle) {
        return this.mCredentialTypeCache.query(userHandle);
    }

    @UnsupportedAppUsage
    public boolean isSecure(int userId) {
        int type = this.getCredentialTypeForUser(userId);
        return type != -1;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isLockPasswordEnabled(int userId) {
        int type = this.getCredentialTypeForUser(userId);
        return type == 4 || type == 3;
    }

    @UnsupportedAppUsage
    public boolean isLockPatternEnabled(int userId) {
        int type = this.getCredentialTypeForUser(userId);
        return type == 1;
    }

    private boolean hasActivePointerDeviceAttached() {
        return !this.getEnabledNonTouchInputDevices(2).isEmpty();
    }

    @UnsupportedAppUsage
    public boolean isVisiblePatternEnabled(int userId) {
        boolean defaultValue = true;
        if (Flags.hideLastCharWithPhysicalInput()) {
            defaultValue = !this.hasActivePointerDeviceAttached();
        }
        return this.getBoolean("lock_pattern_visible_pattern", defaultValue, userId);
    }

    public void setVisiblePatternEnabled(boolean enabled, int userId) {
        this.setBoolean("lock_pattern_visible_pattern", enabled, userId);
    }

    public boolean isVisiblePatternEverChosen(int userId) {
        return this.getString("lock_pattern_visible_pattern", userId) != null;
    }

    private List<InputDevice> getEnabledNonTouchInputDevices(int source) {
        InputManagerGlobal inputManager = InputManagerGlobal.getInstance();
        int[] inputIds = inputManager.getInputDeviceIds();
        ArrayList<InputDevice> matchingDevices = new ArrayList<InputDevice>();
        for (int deviceId : inputIds) {
            InputDevice inputDevice = inputManager.getInputDevice(deviceId);
            if (!inputDevice.isEnabled() || inputDevice.supportsSource(4098) || inputDevice.isVirtual() || !inputDevice.supportsSource(source)) continue;
            matchingDevices.add(inputDevice);
        }
        return matchingDevices;
    }

    private boolean hasPhysicalKeyboardActive() {
        List<InputDevice> keyboards = this.getEnabledNonTouchInputDevices(257);
        for (InputDevice keyboard : keyboards) {
            if (!keyboard.isFullKeyboard()) continue;
            return true;
        }
        return false;
    }

    public boolean isPinEnhancedPrivacyEnabled(int userId) {
        boolean defaultValue = false;
        if (Flags.hideLastCharWithPhysicalInput()) {
            defaultValue = this.hasPhysicalKeyboardActive();
        }
        return this.getBoolean(LOCK_PIN_ENHANCED_PRIVACY, defaultValue, userId);
    }

    public void setPinEnhancedPrivacyEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCK_PIN_ENHANCED_PRIVACY, enabled, userId);
    }

    public boolean isPinEnhancedPrivacyEverChosen(int userId) {
        return this.getString(LOCK_PIN_ENHANCED_PRIVACY, userId) != null;
    }

    @UnsupportedAppUsage
    public long setLockoutAttemptDeadline(int userId, int timeoutMs) {
        long deadline = SystemClock.elapsedRealtime() + (long)timeoutMs;
        if (userId == -9999) {
            return deadline;
        }
        this.mLockoutDeadlines.put(userId, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline(int userId) {
        long now;
        long deadline = this.mLockoutDeadlines.get(userId, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) && deadline != 0L) {
            this.mLockoutDeadlines.put(userId, 0L);
            return 0L;
        }
        return deadline;
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private long getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    @UnsupportedAppUsage
    private void setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write long " + secureSettingKey + re);
        }
    }

    @UnsupportedAppUsage
    private String getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @UnsupportedAppUsage
    private void setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write string " + secureSettingKey + re);
        }
    }

    public void setPowerButtonInstantlyLocks(boolean enabled, int userId) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, enabled, userId);
    }

    @UnsupportedAppUsage
    public boolean getPowerButtonInstantlyLocks(int userId) {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true, userId);
    }

    public boolean isPowerButtonInstantlyLocksEverChosen(int userId) {
        return this.getString(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, userId) != null;
    }

    public void setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        this.setString(ENABLED_TRUST_AGENTS, this.serializeTrustAgents(activeTrustAgents), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(userId);
    }

    public List<ComponentName> getEnabledTrustAgents(int userId) {
        return this.deserializeTrustAgents(this.getString(ENABLED_TRUST_AGENTS, userId));
    }

    public void setKnownTrustAgents(Collection<ComponentName> knownTrustAgents, int userId) {
        this.setString(KNOWN_TRUST_AGENTS, this.serializeTrustAgents(knownTrustAgents), userId);
    }

    public List<ComponentName> getKnownTrustAgents(int userId) {
        return this.deserializeTrustAgents(this.getString(KNOWN_TRUST_AGENTS, userId));
    }

    private String serializeTrustAgents(Collection<ComponentName> trustAgents) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : trustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        return sb.toString();
    }

    private List<ComponentName> deserializeTrustAgents(String serializedTrustAgents) {
        if (TextUtils.isEmpty(serializedTrustAgents)) {
            return new ArrayList<ComponentName>();
        }
        String[] split = serializedTrustAgents.split(PASSWORD_HISTORY_DELIMITER);
        ArrayList<ComponentName> trustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            trustAgents.add(ComponentName.unflattenFromString(s));
        }
        return trustAgents;
    }

    public void requireCredentialEntry(int userId) {
        this.requireStrongAuth(4, userId);
    }

    public void requireStrongAuth(int strongAuthReason, int userId) {
        try {
            this.getLockSettings().requireStrongAuth(strongAuthReason, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error while requesting strong auth: " + e);
        }
    }

    private void reportEnabledTrustAgentsChanged(int userHandle) {
        this.getTrustManager().reportEnabledTrustAgentsChanged(userHandle);
    }

    private void throwIfCalledOnMainThread() {
        if (Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalStateException("should not be called from the main thread.");
        }
    }

    public void registerStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().registerStrongAuthTracker(strongAuthTracker.getStub());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unregisterStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().unregisterStrongAuthTracker(strongAuthTracker.getStub());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not unregister StrongAuthTracker", e);
        }
    }

    public boolean registerWeakEscrowTokenRemovedListener(@NonNull IWeakEscrowTokenRemovedListener listener) {
        try {
            return this.getLockSettings().registerWeakEscrowTokenRemovedListener(listener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not register WeakEscrowTokenRemovedListener.");
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean unregisterWeakEscrowTokenRemovedListener(@NonNull IWeakEscrowTokenRemovedListener listener) {
        try {
            return this.getLockSettings().unregisterWeakEscrowTokenRemovedListener(listener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not register WeakEscrowTokenRemovedListener.");
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportSuccessfulBiometricUnlock(boolean isStrongBiometric, int userId) {
        try {
            this.getLockSettings().reportSuccessfulBiometricUnlock(isStrongBiometric, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not report successful biometric unlock", e);
        }
    }

    public void scheduleNonStrongBiometricIdleTimeout(int userId) {
        try {
            this.getLockSettings().scheduleNonStrongBiometricIdleTimeout(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not schedule non-strong biometric idle timeout", e);
        }
    }

    public int getStrongAuthForUser(int userId) {
        try {
            return this.getLockSettings().getStrongAuthForUser(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not get StrongAuth", e);
            return StrongAuthTracker.getDefaultFlags(this.mContext);
        }
    }

    public boolean isCredentialsDisabledForUser(int userId) {
        return this.getDevicePolicyManager().getPasswordQuality(null, userId) == 524288;
    }

    public boolean isTrustAllowedForUser(int userId) {
        return this.getStrongAuthForUser(userId) == 0;
    }

    public boolean isBiometricAllowedForUser(int userId) {
        return (this.getStrongAuthForUser(userId) & 0xFFFFF8FB) == 0;
    }

    public boolean isUserInLockdown(int userId) {
        return (this.getStrongAuthForUser(userId) & 0x20) != 0;
    }

    private ICheckCredentialProgressCallback wrapCallback(CheckCredentialProgressCallback callback) {
        if (callback == null) {
            return null;
        }
        if (this.mHandler == null) {
            throw new IllegalStateException("Must construct LockPatternUtils on a looper thread to use progress callbacks.");
        }
        return new WrappedCallback(this.mHandler, callback);
    }

    public long addWeakEscrowToken(byte[] token, int userId, @NonNull IWeakEscrowTokenActivatedListener callback) {
        try {
            return this.getLockSettings().addWeakEscrowToken(token, userId, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not add weak token.");
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeWeakEscrowToken(long handle, int userId) {
        try {
            return this.getLockSettings().removeWeakEscrowToken(handle, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not remove the weak token.");
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWeakEscrowTokenActive(long handle, int userId) {
        try {
            return this.getLockSettings().isWeakEscrowTokenActive(handle, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not check the weak token.");
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWeakEscrowTokenValid(long handle, byte[] token, int userId) {
        try {
            return this.getLockSettings().isWeakEscrowTokenValid(handle, token, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not validate the weak token.");
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasPendingEscrowToken(int userId) {
        try {
            return this.getLockSettings().hasPendingEscrowToken(userId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean hasSecureLockScreen() {
        if (this.mHasSecureLockScreen == null) {
            try {
                this.mHasSecureLockScreen = this.getLockSettings().hasSecureLockScreen();
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return this.mHasSecureLockScreen;
    }

    public static boolean userOwnsFrpCredential(Context context, UserInfo info) {
        return info != null && info.isMain() && info.isAdmin() && LockPatternUtils.frpCredentialEnabled(context);
    }

    public static boolean frpCredentialEnabled(Context context) {
        return context.getResources().getBoolean(17891701);
    }

    public static boolean isRepairModeSupported(Context context) {
        return context.getResources().getBoolean(17891879);
    }

    public static boolean isRepairModeActive(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "repair_mode_active", 0) > 0;
    }

    public static boolean canUserEnterRepairMode(Context context, UserInfo info) {
        return info != null && info.isAdmin() && LockPatternUtils.isRepairModeSupported(context);
    }

    public static boolean isGsiRunning() {
        return SystemProperties.getInt(GSI_RUNNING_PROP, 0) > 0;
    }

    public static boolean isSpecialUserId(int userId) {
        return LockPatternUtils.isSpecialUserId(null, userId, false);
    }

    private static boolean isSpecialUserId(@Nullable Context context, int userId, boolean checkDeviceSupported) {
        switch (userId) {
            case -9999: {
                if (checkDeviceSupported) {
                    return LockPatternUtils.frpCredentialEnabled(context);
                }
                return true;
            }
            case -9998: {
                if (checkDeviceSupported) {
                    return LockPatternUtils.isRepairModeSupported(context);
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryUnlockWithCachedUnifiedChallenge(int userId) {
        try {
            return this.getLockSettings().tryUnlockWithCachedUnifiedChallenge(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public void removeCachedUnifiedChallenge(int userId) {
        try {
            this.getLockSettings().removeCachedUnifiedChallenge(userId);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    public void unlockUserKeyIfUnsecured(int userId) {
        try {
            this.getLockSettings().unlockUserKeyIfUnsecured(userId);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    @NonNull
    public RemoteLockscreenValidationSession startRemoteLockscreenValidation() {
        try {
            return this.getLockSettings().startRemoteLockscreenValidation();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public RemoteLockscreenValidationResult validateRemoteLockscreen(@NonNull byte[] encryptedCredential) {
        try {
            return this.getLockSettings().validateRemoteLockscreen(encryptedCredential);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface CheckCredentialProgressCallback {
        public void onEarlyMatched();
    }

    public static class RequestThrottledException
    extends Exception {
        private int mTimeoutMs;

        @UnsupportedAppUsage
        public RequestThrottledException(int timeoutMs) {
            this.mTimeoutMs = timeoutMs;
        }

        @UnsupportedAppUsage
        public int getTimeoutMs() {
            return this.mTimeoutMs;
        }
    }

    public static class StrongAuthTracker {
        public static final int STRONG_AUTH_NOT_REQUIRED = 0;
        public static final int STRONG_AUTH_REQUIRED_AFTER_BOOT = 1;
        public static final int STRONG_AUTH_REQUIRED_AFTER_DPM_LOCK_NOW = 2;
        public static final int SOME_AUTH_REQUIRED_AFTER_USER_REQUEST = 4;
        public static final int STRONG_AUTH_REQUIRED_AFTER_LOCKOUT = 8;
        public static final int STRONG_AUTH_REQUIRED_AFTER_TIMEOUT = 16;
        public static final int STRONG_AUTH_REQUIRED_AFTER_USER_LOCKDOWN = 32;
        public static final int STRONG_AUTH_REQUIRED_FOR_UNATTENDED_UPDATE = 64;
        public static final int STRONG_AUTH_REQUIRED_AFTER_NON_STRONG_BIOMETRICS_TIMEOUT = 128;
        public static final int SOME_AUTH_REQUIRED_AFTER_TRUSTAGENT_EXPIRED = 256;
        public static final int SOME_AUTH_REQUIRED_AFTER_ADAPTIVE_AUTH_REQUEST = 512;
        public static final int SOME_AUTH_REQUIRED_AFTER_WATCH_DISCONNECTED = 1024;
        private static final int ALLOWING_BIOMETRIC = 1796;
        private final SparseIntArray mStrongAuthRequiredForUser = new SparseIntArray();
        private final H mHandler;
        private final int mDefaultStrongAuthFlags;
        private final SparseBooleanArray mIsNonStrongBiometricAllowedForUser = new SparseBooleanArray();
        private final boolean mDefaultIsNonStrongBiometricAllowed = true;
        private final IStrongAuthTracker.Stub mStub = new IStrongAuthTracker.Stub(){

            @Override
            public void onStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
                mHandler.obtainMessage(1, strongAuthFlags, userId).sendToTarget();
            }

            @Override
            public void onIsNonStrongBiometricAllowedChanged(boolean allowed, int userId) {
                mHandler.obtainMessage(2, allowed ? 1 : 0, userId).sendToTarget();
            }
        };

        public StrongAuthTracker(Context context) {
            this(context, Looper.myLooper());
        }

        public StrongAuthTracker(Context context, Looper looper) {
            this.mHandler = new H(looper);
            this.mDefaultStrongAuthFlags = StrongAuthTracker.getDefaultFlags(context);
        }

        public static int getDefaultFlags(Context context) {
            boolean strongAuthRequired = context.getResources().getBoolean(17891941);
            return strongAuthRequired ? 1 : 0;
        }

        public int getStrongAuthForUser(int userId) {
            return this.mStrongAuthRequiredForUser.get(userId, this.mDefaultStrongAuthFlags);
        }

        public boolean isTrustAllowedForUser(int userId) {
            return this.getStrongAuthForUser(userId) == 0;
        }

        public boolean isBiometricAllowedForUser(boolean isStrongBiometric, int userId) {
            boolean allowed;
            boolean bl = allowed = (this.getStrongAuthForUser(userId) & 0xFFFFF8FB) == 0;
            if (!isStrongBiometric) {
                allowed &= this.isNonStrongBiometricAllowedAfterIdleTimeout(userId);
            }
            return allowed;
        }

        public boolean isNonStrongBiometricAllowedAfterIdleTimeout(int userId) {
            return this.mIsNonStrongBiometricAllowedForUser.get(userId, true);
        }

        public void onStrongAuthRequiredChanged(int userId) {
        }

        public void onIsNonStrongBiometricAllowedChanged(int userId) {
        }

        protected void handleStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
            int oldValue = this.getStrongAuthForUser(userId);
            if (strongAuthFlags != oldValue) {
                if (strongAuthFlags == this.mDefaultStrongAuthFlags) {
                    this.mStrongAuthRequiredForUser.delete(userId);
                } else {
                    this.mStrongAuthRequiredForUser.put(userId, strongAuthFlags);
                }
                this.onStrongAuthRequiredChanged(userId);
            }
        }

        protected void handleIsNonStrongBiometricAllowedChanged(boolean allowed, int userId) {
            boolean oldValue = this.isNonStrongBiometricAllowedAfterIdleTimeout(userId);
            if (allowed != oldValue) {
                if (allowed) {
                    this.mIsNonStrongBiometricAllowedForUser.delete(userId);
                } else {
                    this.mIsNonStrongBiometricAllowedForUser.put(userId, allowed);
                }
                this.onIsNonStrongBiometricAllowedChanged(userId);
            }
        }

        public IStrongAuthTracker.Stub getStub() {
            return this.mStub;
        }

        private class H
        extends Handler {
            static final int MSG_ON_STRONG_AUTH_REQUIRED_CHANGED = 1;
            static final int MSG_ON_IS_NON_STRONG_BIOMETRIC_ALLOWED_CHANGED = 2;

            public H(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        StrongAuthTracker.this.handleStrongAuthRequiredChanged(msg.arg1, msg.arg2);
                        break;
                    }
                    case 2: {
                        StrongAuthTracker.this.handleIsNonStrongBiometricAllowedChanged(msg.arg1 == 1, msg.arg2);
                    }
                }
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StrongAuthFlags {
        }
    }

    private static class WrappedCallback
    extends ICheckCredentialProgressCallback.Stub {
        private Handler mHandler;
        private CheckCredentialProgressCallback mCallback;

        WrappedCallback(Handler handler, CheckCredentialProgressCallback callback) {
            this.mHandler = handler;
            this.mCallback = callback;
        }

        @Override
        public void onCredentialVerified() throws RemoteException {
            if (this.mHandler == null) {
                Log.e(LockPatternUtils.TAG, "Handler is null during callback");
            }
            this.mHandler.post(() -> {
                this.mCallback.onEarlyMatched();
                this.mCallback = null;
            });
            this.mHandler = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerifyFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CredentialType {
    }
}

