/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Person;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.widget.ImageFloatingTextView;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPool;
import com.android.internal.widget.MessagingPropertyAnimator;
import com.android.internal.widget.NotificationOptimizedLinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@RemoteViews.RemoteView
public class MessagingGroup
extends NotificationOptimizedLinearLayout
implements MessagingLinearLayout.MessagingChild {
    private static final MessagingPool<MessagingGroup> sInstancePool = new MessagingPool(10);
    public static final int IMAGE_DISPLAY_LOCATION_INLINE = 0;
    public static final int IMAGE_DISPLAY_LOCATION_AT_END = 1;
    public static final int IMAGE_DISPLAY_LOCATION_EXTERNAL = 2;
    private MessagingLinearLayout mMessageContainer;
    ImageFloatingTextView mSenderView;
    private ImageView mAvatarView;
    private String mAvatarSymbol = "";
    private int mLayoutColor;
    private CharSequence mAvatarName = "";
    private Icon mAvatarIcon;
    private int mTextColor;
    private int mSendingTextColor;
    private List<MessagingMessage> mMessages;
    private ArrayList<MessagingMessage> mAddedMessages = new ArrayList();
    private boolean mFirstLayout;
    private boolean mIsHidingAnimated;
    private boolean mNeedsGeneratedAvatar;
    private Person mSender;
    private int mImageDisplayLocation;
    private ViewGroup mImageContainer;
    private MessagingImageMessage mIsolatedMessage;
    private boolean mClippingDisabled;
    private Point mDisplaySize = new Point();
    private ProgressBar mSendingSpinner;
    private View mSendingSpinnerContainer;
    private boolean mShowingAvatar = true;
    private CharSequence mSenderName;
    private boolean mSingleLine = false;
    private boolean mIsCollapsed = false;
    private LinearLayout mContentContainer;
    private int mRequestedMaxDisplayedLines = Integer.MAX_VALUE;
    private int mSenderTextPaddingSingleLine;
    private boolean mIsFirstGroupInLayout = true;
    private boolean mCanHideSenderIfFirst;
    private boolean mIsInConversation = true;
    private ViewGroup mMessagingIconContainer;
    private int mConversationContentStart;
    private int mNonConversationContentStart;
    private int mNonConversationPaddingStart;
    private int mConversationAvatarSize;
    private int mNonConversationAvatarSize;
    private int mNotificationTextMarginTop;

    public MessagingGroup(@NonNull Context context) {
        super(context);
    }

    public MessagingGroup(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MessagingGroup(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MessagingGroup(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMessageContainer = (MessagingLinearLayout)this.findViewById(16909132);
        this.mSenderView = (ImageFloatingTextView)this.findViewById(16909292);
        this.mAvatarView = (ImageView)this.findViewById(16909290);
        this.mImageContainer = (ViewGroup)this.findViewById(16909295);
        this.mSendingSpinner = (ProgressBar)this.findViewById(16909296);
        this.mMessagingIconContainer = (ViewGroup)this.findViewById(16909291);
        this.mContentContainer = (LinearLayout)this.findViewById(16909294);
        this.mSendingSpinnerContainer = this.findViewById(16909297);
        Resources res = this.getResources();
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        this.mDisplaySize.x = displayMetrics.widthPixels;
        this.mDisplaySize.y = displayMetrics.heightPixels;
        this.mSenderTextPaddingSingleLine = res.getDimensionPixelSize(17105499);
        this.mConversationContentStart = res.getDimensionPixelSize(17105203);
        this.mNonConversationContentStart = res.getDimensionPixelSize(17105578);
        this.mNonConversationPaddingStart = res.getDimensionPixelSize(17105504);
        this.mConversationAvatarSize = res.getDimensionPixelSize(17105497);
        this.mNonConversationAvatarSize = res.getDimensionPixelSize(17105608);
        this.mNotificationTextMarginTop = res.getDimensionPixelSize(17105644);
    }

    public void updateClipRect() {
        Rect clipRect;
        if (this.mSenderView.getVisibility() != 8 && !this.mClippingDisabled) {
            int top = this.mSingleLine ? 0 : this.getDistanceFromParent(this.mSenderView, this.mContentContainer) - this.getDistanceFromParent(this.mMessageContainer, this.mContentContainer) + this.mSenderView.getHeight();
            int size = Math.max(this.mDisplaySize.x, this.mDisplaySize.y);
            clipRect = new Rect(-size, top, size, size);
        } else {
            clipRect = null;
        }
        this.mMessageContainer.setClipBounds(clipRect);
    }

    private int getDistanceFromParent(View searchedView, ViewGroup parent) {
        int position = 0;
        for (View view = searchedView; view != parent; view = (View)((Object)view.getParent())) {
            position = (int)((float)position + ((float)view.getTop() + view.getTranslationY()));
        }
        return position;
    }

    public void setSender(Person sender, CharSequence nameOverride) {
        this.mSender = sender;
        if (nameOverride == null) {
            nameOverride = sender.getName();
        }
        if (Flags.cleanUpSpansAndNewLines() && nameOverride != null) {
            nameOverride = nameOverride.toString();
        }
        this.mSenderName = nameOverride;
        if (this.mSingleLine && !TextUtils.isEmpty(nameOverride)) {
            nameOverride = this.mContext.getResources().getString(17040153, nameOverride);
        }
        this.mSenderView.setText(nameOverride);
        boolean bl = this.mNeedsGeneratedAvatar = sender.getIcon() == null;
        if (!this.mNeedsGeneratedAvatar) {
            this.setAvatar(sender.getIcon());
        }
        this.updateSenderVisibility();
    }

    public void setShowingAvatar(boolean showingAvatar) {
        this.mAvatarView.setVisibility(showingAvatar ? 0 : 8);
        this.mShowingAvatar = showingAvatar;
    }

    public void setSending(boolean sending) {
        int visibility;
        int n = visibility = sending ? 0 : 8;
        if (this.mSendingSpinnerContainer.getVisibility() != visibility) {
            this.mSendingSpinnerContainer.setVisibility(visibility);
            this.updateMessageColor();
        }
    }

    private int calculateSendingTextColor() {
        TypedValue alphaValue = new TypedValue();
        this.mContext.getResources().getValue(17105639, alphaValue, true);
        float alpha = alphaValue.getFloat();
        return Color.valueOf(Color.red(this.mTextColor), Color.green(this.mTextColor), Color.blue(this.mTextColor), alpha).toArgb();
    }

    public void setAvatar(Icon icon) {
        this.mAvatarIcon = icon;
        if (this.mShowingAvatar || icon == null) {
            this.mAvatarView.setImageIcon(icon);
        }
        this.mAvatarSymbol = "";
        this.mAvatarName = "";
    }

    static MessagingGroup createGroup(MessagingLinearLayout layout2) {
        MessagingGroup createdGroup = (MessagingGroup)sInstancePool.acquire();
        if (createdGroup == null) {
            createdGroup = (MessagingGroup)LayoutInflater.from(layout2.getContext()).inflate(MessagingGroup.getMessagingGroupLayoutResource(), (ViewGroup)layout2, false);
            createdGroup.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        layout2.addView(createdGroup);
        return createdGroup;
    }

    private static int getMessagingGroupLayoutResource() {
        if (Flags.notificationsRedesignTemplates()) {
            return 17367226;
        }
        return 17367279;
    }

    public void removeMessage(MessagingMessage messagingMessage, ArrayList<MessagingLinearLayout.MessagingChild> toRecycle) {
        View view = messagingMessage.getView();
        boolean wasShown = view.isShown();
        ViewGroup messageParent = (ViewGroup)view.getParent();
        if (messageParent == null) {
            return;
        }
        messageParent.removeView(view);
        if (wasShown && !MessagingLinearLayout.isGone(view)) {
            messageParent.addTransientView(view, 0);
            this.performRemoveAnimation(view, () -> {
                messageParent.removeTransientView(view);
                messagingMessage.recycle();
            });
        } else {
            toRecycle.add(messagingMessage);
        }
    }

    @Override
    public void recycle() {
        if (this.mIsolatedMessage != null) {
            this.mImageContainer.removeView(this.mIsolatedMessage);
        }
        for (int i = 0; i < this.mMessages.size(); ++i) {
            MessagingMessage message = this.mMessages.get(i);
            this.mMessageContainer.removeView(message.getView());
            message.recycle();
        }
        this.setAvatar(null);
        this.mAvatarView.setAlpha(1.0f);
        this.mAvatarView.setTranslationY(0.0f);
        this.mSenderView.setAlpha(1.0f);
        this.mSenderView.setTranslationY(0.0f);
        this.setAlpha(1.0f);
        this.mIsolatedMessage = null;
        this.mMessages = null;
        this.mSenderName = null;
        this.mAddedMessages.clear();
        this.mFirstLayout = true;
        this.setCanHideSenderIfFirst(false);
        this.setIsFirstInLayout(true);
        this.setMaxDisplayedLines(Integer.MAX_VALUE);
        this.setSingleLine(false);
        this.setShowingAvatar(true);
        MessagingPropertyAnimator.recycle(this);
        sInstancePool.release(this);
    }

    public void removeGroupAnimated(Runnable endAction) {
        this.performRemoveAnimation(this, () -> {
            this.setAlpha(1.0f);
            MessagingPropertyAnimator.setToLaidOutPosition(this);
            if (endAction != null) {
                endAction.run();
            }
        });
    }

    public void performRemoveAnimation(View message, Runnable endAction) {
        this.performRemoveAnimation(message, -message.getHeight(), endAction);
    }

    private void performRemoveAnimation(View view, int disappearTranslation, Runnable endAction) {
        MessagingPropertyAnimator.startLocalTranslationTo(view, disappearTranslation, MessagingLayout.FAST_OUT_LINEAR_IN);
        MessagingPropertyAnimator.fadeOut(view, endAction);
    }

    public CharSequence getSenderName() {
        return this.mSenderName;
    }

    public static void dropCache() {
        sInstancePool.clear();
    }

    @Override
    public int getMeasuredType() {
        if (this.mIsolatedMessage != null) {
            return 1;
        }
        boolean hasNormal = false;
        for (int i = this.mMessageContainer.getChildCount() - 1; i >= 0; --i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (child.getVisibility() == 8 || !(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            int type = ((MessagingLinearLayout.MessagingChild)((Object)child)).getMeasuredType();
            boolean tooSmall = type == 2;
            MessagingLinearLayout.LayoutParams lp = (MessagingLinearLayout.LayoutParams)child.getLayoutParams();
            if (tooSmall |= lp.hide) {
                if (hasNormal) {
                    return 1;
                }
                return 2;
            }
            if (type == 1) {
                return 1;
            }
            hasNormal = true;
        }
        return 0;
    }

    @Override
    public int getConsumedLines() {
        int result = 0;
        for (int i = 0; i < this.mMessageContainer.getChildCount(); ++i) {
            View child = this.mMessageContainer.getChildAt(i);
            if (!(child instanceof MessagingLinearLayout.MessagingChild)) continue;
            result += ((MessagingLinearLayout.MessagingChild)((Object)child)).getConsumedLines();
        }
        result = this.mIsolatedMessage != null ? Math.max(result, 1) : result;
        return result + 1;
    }

    @Override
    public void setMaxDisplayedLines(int lines) {
        this.mRequestedMaxDisplayedLines = lines;
        this.updateMaxDisplayedLines();
    }

    private void updateMaxDisplayedLines() {
        this.mMessageContainer.setMaxDisplayedLines(this.mSingleLine ? 1 : this.mRequestedMaxDisplayedLines);
    }

    @Override
    public void hideAnimated() {
        this.setIsHidingAnimated(true);
        this.removeGroupAnimated(() -> this.setIsHidingAnimated(false));
    }

    @Override
    public boolean isHidingAnimated() {
        return this.mIsHidingAnimated;
    }

    @Override
    public void setIsFirstInLayout(boolean first) {
        if (first != this.mIsFirstGroupInLayout) {
            this.mIsFirstGroupInLayout = first;
            this.updateSenderVisibility();
        }
    }

    public boolean hasSenderNameHidden() {
        return this.mSenderView.getVisibility() == 8;
    }

    public void setCanHideSenderIfFirst(boolean canHide) {
        if (this.mCanHideSenderIfFirst != canHide) {
            this.mCanHideSenderIfFirst = canHide;
            this.updateSenderVisibility();
        }
    }

    private void updateSenderVisibility() {
        boolean hidden = (this.mIsFirstGroupInLayout || this.mSingleLine) && this.mCanHideSenderIfFirst || TextUtils.isEmpty(this.mSenderName);
        this.mSenderView.setVisibility(hidden ? 8 : 0);
    }

    private void updateIconVisibility() {
        if (Flags.notificationsRedesignTemplates()) {
            this.mMessagingIconContainer.setVisibility(this.mIsCollapsed ? 8 : 0);
        }
    }

    @Override
    public boolean hasDifferentHeightWhenFirst() {
        return this.mCanHideSenderIfFirst && !this.mSingleLine && !TextUtils.isEmpty(this.mSenderName);
    }

    private void setIsHidingAnimated(boolean isHiding) {
        ViewParent parent = this.getParent();
        this.mIsHidingAnimated = isHiding;
        this.invalidate();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).invalidate();
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    public Icon getAvatarSymbolIfMatching(CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (this.mAvatarName.equals(avatarName) && this.mAvatarSymbol.equals(avatarSymbol) && layoutColor == this.mLayoutColor) {
            return this.mAvatarIcon;
        }
        return null;
    }

    public void setCreatedAvatar(Icon cachedIcon, CharSequence avatarName, String avatarSymbol, int layoutColor) {
        if (!this.mAvatarName.equals(avatarName) || !this.mAvatarSymbol.equals(avatarSymbol) || layoutColor != this.mLayoutColor) {
            this.setAvatar(cachedIcon);
            this.mAvatarSymbol = avatarSymbol;
            this.setLayoutColor(layoutColor);
            this.mAvatarName = avatarName;
        }
    }

    public void setTextColors(int senderTextColor, int messageTextColor) {
        this.mTextColor = messageTextColor;
        this.mSendingTextColor = this.calculateSendingTextColor();
        this.updateMessageColor();
        this.mSenderView.setTextColor(senderTextColor);
    }

    public void setLayoutColor(int layoutColor) {
        if (layoutColor != this.mLayoutColor) {
            this.mLayoutColor = layoutColor;
            this.mSendingSpinner.setIndeterminateTintList(ColorStateList.valueOf(this.mLayoutColor));
        }
    }

    private void updateMessageColor() {
        if (this.mMessages != null) {
            int color2 = this.mSendingSpinnerContainer.getVisibility() == 0 ? this.mSendingTextColor : this.mTextColor;
            for (MessagingMessage message : this.mMessages) {
                boolean isRemoteInputHistory = message.getMessage() != null && message.getMessage().isRemoteInputHistory();
                message.setColor(isRemoteInputHistory ? color2 : this.mTextColor);
            }
        }
    }

    public void setMessages(List<MessagingMessage> group) {
        int textMessageIndex = 0;
        MessagingImageMessage isolatedMessage = null;
        for (int messageIndex = 0; messageIndex < group.size(); ++messageIndex) {
            MessagingMessage message2 = group.get(messageIndex);
            if (message2.getGroup() != this) {
                message2.setMessagingGroup(this);
                this.mAddedMessages.add(message2);
            }
            boolean isImage = message2 instanceof MessagingImageMessage;
            if (this.mImageDisplayLocation != 0 && isImage) {
                isolatedMessage = (MessagingImageMessage)message2;
                continue;
            }
            if (this.removeFromParentIfDifferent(message2, this.mMessageContainer)) {
                ViewGroup.LayoutParams layoutParams = message2.getView().getLayoutParams();
                if (layoutParams != null && !(layoutParams instanceof MessagingLinearLayout.LayoutParams)) {
                    message2.getView().setLayoutParams(this.mMessageContainer.generateDefaultLayoutParams());
                }
                this.mMessageContainer.addView(message2.getView(), textMessageIndex);
            }
            if (isImage) {
                ((MessagingImageMessage)message2).setIsolated(false);
            }
            if (textMessageIndex != this.mMessageContainer.indexOfChild(message2.getView())) {
                this.mMessageContainer.removeView(message2.getView());
                this.mMessageContainer.addView(message2.getView(), textMessageIndex);
            }
            ++textMessageIndex;
        }
        if (isolatedMessage != null) {
            if (this.mImageDisplayLocation == 1 && this.removeFromParentIfDifferent(isolatedMessage, this.mImageContainer)) {
                this.mImageContainer.removeAllViews();
                this.mImageContainer.addView(isolatedMessage.getView());
            } else if (this.mImageDisplayLocation == 2) {
                this.mImageContainer.removeAllViews();
            }
            isolatedMessage.setIsolated(true);
        } else if (this.mIsolatedMessage != null) {
            this.mImageContainer.removeAllViews();
        }
        this.mIsolatedMessage = isolatedMessage;
        this.updateImageContainerVisibility();
        this.mMessages = group;
        if (com.android.internal.hidden_from_bootclasspath.android.widget.flags.Flags.dropNonExistingMessages()) {
            this.mAddedMessages.removeIf(message -> !this.mMessages.contains(message));
        }
        this.updateMessageColor();
    }

    private void updateImageContainerVisibility() {
        this.mImageContainer.setVisibility(this.mIsolatedMessage != null && this.mImageDisplayLocation == 1 ? 0 : 8);
    }

    private boolean removeFromParentIfDifferent(MessagingMessage message, ViewGroup newParent) {
        ViewParent parent = message.getView().getParent();
        if (parent != newParent) {
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(message.getView());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedMessages.isEmpty()) {
            final boolean firstLayout = this.mFirstLayout;
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    for (MessagingMessage message : MessagingGroup.this.mAddedMessages) {
                        if (!message.getView().isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(message.getView());
                        if (firstLayout) continue;
                        MessagingPropertyAnimator.startLocalTranslationFrom(message.getView(), message.getView().getHeight(), MessagingLayout.LINEAR_OUT_SLOW_IN);
                    }
                    MessagingGroup.this.mAddedMessages.clear();
                    MessagingGroup.this.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }
            });
        }
        this.mFirstLayout = false;
        this.updateClipRect();
    }

    public int calculateGroupCompatibility(MessagingGroup otherGroup) {
        if (TextUtils.equals(this.getSenderName(), otherGroup.getSenderName())) {
            int result = 1;
            for (int i = 0; i < this.mMessages.size() && i < otherGroup.mMessages.size(); ++i) {
                MessagingMessage otherMessage;
                MessagingMessage ownMessage = this.mMessages.get(this.mMessages.size() - 1 - i);
                if (!ownMessage.sameAs(otherMessage = otherGroup.mMessages.get(otherGroup.mMessages.size() - 1 - i))) {
                    return result;
                }
                ++result;
            }
            return result;
        }
        return 0;
    }

    public TextView getSenderView() {
        return this.mSenderView;
    }

    public View getAvatar() {
        return this.mAvatarView;
    }

    public Icon getAvatarIcon() {
        return this.mAvatarIcon;
    }

    public MessagingLinearLayout getMessageContainer() {
        return this.mMessageContainer;
    }

    public MessagingImageMessage getIsolatedMessage() {
        return this.mIsolatedMessage;
    }

    public boolean needsGeneratedAvatar() {
        return this.mNeedsGeneratedAvatar;
    }

    public Person getSender() {
        return this.mSender;
    }

    public void setClippingDisabled(boolean disabled) {
        this.mClippingDisabled = disabled;
    }

    public void setImageDisplayLocation(int displayLocation) {
        if (this.mImageDisplayLocation != displayLocation) {
            this.mImageDisplayLocation = displayLocation;
            this.updateImageContainerVisibility();
        }
    }

    public List<MessagingMessage> getMessages() {
        return this.mMessages;
    }

    public void setSingleLine(boolean singleLine) {
        if (singleLine != this.mSingleLine) {
            this.mSingleLine = singleLine;
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)this.mMessageContainer.getLayoutParams();
            p.topMargin = singleLine ? 0 : this.mNotificationTextMarginTop;
            this.mMessageContainer.setLayoutParams(p);
            this.mContentContainer.setOrientation(singleLine ? 0 : 1);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mSenderView.getLayoutParams();
            layoutParams.setMarginEnd(singleLine ? this.mSenderTextPaddingSingleLine : 0);
            this.mSenderView.setSingleLine(singleLine);
            this.updateMaxDisplayedLines();
            this.updateClipRect();
            this.updateSenderVisibility();
        }
    }

    public void setIsCollapsed(boolean isCollapsed) {
        this.mIsCollapsed = isCollapsed;
        this.updateIconVisibility();
    }

    public boolean isSingleLine() {
        return this.mSingleLine;
    }

    public void setIsInConversation(boolean isInConversation) {
        if (this.mIsInConversation != isInConversation) {
            int size;
            this.mIsInConversation = isInConversation;
            if (Flags.notificationsRedesignTemplates()) {
                this.updateIconVisibility();
                return;
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mMessagingIconContainer.getLayoutParams();
            layoutParams.width = this.mIsInConversation ? this.mConversationContentStart : this.mNonConversationContentStart;
            this.mMessagingIconContainer.setLayoutParams(layoutParams);
            int imagePaddingStart = isInConversation ? 0 : this.mNonConversationPaddingStart;
            this.mMessagingIconContainer.setPaddingRelative(imagePaddingStart, 0, 0, 0);
            ViewGroup.LayoutParams avatarLayoutParams = this.mAvatarView.getLayoutParams();
            avatarLayoutParams.height = size = this.mIsInConversation ? this.mConversationAvatarSize : this.mNonConversationAvatarSize;
            avatarLayoutParams.width = size;
            this.mAvatarView.setLayoutParams(avatarLayoutParams);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ImageDisplayLocation {
    }
}

