/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import com.android.layoutlib.androidx.annotation.ColorInt;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NotificationProgressDrawable
extends Drawable {
    private static final String TAG = "NotifProgressDrawable";
    @Nullable
    private BoundsChangeListener mBoundsChangeListener = null;
    private State mState;
    private boolean mMutated;
    private final ArrayList<DrawablePart> mParts = new ArrayList();
    private final RectF mSegRectF = new RectF();
    private final RectF mPointRectF = new RectF();
    private final Paint mFillPaint = new Paint();
    @ColorInt
    private int mEndDotColor;
    private int mAlpha;

    public NotificationProgressDrawable() {
        this(new State(), null);
    }

    public float getPointRadius() {
        return this.mState.mPointRadius;
    }

    public void setParts(List<DrawablePart> parts) {
        this.mParts.clear();
        this.mParts.addAll(parts);
        this.invalidateSelf();
    }

    public void setParts(DrawablePart ... parts) {
        this.setParts(Arrays.asList(parts));
    }

    public void updateEndDotColor(@ColorInt int endDotColor) {
        if (this.mEndDotColor != endDotColor) {
            this.mEndDotColor = endDotColor;
            this.invalidateSelf();
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        float pointRadius = this.mState.mPointRadius;
        float left = this.getBounds().left;
        float centerY = this.getBounds().centerY();
        int numParts = this.mParts.size();
        float pointTop = Math.round(centerY - pointRadius);
        float pointBottom = Math.round(centerY + pointRadius);
        for (int iPart = 0; iPart < numParts; ++iPart) {
            float cornerRadius;
            DrawablePart part = this.mParts.get(iPart);
            float start = left + part.mStart;
            float end = left + part.mEnd;
            if (part instanceof DrawableSegment) {
                DrawableSegment segment = (DrawableSegment)part;
                if (start > end) continue;
                float radiusY = segment.mFaded ? this.mState.mFadedSegmentHeight / 2.0f : this.mState.mSegmentHeight / 2.0f;
                cornerRadius = this.mState.mSegmentCornerRadius;
                this.mFillPaint.setColor(segment.mColor);
                this.mSegRectF.set(Math.round(start), Math.round(centerY - radiusY), Math.round(end), Math.round(centerY + radiusY));
                canvas.drawRoundRect(this.mSegRectF, cornerRadius, cornerRadius, this.mFillPaint);
                continue;
            }
            if (!(part instanceof DrawablePoint)) continue;
            DrawablePoint point = (DrawablePoint)part;
            this.mPointRectF.set(Math.round(start), pointTop, Math.round(end), pointBottom);
            float inset = this.mState.mPointRectInset;
            cornerRadius = this.mState.mPointRectCornerRadius;
            this.mPointRectF.inset(inset, inset);
            this.mFillPaint.setColor(point.mColor);
            canvas.drawRoundRect(this.mPointRectF, cornerRadius, cornerRadius, this.mFillPaint);
        }
        if (this.mEndDotColor != 0) {
            float right = this.getBounds().right;
            float dotRadius = this.mState.mFadedSegmentHeight / 2.0f;
            this.mFillPaint.setColor(this.mEndDotColor);
            this.mSegRectF.set(Math.round(right - this.mState.mFadedSegmentHeight), Math.round(centerY - dotRadius), Math.round(right), Math.round(centerY + dotRadius));
            canvas.drawRoundRect(this.mSegRectF, this.mState.mSegmentCornerRadius, this.mState.mSegmentCornerRadius, this.mFillPaint);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.getChangingConfigurations();
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return 0;
    }

    public void setBoundsChangeListener(BoundsChangeListener listener) {
        this.mBoundsChangeListener = listener;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.mBoundsChangeListener != null) {
            this.mBoundsChangeListener.onDrawableBoundsChanged();
        }
    }

    @Override
    public void inflate(@NonNull Resources r, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        this.mState.setDensity(NotificationProgressDrawable.resolveDensity(r, 0));
        this.inflateChildElements(r, parser, attrs, theme);
        this.updateLocalState();
    }

    @Override
    public void applyTheme(@NonNull Resources.Theme t) {
        super.applyTheme(t);
        State state = this.mState;
        if (state == null) {
            return;
        }
        state.setDensity(NotificationProgressDrawable.resolveDensity(t.getResources(), 0));
        this.applyThemeChildElements(t);
        this.updateLocalState();
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState.canApplyTheme() || super.canApplyTheme();
    }

    private void inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            TypedArray a;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (name.equals("segments")) {
                a = NotificationProgressDrawable.obtainAttributes(r, theme, attrs, R.styleable.NotificationProgressDrawableSegments);
                this.updateSegmentsFromTypedArray(a);
                a.recycle();
                continue;
            }
            if (name.equals("points")) {
                a = NotificationProgressDrawable.obtainAttributes(r, theme, attrs, R.styleable.NotificationProgressDrawablePoints);
                this.updatePointsFromTypedArray(a);
                a.recycle();
                continue;
            }
            Log.w(TAG, "Bad element under NotificationProgressDrawable: " + name);
        }
    }

    private void applyThemeChildElements(Resources.Theme t) {
        TypedArray a;
        State state = this.mState;
        if (state.mThemeAttrsSegments != null) {
            a = t.resolveAttributes(state.mThemeAttrsSegments, R.styleable.NotificationProgressDrawableSegments);
            this.updateSegmentsFromTypedArray(a);
            a.recycle();
        }
        if (state.mThemeAttrsPoints != null) {
            a = t.resolveAttributes(state.mThemeAttrsPoints, R.styleable.NotificationProgressDrawablePoints);
            this.updatePointsFromTypedArray(a);
            a.recycle();
        }
    }

    private void updateSegmentsFromTypedArray(TypedArray a) {
        State state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrsSegments = a.extractThemeAttrs();
        state.mSegmentHeight = a.getDimension(0, state.mSegmentHeight);
        state.mFadedSegmentHeight = a.getDimension(2, state.mFadedSegmentHeight);
        state.mSegmentCornerRadius = a.getDimension(1, state.mSegmentCornerRadius);
    }

    private void updatePointsFromTypedArray(TypedArray a) {
        State state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrsPoints = a.extractThemeAttrs();
        state.mPointRadius = a.getDimension(0, state.mPointRadius);
        state.mPointRectInset = a.getDimension(1, state.mPointRectInset);
        state.mPointRectCornerRadius = a.getDimension(2, state.mPointRectCornerRadius);
    }

    static int resolveDensity(@Nullable Resources r, int parentDensity) {
        int densityDpi = r == null ? parentDensity : r.getDisplayMetrics().densityDpi;
        return densityDpi == 0 ? 160 : densityDpi;
    }

    private static float scaleFromDensity(float pixels, int sourceDensity, int targetDensity) {
        return pixels * (float)targetDensity / (float)sourceDensity;
    }

    private static int scaleFromDensity(int pixels, int sourceDensity, int targetDensity, boolean isSize) {
        if (pixels == 0 || sourceDensity == targetDensity) {
            return pixels;
        }
        float result = (float)(pixels * targetDensity) / (float)sourceDensity;
        if (!isSize) {
            return (int)result;
        }
        int rounded = Math.round(result);
        if (rounded != 0) {
            return rounded;
        }
        if (pixels > 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState = new State(this.mState, null);
            this.updateLocalState();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mState;
    }

    private NotificationProgressDrawable(@NonNull State state, @Nullable Resources res) {
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mEndDotColor = 0;
        this.mState = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
    }

    static class State
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        float mSegmentHeight;
        float mFadedSegmentHeight;
        float mSegmentCornerRadius;
        float mPointRadius;
        float mPointRectInset;
        float mPointRectCornerRadius;
        int[] mThemeAttrs;
        int[] mThemeAttrsSegments;
        int[] mThemeAttrsPoints;
        int mDensity = 160;

        State() {
        }

        State(@NonNull State orig, @Nullable Resources res) {
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mSegmentHeight = orig.mSegmentHeight;
            this.mFadedSegmentHeight = orig.mFadedSegmentHeight;
            this.mSegmentCornerRadius = orig.mSegmentCornerRadius;
            this.mPointRadius = orig.mPointRadius;
            this.mPointRectInset = orig.mPointRectInset;
            this.mPointRectCornerRadius = orig.mPointRectCornerRadius;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mThemeAttrsSegments = orig.mThemeAttrsSegments;
            this.mThemeAttrsPoints = orig.mThemeAttrsPoints;
            this.mDensity = NotificationProgressDrawable.resolveDensity(res, orig.mDensity);
            if (orig.mDensity != this.mDensity) {
                this.applyDensityScaling(orig.mDensity, this.mDensity);
            }
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mSegmentHeight > 0.0f) {
                this.mSegmentHeight = NotificationProgressDrawable.scaleFromDensity(this.mSegmentHeight, sourceDensity, targetDensity);
            }
            if (this.mFadedSegmentHeight > 0.0f) {
                this.mFadedSegmentHeight = NotificationProgressDrawable.scaleFromDensity(this.mFadedSegmentHeight, sourceDensity, targetDensity);
            }
            if (this.mSegmentCornerRadius > 0.0f) {
                this.mSegmentCornerRadius = NotificationProgressDrawable.scaleFromDensity(this.mSegmentCornerRadius, sourceDensity, targetDensity);
            }
            if (this.mPointRadius > 0.0f) {
                this.mPointRadius = NotificationProgressDrawable.scaleFromDensity(this.mPointRadius, sourceDensity, targetDensity);
            }
            if (this.mPointRectInset > 0.0f) {
                this.mPointRectInset = NotificationProgressDrawable.scaleFromDensity(this.mPointRectInset, sourceDensity, targetDensity);
            }
            if (this.mPointRectCornerRadius > 0.0f) {
                this.mPointRectCornerRadius = NotificationProgressDrawable.scaleFromDensity(this.mPointRectCornerRadius, sourceDensity, targetDensity);
            }
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new NotificationProgressDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(@Nullable Resources res) {
            int density = NotificationProgressDrawable.resolveDensity(res, this.mDensity);
            State state = density != this.mDensity ? new State(this, res) : this;
            return new NotificationProgressDrawable(state, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mThemeAttrsSegments != null || this.mThemeAttrsPoints != null || super.canApplyTheme();
        }

        public void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
            }
        }
    }

    public static abstract class DrawablePart {
        protected float mStart;
        protected float mEnd;
        @ColorInt
        protected final int mColor;

        protected DrawablePart(float start, float end, @ColorInt int color2) {
            this.mStart = start;
            this.mEnd = end;
            this.mColor = color2;
        }

        public float getStart() {
            return this.mStart;
        }

        public void setStart(float start) {
            this.mStart = start;
        }

        public float getEnd() {
            return this.mEnd;
        }

        public void setEnd(float end) {
            this.mEnd = end;
        }

        public float getWidth() {
            return this.mEnd - this.mStart;
        }

        public int getColor() {
            return this.mColor;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DrawablePart that = (DrawablePart)other;
            if (Float.compare(this.mStart, that.mStart) != 0) {
                return false;
            }
            if (Float.compare(this.mEnd, that.mEnd) != 0) {
                return false;
            }
            return this.mColor == that.mColor;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mStart), Float.valueOf(this.mEnd), this.mColor);
        }
    }

    public static class DrawableSegment
    extends DrawablePart {
        private final boolean mFaded;

        public DrawableSegment(float start, float end, int color2) {
            this(start, end, color2, false);
        }

        public DrawableSegment(float start, float end, int color2, boolean faded) {
            super(start, end, color2);
            this.mFaded = faded;
        }

        public String toString() {
            return "Segment(start=" + this.mStart + ", end=" + this.mEnd + ", color=" + this.mColor + ", faded=" + this.mFaded + ')';
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!super.equals(other)) {
                return false;
            }
            DrawableSegment that = (DrawableSegment)other;
            return this.mFaded == that.mFaded;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mFaded);
        }
    }

    public static class DrawablePoint
    extends DrawablePart {
        public DrawablePoint(float start, float end, int color2) {
            super(start, end, color2);
        }

        public String toString() {
            return "Point(start=" + this.mStart + ", end=" + this.mEnd + ", color=" + this.mColor + ")";
        }
    }

    public static interface BoundsChangeListener {
        public void onDrawableBoundsChanged();
    }
}

