/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.accessibility;

import android.graphics.Rect;
import android.util.Log;
import com.android.internal.widget.remotecompose.accessibility.RemoteComposeDocumentAccessibility;
import com.android.internal.widget.remotecompose.accessibility.SemanticNodeApplier;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.semantics.AccessibilitySemantics;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.semantics.CoreSemantics;
import com.android.internal.widget.remotecompose.core.semantics.ScrollableComponent;
import java.util.List;

public abstract class BaseSemanticNodeApplier<N>
implements SemanticNodeApplier<N> {
    private static final String LOG_TAG = "RemoteCompose";

    @Override
    public void applyComponent(RemoteComposeDocumentAccessibility remoteComposeAccessibility, N nodeInfo, Component component, List<AccessibilitySemantics> semantics) {
        LayoutComponent parent;
        ScrollableComponent scrollable;
        float[] locationInWindow = new float[2];
        component.getLocationInWindow(locationInWindow);
        Rect bounds = new Rect((int)locationInWindow[0], (int)locationInWindow[1], (int)(locationInWindow[0] + component.getWidth()), (int)(locationInWindow[1] + component.getHeight()));
        this.setBoundsInScreen(nodeInfo, bounds);
        this.setUniqueId(nodeInfo, String.valueOf(component.getComponentId()));
        if (component instanceof AccessibleComponent) {
            this.applyContentDescription(((AccessibleComponent)((Object)component)).getContentDescriptionId(), nodeInfo, remoteComposeAccessibility);
            this.applyText(((AccessibleComponent)((Object)component)).getTextId(), nodeInfo, remoteComposeAccessibility);
            this.applyRole(((AccessibleComponent)((Object)component)).getRole(), nodeInfo);
        }
        this.applySemantics(remoteComposeAccessibility, nodeInfo, semantics);
        if (this.getText(nodeInfo) == null && this.getContentDescription(nodeInfo) == null) {
            this.setContentDescription(nodeInfo, "");
        }
        if (component.getParent() instanceof LayoutComponent && (scrollable = (parent = (LayoutComponent)component.getParent()).selfOrModifier(ScrollableComponent.class)) != null) {
            this.applyListItem(nodeInfo, parent.getComponentId());
        }
    }

    protected void applySemantics(RemoteComposeDocumentAccessibility remoteComposeAccessibility, N nodeInfo, List<AccessibilitySemantics> semantics) {
        for (AccessibilitySemantics semantic : semantics) {
            if (!semantic.isInterestingForSemantics()) continue;
            if (semantic instanceof CoreSemantics) {
                CoreSemantics coreSemantics = (CoreSemantics)semantic;
                this.applyCoreSemantics(remoteComposeAccessibility, nodeInfo, coreSemantics);
                continue;
            }
            if (semantic instanceof AccessibleComponent) {
                AccessibleComponent accessibleComponent = (AccessibleComponent)semantic;
                if (accessibleComponent.isClickable()) {
                    this.setClickable(nodeInfo, true);
                }
                if (accessibleComponent.getContentDescriptionId() != null) {
                    this.applyContentDescription(accessibleComponent.getContentDescriptionId(), nodeInfo, remoteComposeAccessibility);
                }
                if (accessibleComponent.getTextId() != null) {
                    this.applyText(accessibleComponent.getTextId(), nodeInfo, remoteComposeAccessibility);
                }
                this.applyRole(accessibleComponent.getRole(), nodeInfo);
                continue;
            }
            if (semantic instanceof ScrollableComponent) {
                ScrollableComponent scrollableSemantic = (ScrollableComponent)semantic;
                if (!scrollableSemantic.supportsScrollByOffset()) continue;
                ScrollableComponent.ScrollAxisRange scrollAxis = scrollableSemantic.getScrollAxisRange();
                this.applyScrollable(nodeInfo, scrollAxis, scrollableSemantic.scrollDirection());
                continue;
            }
            Log.w(LOG_TAG, "Unknown semantic: " + semantic);
        }
    }

    protected void applyCoreSemantics(RemoteComposeDocumentAccessibility remoteComposeAccessibility, N nodeInfo, CoreSemantics coreSemantics) {
        this.applyContentDescription(coreSemantics.getContentDescriptionId(), nodeInfo, remoteComposeAccessibility);
        this.applyRole(coreSemantics.getRole(), nodeInfo);
        this.applyText(coreSemantics.getTextId(), nodeInfo, remoteComposeAccessibility);
        this.applyStateDescription(coreSemantics.getStateDescriptionId(), nodeInfo, remoteComposeAccessibility);
        if (!coreSemantics.mEnabled) {
            this.setEnabled(nodeInfo, false);
        }
    }

    protected void applyStateDescription(Integer stateDescriptionId, N nodeInfo, RemoteComposeDocumentAccessibility remoteComposeAccessibility) {
        if (stateDescriptionId != null) {
            this.setStateDescription(nodeInfo, this.appendNullable(this.getStateDescription(nodeInfo), remoteComposeAccessibility.stringValue(stateDescriptionId)));
        }
    }

    protected void applyRole(AccessibleComponent.Role role, N nodeInfo) {
        if (role != null) {
            this.setRoleDescription(nodeInfo, role.getDescription());
        }
    }

    protected void applyText(Integer textId, N nodeInfo, RemoteComposeDocumentAccessibility remoteComposeAccessibility) {
        if (textId != null) {
            String value = remoteComposeAccessibility.stringValue(textId);
            this.setText(nodeInfo, this.appendNullable(this.getText(nodeInfo), value));
        }
    }

    protected void applyContentDescription(Integer contentDescriptionId, N nodeInfo, RemoteComposeDocumentAccessibility remoteComposeAccessibility) {
        if (contentDescriptionId != null) {
            this.setContentDescription(nodeInfo, this.appendNullable(this.getContentDescription(nodeInfo), remoteComposeAccessibility.stringValue(contentDescriptionId)));
        }
    }

    private CharSequence appendNullable(CharSequence contentDescription, String value) {
        if (contentDescription == null) {
            return value;
        }
        if (value == null) {
            return contentDescription;
        }
        return contentDescription + " " + value;
    }

    protected abstract void setClickable(N var1, boolean var2);

    protected abstract void setEnabled(N var1, boolean var2);

    protected abstract CharSequence getStateDescription(N var1);

    protected abstract void setStateDescription(N var1, CharSequence var2);

    protected abstract void setRoleDescription(N var1, String var2);

    protected abstract CharSequence getText(N var1);

    protected abstract void setText(N var1, CharSequence var2);

    protected abstract CharSequence getContentDescription(N var1);

    protected abstract void setContentDescription(N var1, CharSequence var2);

    protected abstract void setBoundsInScreen(N var1, Rect var2);

    protected abstract void setUniqueId(N var1, String var2);

    protected abstract void applyScrollable(N var1, ScrollableComponent.ScrollAxisRange var2, int var3);

    protected abstract void applyListItem(N var1, int var2);
}

