/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.documentation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.documentation.StringPair;
import java.util.ArrayList;

public class OperationField {
    final int mType;
    @NonNull
    final String mName;
    @NonNull
    final String mDescription;
    @Nullable
    String mVarSize = null;
    @NonNull
    ArrayList<StringPair> mPossibleValues = new ArrayList();

    public OperationField(int type, @NonNull String name, @NonNull String description) {
        this.mType = type;
        this.mName = name;
        this.mDescription = description;
    }

    public OperationField(int type, @NonNull String name, @Nullable String varSize, @NonNull String description) {
        this.mType = type;
        this.mName = name;
        this.mDescription = description;
        this.mVarSize = varSize;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @NonNull
    public ArrayList<StringPair> getPossibleValues() {
        return this.mPossibleValues;
    }

    public void possibleValue(@NonNull String name, @NonNull String value) {
        this.mPossibleValues.add(new StringPair(name, value));
    }

    public boolean hasEnumeratedValues() {
        return !this.mPossibleValues.isEmpty();
    }

    @Nullable
    public String getVarSize() {
        return this.mVarSize;
    }

    public int getSize() {
        switch (this.mType) {
            case 6: {
                return 1;
            }
            case 0: {
                return 4;
            }
            case 1: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 2;
            }
            case 11: {
                return -1;
            }
            case 10: {
                return -1;
            }
        }
        return 0;
    }
}

