/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class BitmapFontData
extends Operation
implements Serializable {
    private static final int OP_CODE = 167;
    private static final String CLASS_NAME = "BitmapFontData";
    int mId;
    @NonNull
    Glyph[] mFontGlyphs;

    public BitmapFontData(int id2, @NonNull Glyph[] fontGlyphs) {
        this.mId = id2;
        this.mFontGlyphs = fontGlyphs;
        Arrays.sort(this.mFontGlyphs, (o1, o2) -> o2.mChars.length() - o1.mChars.length());
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        BitmapFontData.apply(buffer, this.mId, this.mFontGlyphs);
    }

    @NonNull
    public String toString() {
        return "BITMAP FONT DATA " + this.mId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 167;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull Glyph[] glyphs) {
        buffer.start(167);
        buffer.writeInt(id2);
        buffer.writeInt(glyphs.length);
        for (Glyph element : glyphs) {
            buffer.writeUTF8(element.mChars);
            buffer.writeInt(element.mBitmapId);
            buffer.writeShort(element.mMarginLeft);
            buffer.writeShort(element.mMarginTop);
            buffer.writeShort(element.mMarginRight);
            buffer.writeShort(element.mMarginBottom);
            buffer.writeShort(element.mBitmapWidth);
            buffer.writeShort(element.mBitmapHeight);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int numGlyphElements = buffer.readInt();
        Glyph[] glyphs = new Glyph[numGlyphElements];
        for (int i = 0; i < numGlyphElements; ++i) {
            glyphs[i] = new Glyph();
            glyphs[i].mChars = buffer.readUTF8();
            glyphs[i].mBitmapId = buffer.readInt();
            glyphs[i].mMarginLeft = (short)buffer.readShort();
            glyphs[i].mMarginTop = (short)buffer.readShort();
            glyphs[i].mMarginRight = (short)buffer.readShort();
            glyphs[i].mMarginBottom = (short)buffer.readShort();
            glyphs[i].mBitmapWidth = (short)buffer.readShort();
            glyphs[i].mBitmapHeight = (short)buffer.readShort();
        }
        operations.add(new BitmapFontData(id2, glyphs));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 167, CLASS_NAME).description("Bitmap font data").field(0, "id", "id of bitmap font data").field(11, "glyphNodes", "list used to greedily convert strings into glyphs").field(11, "glyphElements", "");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.putObject(this.mId, this);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Nullable
    public Glyph lookupGlyph(String string2, int offset) {
        for (Glyph glyph : this.mFontGlyphs) {
            if (!string2.startsWith(glyph.mChars, offset)) continue;
            return glyph;
        }
        return null;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId);
    }

    public static class Glyph {
        public String mChars;
        public int mBitmapId;
        public short mMarginLeft;
        public short mMarginTop;
        public short mMarginRight;
        public short mMarginBottom;
        public short mBitmapWidth;
        public short mBitmapHeight;

        public Glyph() {
        }

        public Glyph(String chars, int bitmapId, short marginLeft, short marginTop, short marginRight, short marginBottom, short width, short height) {
            this.mChars = chars;
            this.mBitmapId = bitmapId;
            this.mMarginLeft = marginLeft;
            this.mMarginTop = marginTop;
            this.mMarginRight = marginRight;
            this.mMarginBottom = marginBottom;
            this.mBitmapWidth = width;
            this.mBitmapHeight = height;
        }
    }
}

