/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class ClipRect
extends DrawBase4 {
    private static final int OP_CODE = 39;
    private static final String CLASS_NAME = "ClipRect";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = ClipRect::new;
        ClipRect.read(m, buffer, operations);
    }

    public static int id() {
        return 39;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        ClipRect.apply(buffer, v1, v2, v3, v4);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 39, CLASS_NAME).description("Intersect the current clip with rectangle").field(1, "left", "The left side of the rectangle to intersect with the current clip").field(1, "top", "The top of the rectangle to intersect with the current clip").field(1, "right", "The right side of the rectangle to intersect with the current clip").field(1, "bottom", "The bottom of the rectangle to intersect with the current clip");
    }

    public ClipRect(float left, float top, float right, float bottom) {
        super(left, top, right, bottom);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.clipRect(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2, float y2) {
        ClipRect.write(buffer, 39, x1, y1, x2, y2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "left", "top", "right", "bottom").addType(CLASS_NAME);
    }
}

