/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.DataMap;
import java.util.List;

public class DataMapIds
extends Operation {
    private static final int OP_CODE = 145;
    private static final String CLASS_NAME = "DataMapIds";
    int mId;
    final DataMap mDataMap;
    private static final int MAX_MAP = 2000;
    public static final byte TYPE_STRING = 0;
    public static final byte TYPE_INT = 1;
    public static final byte TYPE_FLOAT = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_BOOLEAN = 4;

    @NonNull
    private String typeString(byte type) {
        switch (type) {
            case 0: {
                return "String";
            }
            case 1: {
                return "Int";
            }
            case 2: {
                return "Float";
            }
            case 3: {
                return "Long";
            }
            case 4: {
                return "Boolean";
            }
        }
        return "?";
    }

    public DataMapIds(int id2, @NonNull String[] names, @NonNull byte[] types, @NonNull int[] ids) {
        this.mId = id2;
        this.mDataMap = new DataMap(names, types, ids);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DataMapIds.apply(buffer, this.mId, this.mDataMap.mNames, this.mDataMap.mTypes, this.mDataMap.mIds);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("DataMapIds[" + Utils.idString(this.mId) + "] ");
        for (int i = 0; i < this.mDataMap.mNames.length; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            builder.append(this.typeString(this.mDataMap.mTypes[i]));
            builder.append("[");
            builder.append(this.mDataMap.mNames[i]);
            builder.append("]=");
            builder.append(this.mDataMap.mIds[i]);
        }
        return builder.toString();
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull String[] names, @Nullable byte[] type, @NonNull int[] ids) {
        buffer.start(145);
        buffer.writeInt(id2);
        buffer.writeInt(names.length);
        for (int i = 0; i < names.length; ++i) {
            buffer.writeUTF8(names[i]);
            buffer.writeByte(type == null ? 2 : type[i]);
            buffer.writeInt(ids[i]);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int len = buffer.readInt();
        if (len > 2000) {
            throw new RuntimeException(len + " map entries more than max = " + 2000);
        }
        String[] names = new String[len];
        int[] ids = new int[len];
        byte[] types = new byte[len];
        for (int i = 0; i < names.length; ++i) {
            names[i] = buffer.readUTF8();
            types[i] = (byte)buffer.readByte();
            ids[i] = buffer.readInt();
        }
        DataMapIds data = new DataMapIds(id2, names, types, ids);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 145, CLASS_NAME).description("Encode a collection of name id pairs").field(0, "id", "id the array").field(0, "length", "number of entries").field(0, "names[0]", "length", "path encoded as floats").field(5, "id[0]", "length", "path encoded as floats");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.putDataMap(this.mId, this.mDataMap);
    }
}

