/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawBitmap
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 44;
    private static final String CLASS_NAME = "DrawBitmap";
    float mLeft;
    float mTop;
    float mRight;
    float mBottom;
    float mOutputLeft;
    float mOutputTop;
    float mOutputRight;
    float mOutputBottom;
    int mId;
    int mDescriptionId = 0;

    public DrawBitmap(int imageId, float left, float top, float right, float bottom, int descriptionId) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
        this.mId = imageId;
        this.mDescriptionId = descriptionId;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutputLeft = Float.isNaN(this.mLeft) ? context.getFloat(Utils.idFromNan(this.mLeft)) : this.mLeft;
        this.mOutputTop = Float.isNaN(this.mTop) ? context.getFloat(Utils.idFromNan(this.mTop)) : this.mTop;
        this.mOutputRight = Float.isNaN(this.mRight) ? context.getFloat(Utils.idFromNan(this.mRight)) : this.mRight;
        this.mOutputBottom = Float.isNaN(this.mBottom) ? context.getFloat(Utils.idFromNan(this.mBottom)) : this.mBottom;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mLeft)) {
            context.listensTo(Utils.idFromNan(this.mLeft), this);
        }
        if (Float.isNaN(this.mTop)) {
            context.listensTo(Utils.idFromNan(this.mTop), this);
        }
        if (Float.isNaN(this.mRight)) {
            context.listensTo(Utils.idFromNan(this.mRight), this);
        }
        if (Float.isNaN(this.mBottom)) {
            context.listensTo(Utils.idFromNan(this.mBottom), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawBitmap.apply(buffer, this.mId, this.mLeft, this.mTop, this.mRight, this.mBottom, this.mDescriptionId);
    }

    @NonNull
    public String toString() {
        return "DrawBitmap (desc=" + this.mDescriptionId + ")" + this.mLeft + " " + this.mTop + " " + this.mRight + " " + this.mBottom + ";";
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        float sLeft = buffer.readFloat();
        float srcTop = buffer.readFloat();
        float srcRight = buffer.readFloat();
        float srcBottom = buffer.readFloat();
        int descriptionId = buffer.readInt();
        DrawBitmap op = new DrawBitmap(id2, sLeft, srcTop, srcRight, srcBottom, descriptionId);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 44;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, float left, float top, float right, float bottom, int descriptionId) {
        buffer.start(44);
        buffer.writeInt(id2);
        buffer.writeFloat(left);
        buffer.writeFloat(top);
        buffer.writeFloat(right);
        buffer.writeFloat(bottom);
        buffer.writeInt(descriptionId);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 44, CLASS_NAME).description("Draw a bitmap").field(0, "id", "id of float").field(1, "left", "The left side of the image").field(1, "top", "The top of the image").field(1, "right", "The right side of the image").field(1, "bottom", "The bottom of the image").field(0, "descriptionId", "id of string");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawBitmap(this.mId, this.mOutputLeft, this.mOutputTop, this.mOutputRight, this.mOutputBottom);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("imageId", this.mId).add("contentDescriptionId", this.mDescriptionId).add("left", this.mLeft, this.mOutputLeft).add("top", this.mTop, this.mOutputTop).add("right", this.mRight, this.mOutputRight).add("bottom", this.mBottom, this.mOutputBottom);
    }
}

