/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.BitmapFontData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawBitmapFontText
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 48;
    private static final String CLASS_NAME = "DrawBitmapFontText";
    int mTextID;
    int mBitmapFontID;
    int mStart;
    int mEnd;
    float mX;
    float mY;
    float mOutX;
    float mOutY;

    public DrawBitmapFontText(int textID, int bitmapFontID, int start, int end, float x, float y) {
        this.mTextID = textID;
        this.mBitmapFontID = bitmapFontID;
        this.mStart = start;
        this.mEnd = end;
        this.mOutX = this.mX = x;
        this.mOutY = this.mY = y;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutX = Float.isNaN(this.mX) ? context.getFloat(Utils.idFromNan(this.mX)) : this.mX;
        this.mOutY = Float.isNaN(this.mY) ? context.getFloat(Utils.idFromNan(this.mY)) : this.mY;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mX)) {
            context.listensTo(Utils.idFromNan(this.mX), this);
        }
        if (Float.isNaN(this.mY)) {
            context.listensTo(Utils.idFromNan(this.mY), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawBitmapFontText.apply(buffer, this.mTextID, this.mBitmapFontID, this.mStart, this.mEnd, this.mX, this.mY);
    }

    @NonNull
    public String toString() {
        return "DrawBitmapFontText [" + this.mTextID + "] " + this.mBitmapFontID + ", " + this.mStart + ", " + this.mEnd + ", " + Utils.floatToString(this.mX, this.mOutX) + ", " + Utils.floatToString(this.mY, this.mOutY);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int text = buffer.readInt();
        int bitmapFont = buffer.readInt();
        int start = buffer.readInt();
        int end = buffer.readInt();
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        DrawBitmapFontText op = new DrawBitmapFontText(text, bitmapFont, start, end, x, y);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 48;
    }

    public static void apply(@NonNull WireBuffer buffer, int textID, int bitmapFontID, int start, int end, float x, float y) {
        buffer.start(48);
        buffer.writeInt(textID);
        buffer.writeInt(bitmapFontID);
        buffer.writeInt(start);
        buffer.writeInt(end);
        buffer.writeFloat(x);
        buffer.writeFloat(y);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", DrawBitmapFontText.id(), CLASS_NAME).description("Draw a run of bitmap font text, all in a single direction").field(0, "textId", "id of bitmap").field(0, "bitmapFontId", "id of the bitmap font").field(0, "start", "The start of the text to render. -1=end of string").field(0, "end", "The end of the text to render").field(0, "contextStart", "the index of the start of the shaping context").field(0, "contextEnd", "the index of the end of the shaping context").field(1, "x", "The x position at which to draw the text").field(1, "y", "The y position at which to draw the text").field(2, "RTL", "Whether the run is in RTL direction");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        BitmapFontData bitmapFont;
        RemoteContext remoteContext = context.getContext();
        String textToPaint = remoteContext.getText(this.mTextID);
        if (textToPaint == null) {
            return;
        }
        if (this.mEnd == -1) {
            if (this.mStart != 0) {
                textToPaint = textToPaint.substring(this.mStart);
            }
        } else {
            textToPaint = this.mEnd > textToPaint.length() ? textToPaint.substring(this.mStart) : textToPaint.substring(this.mStart, this.mEnd);
        }
        if ((bitmapFont = (BitmapFontData)remoteContext.getObject(this.mBitmapFontID)) == null) {
            return;
        }
        float xPos = this.mX;
        int pos = 0;
        while (pos < textToPaint.length()) {
            BitmapFontData.Glyph glyph = bitmapFont.lookupGlyph(textToPaint, pos);
            if (glyph == null) {
                ++pos;
                continue;
            }
            pos += glyph.mChars.length();
            if (glyph.mBitmapId == -1) {
                xPos += (float)(glyph.mMarginLeft + glyph.mMarginRight);
                continue;
            }
            float xPos2 = (xPos += (float)glyph.mMarginLeft) + (float)glyph.mBitmapWidth;
            context.drawBitmap(glyph.mBitmapId, xPos, this.mY + (float)glyph.mMarginTop, xPos2, this.mY + (float)glyph.mBitmapHeight + (float)glyph.mMarginTop);
            xPos = xPos2 + (float)glyph.mMarginRight;
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextID).add("bitmapFontId", this.mBitmapFontID).add("start", this.mStart).add("end", this.mEnd).add("x", this.mX, this.mOutX).add("y", this.mY, this.mOutY);
    }
}

