/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class DrawPath
extends PaintOperation
implements Serializable {
    private static final int OP_CODE = 124;
    private static final String CLASS_NAME = "DrawPath";
    int mId;
    float mStart = 0.0f;
    float mEnd = 1.0f;

    public DrawPath(int pathId) {
        this.mId = pathId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawPath.apply(buffer, this.mId);
    }

    @NonNull
    public String toString() {
        return "DrawPath [" + this.mId + "], " + this.mStart + ", " + this.mEnd;
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        DrawPath op = new DrawPath(id2);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 124;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2) {
        buffer.start(124);
        buffer.writeInt(id2);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 124, CLASS_NAME).description("Draw a bitmap using integer coordinates").field(0, "id", "id of path");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawPath(this.mId, this.mStart, this.mEnd);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("start", Float.valueOf(this.mStart)).add("end", Float.valueOf(this.mEnd));
    }
}

