/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawText
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 43;
    private static final String CLASS_NAME = "DrawText";
    int mTextID;
    int mStart = 0;
    int mEnd = 0;
    int mContextStart = 0;
    int mContextEnd = 0;
    float mX = 0.0f;
    float mY = 0.0f;
    float mOutX = 0.0f;
    float mOutY = 0.0f;
    boolean mRtl = false;

    public DrawText(int textID, int start, int end, int contextStart, int contextEnd, float x, float y, boolean rtl) {
        this.mTextID = textID;
        this.mStart = start;
        this.mEnd = end;
        this.mContextStart = contextStart;
        this.mContextEnd = contextEnd;
        this.mOutX = this.mX = x;
        this.mOutY = this.mY = y;
        this.mRtl = rtl;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutX = Float.isNaN(this.mX) ? context.getFloat(Utils.idFromNan(this.mX)) : this.mX;
        this.mOutY = Float.isNaN(this.mY) ? context.getFloat(Utils.idFromNan(this.mY)) : this.mY;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mX)) {
            context.listensTo(Utils.idFromNan(this.mX), this);
        }
        if (Float.isNaN(this.mY)) {
            context.listensTo(Utils.idFromNan(this.mY), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawText.apply(buffer, this.mTextID, this.mStart, this.mEnd, this.mContextStart, this.mContextEnd, this.mX, this.mY, this.mRtl);
    }

    @NonNull
    public String toString() {
        return "DrawTextRun [" + this.mTextID + "] " + this.mStart + ", " + this.mEnd + ", " + Utils.floatToString(this.mX, this.mOutX) + ", " + Utils.floatToString(this.mY, this.mOutY);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int text = buffer.readInt();
        int start = buffer.readInt();
        int end = buffer.readInt();
        int contextStart = buffer.readInt();
        int contextEnd = buffer.readInt();
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        boolean rtl = buffer.readBoolean();
        DrawText op = new DrawText(text, start, end, contextStart, contextEnd, x, y, rtl);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 43;
    }

    public static void apply(@NonNull WireBuffer buffer, int textID, int start, int end, int contextStart, int contextEnd, float x, float y, boolean rtl) {
        buffer.start(43);
        buffer.writeInt(textID);
        buffer.writeInt(start);
        buffer.writeInt(end);
        buffer.writeInt(contextStart);
        buffer.writeInt(contextEnd);
        buffer.writeFloat(x);
        buffer.writeFloat(y);
        buffer.writeBoolean(rtl);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", DrawText.id(), CLASS_NAME).description("Draw a run of text, all in a single direction").field(0, "textId", "id of bitmap").field(0, "start", "The start of the text to render. -1=end of string").field(0, "end", "The end of the text to render").field(0, "contextStart", "the index of the start of the shaping context").field(0, "contextEnd", "the index of the end of the shaping context").field(1, "x", "The x position at which to draw the text").field(1, "y", "The y position at which to draw the text").field(2, "RTL", "Whether the run is in RTL direction");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawTextRun(this.mTextID, this.mStart, this.mEnd, this.mContextStart, this.mContextEnd, this.mOutX, this.mOutY, this.mRtl);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextID).add("start", this.mStart).add("end", this.mEnd).add("contextStart", this.mContextStart).add("contextEnd", this.mContextEnd).add("x", this.mX, this.mOutX).add("y", this.mY, this.mOutY).add("rtl", this.mRtl);
    }
}

