/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class DrawTextAnchored
extends PaintOperation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 133;
    private static final String CLASS_NAME = "DrawTextAnchored";
    int mTextID;
    float mX;
    float mY;
    float mPanX;
    float mPanY;
    int mFlags;
    float mOutX;
    float mOutY;
    float mOutPanX;
    float mOutPanY;
    String mLastString;
    public static final int ANCHOR_TEXT_RTL = 1;
    public static final int ANCHOR_MONOSPACE_MEASURE = 2;
    public static final int MEASURE_EVERY_TIME = 4;
    @NonNull
    float[] mBounds = new float[4];

    public DrawTextAnchored(int textID, float x, float y, float panX, float panY, int flags) {
        this.mTextID = textID;
        this.mX = x;
        this.mY = y;
        this.mOutX = this.mX;
        this.mOutY = this.mY;
        this.mFlags = flags;
        this.mOutPanX = this.mPanX = panX;
        this.mOutPanY = this.mPanY = panY;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutX = Float.isNaN(this.mX) ? context.getFloat(Utils.idFromNan(this.mX)) : this.mX;
        this.mOutY = Float.isNaN(this.mY) ? context.getFloat(Utils.idFromNan(this.mY)) : this.mY;
        this.mOutPanX = Float.isNaN(this.mPanX) ? context.getFloat(Utils.idFromNan(this.mPanX)) : this.mPanX;
        this.mOutPanY = Float.isNaN(this.mPanY) ? context.getFloat(Utils.idFromNan(this.mPanY)) : this.mPanY;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mX)) {
            context.listensTo(Utils.idFromNan(this.mX), this);
        }
        if (Float.isNaN(this.mY)) {
            context.listensTo(Utils.idFromNan(this.mY), this);
        }
        if (Float.isNaN(this.mPanX)) {
            context.listensTo(Utils.idFromNan(this.mPanX), this);
        }
        if (Float.isNaN(this.mPanY) && Utils.idFromNan(this.mPanY) > 0) {
            context.listensTo(Utils.idFromNan(this.mPanY), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawTextAnchored.apply(buffer, this.mTextID, this.mX, this.mY, this.mPanX, this.mPanY, this.mFlags);
    }

    @NonNull
    public String toString() {
        return "DrawTextAnchored [" + this.mTextID + "] " + DrawTextAnchored.floatToStr(this.mX) + ", " + DrawTextAnchored.floatToStr(this.mY) + ", " + DrawTextAnchored.floatToStr(this.mPanX) + ", " + DrawTextAnchored.floatToStr(this.mPanY) + ", " + Integer.toBinaryString(this.mFlags);
    }

    private static String floatToStr(float v) {
        if (Float.isNaN(v)) {
            return "[" + Utils.idFromNan(v) + "]";
        }
        return Float.toString(v);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textID = buffer.readInt();
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float panX = buffer.readFloat();
        float panY = buffer.readFloat();
        int flags = buffer.readInt();
        DrawTextAnchored op = new DrawTextAnchored(textID, x, y, panX, panY, flags);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 133;
    }

    public static void apply(@NonNull WireBuffer buffer, int textID, float x, float y, float panX, float panY, int flags) {
        buffer.start(133);
        buffer.writeInt(textID);
        buffer.writeFloat(x);
        buffer.writeFloat(y);
        buffer.writeFloat(panX);
        buffer.writeFloat(panY);
        buffer.writeInt(flags);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 133, CLASS_NAME).description("Draw text centered about an anchor point").field(0, "textId", "id of bitmap").field(1, "x", "The x-position of the anchor point").field(1, "y", "The y-position of the anchor point").field(1, "panX", "The pan from left(-1) to right(1) 0 being centered").field(1, "panY", "The pan from top(-1) to bottom(1) 0 being centered").field(0, "flags", "Change the behaviour");
    }

    private float getHorizontalOffset() {
        float scale = 1.0f;
        float textWidth = scale * (this.mBounds[2] - this.mBounds[0]);
        float boxWidth = 0.0f;
        return (boxWidth - textWidth) * (1.0f + this.mOutPanX) / 2.0f - scale * this.mBounds[0];
    }

    private float getVerticalOffset() {
        float scale = 1.0f;
        float boxHeight = 0.0f;
        float textHeight = scale * (this.mBounds[3] - this.mBounds[1]);
        return (boxHeight - textHeight) * (1.0f - this.mOutPanY) / 2.0f - scale * this.mBounds[1];
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        int flags = (this.mFlags & 2) != 0 ? 1 : 0;
        String str = context.getText(this.mTextID);
        if (str != this.mLastString || (this.mFlags & 4) != 0) {
            this.mLastString = str;
            context.getTextBounds(this.mTextID, 0, -1, flags, this.mBounds);
        }
        float x = this.mOutX + this.getHorizontalOffset();
        float y = Float.isNaN(this.mOutPanY) ? this.mOutY : this.mOutY + this.getVerticalOffset();
        context.drawTextRun(this.mTextID, 0, -1, 0, 1, x, y, (this.mFlags & 1) == 1);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextID).add("x", this.mX, this.mOutX).add("y", this.mY, this.mOutY).add("panX", this.mPanX, this.mOutPanX).add("panY", this.mPanY, this.mOutPanY).add("flags", this.mFlags);
    }
}

