/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.FloatFunctionDefine;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatFunctionCall
extends PaintOperation
implements VariableSupport {
    private static final int OP_CODE = 166;
    private static final String CLASS_NAME = "FunctionCall";
    private final int mId;
    private final float[] mArgs;
    private final float[] mOutArgs;
    FloatFunctionDefine mFunction;
    @NonNull
    private ArrayList<Operation> mList = new ArrayList();
    @NonNull
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();

    public FloatFunctionCall(int id2, float[] args) {
        this.mId = id2;
        this.mArgs = args;
        if (args != null) {
            this.mOutArgs = new float[args.length];
            System.arraycopy(args, 0, this.mOutArgs, 0, args.length);
        } else {
            this.mOutArgs = null;
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mOutArgs != null) {
            for (int i = 0; i < this.mArgs.length; ++i) {
                float v = this.mArgs[i];
                this.mOutArgs[i] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? context.getFloat(Utils.idFromNan(v)) : v;
            }
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        this.mFunction = (FloatFunctionDefine)context.getObject(this.mId);
        if (this.mArgs != null) {
            for (int i = 0; i < this.mArgs.length; ++i) {
                float v = this.mArgs[i];
                if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
                context.listensTo(Utils.idFromNan(v), this);
            }
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        FloatFunctionCall.apply(buffer, this.mId, this.mArgs);
    }

    @NonNull
    public String toString() {
        String str = "callFunction[" + Utils.idString(this.mId) + "] ";
        for (int i = 0; i < this.mArgs.length; ++i) {
            str = str + (i == 0 ? "" : " ,") + Utils.floatToString(this.mArgs[i], this.mOutArgs[i]);
        }
        return str;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @Nullable float[] args) {
        buffer.start(166);
        buffer.writeInt(id2);
        if (args != null) {
            buffer.writeInt(args.length);
            for (int i = 0; i < args.length; ++i) {
                buffer.writeFloat(args[i]);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int argLen = buffer.readInt();
        float[] args = null;
        if (argLen > 0) {
            args = new float[argLen];
            for (int i = 0; i < argLen; ++i) {
                args[i] = buffer.readFloat();
            }
        }
        FloatFunctionCall data = new FloatFunctionCall(id2, args);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 166, CLASS_NAME).description("Command to call the function").field(0, "id", "id of function to call").field(0, "argLen", "the number of Arguments").field(10, "values", "argLen", "array of float arguments");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        RemoteContext remoteContext = context.getContext();
        int[] args = this.mFunction.getArgs();
        for (int j = 0; j < this.mOutArgs.length; ++j) {
            remoteContext.loadFloat(args[j], this.mOutArgs[j]);
            this.updateVariables(remoteContext);
        }
        this.mFunction.execute(remoteContext);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("args", Collections.singletonList(this.mArgs)).add("outArgs", Collections.singletonList(this.mOutArgs));
    }
}

