/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase2;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class MatrixTranslate
extends DrawBase2 {
    private static final int OP_CODE = 127;
    private static final String CLASS_NAME = "MatrixTranslate";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase2.Maker m = MatrixTranslate::new;
        MatrixTranslate.read(m, buffer, operations);
    }

    public static int id() {
        return 127;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2) {
        MatrixTranslate.apply(buffer, v1, v2);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 127, CLASS_NAME).description("Preconcat the current matrix with the specified translation").field(1, "dx", "The distance to translate in X").field(1, "dy", "The distance to translate in Y");
    }

    public MatrixTranslate(float translateX, float translateY) {
        super(translateX, translateY);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.matrixTranslate(this.mV1, this.mV2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1) {
        MatrixTranslate.write(buffer, 127, x1, y1);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "dx", "dy").addType(CLASS_NAME);
    }
}

