/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.PathData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class PathAppend
extends PaintOperation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 160;
    private static final String CLASS_NAME = "PathAppend";
    int mInstanceId;
    float[] mFloatPath;
    float[] mOutputPath;
    public static final int MOVE = 10;
    public static final int LINE = 11;
    public static final int QUADRATIC = 12;
    public static final int CONIC = 13;
    public static final int CUBIC = 14;
    public static final int CLOSE = 15;
    public static final int DONE = 16;
    public static final int RESET = 17;
    public static final float MOVE_NAN = Utils.asNan(10);
    public static final float LINE_NAN = Utils.asNan(11);
    public static final float QUADRATIC_NAN = Utils.asNan(12);
    public static final float CONIC_NAN = Utils.asNan(13);
    public static final float CUBIC_NAN = Utils.asNan(14);
    public static final float CLOSE_NAN = Utils.asNan(15);
    public static final float DONE_NAN = Utils.asNan(16);
    public static final float RESET_NAN = Utils.asNan(17);

    PathAppend(int instanceId, float[] floatPath) {
        this.mInstanceId = instanceId;
        this.mFloatPath = floatPath;
        this.mOutputPath = Arrays.copyOf(this.mFloatPath, this.mFloatPath.length);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        for (int i = 0; i < this.mFloatPath.length; ++i) {
            float v = this.mFloatPath[i];
            this.mOutputPath[i] = Utils.isVariable(v) ? (Float.isNaN(v) ? context.getFloat(Utils.idFromNan(v)) : v) : v;
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        for (float v : this.mFloatPath) {
            if (!Float.isNaN(v)) continue;
            context.listensTo(Utils.idFromNan(v), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PathAppend.apply(buffer, this.mInstanceId, this.mOutputPath);
    }

    @Override
    @NonNull
    public String deepToString(String indent) {
        return PathData.pathString(this.mFloatPath);
    }

    @NonNull
    public String toString() {
        return "PathAppend[" + this.mInstanceId + "] += \"" + PathAppend.pathString(this.mOutputPath) + "\"";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 160;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull float[] data) {
        buffer.start(160);
        buffer.writeInt(id2);
        buffer.writeInt(data.length);
        for (float datum : data) {
            buffer.writeFloat(datum);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int len = buffer.readInt();
        float[] data = new float[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buffer.readFloat();
        }
        operations.add(new PathAppend(id2, data));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 160, CLASS_NAME).description("Append to a Path").field(0, "id", "id string").field(0, "length", "id string").field(10, "pathData", "length", "path encoded as floats");
    }

    @Override
    public void paint(PaintContext context) {
        this.apply(context.getContext());
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        float[] data = context.getPathData(this.mInstanceId);
        float[] out = this.mOutputPath;
        if (Float.floatToRawIntBits(out[0]) == Float.floatToRawIntBits(RESET_NAN)) {
            context.loadPathData(this.mInstanceId, new float[0]);
            return;
        }
        if (data != null) {
            int i;
            out = new float[data.length + this.mOutputPath.length];
            for (i = 0; i < data.length; ++i) {
                out[i] = data[i];
            }
            for (i = 0; i < this.mOutputPath.length; ++i) {
                out[i + data.length] = this.mOutputPath[i];
            }
        } else {
            System.out.println(">>>>>>>>>>> DATA IS NULL");
        }
        context.loadPathData(this.mInstanceId, out);
    }

    @NonNull
    public static String pathString(@Nullable float[] path) {
        if (path == null) {
            return "null";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (!Float.isNaN(path[i])) continue;
            int id2 = Utils.idFromNan(path[i]);
            if (id2 <= 16) {
                switch (id2) {
                    case 10: {
                        str.append("M");
                        break;
                    }
                    case 11: {
                        str.append("L");
                        break;
                    }
                    case 12: {
                        str.append("Q");
                        break;
                    }
                    case 13: {
                        str.append("R");
                        break;
                    }
                    case 14: {
                        str.append("C");
                        break;
                    }
                    case 15: {
                        str.append("Z");
                        break;
                    }
                    case 16: {
                        str.append(".");
                        break;
                    }
                    default: {
                        str.append("[" + id2 + "]");
                        break;
                    }
                }
                continue;
            }
            str.append("(" + id2 + ")");
        }
        return str.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mInstanceId).addPath("path", this.mFloatPath);
    }
}

