/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class PathCombine
extends PaintOperation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 175;
    private static final String CLASS_NAME = "PathCombine";
    public int mOutId;
    public int mPathId1;
    public int mPathId2;
    private byte mOperation;
    public static final byte OP_DIFFERENCE = 0;
    public static final byte OP_INTERSECT = 1;
    public static final byte OP_REVERSE_DIFFERENCE = 2;
    public static final byte OP_UNION = 3;
    public static final byte OP_XOR = 4;

    public PathCombine(int outId, int pathId1, int pathId2, byte operation) {
        this.mOutId = outId;
        this.mPathId1 = pathId1;
        this.mPathId2 = pathId2;
        this.mOperation = operation;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PathCombine.apply(buffer, this.mOutId, this.mPathId1, this.mPathId2, this.mOperation);
    }

    @NonNull
    public String toString() {
        return "PathCombine[" + this.mOutId + "] = [" + this.mPathId1 + " ] + [ " + this.mPathId2 + "], " + this.mOperation;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 175;
    }

    public static void apply(@NonNull WireBuffer buffer, int outId, int pathId1, int pathId2, byte op) {
        buffer.start(175);
        buffer.writeInt(outId);
        buffer.writeInt(pathId1);
        buffer.writeInt(pathId2);
        buffer.writeByte(op);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int outId1 = buffer.readInt();
        int pathId1 = buffer.readInt();
        int pathId2 = buffer.readInt();
        byte op = (byte)buffer.readByte();
        operations.add(new PathCombine(outId1, pathId1, pathId2, op));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 175, CLASS_NAME).description("Merge two string into one").field(0, "srcPathId1", "id of the path").field(0, "srcPathId1", "x Shift of the path").field(6, "operation", "the operation");
    }

    @Override
    @NonNull
    public String deepToString(String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        context.combinePath(this.mOutId, this.mPathId1, this.mPathId2, this.mOperation);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("outId", this.mOutId).add("pathId1", this.mPathId1).add("pathId2", this.mPathId2).add("operation", this.mOperation);
    }
}

