/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class PathTween
extends PaintOperation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 158;
    private static final String CLASS_NAME = "PathTween";
    public int mOutId;
    public int mPathId1;
    public int mPathId2;
    public float mTween;
    public float mTweenOut;

    public PathTween(int outId, int pathId1, int pathId2, float tween) {
        this.mOutId = outId;
        this.mPathId1 = pathId1;
        this.mPathId2 = pathId2;
        this.mTweenOut = this.mTween = tween;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mTweenOut = Float.isNaN(this.mTween) ? context.getFloat(Utils.idFromNan(this.mTween)) : this.mTween;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mTween)) {
            context.listensTo(Utils.idFromNan(this.mTween), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PathTween.apply(buffer, this.mOutId, this.mPathId1, this.mPathId2, this.mTween);
    }

    @NonNull
    public String toString() {
        return "PathTween[" + this.mOutId + "] = [" + this.mPathId1 + " ] + [ " + this.mPathId2 + "], " + Utils.floatToString(this.mTween, this.mTweenOut);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 158;
    }

    public static void apply(@NonNull WireBuffer buffer, int outId, int pathId1, int pathId2, float tween) {
        buffer.start(158);
        buffer.writeInt(outId);
        buffer.writeInt(pathId1);
        buffer.writeInt(pathId2);
        buffer.writeFloat(tween);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int outId1 = buffer.readInt();
        int pathId1 = buffer.readInt();
        int pathId2 = buffer.readInt();
        float tween = buffer.readFloat();
        operations.add(new PathTween(outId1, pathId1, pathId2, tween));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 158, CLASS_NAME).description("Merge two string into one").field(0, "pathId", "id of the path").field(0, "srcPathId1", "id of the path").field(0, "srcPathId1", "x Shift of the path");
    }

    @Override
    @NonNull
    public String deepToString(String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        context.tweenPath(this.mOutId, this.mPathId1, this.mPathId2, this.mTweenOut);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("outId", this.mOutId).add("pathId1", this.mPathId1).add("pathId2", this.mPathId2).add("tween", this.mTween, this.mTweenOut);
    }
}

