/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.operations.ComponentValue;
import com.android.internal.widget.remotecompose.core.operations.TextData;
import com.android.internal.widget.remotecompose.core.operations.TouchExpression;
import com.android.internal.widget.remotecompose.core.operations.layout.ClickHandler;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponentContent;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.TouchHandler;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.AnimateMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.AnimationSpec;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Measurable;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.ArrayList;
import java.util.HashSet;

public class Component
extends PaintOperation
implements Container,
Measurable,
SerializableToString,
Serializable {
    private static final boolean DEBUG = false;
    protected int mComponentId = -1;
    protected float mX;
    protected float mY;
    protected float mWidth;
    protected float mHeight;
    @Nullable
    protected Component mParent;
    protected int mAnimationId = -1;
    public int mVisibility = 1;
    public int mScheduledVisibility = 1;
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();
    public PaintOperation mPreTranslate;
    public boolean mNeedsMeasure = true;
    public boolean mNeedsRepaint = false;
    @Nullable
    public AnimateMeasure mAnimateMeasure;
    @NonNull
    public AnimationSpec mAnimationSpec = AnimationSpec.DEFAULT;
    public boolean mFirstLayout = true;
    @NonNull
    PaintBundle mPaint = new PaintBundle();
    @NonNull
    protected HashSet<ComponentValue> mComponentValues = new HashSet();
    protected float mZIndex = 0.0f;
    private boolean mNeedsBoundsAnimation = false;
    @NonNull
    public float[] locationInWindow = new float[2];

    public void markNeedsBoundsAnimation() {
        this.mNeedsBoundsAnimation = true;
        if (this.mParent != null && !this.mParent.mNeedsBoundsAnimation) {
            this.mParent.markNeedsBoundsAnimation();
        }
    }

    public void clearNeedsBoundsAnimation() {
        this.mNeedsBoundsAnimation = false;
    }

    public boolean needsBoundsAnimation() {
        return this.mNeedsBoundsAnimation;
    }

    public float getZIndex() {
        return this.mZIndex;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public int getComponentId() {
        return this.mComponentId;
    }

    public int getAnimationId() {
        return this.mAnimationId;
    }

    @Nullable
    public Component getParent() {
        return this.mParent;
    }

    public void setX(float value) {
        this.mX = value;
    }

    public void setY(float value) {
        this.mY = value;
    }

    public void setWidth(float value) {
        this.mWidth = value;
    }

    public void setHeight(float value) {
        this.mHeight = value;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        for (Operation op : this.mList) {
            if (!(op instanceof VariableSupport) || !op.isDirty()) continue;
            op.markNotDirty();
            ((VariableSupport)((Object)op)).updateVariables(context);
        }
        super.apply(context);
    }

    private void updateComponentValues(@NonNull RemoteContext context) {
        for (ComponentValue v : this.mComponentValues) {
            if (context.getMode() == RemoteContext.ContextMode.DATA) {
                context.loadFloat(v.getValueId(), 1.0f);
                continue;
            }
            switch (v.getType()) {
                case 0: {
                    context.loadFloat(v.getValueId(), this.mWidth);
                    break;
                }
                case 1: {
                    context.loadFloat(v.getValueId(), this.mHeight);
                }
            }
        }
    }

    public void setComponentId(int id2) {
        this.mComponentId = id2;
    }

    public void setAnimationId(int id2) {
        this.mAnimationId = id2;
    }

    public Component(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height) {
        this.mComponentId = componentId;
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.mParent = parent;
        this.mAnimationId = animationId;
    }

    public Component(int componentId, float x, float y, float width, float height, @Nullable Component parent) {
        this(parent, componentId, -1, x, y, width, height);
    }

    public Component(@NonNull Component component) {
        this(component.mParent, component.mComponentId, component.mAnimationId, component.mX, component.mY, component.mWidth, component.mHeight);
        this.mList.addAll(component.mList);
        this.finalizeCreation();
    }

    public void finalizeCreation() {
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).mParent = this;
            }
            if (!(op instanceof AnimationSpec)) continue;
            this.mAnimationSpec = (AnimationSpec)op;
            this.mAnimationId = this.mAnimationSpec.getAnimationId();
        }
    }

    @Override
    public boolean needsMeasure() {
        return this.mNeedsMeasure;
    }

    public void setParent(@Nullable Component parent) {
        this.mParent = parent;
    }

    public void updateVariables(@NonNull RemoteContext context) {
        Component prev = context.mLastComponent;
        context.mLastComponent = this;
        if (!this.mComponentValues.isEmpty()) {
            this.updateComponentValues(context);
        }
        context.mLastComponent = prev;
    }

    public void addComponentValue(@NonNull ComponentValue v) {
        this.mComponentValues.add(v);
    }

    public float minIntrinsicWidth(@Nullable RemoteContext context) {
        return this.getWidth();
    }

    public float maxIntrinsicWidth(@Nullable RemoteContext context) {
        return this.getWidth();
    }

    public float minIntrinsicHeight(@Nullable RemoteContext context) {
        return this.getHeight();
    }

    public float maxIntrinsicHeight(@Nullable RemoteContext context) {
        return this.getHeight();
    }

    public void inflate() {
        for (Operation op : this.mList) {
            if (!(op instanceof TouchListener)) continue;
            TouchListener touchListener = (TouchListener)((Object)op);
            touchListener.setComponent(this);
        }
    }

    protected AnimationSpec getAnimationSpec() {
        return this.mAnimationSpec;
    }

    protected void setAnimationSpec(@NonNull AnimationSpec animationSpec) {
        this.mAnimationSpec = animationSpec;
    }

    public void registerVariables(RemoteContext context) {
    }

    public boolean isVisible() {
        if (this.mParent == null || !Visibility.isVisible(this.mVisibility)) {
            return Visibility.isVisible(this.mVisibility);
        }
        return this.mParent.isVisible();
    }

    public boolean isGone() {
        return Visibility.isGone(this.mVisibility);
    }

    public boolean isInvisible() {
        return Visibility.isInvisible(this.mVisibility);
    }

    public void setVisibility(int visibility) {
        if (visibility != this.mVisibility || visibility != this.mScheduledVisibility) {
            this.mScheduledVisibility = visibility;
            this.invalidateMeasure();
        }
    }

    @Override
    public boolean suitableForTransition(@NonNull Operation o) {
        if (!(o instanceof Component)) {
            return false;
        }
        if (this.mList.size() != ((Component)o).mList.size()) {
            return false;
        }
        for (int i = 0; i < this.mList.size(); ++i) {
            Operation o1 = this.mList.get(i);
            Operation o2 = ((Component)o).mList.get(i);
            if (o1 instanceof Component && o2 instanceof Component && !((Component)o1).suitableForTransition(o2)) {
                return false;
            }
            if (!(o1 instanceof PaintOperation) || ((PaintOperation)o1).suitableForTransition(o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void measure(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        ComponentMeasure m = measure.get(this);
        m.setW(this.mWidth);
        m.setH(this.mHeight);
    }

    @Override
    public void layout(@NonNull RemoteContext context, @NonNull MeasurePass measure) {
        ComponentMeasure m = measure.get(this);
        if (!this.mFirstLayout && context.isAnimationEnabled() && this.mAnimationSpec.isAnimationEnabled() && !(this instanceof LayoutComponentContent)) {
            if (this.mAnimateMeasure == null) {
                ComponentMeasure origin = new ComponentMeasure(this.mComponentId, this.mX, this.mY, this.mWidth, this.mHeight, this.mVisibility);
                ComponentMeasure target = new ComponentMeasure(this.mComponentId, m.getX(), m.getY(), m.getW(), m.getH(), m.getVisibility());
                if (!target.same(origin)) {
                    this.mAnimateMeasure = new AnimateMeasure(context.currentTime, this, origin, target, this.mAnimationSpec.getMotionDuration(), this.mAnimationSpec.getVisibilityDuration(), this.mAnimationSpec.getEnterAnimation(), this.mAnimationSpec.getExitAnimation(), this.mAnimationSpec.getMotionEasingType(), this.mAnimationSpec.getVisibilityEasingType());
                }
            } else {
                this.mAnimateMeasure.updateTarget(m, context.currentTime);
            }
        } else {
            this.mVisibility = m.getVisibility();
        }
        if (this.mAnimateMeasure == null) {
            this.setWidth(m.getW());
            this.setHeight(m.getH());
            this.setLayoutPosition(m.getX(), m.getY());
            this.updateComponentValues(context);
            this.clearNeedsBoundsAnimation();
        } else {
            this.mAnimateMeasure.apply(context);
            this.updateComponentValues(context);
            this.markNeedsBoundsAnimation();
        }
        this.mFirstLayout = false;
    }

    @Override
    public void animatingBounds(@NonNull RemoteContext context) {
        if (this.mAnimateMeasure != null) {
            this.mAnimateMeasure.apply(context);
            this.updateComponentValues(context);
        } else {
            this.clearNeedsBoundsAnimation();
        }
        for (Operation op : this.mList) {
            if (!(op instanceof Measurable)) continue;
            Measurable m = (Measurable)((Object)op);
            m.animatingBounds(context);
        }
    }

    public boolean contains(float x, float y) {
        this.locationInWindow[0] = 0.0f;
        this.locationInWindow[1] = 0.0f;
        this.getLocationInWindow(this.locationInWindow);
        float lx1 = this.locationInWindow[0];
        float lx2 = lx1 + this.mWidth;
        float ly1 = this.locationInWindow[1];
        float ly2 = ly1 + this.mHeight;
        return x >= lx1 && x < lx2 && y >= ly1 && y < ly2;
    }

    public float getScrollX() {
        return 0.0f;
    }

    public float getScrollY() {
        return 0.0f;
    }

    public void onClick(@NonNull RemoteContext context, @NonNull CoreDocument document, float x, float y) {
        boolean isUnconditional = x == -1.0f & y == -1.0f;
        if (!isUnconditional && !this.contains(x, y)) {
            return;
        }
        float cx = isUnconditional ? -1.0f : x - this.getScrollX();
        float cy = isUnconditional ? -1.0f : y - this.getScrollY();
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).onClick(context, document, cx, cy);
            }
            if (!(op instanceof ClickHandler)) continue;
            ((ClickHandler)((Object)op)).onClick(context, document, this, cx, cy);
        }
    }

    public void onTouchDown(RemoteContext context, CoreDocument document, float x, float y) {
        if (!this.contains(x, y)) {
            return;
        }
        float cx = x - this.getScrollX();
        float cy = y - this.getScrollY();
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).onTouchDown(context, document, cx, cy);
            }
            if (op instanceof TouchHandler) {
                ((TouchHandler)((Object)op)).onTouchDown(context, document, this, cx, cy);
            }
            if (!(op instanceof TouchExpression)) continue;
            TouchExpression touchExpression = (TouchExpression)op;
            touchExpression.updateVariables(context);
            touchExpression.touchDown(context, cx, cy);
            document.appliedTouchOperation(this);
        }
    }

    public void onTouchUp(RemoteContext context, CoreDocument document, float x, float y, float dx, float dy, boolean force) {
        if (!force && !this.contains(x, y)) {
            return;
        }
        float cx = x - this.getScrollX();
        float cy = y - this.getScrollY();
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).onTouchUp(context, document, cx, cy, dx, dy, force);
            }
            if (op instanceof TouchHandler) {
                ((TouchHandler)((Object)op)).onTouchUp(context, document, this, cx, cy, dx, dy);
            }
            if (!(op instanceof TouchExpression)) continue;
            TouchExpression touchExpression = (TouchExpression)op;
            touchExpression.updateVariables(context);
            touchExpression.touchUp(context, cx, cy, dx, dy);
        }
    }

    public void onTouchCancel(RemoteContext context, CoreDocument document, float x, float y, boolean force) {
        if (!force && !this.contains(x, y)) {
            return;
        }
        float cx = x - this.getScrollX();
        float cy = y - this.getScrollY();
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).onTouchCancel(context, document, cx, cy, force);
            }
            if (op instanceof TouchHandler) {
                ((TouchHandler)((Object)op)).onTouchCancel(context, document, this, cx, cy);
            }
            if (!(op instanceof TouchExpression)) continue;
            TouchExpression touchExpression = (TouchExpression)op;
            touchExpression.updateVariables(context);
            touchExpression.touchUp(context, cx, cy, 0.0f, 0.0f);
        }
    }

    public void onTouchDrag(RemoteContext context, CoreDocument document, float x, float y, boolean force) {
        if (!force && !this.contains(x, y)) {
            return;
        }
        float cx = x - this.getScrollX();
        float cy = y - this.getScrollY();
        for (Operation op : this.mList) {
            if (op instanceof Component) {
                ((Component)op).onTouchDrag(context, document, cx, cy, force);
            }
            if (op instanceof TouchHandler) {
                ((TouchHandler)((Object)op)).onTouchDrag(context, document, this, cx, cy);
            }
            if (!(op instanceof TouchExpression)) continue;
            TouchExpression touchExpression = (TouchExpression)op;
            touchExpression.updateVariables(context);
            touchExpression.touchDrag(context, x, y);
        }
    }

    public void getLocationInWindow(@NonNull float[] value, boolean forSelf) {
        value[0] = value[0] + this.mX;
        value[1] = value[1] + this.mY;
        if (this.mParent != null) {
            this.mParent.getLocationInWindow(value, false);
        }
    }

    public void getLocationInWindow(@NonNull float[] value) {
        this.getLocationInWindow(value, true);
    }

    @NonNull
    public String toString() {
        return "COMPONENT(<" + this.mComponentId + "> " + this.getClass().getSimpleName() + ") [" + this.mX + "," + this.mY + " - " + this.mWidth + " x " + this.mHeight + "] " + this.textContent() + " Visibility (" + Visibility.toString(this.mVisibility) + ") ";
    }

    @NonNull
    protected String getSerializedName() {
        return "COMPONENT";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        String content = this.getSerializedName() + " [" + this.mComponentId + ":" + this.mAnimationId + "] = [" + this.mX + ", " + this.mY + ", " + this.mWidth + ", " + this.mHeight + "] " + Visibility.toString(this.mVisibility);
        serializer.append(indent, content);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
    }

    @NonNull
    public RootLayoutComponent getRoot() throws Exception {
        if (this instanceof RootLayoutComponent) {
            return (RootLayoutComponent)this;
        }
        Component p = this.mParent;
        while (!(p instanceof RootLayoutComponent)) {
            if (p == null) {
                throw new Exception("No RootLayoutComponent found");
            }
            p = p.mParent;
        }
        return (RootLayoutComponent)p;
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        builder.append(this.toString());
        builder.append("\n");
        String indent2 = "  " + indent;
        for (Operation op : this.mList) {
            builder.append(op.deepToString(indent2));
            builder.append("\n");
        }
        return builder.toString();
    }

    public void invalidateMeasure() {
        this.needsRepaint();
        this.mNeedsMeasure = true;
        Component p = this.mParent;
        while (p != null) {
            p.mNeedsMeasure = true;
            p = p.mParent;
        }
    }

    public void needsRepaint() {
        try {
            this.getRoot().mNeedsRepaint = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    public String content() {
        StringBuilder builder = new StringBuilder();
        for (Operation op : this.mList) {
            builder.append("- ");
            builder.append(op);
            builder.append("\n");
        }
        return builder.toString();
    }

    @NonNull
    public String textContent() {
        StringBuilder builder = new StringBuilder();
        for (Operation ignored : this.mList) {
            String letter = "";
            builder.append(letter);
        }
        return builder.toString();
    }

    public void debugBox(@NonNull Component component, @NonNull PaintContext context) {
        float width = component.mWidth;
        float height = component.mHeight;
        context.savePaint();
        this.mPaint.reset();
        this.mPaint.setColor(0, 0, 255, 255);
        context.applyPaint(this.mPaint);
        context.drawLine(0.0f, 0.0f, width, 0.0f);
        context.drawLine(width, 0.0f, width, height);
        context.drawLine(width, height, 0.0f, height);
        context.drawLine(0.0f, height, 0.0f, 0.0f);
        context.restorePaint();
    }

    public void setLayoutPosition(float x, float y) {
        this.mX = x;
        this.mY = y;
    }

    public float getTranslateX() {
        if (this.mParent != null) {
            return this.mX - this.mParent.mX;
        }
        return 0.0f;
    }

    public float getTranslateY() {
        if (this.mParent != null) {
            return this.mY - this.mParent.mY;
        }
        return 0.0f;
    }

    public void paintingComponent(@NonNull PaintContext context) {
        if (this.mPreTranslate != null) {
            this.mPreTranslate.paint(context);
        }
        Component prev = context.getContext().mLastComponent;
        context.getContext().mLastComponent = this;
        context.save();
        context.translate(this.mX, this.mY);
        if (context.isVisualDebug()) {
            this.debugBox(this, context);
        }
        for (Operation op : this.mList) {
            if (op.isDirty() && op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).updateVariables(context.getContext());
                op.markNotDirty();
            }
            if (op instanceof PaintOperation) {
                ((PaintOperation)op).paint(context);
                context.getContext().incrementOpCount();
                continue;
            }
            op.apply(context.getContext());
            context.getContext().incrementOpCount();
        }
        context.restore();
        context.getContext().mLastComponent = prev;
    }

    public boolean applyAnimationAsNeeded(@NonNull PaintContext context) {
        if (context.isAnimationEnabled() && this.mAnimateMeasure != null) {
            this.mAnimateMeasure.paint(context);
            if (this.mAnimateMeasure.isDone()) {
                this.mAnimateMeasure = null;
                this.clearNeedsBoundsAnimation();
                this.needsRepaint();
            } else {
                this.markNeedsBoundsAnimation();
            }
            return true;
        }
        return false;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        if (context.isVisualDebug()) {
            context.save();
            context.translate(this.mX, this.mY);
            context.savePaint();
            this.mPaint.reset();
            this.mPaint.setColor(0, 255, 0, 255);
            context.applyPaint(this.mPaint);
            context.drawLine(0.0f, 0.0f, this.mWidth, 0.0f);
            context.drawLine(this.mWidth, 0.0f, this.mWidth, this.mHeight);
            context.drawLine(this.mWidth, this.mHeight, 0.0f, this.mHeight);
            context.drawLine(0.0f, this.mHeight, 0.0f, 0.0f);
            this.mPaint.setColor(255, 0, 0, 255);
            context.applyPaint(this.mPaint);
            context.drawLine(0.0f, 0.0f, this.mWidth, this.mHeight);
            context.drawLine(0.0f, this.mHeight, this.mWidth, 0.0f);
            context.restorePaint();
            context.restore();
        }
        if (this.applyAnimationAsNeeded(context)) {
            return;
        }
        if (this.isGone() || this.isInvisible()) {
            return;
        }
        this.paintingComponent(context);
    }

    public void getComponents(@NonNull ArrayList<Component> components) {
        for (Operation op : this.mList) {
            if (!(op instanceof Component)) continue;
            components.add((Component)op);
        }
    }

    public void getData(@NonNull ArrayList<Operation> data) {
        for (Operation op : this.mList) {
            if (!(op instanceof TextData) && !(op instanceof BitmapData)) continue;
            data.add(op);
        }
    }

    public int getComponentCount() {
        int count = 0;
        for (Operation op : this.mList) {
            if (!(op instanceof Component)) continue;
            count += 1 + ((Component)op).getComponentCount();
        }
        return count;
    }

    public int getPaintId() {
        if (this.mAnimationId != -1) {
            return this.mAnimationId;
        }
        return this.mComponentId;
    }

    public boolean doesNeedsRepaint() {
        return this.mNeedsRepaint;
    }

    @Nullable
    public Component getComponent(int cid) {
        if (this.mComponentId == cid || this.mAnimationId == cid) {
            return this;
        }
        for (Operation c : this.mList) {
            Component search;
            if (!(c instanceof Component) || (search = ((Component)c).getComponent(cid)) == null) continue;
            return search;
        }
        return null;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.COMPONENT);
        serializer.addType(this.getSerializedName());
        serializer.add("id", this.mComponentId);
        serializer.add("x", Float.valueOf(this.mX));
        serializer.add("y", Float.valueOf(this.mY));
        serializer.add("width", Float.valueOf(this.mWidth));
        serializer.add("height", Float.valueOf(this.mHeight));
        serializer.add("visibility", Visibility.toString(this.mVisibility));
        serializer.add("list", this.mList);
    }

    @Nullable
    public <T> T selfOrModifier(Class<T> operationClass) {
        if (operationClass.isInstance(this)) {
            return operationClass.cast(this);
        }
        for (Operation op : this.mList) {
            if (!operationClass.isInstance(op)) continue;
            return operationClass.cast(op);
        }
        return null;
    }

    public static class Visibility {
        public static final int GONE = 0;
        public static final int VISIBLE = 1;
        public static final int INVISIBLE = 2;
        public static final int OVERRIDE_GONE = 16;
        public static final int OVERRIDE_VISIBLE = 32;
        public static final int OVERRIDE_INVISIBLE = 64;
        public static final int CLEAR_OVERRIDE = 128;

        public static String toString(int value) {
            switch (value) {
                case 0: {
                    return "GONE";
                }
                case 1: {
                    return "VISIBLE";
                }
                case 2: {
                    return "INVISIBLE";
                }
            }
            if (value >> 4 > 0) {
                if ((value & 0x10) == 16) {
                    return "OVERRIDE_GONE";
                }
                if ((value & 0x20) == 32) {
                    return "OVERRIDE_VISIBLE";
                }
                if ((value & 0x40) == 64) {
                    return "OVERRIDE_INVISIBLE";
                }
            }
            return "" + value;
        }

        public static boolean isGone(int value) {
            if (value >> 4 > 0) {
                return (value & 0x10) == 16;
            }
            return value == 0;
        }

        public static boolean isVisible(int value) {
            if (value >> 4 > 0) {
                return (value & 0x20) == 32;
            }
            return value == 1;
        }

        public static boolean isInvisible(int value) {
            if (value >> 4 > 0) {
                return (value & 0x40) == 64;
            }
            return value == 2;
        }

        public static boolean hasOverride(int value) {
            return value >> 4 > 0;
        }

        public static int clearOverride(int value) {
            return value & 0xF;
        }

        public static int add(int value, int visibility) {
            int v = value & 0xF;
            if (((v += visibility) & 0x80) == 128) {
                v &= 0xF;
            }
            return v;
        }
    }
}

