/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import java.util.ArrayList;
import java.util.List;

public class ComponentStart
extends Operation
implements Container {
    int mType = 0;
    float mX;
    float mY;
    float mWidth;
    float mHeight;
    int mComponentId;
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();
    public static final int UNKNOWN = -1;
    public static final int DEFAULT = 0;
    public static final int ROOT_LAYOUT = 1;
    public static final int LAYOUT = 2;
    public static final int LAYOUT_CONTENT = 3;
    public static final int SCROLL_CONTENT = 4;
    public static final int BUTTON = 5;
    public static final int CHECKBOX = 6;
    public static final int TEXT = 7;
    public static final int CURVED_TEXT = 8;
    public static final int STATE_HOST = 9;
    public static final int CUSTOM = 10;
    public static final int LOTTIE = 11;
    public static final int IMAGE = 12;
    public static final int STATE_BOX_CONTENT = 13;
    public static final int LAYOUT_BOX = 14;
    public static final int LAYOUT_ROW = 15;
    public static final int LAYOUT_COLUMN = 16;

    public int getType() {
        return this.mType;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public int getComponentId() {
        return this.mComponentId;
    }

    public ComponentStart(int type, int componentId, float width, float height) {
        this.mType = type;
        this.mComponentId = componentId;
        this.mX = 0.0f;
        this.mY = 0.0f;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ComponentStart.apply(buffer, this.mType, this.mComponentId, this.mWidth, this.mHeight);
    }

    @NonNull
    public String toString() {
        return "COMPONENT_START (type " + this.mType + " " + ComponentStart.typeDescription(this.mType) + ") - (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ")";
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @NonNull
    public static String typeDescription(int type) {
        switch (type) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "ROOT_LAYOUT";
            }
            case 2: {
                return "LAYOUT";
            }
            case 3: {
                return "CONTENT";
            }
            case 4: {
                return "SCROLL_CONTENT";
            }
            case 5: {
                return "BUTTON";
            }
            case 6: {
                return "CHECKBOX";
            }
            case 7: {
                return "TEXT";
            }
            case 8: {
                return "CURVED_TEXT";
            }
            case 9: {
                return "STATE_HOST";
            }
            case 11: {
                return "LOTTIE";
            }
            case 10: {
                return "CUSTOM";
            }
            case 12: {
                return "IMAGE";
            }
        }
        return "UNKNOWN";
    }

    @NonNull
    public static String name() {
        return "ComponentStart";
    }

    public static int id() {
        return 2;
    }

    public static void apply(@NonNull WireBuffer buffer, int type, int componentId, float width, float height) {
        buffer.start(2);
        buffer.writeInt(type);
        buffer.writeInt(componentId);
        buffer.writeFloat(width);
        buffer.writeFloat(height);
    }

    public static int size() {
        return 13;
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int type = buffer.readInt();
        int componentId = buffer.readInt();
        float width = buffer.readFloat();
        float height = buffer.readFloat();
        operations.add(new ComponentStart(type, componentId, width, height));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", ComponentStart.id(), ComponentStart.name()).description("Basic component encapsulating draw commands.This is not resizable.").field(0, "TYPE", "Type of components").field(0, "COMPONENT_ID", "unique id for this component").field(1, "WIDTH", "width of the component").field(1, "HEIGHT", "height of the component");
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }
}

