/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.OperationInterface;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.operations.ComponentData;
import com.android.internal.widget.remotecompose.core.operations.MatrixRestore;
import com.android.internal.widget.remotecompose.core.operations.MatrixSave;
import com.android.internal.widget.remotecompose.core.operations.MatrixTranslate;
import com.android.internal.widget.remotecompose.core.operations.layout.CanvasContent;
import com.android.internal.widget.remotecompose.core.operations.layout.CanvasOperations;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponentContent;
import com.android.internal.widget.remotecompose.core.operations.layout.ScrollDelegate;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.AnimationSpec;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ComponentModifiers;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ComponentVisibilityOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DimensionModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.GraphicsLayerModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.PaddingModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ScrollModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ZIndexModifierOperation;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.ArrayList;
import java.util.HashMap;

public class LayoutComponent
extends Component {
    @Nullable
    protected WidthModifierOperation mWidthModifier = null;
    @Nullable
    protected HeightModifierOperation mHeightModifier = null;
    @Nullable
    protected ZIndexModifierOperation mZIndexModifier = null;
    @Nullable
    protected GraphicsLayerModifierOperation mGraphicsLayerModifier = null;
    protected float mPaddingLeft = 0.0f;
    protected float mPaddingRight = 0.0f;
    protected float mPaddingTop = 0.0f;
    protected float mPaddingBottom = 0.0f;
    float mScrollX = 0.0f;
    float mScrollY = 0.0f;
    @Nullable
    protected ScrollDelegate mHorizontalScrollDelegate = null;
    @Nullable
    protected ScrollDelegate mVerticalScrollDelegate = null;
    @NonNull
    protected ComponentModifiers mComponentModifiers = new ComponentModifiers();
    @NonNull
    protected ArrayList<Component> mChildrenComponents = new ArrayList();
    protected boolean mChildrenHaveZIndex = false;
    private CanvasOperations mDrawContentOperations;
    @Nullable
    protected LayoutComponentContent mContent = null;
    private static final boolean USE_IMAGE_TEMP_FIX = true;
    protected final HashMap<Integer, Object> mCachedAttributes = new HashMap();

    public LayoutComponent(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height) {
        super(parent, componentId, animationId, x, y, width, height);
    }

    public float getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public float getPaddingTop() {
        return this.mPaddingTop;
    }

    public float getPaddingRight() {
        return this.mPaddingRight;
    }

    public float getPaddingBottom() {
        return this.mPaddingBottom;
    }

    @Nullable
    public WidthModifierOperation getWidthModifier() {
        return this.mWidthModifier;
    }

    @Nullable
    public HeightModifierOperation getHeightModifier() {
        return this.mHeightModifier;
    }

    @Override
    public float getZIndex() {
        if (this.mZIndexModifier != null) {
            return this.mZIndexModifier.getValue();
        }
        return this.mZIndex;
    }

    public void setCanvasOperations(@Nullable CanvasOperations operations) {
        this.mDrawContentOperations = operations;
    }

    @Override
    public void inflate() {
        ArrayList<Operation> data = new ArrayList<Operation>();
        ArrayList<Operation> supportedOperations = new ArrayList<Operation>();
        for (Operation op : this.mList) {
            if (op instanceof LayoutComponentContent) {
                this.mContent = (LayoutComponentContent)op;
                this.mContent.mParent = this;
                this.mChildrenComponents.clear();
                LayoutComponentContent content = (LayoutComponentContent)op;
                content.getComponents(this.mChildrenComponents);
                if (this.mChildrenComponents.isEmpty() && !this.mContent.mList.isEmpty()) {
                    CanvasContent canvasContent = new CanvasContent(-1, 0.0f, 0.0f, 0.0f, 0.0f, this, -1);
                    for (Operation opc : this.mContent.mList) {
                        if (opc instanceof BitmapData) {
                            canvasContent.mList.add(opc);
                            int w = ((BitmapData)opc).getWidth();
                            int h = ((BitmapData)opc).getHeight();
                            canvasContent.setWidth(w);
                            canvasContent.setHeight(h);
                            continue;
                        }
                        if (opc instanceof MatrixTranslate || opc instanceof MatrixSave || opc instanceof MatrixRestore) continue;
                        canvasContent.mList.add(opc);
                    }
                    if (canvasContent.mList.isEmpty()) continue;
                    this.mContent.mList.clear();
                    this.mChildrenComponents.add(canvasContent);
                    canvasContent.inflate();
                    continue;
                }
                content.getData(data);
                continue;
            }
            if (op instanceof ModifierOperation) {
                if (op instanceof ComponentVisibilityOperation) {
                    ((ComponentVisibilityOperation)op).setParent(this);
                }
                if (op instanceof ScrollModifierOperation) {
                    ((ScrollModifierOperation)op).inflate(this);
                }
                this.mComponentModifiers.add((ModifierOperation)((Object)op));
                continue;
            }
            if (!(op instanceof ComponentData)) continue;
            supportedOperations.add(op);
            if (!(op instanceof TouchListener)) continue;
            ((TouchListener)((Object)op)).setComponent(this);
        }
        this.mList.clear();
        this.mList.addAll(data);
        this.mList.addAll(supportedOperations);
        this.mList.add(this.mComponentModifiers);
        for (Component c : this.mChildrenComponents) {
            c.mParent = this;
            this.mList.add(c);
            if (!(c instanceof LayoutComponent) || ((LayoutComponent)c).mZIndexModifier == null) continue;
            this.mChildrenHaveZIndex = true;
        }
        this.mX = 0.0f;
        this.mY = 0.0f;
        this.mPaddingLeft = 0.0f;
        this.mPaddingTop = 0.0f;
        this.mPaddingRight = 0.0f;
        this.mPaddingBottom = 0.0f;
        WidthInModifierOperation widthInConstraints = null;
        HeightInModifierOperation heightInConstraints = null;
        for (OperationInterface operationInterface : this.mComponentModifiers.getList()) {
            if (operationInterface instanceof PaddingModifierOperation) {
                float left = ((PaddingModifierOperation)operationInterface).getLeft();
                float right = ((PaddingModifierOperation)operationInterface).getRight();
                float top = ((PaddingModifierOperation)operationInterface).getTop();
                float bottom = ((PaddingModifierOperation)operationInterface).getBottom();
                this.mPaddingLeft += left;
                this.mPaddingTop += top;
                this.mPaddingRight += right;
                this.mPaddingBottom += bottom;
                continue;
            }
            if (operationInterface instanceof WidthModifierOperation && this.mWidthModifier == null) {
                this.mWidthModifier = (WidthModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof HeightModifierOperation && this.mHeightModifier == null) {
                this.mHeightModifier = (HeightModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof WidthInModifierOperation) {
                widthInConstraints = (WidthInModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof HeightInModifierOperation) {
                heightInConstraints = (HeightInModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof ZIndexModifierOperation) {
                this.mZIndexModifier = (ZIndexModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof GraphicsLayerModifierOperation) {
                this.mGraphicsLayerModifier = (GraphicsLayerModifierOperation)operationInterface;
                continue;
            }
            if (operationInterface instanceof AnimationSpec) {
                this.mAnimationSpec = (AnimationSpec)operationInterface;
                continue;
            }
            if (!(operationInterface instanceof ScrollDelegate)) continue;
            ScrollDelegate scrollDelegate = (ScrollDelegate)((Object)operationInterface);
            if (scrollDelegate.handlesHorizontalScroll()) {
                this.mHorizontalScrollDelegate = scrollDelegate;
            }
            if (!scrollDelegate.handlesVerticalScroll()) continue;
            this.mVerticalScrollDelegate = scrollDelegate;
        }
        if (this.mWidthModifier == null) {
            this.mWidthModifier = new WidthModifierOperation(DimensionModifierOperation.Type.WRAP);
        }
        if (this.mHeightModifier == null) {
            this.mHeightModifier = new HeightModifierOperation(DimensionModifierOperation.Type.WRAP);
        }
        if (widthInConstraints != null) {
            this.mWidthModifier.setWidthIn(widthInConstraints);
        }
        if (heightInConstraints != null) {
            this.mHeightModifier.setHeightIn(heightInConstraints);
        }
        if (this.mAnimationSpec != AnimationSpec.DEFAULT) {
            for (int i = 0; i < this.mChildrenComponents.size(); ++i) {
                Component component = this.mChildrenComponents.get(i);
                if (component == null || component.getAnimationSpec() != AnimationSpec.DEFAULT) continue;
                component.setAnimationSpec(this.mAnimationSpec);
            }
        }
        this.setWidth(this.computeModifierDefinedWidth(null));
        this.setHeight(this.computeModifierDefinedHeight(null));
    }

    @Override
    @NonNull
    public String toString() {
        return "UNKNOWN LAYOUT_COMPONENT";
    }

    @Override
    public void getLocationInWindow(@NonNull float[] value, boolean forSelf) {
        value[0] = value[0] + (this.mX + this.mPaddingLeft);
        value[1] = value[1] + (this.mY + this.mPaddingTop);
        if (this.mParent != null) {
            this.mParent.getLocationInWindow(value, false);
        }
    }

    @Override
    public float getScrollX() {
        if (this.mHorizontalScrollDelegate != null) {
            return this.mHorizontalScrollDelegate.getScrollX(this.mScrollX);
        }
        return this.mScrollX;
    }

    public void setScrollX(float value) {
        this.mScrollX = value;
    }

    @Override
    public float getScrollY() {
        if (this.mVerticalScrollDelegate != null) {
            return this.mVerticalScrollDelegate.getScrollY(this.mScrollY);
        }
        return this.mScrollY;
    }

    public void setScrollY(float value) {
        this.mScrollY = value;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        if (this.mDrawContentOperations != null) {
            context.save();
            context.translate(this.mX, this.mY);
            this.mDrawContentOperations.paint(context);
            context.restore();
            return;
        }
        super.paint(context);
    }

    public void drawContent(@NonNull PaintContext context) {
        context.save();
        context.translate(-this.mX, -this.mY);
        this.paintingComponent(context);
        context.restore();
    }

    @Override
    public void paintingComponent(@NonNull PaintContext context) {
        Component prev = context.getContext().mLastComponent;
        RemoteContext remoteContext = context.getContext();
        remoteContext.mLastComponent = this;
        context.save();
        context.translate(this.mX, this.mY);
        if (context.isVisualDebug()) {
            this.debugBox(this, context);
        }
        if (this.mGraphicsLayerModifier != null) {
            context.startGraphicsLayer((int)this.getWidth(), (int)this.getHeight());
            this.mCachedAttributes.clear();
            this.mGraphicsLayerModifier.fillInAttributes(this.mCachedAttributes);
            context.setGraphicsLayer(this.mCachedAttributes);
        }
        this.mComponentModifiers.paint(context);
        float tx = this.mPaddingLeft + this.getScrollX();
        float ty = this.mPaddingTop + this.getScrollY();
        context.translate(tx, ty);
        if (this.mChildrenHaveZIndex) {
            ArrayList<Component> sorted = new ArrayList<Component>(this.mChildrenComponents);
            sorted.sort((a, b) -> (int)(a.getZIndex() - b.getZIndex()));
            for (Component child : sorted) {
                if (child.isDirty() && child instanceof VariableSupport) {
                    child.updateVariables(context.getContext());
                    child.markNotDirty();
                }
                remoteContext.incrementOpCount();
                child.paint(context);
            }
        } else {
            for (Component child : this.mChildrenComponents) {
                if (child.isDirty() && child instanceof VariableSupport) {
                    child.updateVariables(context.getContext());
                    child.markNotDirty();
                }
                remoteContext.incrementOpCount();
                child.paint(context);
            }
        }
        if (this.mGraphicsLayerModifier != null) {
            context.endGraphicsLayer();
        }
        context.translate(-tx, -ty);
        context.restore();
        context.getContext().mLastComponent = prev;
    }

    public float computeModifierDefinedWidth(@Nullable RemoteContext context) {
        float s = 0.0f;
        float e = 0.0f;
        float w = 0.0f;
        for (OperationInterface operationInterface : this.mComponentModifiers.getList()) {
            if (context != null && operationInterface.isDirty() && operationInterface instanceof VariableSupport) {
                ((VariableSupport)((Object)operationInterface)).updateVariables(context);
                operationInterface.markNotDirty();
            }
            if (operationInterface instanceof WidthModifierOperation) {
                WidthModifierOperation o = (WidthModifierOperation)operationInterface;
                if (o.getType() != DimensionModifierOperation.Type.EXACT && o.getType() != DimensionModifierOperation.Type.EXACT_DP) break;
                w = o.getValue();
                break;
            }
            if (!(operationInterface instanceof PaddingModifierOperation)) continue;
            PaddingModifierOperation pop = (PaddingModifierOperation)operationInterface;
            s += pop.getLeft();
            e += pop.getRight();
        }
        return s + w + e;
    }

    public float computeModifierDefinedPaddingWidth(@NonNull float[] padding) {
        float s = 0.0f;
        float e = 0.0f;
        for (OperationInterface operationInterface : this.mComponentModifiers.getList()) {
            if (!(operationInterface instanceof PaddingModifierOperation)) continue;
            PaddingModifierOperation pop = (PaddingModifierOperation)operationInterface;
            s += pop.getLeft();
            e += pop.getRight();
        }
        padding[0] = s;
        padding[1] = e;
        return s + e;
    }

    public float computeModifierDefinedHeight(@Nullable RemoteContext context) {
        float t = 0.0f;
        float b = 0.0f;
        float h = 0.0f;
        for (OperationInterface operationInterface : this.mComponentModifiers.getList()) {
            if (context != null && operationInterface.isDirty() && operationInterface instanceof VariableSupport) {
                ((VariableSupport)((Object)operationInterface)).updateVariables(context);
                operationInterface.markNotDirty();
            }
            if (operationInterface instanceof HeightModifierOperation) {
                HeightModifierOperation o = (HeightModifierOperation)operationInterface;
                if (o.getType() != DimensionModifierOperation.Type.EXACT && o.getType() != DimensionModifierOperation.Type.EXACT_DP) break;
                h = o.getValue();
                break;
            }
            if (!(operationInterface instanceof PaddingModifierOperation)) continue;
            PaddingModifierOperation pop = (PaddingModifierOperation)operationInterface;
            t += pop.getTop();
            b += pop.getBottom();
        }
        return t + h + b;
    }

    public float computeModifierDefinedPaddingHeight(@NonNull float[] padding) {
        float t = 0.0f;
        float b = 0.0f;
        for (OperationInterface operationInterface : this.mComponentModifiers.getList()) {
            if (!(operationInterface instanceof PaddingModifierOperation)) continue;
            PaddingModifierOperation pop = (PaddingModifierOperation)operationInterface;
            t += pop.getTop();
            b += pop.getBottom();
        }
        padding[0] = t;
        padding[1] = b;
        return t + b;
    }

    @NonNull
    public ComponentModifiers getComponentModifiers() {
        return this.mComponentModifiers;
    }

    @NonNull
    public ArrayList<Component> getChildrenComponents() {
        return this.mChildrenComponents;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.addTags(SerializeTags.LAYOUT_COMPONENT).add("paddingLeft", Float.valueOf(this.mPaddingLeft)).add("paddingRight", Float.valueOf(this.mPaddingRight)).add("paddingTop", Float.valueOf(this.mPaddingTop)).add("paddingBottom", Float.valueOf(this.mPaddingBottom));
    }

    @Override
    @Nullable
    public <T> T selfOrModifier(Class<T> operationClass) {
        if (operationClass.isInstance(this)) {
            return operationClass.cast(this);
        }
        for (ModifierOperation op : this.mComponentModifiers.getList()) {
            if (!operationClass.isInstance(op)) continue;
            return operationClass.cast(op);
        }
        return null;
    }

    @Override
    public void registerVariables(RemoteContext context) {
        if (this.mDrawContentOperations != null) {
            this.mDrawContentOperations.registerListening(context);
        }
    }
}

