/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LoopOperation
extends PaintOperation
implements Container,
VariableSupport,
Serializable {
    private static final String CLASS_NAME = "LoopOperation";
    private static final int OP_CODE = 215;
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();
    int mIndexVariableId;
    float mUntil;
    float mFrom;
    float mStep;
    float mUntilOut;
    float mFromOut;
    float mStepOut;

    public LoopOperation(int count, int indexId) {
        this.mUntil = count;
        this.mIndexVariableId = indexId;
    }

    @Override
    public void registerListening(RemoteContext context) {
        if (Float.isNaN(this.mUntil)) {
            context.listensTo(Utils.idFromNan(this.mUntil), this);
        }
        if (Float.isNaN(this.mFrom)) {
            context.listensTo(Utils.idFromNan(this.mFrom), this);
        }
        if (Float.isNaN(this.mStep)) {
            context.listensTo(Utils.idFromNan(this.mStep), this);
        }
    }

    @Override
    public void updateVariables(RemoteContext context) {
        this.mUntilOut = Float.isNaN(this.mUntil) ? context.getFloat(Utils.idFromNan(this.mUntil)) : this.mUntil;
        this.mFromOut = Float.isNaN(this.mFrom) ? context.getFloat(Utils.idFromNan(this.mFrom)) : this.mFrom;
        this.mStepOut = Float.isNaN(this.mStep) ? context.getFloat(Utils.idFromNan(this.mStep)) : this.mStep;
        for (Operation op : this.mList) {
            if (!(op instanceof VariableSupport) || !op.isDirty()) continue;
            ((VariableSupport)((Object)op)).updateVariables(context);
        }
    }

    public LoopOperation(int indexId, float from, float step, float until) {
        this.mUntil = until;
        this.mFrom = from;
        this.mStep = step;
        this.mIndexVariableId = indexId;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        LoopOperation.apply(buffer, this.mIndexVariableId, this.mFrom, this.mStep, this.mUntil);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("LoopOperation\n");
        for (Operation operation : this.mList) {
            builder.append("  ");
            builder.append(operation);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        RemoteContext remoteContext = context.getContext();
        if (this.mIndexVariableId == 0) {
            for (float i = this.mFromOut; i < this.mUntilOut; i += this.mStepOut) {
                for (Operation op : this.mList) {
                    remoteContext.incrementOpCount();
                    op.apply(context.getContext());
                }
            }
        } else {
            for (float i = this.mFromOut; i < this.mUntilOut; i += this.mStepOut) {
                context.getContext().loadFloat(this.mIndexVariableId, i);
                for (Operation op : this.mList) {
                    if (op instanceof VariableSupport && op.isDirty()) {
                        ((VariableSupport)((Object)op)).updateVariables(context.getContext());
                    }
                    remoteContext.incrementOpCount();
                    op.apply(context.getContext());
                }
            }
        }
    }

    @NonNull
    public static String name() {
        return "Loop";
    }

    public static void apply(@NonNull WireBuffer buffer, int indexId, float from, float step, float until) {
        buffer.start(215);
        buffer.writeInt(indexId);
        buffer.writeFloat(from);
        buffer.writeFloat(step);
        buffer.writeFloat(until);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int indexId = buffer.readInt();
        float from = buffer.readFloat();
        float step = buffer.readFloat();
        float until = buffer.readFloat();
        operations.add(new LoopOperation(indexId, from, step, until));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Operations", 215, LoopOperation.name()).description("Loop. This operation execute a list of action in a loop").field(0, "id", "if not 0 write value").field(1, "from", "values starts at").field(1, "step", "value step").field(1, "until", "stops less than or equal");
    }

    public int estimateIterations() {
        if (!(Float.isNaN(this.mUntil) || Float.isNaN(this.mFrom) || Float.isNaN(this.mStep))) {
            return (int)(0.5f + (this.mUntil - this.mFrom) / this.mStep);
        }
        return 10;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("indexVariableId", this.mIndexVariableId).add("until", this.mUntil, this.mUntilOut).add("from", this.mFrom, this.mFromOut).add("step", this.mStep, this.mStepOut).add("list", this.mList);
    }
}

