/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Measurable;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ComponentModifiers;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class RootLayoutComponent
extends Component {
    private int mCurrentId = -1;
    private boolean mHasTouchListeners = false;

    public RootLayoutComponent(int componentId, float x, float y, float width, float height, @Nullable Component parent, int animationId) {
        super(parent, componentId, animationId, x, y, width, height);
    }

    public RootLayoutComponent(int componentId, float x, float y, float width, float height, @Nullable Component parent) {
        super(parent, componentId, -1, x, y, width, height);
    }

    @Override
    @NonNull
    public String toString() {
        return "ROOT " + this.mComponentId + " (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + Component.Visibility.toString(this.mVisibility);
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "ROOT [" + this.mComponentId + ":" + this.mAnimationId + "] = [" + this.mX + ", " + this.mY + ", " + this.mWidth + ", " + this.mHeight + "] " + Component.Visibility.toString(this.mVisibility));
    }

    public void setHasTouchListeners(boolean value) {
        this.mHasTouchListeners = value;
    }

    public void assignIds(int lastId) {
        this.mCurrentId = lastId;
        this.assignId(this);
    }

    private void assignId(@NonNull Component component) {
        if (component.mComponentId == -1) {
            --this.mCurrentId;
            component.mComponentId = this.mCurrentId;
        }
        for (Operation op : component.mList) {
            if (!(op instanceof Component)) continue;
            this.assignId((Component)op);
        }
    }

    public void layout(@NonNull RemoteContext context) {
        if (!this.mNeedsMeasure) {
            return;
        }
        context.mLastComponent = this;
        this.setWidth(context.mWidth);
        this.setHeight(context.mHeight);
        MeasurePass measurePass = new MeasurePass();
        for (Operation op : this.mList) {
            if (!(op instanceof Measurable)) continue;
            Measurable m = (Measurable)((Object)op);
            m.measure(context.getPaintContext(), 0.0f, this.mWidth, 0.0f, this.mHeight, measurePass);
            m.layout(context, measurePass);
        }
        this.mNeedsMeasure = false;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        this.mNeedsRepaint = false;
        RemoteContext remoteContext = context.getContext();
        remoteContext.mLastComponent = this;
        context.save();
        if (this.mParent == null) {
            context.clipRect(0.0f, 0.0f, this.mWidth, this.mHeight);
        }
        for (Operation op : this.mList) {
            if (!(op instanceof PaintOperation)) continue;
            ((PaintOperation)op).paint(context);
            remoteContext.incrementOpCount();
        }
        context.restore();
    }

    @NonNull
    public String displayHierarchy() {
        StringSerializer serializer = new StringSerializer();
        this.displayHierarchy(this, 0, serializer);
        return serializer.toString();
    }

    public void displayHierarchy(@NonNull Component component, int indent, @NonNull StringSerializer serializer) {
        component.serializeToString(indent, serializer);
        for (Operation c : component.mList) {
            if (c instanceof ComponentModifiers) {
                ((ComponentModifiers)c).serializeToString(indent + 1, serializer);
                continue;
            }
            if (c instanceof Component) {
                this.displayHierarchy((Component)c, indent + 1, serializer);
                continue;
            }
            if (!(c instanceof SerializableToString)) continue;
            ((SerializableToString)((Object)c)).serializeToString(indent + 1, serializer);
        }
    }

    @NonNull
    public static String name() {
        return "RootLayout";
    }

    public static int id() {
        return 200;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId) {
        buffer.start(200);
        buffer.writeInt(componentId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        operations.add(new RootLayoutComponent(componentId, 0.0f, 0.0f, 0.0f, 0.0f, null, -1));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", RootLayoutComponent.id(), RootLayoutComponent.name()).field(0, "COMPONENT_ID", "unique id for this component").description("Root element for a document. Other components / layout managers are children in the component tree starting fromthis Root component.");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        RootLayoutComponent.apply(buffer, this.mComponentId);
    }

    public boolean hasTouchListeners() {
        return this.mHasTouchListeners;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.addTags(SerializeTags.COMPONENT);
        serializer.addType("RootLayoutComponent");
    }
}

