/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.animation;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.animation.Particle;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import java.util.ArrayList;
import java.util.HashMap;

public class ParticleAnimation {
    @NonNull
    HashMap<Integer, ArrayList<Particle>> mAllParticles = new HashMap();
    @NonNull
    PaintBundle mPaint = new PaintBundle();

    public void animate(@NonNull PaintContext context, @NonNull Component component, @NonNull ComponentMeasure start, @NonNull ComponentMeasure end, float progress) {
        int i;
        ArrayList<Particle> particles = this.mAllParticles.get(component.getComponentId());
        if (particles == null) {
            particles = new ArrayList();
            for (i = 0; i < 20; ++i) {
                float x = (float)Math.random();
                float y = (float)Math.random();
                float radius = (float)Math.random();
                float r = 220.0f;
                float g = 220.0f;
                float b = 220.0f;
                particles.add(new Particle(x, y, radius, r, g, b));
            }
            this.mAllParticles.put(component.getComponentId(), particles);
        }
        context.save();
        context.savePaint();
        for (i = 0; i < particles.size(); ++i) {
            Particle particle = particles.get(i);
            this.mPaint.reset();
            this.mPaint.setColor(particle.r / 255.0f, particle.g / 255.0f, particle.b / 255.0f, 200.0f * (1.0f - progress) / 255.0f);
            context.applyPaint(this.mPaint);
            float dx = start.getX() + component.getWidth() * particle.x;
            float dy = start.getY() + component.getHeight() * particle.y + progress * 0.01f * component.getHeight();
            float dr = (component.getHeight() + 60.0f) * 0.15f * particle.radius + 30.0f * progress;
            context.drawCircle(dx, dy, dr);
        }
        context.restorePaint();
        context.restore();
    }
}

