/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class ClipRectModifierOperation
extends DecoratorModifierOperation {
    public static final String CLASS_NAME = "ClipRectModifierOperation";
    private static final int OP_CODE = 108;
    float mWidth;
    float mHeight;

    @Override
    public void paint(@NonNull PaintContext context) {
        context.clipRect(0.0f, 0.0f, this.mWidth, this.mHeight);
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "CLIP_RECT = [" + this.mWidth + ", " + this.mHeight + "]");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ClipRectModifierOperation.apply(buffer);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 108;
    }

    public static void apply(@NonNull WireBuffer buffer) {
        buffer.start(108);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        operations.add(new ClipRectModifierOperation());
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 108, CLASS_NAME).description("Draw the specified round-rect");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("width", Float.valueOf(this.mWidth)).add("height", Float.valueOf(this.mHeight));
    }
}

