/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.AnimatableValue;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.HashMap;
import java.util.List;

public class GraphicsLayerModifierOperation
extends DecoratorModifierOperation {
    private static final int OP_CODE = 224;
    public static final String CLASS_NAME = "GraphicsLayerModifierOperation";
    public static final int SCALE_X = 0;
    public static final int SCALE_Y = 1;
    public static final int ROTATION_X = 2;
    public static final int ROTATION_Y = 3;
    public static final int ROTATION_Z = 4;
    public static final int TRANSFORM_ORIGIN_X = 5;
    public static final int TRANSFORM_ORIGIN_Y = 6;
    public static final int TRANSLATION_X = 7;
    public static final int TRANSLATION_Y = 8;
    public static final int TRANSLATION_Z = 9;
    public static final int SHADOW_ELEVATION = 10;
    public static final int ALPHA = 11;
    public static final int CAMERA_DISTANCE = 12;
    public static final int COMPOSITING_STRATEGY = 13;
    public static final int SPOT_SHADOW_COLOR = 14;
    public static final int AMBIENT_SHADOW_COLOR = 15;
    public static final int HAS_BLUR = 16;
    public static final int BLUR_RADIUS_X = 17;
    public static final int BLUR_RADIUS_Y = 18;
    public static final int BLUR_TILE_MODE = 19;
    public static final int SHAPE = 20;
    public static final int SHAPE_RADIUS = 21;
    public static final int SHAPE_RECT = 0;
    public static final int SHAPE_ROUND_RECT = 1;
    public static final int SHAPE_CIRCLE = 2;
    public static final int TILE_MODE_CLAMP = 0;
    public static final int TILE_MODE_REPEATED = 1;
    public static final int TILE_MODE_MIRROR = 2;
    public static final int TILE_MODE_DECAL = 3;
    private static final short DATA_TYPE_INT = 0;
    private static final short DATA_TYPE_FLOAT = 1;
    AttributeValue[] mValues = new AttributeValue[]{new AttributeValue(0, "SCALE_X", 1.0f), new AttributeValue(1, "SCALE_Y", 1.0f), new AttributeValue(2, "ROTATION_X", 0.0f), new AttributeValue(3, "ROTATION_Y", 0.0f), new AttributeValue(4, "ROTATION_Z", 0.0f), new AttributeValue(5, "TRANSFORM_ORIGIN_X", 0.0f), new AttributeValue(6, "TRANSFORM_ORIGIN_Y", 0.0f), new AttributeValue(7, "TRANSLATION_X", 0.0f), new AttributeValue(8, "TRANSLATION_Y", 0.0f), new AttributeValue(9, "TRANSLATION_Z", 0.0f), new AttributeValue(10, "SHADOW_ELEVATION", 0.0f), new AttributeValue(11, "ALPHA", 1.0f), new AttributeValue(12, "CAMERA_DISTANCE", 8.0f), new AttributeValue(13, "COMPOSITING_STRATEGY", 0), new AttributeValue(14, "SPOT_SHADOW_COLOR", 0), new AttributeValue(15, "AMBIENT_SHADOW_COLOR", 0), new AttributeValue(16, "HAS_BLUR", 0), new AttributeValue(17, "BLUR_RADIUS_X", 0.0f), new AttributeValue(18, "BLUR_RADIUS_Y", 0.0f), new AttributeValue(19, "BLUR_TILE_MODE", 0), new AttributeValue(20, "SHAPE", -1), new AttributeValue(21, "SHAPE_RADIUS", 0.0f)};
    boolean mHasBlurEffect = false;
    static final int FLOAT_VALUE = 0;
    static final int INT_VALUE = 1;

    public void fillInAttributes(HashMap<Integer, Object> attributes) {
        for (int i = 0; i < this.mValues.length; ++i) {
            if (!this.mValues[i].needsToWrite()) continue;
            attributes.put(i, this.mValues[i].getObjectValue());
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        buffer.start(224);
        buffer.writeInt(this.mValues.length);
        for (int i = 0; i < this.mValues.length; ++i) {
            AttributeValue value = this.mValues[i];
            if (!value.needsToWrite()) continue;
            value.write(buffer);
        }
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, "GRAPHICS_LAYER = [" + this.mValues[0].getValue() + ", " + this.mValues[1].getValue() + "]");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        for (int i = 0; i < this.mValues.length; ++i) {
            AttributeValue v = this.mValues[i];
            v.evaluate(context);
        }
    }

    public String toString() {
        return "GraphicsLayerModifierOperation(" + this.mValues[0].getValue() + ", " + this.mValues[1].getValue() + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 224;
    }

    public static void apply(WireBuffer buffer, HashMap<Integer, Object> values) {
        buffer.start(224);
        int size = values.size();
        buffer.writeInt(size);
        for (Integer key : values.keySet()) {
            Object value = values.get(key);
            if (value instanceof Integer) {
                GraphicsLayerModifierOperation.writeIntAttribute(buffer, key, (Integer)value);
                continue;
            }
            if (!(value instanceof Float)) continue;
            GraphicsLayerModifierOperation.writeFloatAttribute(buffer, key, ((Float)value).floatValue());
        }
    }

    private static void writeIntAttribute(WireBuffer buffer, int type, int value) {
        int tag = type | 0;
        buffer.writeInt(tag);
        buffer.writeInt(value);
    }

    private static void writeFloatAttribute(WireBuffer buffer, int type, float value) {
        int tag = type | 0x400;
        buffer.writeInt(tag);
        buffer.writeFloat(value);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        int length = buffer.readInt();
        GraphicsLayerModifierOperation op = new GraphicsLayerModifierOperation();
        for (int i = 0; i < length; ++i) {
            op.readAttributeValue(buffer);
        }
        operations.add(op);
    }

    private void readAttributeValue(WireBuffer buffer) {
        int tag = buffer.readInt();
        int dataType = tag >> 10;
        short index = (short)(tag & 0x3F);
        if (index == 17 || index == 18) {
            this.mHasBlurEffect = true;
            this.mValues[16].setValue(1);
        }
        if (dataType == 1) {
            float value = buffer.readFloat();
            this.mValues[index].setValue(value);
        } else if (dataType == 0) {
            int value = buffer.readInt();
            this.mValues[index].setValue(value);
        }
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 224, CLASS_NAME).description("define the GraphicsLayer Modifier");
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("scaleX", Float.valueOf(this.mValues[0].getValue())).add("scaleY", Float.valueOf(this.mValues[1].getValue())).add("rotationX", Float.valueOf(this.mValues[2].getValue())).add("rotationY", Float.valueOf(this.mValues[3].getValue())).add("rotationZ", Float.valueOf(this.mValues[4].getValue())).add("shadowElevation", Float.valueOf(this.mValues[10].getValue())).add("transformOriginX", Float.valueOf(this.mValues[5].getValue())).add("transformOriginY", Float.valueOf(this.mValues[6].getValue())).add("translationX", Float.valueOf(this.mValues[7].getValue())).add("translationY", Float.valueOf(this.mValues[8].getValue())).add("translationZ", Float.valueOf(this.mValues[9].getValue())).add("alpha", Float.valueOf(this.mValues[11].getValue())).add("cameraDistance", Float.valueOf(this.mValues[12].getValue())).add("compositingStrategy", this.mValues[13].getIntValue()).add("spotShadowColorId", this.mValues[14].getIntValue()).add("ambientShadowColorId", this.mValues[15].getIntValue());
    }

    static class AttributeValue {
        String mName;
        int mId;
        @Nullable
        AnimatableValue mAnimatableValue;
        float mDefaultValue = 0.0f;
        int mIntValue = 0;
        int mIntDefaultValue = 0;
        int mType = 0;

        AttributeValue(int id2, String name, float defaultValue) {
            this.mId = id2;
            this.mName = name;
            this.mDefaultValue = defaultValue;
            this.mType = 0;
        }

        AttributeValue(int id2, String name, int defaultValue) {
            this.mId = id2;
            this.mName = name;
            this.mIntDefaultValue = defaultValue;
            this.mType = 1;
        }

        public float getValue() {
            if (this.mType == 0) {
                if (this.mAnimatableValue != null) {
                    return this.mAnimatableValue.getValue();
                }
                return this.mDefaultValue;
            }
            return this.mIntValue;
        }

        public int getIntValue() {
            if (this.mType == 0) {
                if (this.mAnimatableValue != null) {
                    return (int)this.mAnimatableValue.getValue();
                }
            } else if (this.mType == 1) {
                return this.mIntValue;
            }
            return 0;
        }

        public void evaluate(PaintContext context) {
            if (this.mAnimatableValue != null) {
                this.mAnimatableValue.evaluate(context);
            }
        }

        public boolean needsToWrite() {
            if (this.mType == 0) {
                if (this.mAnimatableValue != null) {
                    return this.mAnimatableValue.getValue() != this.mDefaultValue;
                }
                return false;
            }
            if (this.mType == 1) {
                return this.mIntValue != this.mIntDefaultValue;
            }
            return false;
        }

        public void write(WireBuffer buffer) {
            buffer.writeInt(this.mId);
            if (this.mType == 0) {
                buffer.writeFloat(this.getValue());
            } else if (this.mType == 1) {
                buffer.writeInt(this.getIntValue());
            }
        }

        public Object getObjectValue() {
            if (this.mType == 0) {
                return Float.valueOf(this.getValue());
            }
            return this.getIntValue();
        }

        public void setValue(float value) {
            this.mAnimatableValue = new AnimatableValue(value);
        }

        public void setValue(int value) {
            this.mIntValue = value;
        }
    }
}

