/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DimensionModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightInModifierOperation;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class HeightModifierOperation
extends DimensionModifierOperation {
    private static final int OP_CODE = 67;
    public static final String CLASS_NAME = "HeightModifierOperation";
    private HeightInModifierOperation mHeightIn = null;

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 67;
    }

    public static void apply(@NonNull WireBuffer buffer, int type, float value) {
        buffer.start(67);
        buffer.writeInt(type);
        buffer.writeFloat(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DimensionModifierOperation.Type type = DimensionModifierOperation.Type.fromInt(buffer.readInt());
        float value = buffer.readFloat();
        HeightModifierOperation op = new HeightModifierOperation(type, value);
        operations.add(op);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        HeightModifierOperation.apply(buffer, this.mType.ordinal(), this.mValue);
    }

    public HeightModifierOperation(@NonNull DimensionModifierOperation.Type type, float value) {
        super(type, value);
    }

    public HeightModifierOperation(@NonNull DimensionModifierOperation.Type type) {
        super(type);
    }

    public HeightModifierOperation(float value) {
        super(value);
    }

    @Override
    @NonNull
    public String toString() {
        return "Height(" + (Object)((Object)this.mType) + ", " + this.mValue + ")";
    }

    @Override
    @NonNull
    public String serializedName() {
        return "HEIGHT";
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 67, CLASS_NAME).description("define the animation").field(0, "type", "").field(1, "value", "");
    }

    public void setHeightIn(HeightInModifierOperation heightInConstraints) {
        this.mHeightIn = heightInConstraints;
    }

    public HeightInModifierOperation getHeightIn() {
        return this.mHeightIn;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("height", this.mValue, this.mOutValue).add("dimensionModifierType", this.mType);
    }
}

