/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DecoratorModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class OffsetModifierOperation
extends DecoratorModifierOperation {
    private static final int OP_CODE = 221;
    public static final String CLASS_NAME = "OffsetModifierOperation";
    float mX;
    float mY;

    public OffsetModifierOperation(float x, float y) {
        this.mX = x;
        this.mY = y;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public void setX(float x) {
        this.mX = x;
    }

    public void setY(float y) {
        this.mY = y;
    }

    @Override
    public void write(WireBuffer buffer) {
        OffsetModifierOperation.apply(buffer, this.mX, this.mY);
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, "OFFSET = [" + this.mX + ", " + this.mY + "]");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        float x = context.getContext().mRemoteComposeState.getFloat(Utils.idFromNan(this.mX));
        float y = context.getContext().mRemoteComposeState.getFloat(Utils.idFromNan(this.mY));
        float density = context.getContext().getDensity();
        context.translate(x *= density, y *= density);
    }

    public String toString() {
        return "OffsetModifierOperation(" + this.mX + ", " + this.mY + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 221;
    }

    public static void apply(WireBuffer buffer, float x, float y) {
        buffer.start(221);
        buffer.writeFloat(x);
        buffer.writeFloat(y);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        operations.add(new OffsetModifierOperation(x, y));
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 221, CLASS_NAME).description("define the Offset Modifier").field(1, "x", "").field(1, "y", "");
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("x", Float.valueOf(this.mX)).add("y", Float.valueOf(this.mY));
    }
}

