/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.paint;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintChanges;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PaintBundle
implements Serializable {
    @NonNull
    int[] mArray = new int[200];
    @Nullable
    int[] mOutArray = null;
    int mPos = 0;
    public static final int TEXT_SIZE = 1;
    public static final int COLOR = 4;
    public static final int STROKE_WIDTH = 5;
    public static final int STROKE_MITER = 6;
    public static final int STROKE_CAP = 7;
    public static final int STYLE = 8;
    public static final int SHADER = 9;
    public static final int IMAGE_FILTER_QUALITY = 10;
    public static final int GRADIENT = 11;
    public static final int ALPHA = 12;
    public static final int COLOR_FILTER = 13;
    public static final int ANTI_ALIAS = 14;
    public static final int STROKE_JOIN = 15;
    public static final int TYPEFACE = 16;
    public static final int FILTER_BITMAP = 17;
    public static final int BLEND_MODE = 18;
    public static final int COLOR_ID = 19;
    public static final int COLOR_FILTER_ID = 20;
    public static final int CLEAR_COLOR_FILTER = 21;
    public static final int BLEND_MODE_CLEAR = 0;
    public static final int BLEND_MODE_SRC = 1;
    public static final int BLEND_MODE_DST = 2;
    public static final int BLEND_MODE_SRC_OVER = 3;
    public static final int BLEND_MODE_DST_OVER = 4;
    public static final int BLEND_MODE_SRC_IN = 5;
    public static final int BLEND_MODE_DST_IN = 6;
    public static final int BLEND_MODE_SRC_OUT = 7;
    public static final int BLEND_MODE_DST_OUT = 8;
    public static final int BLEND_MODE_SRC_ATOP = 9;
    public static final int BLEND_MODE_DST_ATOP = 10;
    public static final int BLEND_MODE_XOR = 11;
    public static final int BLEND_MODE_PLUS = 12;
    public static final int BLEND_MODE_MODULATE = 13;
    public static final int BLEND_MODE_SCREEN = 14;
    public static final int BLEND_MODE_OVERLAY = 15;
    public static final int BLEND_MODE_DARKEN = 16;
    public static final int BLEND_MODE_LIGHTEN = 17;
    public static final int BLEND_MODE_COLOR_DODGE = 18;
    public static final int BLEND_MODE_COLOR_BURN = 19;
    public static final int BLEND_MODE_HARD_LIGHT = 20;
    public static final int BLEND_MODE_SOFT_LIGHT = 21;
    public static final int BLEND_MODE_DIFFERENCE = 22;
    public static final int BLEND_MODE_EXCLUSION = 23;
    public static final int BLEND_MODE_MULTIPLY = 24;
    public static final int BLEND_MODE_HUE = 25;
    public static final int BLEND_MODE_SATURATION = 26;
    public static final int BLEND_MODE_COLOR = 27;
    public static final int BLEND_MODE_LUMINOSITY = 28;
    public static final int BLEND_MODE_NULL = 29;
    public static final int PORTER_MODE_ADD = 30;
    public static final int FONT_NORMAL = 0;
    public static final int FONT_BOLD = 1;
    public static final int FONT_ITALIC = 2;
    public static final int FONT_BOLD_ITALIC = 3;
    public static final int FONT_TYPE_DEFAULT = 0;
    public static final int FONT_TYPE_SANS_SERIF = 1;
    public static final int FONT_TYPE_SERIF = 2;
    public static final int FONT_TYPE_MONOSPACE = 3;
    public static final int STYLE_FILL = 0;
    public static final int STYLE_STROKE = 1;
    public static final int STYLE_FILL_AND_STROKE = 2;
    public static final int LINEAR_GRADIENT = 0;
    public static final int RADIAL_GRADIENT = 1;
    public static final int SWEEP_GRADIENT = 2;
    private int mLastShaderSet = -1;
    private boolean mColorFilterSet = false;

    public void applyPaintChange(@NonNull PaintContext paintContext, @NonNull PaintChanges p) {
        int i = 0;
        int mask = 0;
        if (this.mOutArray == null) {
            this.mOutArray = this.mArray;
        }
        while (i < this.mPos) {
            int cmd = this.mOutArray[i++];
            mask |= 1 << cmd - 1;
            switch (cmd & 0xFFFF) {
                case 1: {
                    p.setTextSize(Float.intBitsToFloat(this.mOutArray[i++]));
                    break;
                }
                case 16: {
                    int style2 = cmd >> 16;
                    int weight = style2 & 0x3FF;
                    boolean italic = style2 >> 10 > 0;
                    int font_type = this.mOutArray[i++];
                    p.setTypeFace(font_type, weight, italic);
                    break;
                }
                case 4: 
                case 19: {
                    p.setColor(this.mOutArray[i++]);
                    break;
                }
                case 5: {
                    p.setStrokeWidth(Float.intBitsToFloat(this.mOutArray[i++]));
                    break;
                }
                case 6: {
                    p.setStrokeMiter(Float.intBitsToFloat(this.mOutArray[i++]));
                    break;
                }
                case 7: {
                    p.setStrokeCap(cmd >> 16);
                    break;
                }
                case 8: {
                    p.setStyle(cmd >> 16);
                    break;
                }
                case 9: {
                    p.setShader(this.mOutArray[i++]);
                    break;
                }
                case 15: {
                    p.setStrokeJoin(cmd >> 16);
                    break;
                }
                case 10: {
                    p.setImageFilterQuality(cmd >> 16);
                    break;
                }
                case 18: {
                    p.setBlendMode(cmd >> 16);
                    break;
                }
                case 17: {
                    p.setFilterBitmap(cmd >> 16 != 0);
                    break;
                }
                case 11: {
                    i = this.callSetGradient(cmd, this.mOutArray, i, p);
                    break;
                }
                case 13: 
                case 20: {
                    p.setColorFilter(this.mOutArray[i++], cmd >> 16);
                    break;
                }
                case 12: {
                    p.setAlpha(Float.intBitsToFloat(this.mOutArray[i++]));
                    break;
                }
                case 21: {
                    p.clear(8192L);
                }
            }
        }
    }

    @NonNull
    private static String colorInt(int color2) {
        String str = "000000000000" + Integer.toHexString(color2);
        return "0x" + str.substring(str.length() - 8);
    }

    @NonNull
    private static String colorInt(@NonNull int[] color2) {
        String str = "[";
        for (int i = 0; i < color2.length; ++i) {
            if (i > 0) {
                str = str + ", ";
            }
            str = str + PaintBundle.colorInt(color2[i]);
        }
        return str + "]";
    }

    private static String asFloatStr(int value) {
        float fValue = Float.intBitsToFloat(value);
        if (Float.isNaN(fValue)) {
            return "[" + Utils.idFromNan(fValue) + "]";
        }
        return Float.toString(fValue);
    }

    @NonNull
    public String toString() {
        StringBuilder ret = new StringBuilder("\n");
        int i = 0;
        while (i < this.mPos) {
            int cmd = this.mArray[i++];
            int type = cmd & 0xFFFF;
            switch (type) {
                case 1: {
                    ret.append("    TextSize(" + PaintBundle.asFloatStr(this.mArray[i++]));
                    break;
                }
                case 16: {
                    int style2 = cmd >> 16;
                    int weight = style2 & 0x3FF;
                    boolean italic = style2 >> 10 > 0;
                    int font_type = this.mArray[i++];
                    ret.append("    TypeFace(" + font_type + ", " + weight + ", " + italic);
                    break;
                }
                case 4: {
                    ret.append("    Color(" + PaintBundle.colorInt(this.mArray[i++]));
                    break;
                }
                case 19: {
                    ret.append("    ColorId([" + this.mArray[i++] + "]");
                    break;
                }
                case 5: {
                    ret.append("    StrokeWidth(" + PaintBundle.asFloatStr(this.mArray[i++]));
                    break;
                }
                case 6: {
                    ret.append("    StrokeMiter(" + PaintBundle.asFloatStr(this.mArray[i++]));
                    break;
                }
                case 7: {
                    ret.append("    StrokeCap(" + (cmd >> 16));
                    break;
                }
                case 8: {
                    ret.append("    Style(" + (cmd >> 16));
                    break;
                }
                case 13: {
                    ret.append("    ColorFilter(color=" + PaintBundle.colorInt(this.mArray[i++]) + ", mode=" + PaintBundle.blendModeString(cmd >> 16));
                    break;
                }
                case 20: {
                    ret.append("    ColorFilterID(color=[" + this.mArray[i++] + "], mode=" + PaintBundle.blendModeString(cmd >> 16));
                    break;
                }
                case 21: {
                    ret.append("    clearColorFilter");
                    break;
                }
                case 9: {
                    ret.append("    Shader(" + this.mArray[i++]);
                    break;
                }
                case 12: {
                    ret.append("    Alpha(" + PaintBundle.asFloatStr(this.mArray[i++]));
                    break;
                }
                case 10: {
                    ret.append("    ImageFilterQuality(" + (cmd >> 16));
                    break;
                }
                case 18: {
                    ret.append("    BlendMode(" + PaintBundle.blendModeString(cmd >> 16));
                    break;
                }
                case 17: {
                    ret.append("    FilterBitmap(" + (cmd >> 16 != 0));
                    break;
                }
                case 15: {
                    ret.append("    StrokeJoin(" + (cmd >> 16));
                    break;
                }
                case 14: {
                    ret.append("    AntiAlias(" + (cmd >> 16));
                    break;
                }
                case 11: {
                    i = this.callPrintGradient(cmd, this.mArray, i, ret);
                }
            }
            ret.append("),\n");
        }
        return ret.toString();
    }

    private void registerFloat(int iv, @NonNull RemoteContext context, @NonNull VariableSupport support) {
        float v = Float.intBitsToFloat(iv);
        if (Float.isNaN(v)) {
            context.listensTo(Utils.idFromNan(v), support);
        }
    }

    int callRegisterGradient(int cmd, int[] array2, int i, @NonNull RemoteContext context, @NonNull VariableSupport support) {
        int ret = i;
        int type = cmd >> 16;
        int control = array2[ret++];
        int len = 0xFF & control;
        int register = 0xFFFF & control >> 16;
        int tileMode = 0;
        switch (type) {
            case 0: {
                int j;
                if (len > 0) {
                    for (j = 0; j < len; ++j) {
                        int color2 = array2[ret++];
                        if ((register & 1 << j) == 0) continue;
                        context.listensTo(color2, support);
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    for (j = 0; j < len; ++j) {
                        this.registerFloat(array2[ret++], context, support);
                    }
                }
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                tileMode = array2[ret++];
                break;
            }
            case 1: {
                int j;
                if (len > 0) {
                    for (j = 0; j < len; ++j) {
                        int color3 = array2[ret++];
                        if ((register & 1 << j) == 0) continue;
                        context.listensTo(color3, support);
                    }
                }
                len = array2[ret++];
                for (j = 0; j < len; ++j) {
                    this.registerFloat(array2[ret++], context, support);
                }
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                tileMode = array2[ret++];
                break;
            }
            case 2: {
                int j;
                if (len > 0) {
                    for (j = 0; j < len; ++j) {
                        int color4 = array2[ret++];
                        if ((register & 1 << j) == 0) continue;
                        context.listensTo(color4, support);
                    }
                }
                len = array2[ret++];
                for (j = 0; j < len; ++j) {
                    this.registerFloat(array2[ret++], context, support);
                }
                this.registerFloat(array2[ret++], context, support);
                this.registerFloat(array2[ret++], context, support);
                break;
            }
            default: {
                System.out.println("error ");
            }
        }
        return ret;
    }

    int callPrintGradient(int cmd, int[] array2, int i, @NonNull StringBuilder p) {
        int ret = i;
        int type = cmd >> 16;
        int tileMode = 0;
        int len = array2[ret++];
        int[] colors = null;
        Object[] stops = null;
        switch (type) {
            case 0: {
                int j;
                p.append("    LinearGradient(\n");
                if (len > 0) {
                    colors = new int[len];
                    for (j = 0; j < colors.length; ++j) {
                        colors[j] = array2[ret++];
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    stops = new String[len];
                    for (j = 0; j < stops.length; ++j) {
                        stops[j] = PaintBundle.asFloatStr(array2[ret++]);
                    }
                }
                p.append("      colors = " + PaintBundle.colorInt(colors) + ",\n");
                p.append("      stops = " + Arrays.toString(stops) + ",\n");
                p.append("      start = ");
                p.append("[" + PaintBundle.asFloatStr(array2[ret++]));
                p.append(", " + PaintBundle.asFloatStr(array2[ret++]) + "],\n");
                p.append("      end = ");
                p.append("[" + PaintBundle.asFloatStr(array2[ret++]));
                p.append(", " + PaintBundle.asFloatStr(array2[ret++]) + "],\n");
                tileMode = array2[ret++];
                p.append("      tileMode = " + tileMode + "\n    ");
                break;
            }
            case 1: {
                int j;
                p.append("    RadialGradient(\n");
                if (len > 0) {
                    colors = new int[len];
                    for (j = 0; j < colors.length; ++j) {
                        colors[j] = array2[ret++];
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    stops = new String[len];
                    for (j = 0; j < stops.length; ++j) {
                        stops[j] = PaintBundle.asFloatStr(array2[ret++]);
                    }
                }
                p.append("      colors = " + PaintBundle.colorInt(colors) + ",\n");
                p.append("      stops = " + Arrays.toString(stops) + ",\n");
                p.append("      center = ");
                p.append("[" + PaintBundle.asFloatStr(array2[ret++]));
                p.append(", " + PaintBundle.asFloatStr(array2[ret++]) + "],\n");
                p.append("      radius =");
                p.append(" " + PaintBundle.asFloatStr(array2[ret++]) + ",\n");
                tileMode = array2[ret++];
                p.append("      tileMode = " + tileMode + "\n    ");
                break;
            }
            case 2: {
                int j;
                p.append("    SweepGradient(\n");
                if (len > 0) {
                    colors = new int[len];
                    for (j = 0; j < colors.length; ++j) {
                        colors[j] = array2[ret++];
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    stops = new String[len];
                    for (j = 0; j < stops.length; ++j) {
                        stops[j] = PaintBundle.asFloatStr(array2[ret++]);
                    }
                }
                p.append("      colors = " + PaintBundle.colorInt(colors) + ",\n");
                p.append("      stops = " + Arrays.toString(stops) + ",\n");
                p.append("      center = ");
                p.append("[" + PaintBundle.asFloatStr(array2[ret++]));
                p.append(", " + PaintBundle.asFloatStr(array2[ret++]) + "],\n    ");
                break;
            }
            default: {
                p.append("GRADIENT_??????!!!!");
            }
        }
        return ret;
    }

    int callSetGradient(int cmd, @NonNull int[] array2, int i, @NonNull PaintChanges p) {
        int ret = i;
        int gradientType = cmd >> 16;
        int len = 0xFF & array2[ret++];
        int[] colors = null;
        if (len > 0) {
            colors = new int[len];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = array2[ret++];
            }
        }
        len = array2[ret++];
        float[] stops = null;
        if (len > 0) {
            stops = new float[len];
            for (int j = 0; j < colors.length; ++j) {
                stops[j] = Float.intBitsToFloat(array2[ret++]);
            }
        }
        if (colors == null) {
            return ret;
        }
        int tileMode = 0;
        float centerX = 0.0f;
        float centerY = 0.0f;
        switch (gradientType) {
            case 0: {
                float startX = Float.intBitsToFloat(array2[ret++]);
                float startY = Float.intBitsToFloat(array2[ret++]);
                float endX = Float.intBitsToFloat(array2[ret++]);
                float endY = Float.intBitsToFloat(array2[ret++]);
                tileMode = array2[ret++];
                p.setLinearGradient(colors, stops, startX, startY, endX, endY, tileMode);
                break;
            }
            case 1: {
                centerX = Float.intBitsToFloat(array2[ret++]);
                centerY = Float.intBitsToFloat(array2[ret++]);
                float radius = Float.intBitsToFloat(array2[ret++]);
                tileMode = array2[ret++];
                p.setRadialGradient(colors, stops, centerX, centerY, radius, tileMode);
                break;
            }
            case 2: {
                centerX = Float.intBitsToFloat(array2[ret++]);
                centerY = Float.intBitsToFloat(array2[ret++]);
                p.setSweepGradient(colors, stops, centerX, centerY);
            }
        }
        return ret;
    }

    public void writeBundle(@NonNull WireBuffer buffer) {
        buffer.writeInt(this.mPos);
        for (int index = 0; index < this.mPos; ++index) {
            buffer.writeInt(this.mArray[index]);
        }
    }

    public void readBundle(@NonNull WireBuffer buffer) {
        int len = buffer.readInt();
        if (len <= 0 || len > 1024) {
            throw new RuntimeException("buffer corrupt paint len = " + len);
        }
        this.mArray = new int[len];
        for (int i = 0; i < this.mArray.length; ++i) {
            this.mArray[i] = buffer.readInt();
        }
        this.mPos = len;
    }

    public void setLinearGradient(@NonNull int[] colors, int idMask, @Nullable float[] stops, float startX, float startY, float endX, float endY, int tileMode) {
        int i;
        this.mArray[this.mPos++] = 11;
        int len = colors.length;
        this.mArray[this.mPos++] = idMask << 16 | len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = colors[i];
        }
        len = stops == null ? 0 : stops.length;
        this.mArray[this.mPos++] = len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = Float.floatToRawIntBits(stops[i]);
        }
        this.mArray[this.mPos++] = Float.floatToRawIntBits(startX);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(startY);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(endX);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(endY);
        this.mArray[this.mPos++] = tileMode;
    }

    public void setSweepGradient(@NonNull int[] colors, int idMask, @Nullable float[] stops, float centerX, float centerY) {
        int i;
        this.mArray[this.mPos++] = 131083;
        int len = colors == null ? 0 : colors.length;
        this.mArray[this.mPos++] = idMask << 16 | len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = colors[i];
        }
        len = stops == null ? 0 : stops.length;
        this.mArray[this.mPos++] = len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = Float.floatToRawIntBits(stops[i]);
        }
        this.mArray[this.mPos++] = Float.floatToRawIntBits(centerX);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(centerY);
    }

    public void setRadialGradient(@NonNull int[] colors, int idMask, @Nullable float[] stops, float centerX, float centerY, float radius, int tileMode) {
        int i;
        this.mArray[this.mPos++] = 65547;
        int len = colors == null ? 0 : colors.length;
        this.mArray[this.mPos++] = idMask << 16 | len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = colors[i];
        }
        len = stops == null ? 0 : stops.length;
        this.mArray[this.mPos++] = len;
        for (i = 0; i < len; ++i) {
            this.mArray[this.mPos++] = Float.floatToRawIntBits(stops[i]);
        }
        this.mArray[this.mPos++] = Float.floatToRawIntBits(centerX);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(centerY);
        this.mArray[this.mPos++] = Float.floatToRawIntBits(radius);
        this.mArray[this.mPos++] = tileMode;
    }

    public void setColorFilter(int color2, int mode) {
        this.mArray[this.mPos] = 0xD | mode << 16;
        ++this.mPos;
        this.mArray[this.mPos++] = color2;
    }

    public void setColorFilterId(int color2, int mode) {
        this.mArray[this.mPos] = 0x14 | mode << 16;
        ++this.mPos;
        this.mArray[this.mPos++] = color2;
        this.mColorFilterSet = true;
    }

    public void clearColorFilter() {
        this.mArray[this.mPos] = 21;
        ++this.mPos;
        this.mColorFilterSet = false;
    }

    public void setTextSize(float size) {
        this.mArray[this.mPos] = 1;
        ++this.mPos;
        this.mArray[this.mPos] = Float.floatToRawIntBits(size);
        ++this.mPos;
    }

    public void setTextStyle(int fontType, int weight, boolean italic) {
        int style2 = weight & 0x3FF | (italic ? 2048 : 0);
        this.mArray[this.mPos++] = 0x10 | style2 << 16;
        this.mArray[this.mPos++] = fontType;
    }

    public void setStrokeWidth(float width) {
        this.mArray[this.mPos] = 5;
        ++this.mPos;
        this.mArray[this.mPos] = Float.floatToRawIntBits(width);
        ++this.mPos;
    }

    public void setColor(int color2) {
        this.mArray[this.mPos] = 4;
        ++this.mPos;
        this.mArray[this.mPos] = color2;
        ++this.mPos;
    }

    public void setColor(int r, int g, int b, int a) {
        int color2 = a << 24 | r << 16 | g << 8 | b;
        this.setColor(color2);
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.toARGB(a, r, g, b));
    }

    public void setColorId(int color2) {
        this.mArray[this.mPos] = 19;
        ++this.mPos;
        this.mArray[this.mPos] = color2;
        ++this.mPos;
    }

    public void setStrokeCap(int cap) {
        this.mArray[this.mPos] = 7 | cap << 16;
        ++this.mPos;
    }

    public void setStyle(int style2) {
        this.mArray[this.mPos] = 8 | style2 << 16;
        ++this.mPos;
    }

    public void setShader(int shaderId) {
        this.mLastShaderSet = shaderId;
        this.mArray[this.mPos] = 9;
        ++this.mPos;
        this.mArray[this.mPos] = shaderId;
        ++this.mPos;
    }

    public void setAlpha(float alpha) {
        this.mArray[this.mPos] = 12;
        ++this.mPos;
        this.mArray[this.mPos] = Float.floatToRawIntBits(alpha);
        ++this.mPos;
    }

    public void setStrokeMiter(float miter) {
        this.mArray[this.mPos] = 6;
        ++this.mPos;
        this.mArray[this.mPos] = Float.floatToRawIntBits(miter);
        ++this.mPos;
    }

    public void setStrokeJoin(int join) {
        this.mArray[this.mPos] = 0xF | join << 16;
        ++this.mPos;
    }

    public void setFilterBitmap(boolean filter) {
        this.mArray[this.mPos] = 0x11 | (filter ? 65536 : 0);
        ++this.mPos;
    }

    public void setBlendMode(int blendmode) {
        this.mArray[this.mPos] = 0x12 | blendmode << 16;
        ++this.mPos;
    }

    public void setAntiAlias(boolean aa) {
        this.mArray[this.mPos] = 0xE | (aa ? 1 : 0) << 16;
        ++this.mPos;
    }

    public void clear(long mask) {
    }

    public void reset() {
        this.mPos = 0;
        if (this.mColorFilterSet) {
            this.clearColorFilter();
        }
        if (this.mLastShaderSet != -1 && this.mLastShaderSet != 0) {
            this.setShader(0);
        }
    }

    @NonNull
    public static String blendModeString(int mode) {
        switch (mode) {
            case 0: {
                return "CLEAR";
            }
            case 1: {
                return "SRC";
            }
            case 2: {
                return "DST";
            }
            case 3: {
                return "SRC_OVER";
            }
            case 4: {
                return "DST_OVER";
            }
            case 5: {
                return "SRC_IN";
            }
            case 6: {
                return "DST_IN";
            }
            case 7: {
                return "SRC_OUT";
            }
            case 8: {
                return "DST_OUT";
            }
            case 9: {
                return "SRC_ATOP";
            }
            case 10: {
                return "DST_ATOP";
            }
            case 11: {
                return "XOR";
            }
            case 12: {
                return "PLUS";
            }
            case 13: {
                return "MODULATE";
            }
            case 14: {
                return "SCREEN";
            }
            case 15: {
                return "OVERLAY";
            }
            case 16: {
                return "DARKEN";
            }
            case 17: {
                return "LIGHTEN";
            }
            case 18: {
                return "COLOR_DODGE";
            }
            case 19: {
                return "COLOR_BURN";
            }
            case 20: {
                return "HARD_LIGHT";
            }
            case 21: {
                return "SOFT_LIGHT";
            }
            case 22: {
                return "DIFFERENCE";
            }
            case 23: {
                return "EXCLUSION";
            }
            case 24: {
                return "MULTIPLY";
            }
            case 25: {
                return "HUE";
            }
            case 26: {
                return "SATURATION";
            }
            case 27: {
                return "COLOR";
            }
            case 28: {
                return "LUMINOSITY";
            }
            case 29: {
                return "null";
            }
            case 30: {
                return "ADD";
            }
        }
        return "null";
    }

    public void registerVars(@NonNull RemoteContext context, @NonNull VariableSupport support) {
        int i = 0;
        while (i < this.mPos) {
            int cmd = this.mArray[i++];
            int type = cmd & 0xFFFF;
            switch (type) {
                case 1: 
                case 5: 
                case 6: 
                case 12: {
                    float v = Float.intBitsToFloat(this.mArray[i++]);
                    if (!Float.isNaN(v)) break;
                    context.listensTo(Utils.idFromNan(v), support);
                    break;
                }
                case 19: 
                case 20: {
                    context.listensTo(this.mArray[i++], support);
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 16: {
                    ++i;
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    break;
                }
                case 11: {
                    i = this.callRegisterGradient(cmd, this.mArray, i, context, support);
                }
            }
        }
    }

    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mOutArray == null) {
            this.mOutArray = Arrays.copyOf(this.mArray, this.mArray.length);
        } else {
            System.arraycopy(this.mArray, 0, this.mOutArray, 0, this.mArray.length);
        }
        int i = 0;
        while (i < this.mPos) {
            int cmd = this.mArray[i++];
            int type = cmd & 0xFFFF;
            switch (type) {
                case 1: 
                case 5: 
                case 6: 
                case 12: {
                    this.mOutArray[i] = this.fixFloatVar(this.mArray[i], context);
                    ++i;
                    break;
                }
                case 19: 
                case 20: {
                    this.mOutArray[i] = this.fixColor(this.mArray[i], context);
                    ++i;
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 16: {
                    ++i;
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    break;
                }
                case 11: {
                    i = this.updateFloatsInGradient(cmd, this.mOutArray, this.mArray, i, context);
                }
            }
        }
    }

    private int fixFloatVar(int val, @NonNull RemoteContext context) {
        float v = Float.intBitsToFloat(val);
        if (Float.isNaN(v)) {
            int id2 = Utils.idFromNan(v);
            return Float.floatToRawIntBits(context.getFloat(id2));
        }
        return val;
    }

    private int fixColor(int colorId, @NonNull RemoteContext context) {
        int n = context.getColor(colorId);
        return n;
    }

    int updateFloatsInGradient(int cmd, int[] out, int[] array2, int i, @NonNull RemoteContext context) {
        int ret = i;
        int type = cmd >> 16;
        int control = array2[ret++];
        int len = 0xFF & control;
        int register = 0xFFFF & control >> 16;
        switch (type) {
            case 0: {
                int j;
                if (len > 0) {
                    for (j = 0; j < len; ++j) {
                        int color2 = array2[ret];
                        if ((register & 1 << j) != 0) {
                            out[ret] = this.fixColor(color2, context);
                        }
                        ++ret;
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    for (j = 0; j < len; ++j) {
                        out[ret] = this.fixFloatVar(array2[ret], context);
                        ++ret;
                    }
                }
                out[ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                ++ret;
                ++ret;
                break;
            }
            case 1: {
                int j;
                if (len > 0) {
                    for (j = 0; j < len; ++j) {
                        int color3 = array2[ret];
                        if ((register & 1 << j) != 0) {
                            out[ret] = this.fixColor(color3, context);
                        }
                        ++ret;
                    }
                }
                if ((len = array2[ret++]) > 0) {
                    for (j = 0; j < len; ++j) {
                        out[ret] = this.fixFloatVar(array2[ret], context);
                        ++ret;
                    }
                }
                out[ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                ++ret;
                ++ret;
                break;
            }
            case 2: {
                if (len > 0) {
                    for (int j = 0; j < len; ++j) {
                        int color4 = array2[ret];
                        if ((register & 1 << j) != 0) {
                            out[ret] = this.fixColor(color4, context);
                        }
                        ++ret;
                    }
                }
                len = array2[ret++];
                float[] stops = null;
                if (len > 0) {
                    stops = new float[len];
                    for (int j = 0; j < stops.length; ++j) {
                        out[ret] = this.fixFloatVar(array2[ret], context);
                        ++ret;
                    }
                }
                out[ret] = this.fixFloatVar(array2[ret], context);
                out[++ret] = this.fixFloatVar(array2[ret], context);
                ++ret;
                break;
            }
            default: {
                System.err.println("gradient type unknown");
            }
        }
        return ret;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType("PaintBundle");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < this.mPos) {
            int cmd = this.mArray[i++];
            int type = cmd & 0xFFFF;
            switch (type) {
                case 1: {
                    list.add(MapSerializer.orderedOf("type", "TextSize", "size", PaintBundle.getVariable(this.mArray[i++])));
                    break;
                }
                case 16: {
                    int style2 = cmd >> 16;
                    float weight = style2 & 0x3FF;
                    boolean italic = style2 >> 10 > 0;
                    int fontFamily = this.mArray[i++];
                    list.add(MapSerializer.orderedOf("type", "FontFamily", "fontFamily", fontFamily));
                    list.add(MapSerializer.orderedOf("type", "FontWeight", "weight", Float.valueOf(weight)));
                    list.add(MapSerializer.orderedOf("type", "TypeFace", "italic", italic));
                    break;
                }
                case 4: {
                    list.add(MapSerializer.orderedOf("type", "Color", "color", PaintBundle.colorInt(this.mArray[i++])));
                    break;
                }
                case 19: {
                    list.add(MapSerializer.orderedOf("type", "ColorId", "id", this.mArray[i++]));
                    break;
                }
                case 5: {
                    list.add(MapSerializer.orderedOf("type", "StrokeWidth", "width", PaintBundle.getVariable(this.mArray[i++])));
                    break;
                }
                case 6: {
                    list.add(MapSerializer.orderedOf("type", "StrokeMiter", "miter", PaintBundle.getVariable(this.mArray[i++])));
                    break;
                }
                case 7: {
                    list.add(MapSerializer.orderedOf("type", "StrokeCap", "cap", cmd >> 16));
                    break;
                }
                case 8: {
                    list.add(MapSerializer.orderedOf("type", "Style", "style", cmd >> 16));
                    break;
                }
                case 13: {
                    list.add(MapSerializer.orderedOf("type", "ColorFilter", "color", PaintBundle.colorInt(this.mArray[i++]), "mode", PaintBundle.blendModeString(cmd >> 16)));
                    break;
                }
                case 20: {
                    list.add(MapSerializer.orderedOf("type", "ColorFilterID", "id", this.mArray[i++], "mode", PaintBundle.blendModeString(cmd >> 16)));
                    break;
                }
                case 21: {
                    list.add(MapSerializer.orderedOf("type", "ClearColorFilter"));
                    break;
                }
                case 9: {
                    list.add(MapSerializer.orderedOf("type", "Shader", "id", this.mArray[i++]));
                    break;
                }
                case 12: {
                    list.add(MapSerializer.orderedOf("type", "Alpha", "alpha", PaintBundle.getVariable(this.mArray[i++])));
                    break;
                }
                case 10: {
                    list.add(MapSerializer.orderedOf("type", "ImageFilterQuality", "quality", cmd >> 16));
                    break;
                }
                case 18: {
                    list.add(MapSerializer.orderedOf("type", "BlendMode", "mode", PaintBundle.blendModeString(cmd >> 16)));
                    break;
                }
                case 17: {
                    list.add(MapSerializer.orderedOf("type", "FilterBitmap", "enabled", cmd >> 16 != 0));
                    break;
                }
                case 15: {
                    list.add(MapSerializer.orderedOf("type", "StrokeJoin", "strokeJoin", cmd >> 16));
                    break;
                }
                case 14: {
                    list.add(MapSerializer.orderedOf("type", "AntiAlias", "enabled", cmd >> 16 != 0));
                    break;
                }
                case 11: {
                    i = PaintBundle.serializeGradient(cmd, this.mArray, i, list);
                }
            }
        }
        serializer.add("operations", list);
    }

    private static Map<String, Object> getVariable(int value) {
        float fValue = Float.intBitsToFloat(value);
        if (Float.isNaN(fValue)) {
            return MapSerializer.orderedOf("type", "Variable", "id", Utils.idFromNan(fValue));
        }
        return MapSerializer.orderedOf("type", "Value", "value", Float.valueOf(fValue));
    }

    private static int serializeGradient(int cmd, int[] array2, int i, List<Map<String, Object>> list) {
        int ret = i;
        int gradientType = cmd >> 16;
        int len = 0xFF & array2[ret++];
        String[] colors = null;
        if (len > 0) {
            colors = new String[len];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = PaintBundle.colorInt(array2[ret++]);
            }
        }
        len = array2[ret++];
        float[] stops = null;
        if (len > 0) {
            stops = new float[len];
            for (int j = 0; j < colors.length; ++j) {
                stops[j] = Float.intBitsToFloat(array2[ret++]);
            }
        }
        if (colors == null) {
            return ret;
        }
        switch (gradientType) {
            case 0: {
                int startX = array2[ret++];
                int startY = array2[ret++];
                int endX = array2[ret++];
                int endY = array2[ret++];
                int tileMode = array2[ret++];
                list.add(MapSerializer.orderedOf("type", "LinearGradient", "colors", colors, "stops", stops == null ? List.of() : (Object)stops, "startX", PaintBundle.getVariable(startX), "startY", PaintBundle.getVariable(startY), "endX", PaintBundle.getVariable(endX), "endY", PaintBundle.getVariable(endY), "tileMode", tileMode));
                break;
            }
            case 1: {
                int centerX = array2[ret++];
                int centerY = array2[ret++];
                int radius = array2[ret++];
                int tileMode = array2[ret++];
                list.add(MapSerializer.orderedOf("type", "RadialGradient", "colors", colors, "stops", stops == null ? List.of() : (Object)stops, "centerX", PaintBundle.getVariable(centerX), "centerY", PaintBundle.getVariable(centerY), "radius", PaintBundle.getVariable(radius), "tileMode", tileMode));
                break;
            }
            case 2: {
                int centerX = array2[ret++];
                int centerY = array2[ret++];
                list.add(MapSerializer.orderedOf("type", "SweepGradient", "colors", colors, "stops", stops == null ? List.of() : (Object)stops, "centerX", PaintBundle.getVariable(centerX), "centerY", PaintBundle.getVariable(centerY)));
            }
        }
        return ret;
    }
}

