/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import java.util.Arrays;

public class IntFloatMap {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int NOT_PRESENT = Integer.MIN_VALUE;
    private int[] mKeys = new int[16];
    private float[] mValues;
    int mSize;

    public IntFloatMap() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        this.mValues = new float[16];
    }

    public void clear() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        Arrays.fill(this.mValues, Float.NaN);
        this.mSize = 0;
    }

    public boolean contains(int key) {
        return this.findKey(key) != -1;
    }

    public float put(int key, float value) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Key cannot be NOT_PRESENT");
        }
        if ((float)this.mSize > (float)this.mKeys.length * 0.75f) {
            this.resize();
        }
        return this.insert(key, value);
    }

    public float get(int key) {
        int index = this.findKey(key);
        if (index == -1) {
            return 0.0f;
        }
        return this.mValues[index];
    }

    public int size() {
        return this.mSize;
    }

    private float insert(int key, float value) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE && this.mKeys[index] != key) {
            index = (index + 1) % this.mKeys.length;
        }
        float oldValue = 0.0f;
        if (this.mKeys[index] == Integer.MIN_VALUE) {
            ++this.mSize;
        } else {
            oldValue = this.mValues[index];
        }
        this.mKeys[index] = key;
        this.mValues[index] = value;
        return oldValue;
    }

    private int findKey(int key) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE) {
            if (this.mKeys[index] == key) {
                return index;
            }
            index = (index + 1) % this.mKeys.length;
        }
        return -1;
    }

    private int hash(int key) {
        return key;
    }

    private void resize() {
        int i;
        int[] oldKeys = this.mKeys;
        float[] oldValues = this.mValues;
        this.mKeys = new int[oldKeys.length * 2];
        for (i = 0; i < this.mKeys.length; ++i) {
            this.mKeys[i] = Integer.MIN_VALUE;
        }
        this.mValues = new float[oldKeys.length * 2];
        this.mSize = 0;
        for (i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == Integer.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }
}

