/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import com.android.internal.widget.remotecompose.core.operations.Utils;

public class NanMap {
    public static final int MOVE = 0x300000;
    public static final int LINE = 0x300001;
    public static final int QUADRATIC = 0x300002;
    public static final int CONIC = 0x300003;
    public static final int CUBIC = 0x300004;
    public static final int CLOSE = 0x300005;
    public static final int DONE = 0x300006;
    public static final float MOVE_NAN = Utils.asNan(0x300000);
    public static final float LINE_NAN = Utils.asNan(0x300001);
    public static final float QUADRATIC_NAN = Utils.asNan(0x300002);
    public static final float CONIC_NAN = Utils.asNan(0x300003);
    public static final float CUBIC_NAN = Utils.asNan(0x300004);
    public static final float CLOSE_NAN = Utils.asNan(0x300005);
    public static final float DONE_NAN = Utils.asNan(0x300006);
    public static final int START_VAR = 1048618;
    public static final int START_ARRAY = 0x20002A;
    public static final int TYPE_SYSTEM = 0;
    public static final int TYPE_VARIABLE = 1;
    public static final int TYPE_ARRAY = 2;
    public static final int TYPE_OPERATION = 3;
    public static final int ID_REGION_MASK = 0x700000;
    public static final int ID_REGION_ARRAY = 0x200000;

    public static boolean isSystemVariable(float value) {
        return NanMap.fromNaN(value) >> 20 == 0;
    }

    public static boolean isNormalVariable(float value) {
        return NanMap.fromNaN(value) >> 20 == 1;
    }

    public static boolean isDataVariable(float value) {
        return NanMap.fromNaN(value) >> 20 == 2;
    }

    public static boolean isOperationVariable(float value) {
        return NanMap.fromNaN(value) >> 20 == 3;
    }

    public static int fromNaN(float v) {
        int b = Float.floatToRawIntBits(v);
        return b & 0x7FFFFF;
    }

    public static float asNan(int v) {
        return Float.intBitsToFloat(v | 0xFF800000);
    }
}

