/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.easing;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.Easing;

class CubicEasing
extends Easing {
    float mX1 = 0.0f;
    float mY1 = 0.0f;
    float mX2 = 0.0f;
    float mY2 = 0.0f;
    private static final float[] STANDARD = new float[]{0.4f, 0.0f, 0.2f, 1.0f};
    private static final float[] ACCELERATE = new float[]{0.4f, 0.05f, 0.8f, 0.7f};
    private static final float[] DECELERATE = new float[]{0.0f, 0.0f, 0.2f, 0.95f};
    private static final float[] LINEAR = new float[]{1.0f, 1.0f, 0.0f, 0.0f};
    private static final float[] ANTICIPATE = new float[]{0.36f, 0.0f, 0.66f, -0.56f};
    private static final float[] OVERSHOOT = new float[]{0.34f, 1.56f, 0.64f, 1.0f};
    private static final float ERROR = 0.01f;
    private static final float D_ERROR = 1.0E-4f;

    CubicEasing(int type) {
        this.mType = type;
        this.config(type);
    }

    CubicEasing(float x1, float y1, float x2, float y2) {
        this.setup(x1, y1, x2, y2);
    }

    public void config(int type) {
        switch (type) {
            case 1: {
                this.setup(STANDARD);
                break;
            }
            case 2: {
                this.setup(ACCELERATE);
                break;
            }
            case 3: {
                this.setup(DECELERATE);
                break;
            }
            case 4: {
                this.setup(LINEAR);
                break;
            }
            case 5: {
                this.setup(ANTICIPATE);
                break;
            }
            case 6: {
                this.setup(OVERSHOOT);
            }
        }
        this.mType = type;
    }

    void setup(@NonNull float[] values) {
        this.setup(values[0], values[1], values[2], values[3]);
    }

    void setup(float x1, float y1, float x2, float y2) {
        this.mX1 = x1;
        this.mY1 = y1;
        this.mX2 = x2;
        this.mY2 = y2;
    }

    private float getX(float t) {
        float t1 = 1.0f - t;
        float f1 = 3.0f * t1 * t1 * t;
        float f2 = 3.0f * t1 * t * t;
        float f3 = t * t * t;
        return this.mX1 * f1 + this.mX2 * f2 + f3;
    }

    private float getY(float t) {
        float t1 = 1.0f - t;
        float f1 = 3.0f * t1 * t1 * t;
        float f2 = 3.0f * t1 * t * t;
        float f3 = t * t * t;
        return this.mY1 * f1 + this.mY2 * f2 + f3;
    }

    @Override
    public float getDiff(float x) {
        float t = 0.5f;
        float range = 0.5f;
        while (range > 1.0E-4f) {
            float tx = this.getX(t);
            range *= 0.5f;
            if (tx < x) {
                t += range;
                continue;
            }
            t -= range;
        }
        float x1 = this.getX(t - range);
        float x2 = this.getX(t + range);
        float y1 = this.getY(t - range);
        float y2 = this.getY(t + range);
        return (y2 - y1) / (x2 - x1);
    }

    @Override
    public float get(float x) {
        if (x <= 0.0f) {
            return 0.0f;
        }
        if (x >= 1.0f) {
            return 1.0f;
        }
        float t = 0.5f;
        float range = 0.5f;
        while (range > 0.01f) {
            float tx = this.getX(t);
            range *= 0.5f;
            if (tx < x) {
                t += range;
                continue;
            }
            t -= range;
        }
        float x1 = this.getX(t - range);
        float x2 = this.getX(t + range);
        float y1 = this.getY(t - range);
        float y2 = this.getY(t + range);
        return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
    }
}

