/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.touch;

public class VelocityEasing {
    private float mStartPos = 0.0f;
    private float mStartV = 0.0f;
    private float mEndPos = 0.0f;
    private float mDuration = 0.0f;
    private Stage[] mStage = new Stage[]{new Stage(this, 1), new Stage(this, 2), new Stage(this, 3)};
    private int mNumberOfStages = 0;
    private Easing mEasing;
    private double mEasingAdapterDistance = 0.0;
    private double mEasingAdapterA = 0.0;
    private double mEasingAdapterB = 0.0;
    private boolean mOneDimension = true;
    private float mTotalEasingDuration = 0.0f;

    public float getDuration() {
        if (this.mEasing != null) {
            return this.mTotalEasingDuration;
        }
        return this.mDuration;
    }

    public float getV(float t) {
        if (this.mEasing == null) {
            for (int i = 0; i < this.mNumberOfStages; ++i) {
                if (!(this.mStage[i].mEndTime > t)) continue;
                return this.mStage[i].getVel(t);
            }
            return 0.0f;
        }
        int lastStages = this.mNumberOfStages - 1;
        for (int i = 0; i < lastStages; ++i) {
            if (!(this.mStage[i].mEndTime > t)) continue;
            return this.mStage[i].getVel(t);
        }
        return (float)this.getEasingDiff(t - this.mStage[lastStages].mStartTime);
    }

    public float getPos(float t) {
        if (this.mEasing == null) {
            for (int i = 0; i < this.mNumberOfStages; ++i) {
                if (!(this.mStage[i].mEndTime > t)) continue;
                return this.mStage[i].getPos(t);
            }
            return this.mEndPos;
        }
        int lastStages = this.mNumberOfStages - 1;
        for (int i = 0; i < lastStages; ++i) {
            if (!(this.mStage[i].mEndTime > t)) continue;
            return this.mStage[i].getPos(t);
        }
        float ret = (float)this.getEasing(t - this.mStage[lastStages].mStartTime);
        return ret += this.mStage[lastStages].mStartPos;
    }

    public String toString() {
        String s = " ";
        for (int i = 0; i < this.mNumberOfStages; ++i) {
            Stage stage = this.mStage[i];
            s = s + " $i $stage";
        }
        return s;
    }

    public void config(float currentPos, float destination, float currentVelocity, float maxTime, float maxAcceleration, float maxVelocity, Easing easing) {
        float pos = currentPos;
        float velocity = currentVelocity;
        if (pos == destination) {
            pos += 1.0f;
        }
        this.mStartPos = pos;
        this.mEndPos = destination;
        if (easing != null) {
            this.mEasing = easing.clone();
        }
        float dir = Math.signum(destination - pos);
        float maxV = maxVelocity * dir;
        float maxA = maxAcceleration * dir;
        if ((double)velocity == 0.0) {
            velocity = 1.0E-4f * dir;
        }
        this.mStartV = velocity;
        if (!(this.rampDown(pos, destination, velocity, maxTime) || this.mOneDimension && this.cruseThenRampDown(pos, destination, velocity, maxTime, maxA, maxV) || this.rampUpRampDown(pos, destination, velocity, maxA, maxV, maxTime))) {
            this.rampUpCruseRampDown(pos, destination, velocity, maxA, maxV, maxTime);
        }
        if (this.mOneDimension) {
            this.configureEasingAdapter();
        }
    }

    private boolean rampDown(float currentPos, float destination, float currentVelocity, float maxTime) {
        float timeToDestination = 2.0f * ((destination - currentPos) / currentVelocity);
        if (timeToDestination > 0.0f && timeToDestination <= maxTime) {
            this.mNumberOfStages = 1;
            this.mStage[0].setUp(currentVelocity, currentPos, 0.0f, 0.0f, destination, timeToDestination);
            this.mDuration = timeToDestination;
            return true;
        }
        return false;
    }

    private boolean cruseThenRampDown(float currentPos, float destination, float currentVelocity, float maxTime, float maxA, float maxV) {
        float timeToBreak = currentVelocity / maxA;
        float brakeDist = currentVelocity * timeToBreak / 2.0f;
        float cruseDist = destination - currentPos - brakeDist;
        float cruseTime = cruseDist / currentVelocity;
        float totalTime = cruseTime + timeToBreak;
        if (totalTime > 0.0f && totalTime < maxTime) {
            this.mNumberOfStages = 2;
            this.mStage[0].setUp(currentVelocity, currentPos, 0.0f, currentVelocity, cruseDist, cruseTime);
            this.mStage[1].setUp(currentVelocity, currentPos + cruseDist, cruseTime, 0.0f, destination, cruseTime + timeToBreak);
            this.mDuration = cruseTime + timeToBreak;
            return true;
        }
        return false;
    }

    private boolean rampUpRampDown(float currentPos, float destination, float currentVelocity, float maxA, float maxVelocity, float maxTime) {
        float peak_v = Math.signum(maxA) * (float)Math.sqrt(maxA * (destination - currentPos) + currentVelocity * currentVelocity / 2.0f);
        if (maxVelocity / peak_v > 1.0f) {
            float t1 = (peak_v - currentVelocity) / maxA;
            float d1 = (peak_v + currentVelocity) * t1 / 2.0f + currentPos;
            float t2 = peak_v / maxA;
            this.mNumberOfStages = 2;
            this.mStage[0].setUp(currentVelocity, currentPos, 0.0f, peak_v, d1, t1);
            this.mStage[1].setUp(peak_v, d1, t1, 0.0f, destination, t2 + t1);
            this.mDuration = t2 + t1;
            if (this.mDuration > maxTime) {
                return false;
            }
            if (this.mDuration < maxTime / 2.0f) {
                t2 = t1 = this.mDuration / 2.0f;
                peak_v = (2.0f * (destination - currentPos) / t1 - currentVelocity) / 2.0f;
                d1 = (peak_v + currentVelocity) * t1 / 2.0f + currentPos;
                this.mNumberOfStages = 2;
                this.mStage[0].setUp(currentVelocity, currentPos, 0.0f, peak_v, d1, t1);
                this.mStage[1].setUp(peak_v, d1, t1, 0.0f, destination, t2 + t1);
                this.mDuration = t2 + t1;
                if (this.mDuration > maxTime) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void rampUpCruseRampDown(float currentPos, float destination, float currentVelocity, float maxA, float maxV, float maxTime) {
        float t1 = maxTime / 3.0f;
        float t2 = t1 * 2.0f;
        float distance = destination - currentPos;
        float dt2 = t2 - t1;
        float dt3 = maxTime - t2;
        float v1 = (2.0f * distance - currentVelocity * t1) / (t1 + 2.0f * dt2 + dt3);
        this.mDuration = maxTime;
        float d1 = (currentVelocity + v1) * t1 / 2.0f;
        float d2 = (v1 + v1) * (t2 - t1) / 2.0f;
        this.mNumberOfStages = 3;
        float acc = (v1 - currentVelocity) / t1;
        float dec = v1 / dt3;
        this.mStage[0].setUp(currentVelocity, currentPos, 0.0f, v1, currentPos + d1, t1);
        this.mStage[1].setUp(v1, currentPos + d1, t1, v1, currentPos + d1 + d2, t2);
        this.mStage[2].setUp(v1, currentPos + d1 + d2, t2, 0.0f, destination, maxTime);
        this.mDuration = maxTime;
    }

    double getEasing(double t) {
        double gx = t * t * this.mEasingAdapterA + t * this.mEasingAdapterB;
        if (gx > 1.0) {
            return this.mEasingAdapterDistance;
        }
        return this.mEasing.get(gx) * this.mEasingAdapterDistance;
    }

    private double getEasingDiff(double t) {
        double gx = t * t * this.mEasingAdapterA + t * this.mEasingAdapterB;
        if (gx > 1.0) {
            return 0.0;
        }
        return this.mEasing.getDiff(gx) * this.mEasingAdapterDistance * (t * this.mEasingAdapterA + this.mEasingAdapterB);
    }

    protected void configureEasingAdapter() {
        if (this.mEasing == null) {
            return;
        }
        int last = this.mNumberOfStages - 1;
        float initialVelocity = this.mStage[last].mStartV;
        float distance = this.mStage[last].mEndPos - this.mStage[last].mStartPos;
        float duration = this.mStage[last].mEndTime - this.mStage[last].mStartTime;
        double baseVel = this.mEasing.getDiff(0.0);
        this.mEasingAdapterB = (double)initialVelocity / (baseVel * (double)distance);
        this.mEasingAdapterA = 1.0 - this.mEasingAdapterB;
        this.mEasingAdapterDistance = distance;
        double easingDuration = (Math.sqrt(4.0 * this.mEasingAdapterA + this.mEasingAdapterB * this.mEasingAdapterB) - this.mEasingAdapterB) / (2.0 * this.mEasingAdapterA);
        this.mTotalEasingDuration = (float)(easingDuration + (double)this.mStage[last].mStartTime);
    }

    class Stage {
        private float mStartV = 0.0f;
        private float mStartPos = 0.0f;
        private float mStartTime = 0.0f;
        private float mEndV = 0.0f;
        private float mEndPos = 0.0f;
        private float mEndTime = 0.0f;
        private float mDeltaV = 0.0f;
        private float mDeltaT = 0.0f;
        final int mStage;

        Stage(VelocityEasing this$0, int n) {
            this.mStage = n;
        }

        void setUp(float startV, float startPos, float startTime, float endV, float endPos, float endTime) {
            this.mStartV = startV;
            this.mStartPos = startPos;
            this.mStartTime = startTime;
            this.mEndV = endV;
            this.mEndTime = endTime;
            this.mEndPos = endPos;
            this.mDeltaV = this.mEndV - this.mStartV;
            this.mDeltaT = this.mEndTime - this.mStartTime;
        }

        float getPos(float t) {
            float dt = t - this.mStartTime;
            float pt = dt / this.mDeltaT;
            float v = this.mStartV + this.mDeltaV * pt;
            return dt * (this.mStartV + v) / 2.0f + this.mStartPos;
        }

        float getVel(float t) {
            float dt = t - this.mStartTime;
            float pt = dt / (this.mEndTime - this.mStartTime);
            return this.mStartV + this.mDeltaV * pt;
        }
    }

    static interface Easing {
        public double get(double var1);

        public double getDiff(double var1);

        public Easing clone();
    }
}

