/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.types;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class IntegerConstant
extends Operation
implements Serializable {
    private static final String CLASS_NAME = "IntegerConstant";
    private int mValue;
    public final int mId;

    IntegerConstant(int id2, int value) {
        this.mId = id2;
        this.mValue = value;
    }

    public void update(IntegerConstant ic) {
        this.mValue = ic.mValue;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        IntegerConstant.apply(buffer, this.mId, this.mValue);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadInteger(this.mId, this.mValue);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @NonNull
    public String toString() {
        return "IntegerConstant[" + this.mId + "] = " + this.mValue + "";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 140;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, int value) {
        buffer.start(140);
        buffer.writeInt(textId);
        buffer.writeInt(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int value = buffer.readInt();
        operations.add(new IntegerConstant(id2, value));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", IntegerConstant.id(), CLASS_NAME).description("A integer and its associated id").field(0, "id", "id of Int").field(0, "value", "32-bit int value");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("value", this.mValue);
    }
}

