/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.types;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class LongConstant
extends Operation
implements Serializable {
    private static final String CLASS_NAME = "LongConstant";
    private static final int OP_CODE = 148;
    private long mValue;
    public final int mId;

    public LongConstant(int id2, long value) {
        this.mId = id2;
        this.mValue = value;
    }

    public void update(LongConstant from) {
        this.mValue = from.mValue;
    }

    public long getValue() {
        return this.mValue;
    }

    public void setValue(long value) {
        this.mValue = value;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        LongConstant.apply(buffer, this.mId, this.mValue);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.putObject(this.mId, this);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @NonNull
    public String toString() {
        return "LongConstant[" + this.mId + "] = " + this.mValue + "";
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, long value) {
        buffer.start(148);
        buffer.writeInt(id2);
        buffer.writeLong(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        long value = buffer.readLong();
        operations.add(new LongConstant(id2, value));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 148, CLASS_NAME).description("A boolean and its associated id").field(0, "id", "id of Int").field(8, "value", "The long Value");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("value", this.mValue);
    }
}

