/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.player.platform;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.RuntimeShader;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.Platform;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.ShaderData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintChanges;
import com.android.internal.widget.remotecompose.player.platform.AndroidComputedTextLayout;
import com.android.internal.widget.remotecompose.player.platform.AndroidRemoteContext;
import com.android.internal.widget.remotecompose.player.platform.FloatsToPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AndroidPaintContext
extends PaintContext {
    Paint mPaint = new Paint();
    List<Paint> mPaintList = new ArrayList<Paint>();
    Canvas mCanvas;
    Rect mTmpRect = new Rect();
    RenderNode mNode = null;
    Canvas mPreviousCanvas = null;
    private Paint.FontMetrics mCachedFontMetrics;
    PaintChanges mCachedPaintChanges = new PaintChanges(){
        Shader.TileMode[] mTileModes = new Shader.TileMode[]{Shader.TileMode.CLAMP, Shader.TileMode.REPEAT, Shader.TileMode.MIRROR};

        @Override
        public void setTextSize(float size) {
            AndroidPaintContext.this.mPaint.setTextSize(size);
        }

        @Override
        public void setTypeFace(int fontType, int weight, boolean italic) {
            int[] type = new int[]{0, 1, 2, 3};
            switch (fontType) {
                case 0: {
                    if (weight == 400 && !italic) {
                        AndroidPaintContext.this.mPaint.setTypeface(Typeface.DEFAULT);
                        break;
                    }
                    AndroidPaintContext.this.mPaint.setTypeface(Typeface.create(Typeface.DEFAULT, weight, italic));
                    break;
                }
                case 2: {
                    if (weight == 400 && !italic) {
                        AndroidPaintContext.this.mPaint.setTypeface(Typeface.SERIF);
                        break;
                    }
                    AndroidPaintContext.this.mPaint.setTypeface(Typeface.create(Typeface.SERIF, weight, italic));
                    break;
                }
                case 1: {
                    if (weight == 400 && !italic) {
                        AndroidPaintContext.this.mPaint.setTypeface(Typeface.SANS_SERIF);
                        break;
                    }
                    AndroidPaintContext.this.mPaint.setTypeface(Typeface.create(Typeface.SANS_SERIF, weight, italic));
                    break;
                }
                case 3: {
                    if (weight == 400 && !italic) {
                        AndroidPaintContext.this.mPaint.setTypeface(Typeface.MONOSPACE);
                        break;
                    }
                    AndroidPaintContext.this.mPaint.setTypeface(Typeface.create(Typeface.MONOSPACE, weight, italic));
                }
            }
        }

        @Override
        public void setStrokeWidth(float width) {
            AndroidPaintContext.this.mPaint.setStrokeWidth(width);
        }

        @Override
        public void setColor(int color2) {
            AndroidPaintContext.this.mPaint.setColor(color2);
        }

        @Override
        public void setStrokeCap(int cap) {
            AndroidPaintContext.this.mPaint.setStrokeCap(Paint.Cap.values()[cap]);
        }

        @Override
        public void setStyle(int style2) {
            AndroidPaintContext.this.mPaint.setStyle(Paint.Style.values()[style2]);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void setShader(int shaderId) {
            Object[] val;
            String name;
            int i;
            if (shaderId == 0) {
                AndroidPaintContext.this.mPaint.setShader(null);
                return;
            }
            ShaderData data = AndroidPaintContext.this.getShaderData(shaderId);
            if (data == null) {
                return;
            }
            RuntimeShader shader = new RuntimeShader(AndroidPaintContext.this.getText(data.getShaderTextId()));
            String[] names = data.getUniformFloatNames();
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                val = data.getUniformFloats(name);
                shader.setFloatUniform(name, (float[])val);
            }
            names = data.getUniformIntegerNames();
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                val = data.getUniformInts(name);
                shader.setIntUniform(name, (int[])val);
            }
            names = data.getUniformBitmapNames();
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                int val2 = data.getUniformBitmapId(name);
                AndroidRemoteContext androidContext = (AndroidRemoteContext)AndroidPaintContext.this.mContext;
                Bitmap bitmap = (Bitmap)androidContext.mRemoteComposeState.getFromId(val2);
                BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                shader.setInputShader(name, bitmapShader);
            }
            AndroidPaintContext.this.mPaint.setShader(shader);
        }

        @Override
        public void setImageFilterQuality(int quality) {
            Utils.log(" quality =" + quality);
            AndroidPaintContext.this.mPaint.setFilterBitmap(quality == 1);
        }

        @Override
        public void setBlendMode(int mode) {
            AndroidPaintContext.this.mPaint.setBlendMode(AndroidPaintContext.origamiToBlendMode(mode));
        }

        @Override
        public void setAlpha(float a) {
            AndroidPaintContext.this.mPaint.setAlpha((int)(255.0f * a));
        }

        @Override
        public void setStrokeMiter(float miter) {
            AndroidPaintContext.this.mPaint.setStrokeMiter(miter);
        }

        @Override
        public void setStrokeJoin(int join) {
            AndroidPaintContext.this.mPaint.setStrokeJoin(Paint.Join.values()[join]);
        }

        @Override
        public void setFilterBitmap(boolean filter) {
            AndroidPaintContext.this.mPaint.setFilterBitmap(filter);
        }

        @Override
        public void setAntiAlias(boolean aa) {
            AndroidPaintContext.this.mPaint.setAntiAlias(aa);
        }

        @Override
        public void clear(long mask) {
            if ((mask & 0x2000L) != 0L) {
                AndroidPaintContext.this.mPaint.setColorFilter(null);
            }
        }

        @Override
        public void setLinearGradient(@NonNull int[] colors, @NonNull float[] stops, float startX, float startY, float endX, float endY, int tileMode) {
            AndroidPaintContext.this.mPaint.setShader(new LinearGradient(startX, startY, endX, endY, colors, stops, this.mTileModes[tileMode]));
        }

        @Override
        public void setRadialGradient(@NonNull int[] colors, @NonNull float[] stops, float centerX, float centerY, float radius, int tileMode) {
            AndroidPaintContext.this.mPaint.setShader(new RadialGradient(centerX, centerY, radius, colors, stops, this.mTileModes[tileMode]));
        }

        @Override
        public void setSweepGradient(@NonNull int[] colors, @NonNull float[] stops, float centerX, float centerY) {
            AndroidPaintContext.this.mPaint.setShader(new SweepGradient(centerX, centerY, colors, stops));
        }

        @Override
        public void setColorFilter(int color2, int mode) {
            PorterDuff.Mode pmode = AndroidPaintContext.origamiToPorterDuffMode(mode);
            if (pmode != null) {
                AndroidPaintContext.this.mPaint.setColorFilter(new PorterDuffColorFilter(color2, pmode));
            }
        }
    };

    public AndroidPaintContext(RemoteContext context, Canvas canvas) {
        super(context);
        this.mCanvas = canvas;
    }

    public Canvas getCanvas() {
        return this.mCanvas;
    }

    public void setCanvas(Canvas canvas) {
        this.mCanvas = canvas;
    }

    @Override
    public void save() {
        this.mCanvas.save();
    }

    @Override
    public void saveLayer(float x, float y, float width, float height) {
        this.mCanvas.saveLayer(x, y, x + width, y + height, this.mPaint);
    }

    @Override
    public void restore() {
        this.mCanvas.restore();
    }

    @Override
    public void drawBitmap(int imageId, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom, int cdId) {
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        if (androidContext.mRemoteComposeState.containsId(imageId)) {
            Bitmap bitmap = (Bitmap)androidContext.mRemoteComposeState.getFromId(imageId);
            this.mCanvas.drawBitmap(bitmap, new Rect(srcLeft, srcTop, srcRight, srcBottom), new Rect(dstLeft, dstTop, dstRight, dstBottom), this.mPaint);
        }
    }

    @Override
    public void scale(float scaleX, float scaleY) {
        this.mCanvas.scale(scaleX, scaleY);
    }

    @Override
    public void startGraphicsLayer(int w, int h) {
        this.mNode = new RenderNode("layer");
        this.mNode.setPosition(0, 0, w, h);
        this.mPreviousCanvas = this.mCanvas;
        this.mCanvas = this.mNode.beginRecording();
    }

    @Override
    public void setGraphicsLayer(@NonNull HashMap<Integer, Object> attributes) {
        if (this.mNode == null) {
            return;
        }
        boolean hasBlurEffect = false;
        boolean hasOutline = false;
        for (Integer key : attributes.keySet()) {
            Object value = attributes.get(key);
            switch (key) {
                case 0: {
                    this.mNode.setScaleX(((Float)value).floatValue());
                    break;
                }
                case 1: {
                    this.mNode.setScaleY(((Float)value).floatValue());
                    break;
                }
                case 2: {
                    this.mNode.setRotationX(((Float)value).floatValue());
                    break;
                }
                case 3: {
                    this.mNode.setRotationY(((Float)value).floatValue());
                    break;
                }
                case 4: {
                    this.mNode.setRotationZ(((Float)value).floatValue());
                    break;
                }
                case 5: {
                    this.mNode.setPivotX(((Float)value).floatValue() * (float)this.mNode.getWidth());
                    break;
                }
                case 6: {
                    this.mNode.setPivotY(((Float)value).floatValue() * (float)this.mNode.getWidth());
                    break;
                }
                case 7: {
                    this.mNode.setTranslationX(((Float)value).floatValue());
                    break;
                }
                case 8: {
                    this.mNode.setTranslationY(((Float)value).floatValue());
                    break;
                }
                case 9: {
                    this.mNode.setTranslationZ(((Float)value).floatValue());
                    break;
                }
                case 20: {
                    hasOutline = true;
                    break;
                }
                case 10: {
                    this.mNode.setElevation(((Float)value).floatValue());
                    break;
                }
                case 11: {
                    this.mNode.setAlpha(((Float)value).floatValue());
                    break;
                }
                case 12: {
                    this.mNode.setCameraDistance(((Float)value).floatValue());
                    break;
                }
                case 14: {
                    this.mNode.setSpotShadowColor((Integer)value);
                    break;
                }
                case 15: {
                    this.mNode.setAmbientShadowColor((Integer)value);
                    break;
                }
                case 16: {
                    hasBlurEffect = (Integer)value != 0;
                }
            }
        }
        if (hasOutline) {
            Outline outline = new Outline();
            outline.setAlpha(1.0f);
            Object oShape = attributes.get(20);
            if (oShape != null) {
                float radius;
                Object oShapeRadius = attributes.get(21);
                int type = (Integer)oShape;
                if (type == 0) {
                    outline.setRect(0, 0, this.mNode.getWidth(), this.mNode.getHeight());
                } else if (type == 1) {
                    if (oShapeRadius != null) {
                        radius = ((Float)oShapeRadius).floatValue();
                        outline.setRoundRect(new Rect(0, 0, this.mNode.getWidth(), this.mNode.getHeight()), radius);
                    } else {
                        outline.setRect(0, 0, this.mNode.getWidth(), this.mNode.getHeight());
                    }
                } else if (type == 2) {
                    radius = (float)Math.min(this.mNode.getWidth(), this.mNode.getHeight()) / 2.0f;
                    outline.setRoundRect(new Rect(0, 0, this.mNode.getWidth(), this.mNode.getHeight()), radius);
                }
            }
            this.mNode.setOutline(outline);
        }
        if (hasBlurEffect) {
            Object oBlurRadiusX = attributes.get(17);
            float blurRadiusX = 0.0f;
            if (oBlurRadiusX != null) {
                blurRadiusX = ((Float)oBlurRadiusX).floatValue();
            }
            Object oBlurRadiusY = attributes.get(18);
            float blurRadiusY = 0.0f;
            if (oBlurRadiusY != null) {
                blurRadiusY = ((Float)oBlurRadiusY).floatValue();
            }
            int blurTileMode = 0;
            Object oBlurTileMode = attributes.get(19);
            if (oBlurTileMode != null) {
                blurTileMode = (Integer)oBlurTileMode;
            }
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            switch (blurTileMode) {
                case 0: {
                    tileMode = Shader.TileMode.CLAMP;
                    break;
                }
                case 3: {
                    tileMode = Shader.TileMode.DECAL;
                    break;
                }
                case 2: {
                    tileMode = Shader.TileMode.MIRROR;
                    break;
                }
                case 1: {
                    tileMode = Shader.TileMode.REPEAT;
                }
            }
            RenderEffect effect = RenderEffect.createBlurEffect(blurRadiusX, blurRadiusY, tileMode);
            this.mNode.setRenderEffect(effect);
        }
    }

    @Override
    public void endGraphicsLayer() {
        this.mNode.endRecording();
        this.mCanvas = this.mPreviousCanvas;
        if (this.mCanvas.isHardwareAccelerated()) {
            this.mCanvas.enableZ();
            this.mCanvas.drawRenderNode(this.mNode);
            this.mCanvas.disableZ();
        }
        this.mNode = null;
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.mCanvas.translate(translateX, translateY);
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.mCanvas.drawArc(left, top, right, bottom, startAngle, sweepAngle, false, this.mPaint);
    }

    @Override
    public void drawSector(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.mCanvas.drawArc(left, top, right, bottom, startAngle, sweepAngle, true, this.mPaint);
    }

    @Override
    public void drawBitmap(int id2, float left, float top, float right, float bottom) {
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        if (androidContext.mRemoteComposeState.containsId(id2)) {
            Bitmap bitmap = (Bitmap)androidContext.mRemoteComposeState.getFromId(id2);
            Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF dst = new RectF(left, top, right, bottom);
            this.mCanvas.drawBitmap(bitmap, src, dst, this.mPaint);
        }
    }

    @Override
    public void drawCircle(float centerX, float centerY, float radius) {
        this.mCanvas.drawCircle(centerX, centerY, radius, this.mPaint);
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2) {
        this.mCanvas.drawLine(x1, y1, x2, y2, this.mPaint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom) {
        this.mCanvas.drawOval(left, top, right, bottom, this.mPaint);
    }

    @Override
    public void drawPath(int id2, float start, float end) {
        this.mCanvas.drawPath(this.getPath(id2, start, end), this.mPaint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom) {
        this.mCanvas.drawRect(left, top, right, bottom, this.mPaint);
    }

    @Override
    public void savePaint() {
        this.mPaintList.add(new Paint(this.mPaint));
    }

    @Override
    public void restorePaint() {
        this.mPaint = this.mPaintList.remove(this.mPaintList.size() - 1);
    }

    @Override
    public void replacePaint(PaintBundle paintBundle) {
        this.mPaint.reset();
        this.applyPaint(paintBundle);
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        this.mCanvas.drawRoundRect(left, top, right, bottom, radiusX, radiusY, this.mPaint);
    }

    @Override
    public void drawTextOnPath(int textId, int pathId, float hOffset, float vOffset) {
        this.mCanvas.drawTextOnPath(this.getText(textId), this.getPath(pathId, 0.0f, 1.0f), hOffset, vOffset, this.mPaint);
    }

    @Override
    public void getTextBounds(int textId, int start, int end, int flags, @NonNull float[] bounds) {
        String str = this.getText(textId);
        if (end == -1 || end > str.length()) {
            end = str.length();
        }
        if (this.mCachedFontMetrics == null) {
            this.mCachedFontMetrics = this.mPaint.getFontMetrics();
        }
        this.mPaint.getFontMetrics(this.mCachedFontMetrics);
        this.mPaint.getTextBounds(str, start, end, this.mTmpRect);
        if ((flags & 4) != 0) {
            bounds[0] = 0.0f;
            bounds[2] = this.mPaint.measureText(str, start, end);
        } else {
            bounds[0] = this.mTmpRect.left;
            bounds[2] = (flags & 1) != 0 ? this.mPaint.measureText(str, start, end) - (float)this.mTmpRect.left : (float)this.mTmpRect.right;
        }
        if ((flags & 2) != 0) {
            bounds[1] = Math.round(this.mCachedFontMetrics.ascent);
            bounds[3] = Math.round(this.mCachedFontMetrics.descent);
        } else {
            bounds[1] = this.mTmpRect.top;
            bounds[3] = this.mTmpRect.bottom;
        }
    }

    @Override
    public Platform.ComputedTextLayout layoutComplexText(int textId, int start, int end, int alignment, int overflow, int maxLines, float maxWidth, int flags) {
        String str = this.getText(textId);
        if (str == null) {
            return null;
        }
        if (end == -1 || end > str.length()) {
            end = str.length();
        }
        TextPaint textPaint = new TextPaint();
        textPaint.set(this.mPaint);
        StaticLayout.Builder staticLayoutBuilder = StaticLayout.Builder.obtain(str, start, end, textPaint, (int)maxWidth);
        switch (alignment) {
            case 2: 
            case 6: {
                staticLayoutBuilder.setAlignment(Layout.Alignment.ALIGN_OPPOSITE);
                break;
            }
            case 3: {
                staticLayoutBuilder.setAlignment(Layout.Alignment.ALIGN_CENTER);
                break;
            }
            default: {
                staticLayoutBuilder.setAlignment(Layout.Alignment.ALIGN_NORMAL);
            }
        }
        switch (overflow) {
            case 3: {
                staticLayoutBuilder.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 5: {
                staticLayoutBuilder.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 4: {
                staticLayoutBuilder.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
        }
        staticLayoutBuilder.setMaxLines(maxLines);
        staticLayoutBuilder.setIncludePad(false);
        StaticLayout staticLayout = staticLayoutBuilder.build();
        return new AndroidComputedTextLayout(staticLayout, staticLayout.getWidth(), staticLayout.getHeight());
    }

    @Override
    public void drawTextRun(int textID, int start, int end, int contextStart, int contextEnd, float x, float y, boolean rtl) {
        String textToPaint = this.getText(textID);
        if (textToPaint == null) {
            return;
        }
        if (end == -1) {
            if (start != 0) {
                textToPaint = textToPaint.substring(start);
            }
        } else {
            textToPaint = end > textToPaint.length() ? textToPaint.substring(start) : textToPaint.substring(start, end);
        }
        this.mCanvas.drawText(textToPaint, x, y, this.mPaint);
    }

    @Override
    public void drawComplexText(Platform.ComputedTextLayout computedTextLayout) {
        if (computedTextLayout == null) {
            return;
        }
        StaticLayout staticLayout = ((AndroidComputedTextLayout)computedTextLayout).get();
        staticLayout.draw(this.mCanvas);
    }

    @Override
    public void drawTweenPath(int path1Id, int path2Id, float tween, float start, float end) {
        this.mCanvas.drawPath(this.getPath(path1Id, path2Id, tween, start, end), this.mPaint);
    }

    private static PorterDuff.Mode origamiToPorterDuffMode(int mode) {
        switch (mode) {
            case 0: {
                return PorterDuff.Mode.CLEAR;
            }
            case 1: {
                return PorterDuff.Mode.SRC;
            }
            case 2: {
                return PorterDuff.Mode.DST;
            }
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 4: {
                return PorterDuff.Mode.DST_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 6: {
                return PorterDuff.Mode.DST_IN;
            }
            case 7: {
                return PorterDuff.Mode.SRC_OUT;
            }
            case 8: {
                return PorterDuff.Mode.DST_OUT;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 10: {
                return PorterDuff.Mode.DST_ATOP;
            }
            case 11: {
                return PorterDuff.Mode.XOR;
            }
            case 14: {
                return PorterDuff.Mode.SCREEN;
            }
            case 15: {
                return PorterDuff.Mode.OVERLAY;
            }
            case 16: {
                return PorterDuff.Mode.DARKEN;
            }
            case 17: {
                return PorterDuff.Mode.LIGHTEN;
            }
            case 24: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 30: {
                return PorterDuff.Mode.ADD;
            }
        }
        return PorterDuff.Mode.SRC_OVER;
    }

    public static BlendMode origamiToBlendMode(int mode) {
        switch (mode) {
            case 0: {
                return BlendMode.CLEAR;
            }
            case 1: {
                return BlendMode.SRC;
            }
            case 2: {
                return BlendMode.DST;
            }
            case 3: {
                return BlendMode.SRC_OVER;
            }
            case 4: {
                return BlendMode.DST_OVER;
            }
            case 5: {
                return BlendMode.SRC_IN;
            }
            case 6: {
                return BlendMode.DST_IN;
            }
            case 7: {
                return BlendMode.SRC_OUT;
            }
            case 8: {
                return BlendMode.DST_OUT;
            }
            case 9: {
                return BlendMode.SRC_ATOP;
            }
            case 10: {
                return BlendMode.DST_ATOP;
            }
            case 11: {
                return BlendMode.XOR;
            }
            case 12: {
                return BlendMode.PLUS;
            }
            case 13: {
                return BlendMode.MODULATE;
            }
            case 14: {
                return BlendMode.SCREEN;
            }
            case 15: {
                return BlendMode.OVERLAY;
            }
            case 16: {
                return BlendMode.DARKEN;
            }
            case 17: {
                return BlendMode.LIGHTEN;
            }
            case 18: {
                return BlendMode.COLOR_DODGE;
            }
            case 19: {
                return BlendMode.COLOR_BURN;
            }
            case 20: {
                return BlendMode.HARD_LIGHT;
            }
            case 21: {
                return BlendMode.SOFT_LIGHT;
            }
            case 22: {
                return BlendMode.DIFFERENCE;
            }
            case 23: {
                return BlendMode.EXCLUSION;
            }
            case 24: {
                return BlendMode.MULTIPLY;
            }
            case 25: {
                return BlendMode.HUE;
            }
            case 26: {
                return BlendMode.SATURATION;
            }
            case 27: {
                return BlendMode.COLOR;
            }
            case 28: {
                return BlendMode.LUMINOSITY;
            }
            case 29: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void applyPaint(@NonNull PaintBundle paintData) {
        paintData.applyPaintChange(this, this.mCachedPaintChanges);
    }

    @Override
    public void matrixScale(float scaleX, float scaleY, float centerX, float centerY) {
        if (Float.isNaN(centerX)) {
            this.mCanvas.scale(scaleX, scaleY);
        } else {
            this.mCanvas.scale(scaleX, scaleY, centerX, centerY);
        }
    }

    @Override
    public void matrixTranslate(float translateX, float translateY) {
        this.mCanvas.translate(translateX, translateY);
    }

    @Override
    public void matrixSkew(float skewX, float skewY) {
        this.mCanvas.skew(skewX, skewY);
    }

    @Override
    public void matrixRotate(float rotate, float pivotX, float pivotY) {
        if (Float.isNaN(pivotX)) {
            this.mCanvas.rotate(rotate);
        } else {
            this.mCanvas.rotate(rotate, pivotX, pivotY);
        }
    }

    @Override
    public void matrixSave() {
        this.mCanvas.save();
    }

    @Override
    public void matrixRestore() {
        this.mCanvas.restore();
    }

    @Override
    public void clipRect(float left, float top, float right, float bottom) {
        this.mCanvas.clipRect(left, top, right, bottom);
    }

    @Override
    public void roundedClipRect(float width, float height, float topStart, float topEnd, float bottomStart, float bottomEnd) {
        Path roundedPath = new Path();
        float[] radii = new float[]{topStart, topStart, topEnd, topEnd, bottomEnd, bottomEnd, bottomStart, bottomStart};
        roundedPath.addRoundRect(0.0f, 0.0f, width, height, radii, Path.Direction.CW);
        this.mCanvas.clipPath(roundedPath);
    }

    @Override
    public void clipPath(int pathId, int regionOp) {
        Path path = this.getPath(pathId, 0.0f, 1.0f);
        if (regionOp == 1) {
            this.mCanvas.clipOutPath(path);
        } else {
            this.mCanvas.clipPath(path);
        }
    }

    @Override
    public void tweenPath(int out, int path1, int path2, float tween) {
        float[] p = this.getPathArray(path1, path2, tween);
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        androidContext.mRemoteComposeState.putPathData(out, p);
    }

    @Override
    public void combinePath(int out, int path1, int path2, byte operation) {
        Path p1 = this.getPath(path1, 0.0f, 1.0f);
        Path p2 = this.getPath(path2, 0.0f, 1.0f);
        Path.Op[] op = new Path.Op[]{Path.Op.DIFFERENCE, Path.Op.INTERSECT, Path.Op.REVERSE_DIFFERENCE, Path.Op.UNION, Path.Op.XOR};
        Path p = new Path(p1);
        p.op(p2, op[operation]);
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        androidContext.mRemoteComposeState.putPath(out, p);
    }

    @Override
    public void reset() {
        this.mPaint.reset();
    }

    private Path getPath(int path1Id, int path2Id, float tween, float start, float end) {
        return this.getPath(this.getPathArray(path1Id, path2Id, tween), start, end);
    }

    private float[] getPathArray(int path1Id, int path2Id, float tween) {
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        if (tween == 0.0f) {
            return androidContext.mRemoteComposeState.getPathData(path1Id);
        }
        if (tween == 1.0f) {
            return androidContext.mRemoteComposeState.getPathData(path2Id);
        }
        float[] data1 = androidContext.mRemoteComposeState.getPathData(path1Id);
        float[] data2 = androidContext.mRemoteComposeState.getPathData(path2Id);
        float[] tmp = new float[data2.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Float.isNaN(data1[i]) || Float.isNaN(data2[i]) ? data1[i] : (data2[i] - data1[i]) * tween + data1[i];
        }
        return tmp;
    }

    private Path getPath(float[] tmp, float start, float end) {
        Path path = new Path();
        FloatsToPath.genPath(path, tmp, start, end);
        return path;
    }

    private Path getPath(int id2, float start, float end) {
        AndroidRemoteContext androidContext = (AndroidRemoteContext)this.mContext;
        Path p = (Path)androidContext.mRemoteComposeState.getPath(id2);
        if (p != null) {
            return p;
        }
        Path path = new Path();
        float[] pathData = androidContext.mRemoteComposeState.getPathData(id2);
        if (pathData != null) {
            FloatsToPath.genPath(path, pathData, start, end);
            androidContext.mRemoteComposeState.putPath(id2, path);
        }
        return path;
    }

    @Override
    @Nullable
    public String getText(int id2) {
        return (String)this.mContext.mRemoteComposeState.getFromId(id2);
    }

    private ShaderData getShaderData(int id2) {
        return (ShaderData)this.mContext.mRemoteComposeState.getFromId(id2);
    }
}

