/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.player.platform;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.operations.FloatExpression;
import com.android.internal.widget.remotecompose.core.operations.ShaderData;
import com.android.internal.widget.remotecompose.core.operations.utilities.ArrayAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.DataMap;
import com.android.internal.widget.remotecompose.core.types.LongConstant;
import com.android.internal.widget.remotecompose.player.platform.AndroidPaintContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class AndroidRemoteContext
extends RemoteContext {
    HashMap<String, VarName> mVarNameHashMap = new HashMap();

    public void useCanvas(Canvas canvas) {
        if (this.mPaintContext == null) {
            this.mPaintContext = new AndroidPaintContext(this, canvas);
        } else {
            this.mPaintContext.reset();
            ((AndroidPaintContext)this.mPaintContext).setCanvas(canvas);
        }
        this.mWidth = canvas.getWidth();
        this.mHeight = canvas.getHeight();
    }

    @Override
    public void loadPathData(int instanceId, @NonNull float[] floatPath) {
        this.mRemoteComposeState.putPathData(instanceId, floatPath);
    }

    @Override
    public float[] getPathData(int instanceId) {
        return this.mRemoteComposeState.getPathData(instanceId);
    }

    @Override
    public void loadVariableName(@NonNull String varName, int varId, int varType) {
        this.mVarNameHashMap.put(varName, new VarName(varName, varId, varType));
    }

    @Override
    public void setNamedStringOverride(@NonNull String stringName, @NonNull String value) {
        if (this.mVarNameHashMap.get(stringName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)stringName).mId;
            this.overrideText(id2, value);
        }
    }

    @Override
    public void clearNamedStringOverride(@NonNull String stringName) {
        if (this.mVarNameHashMap.get(stringName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)stringName).mId;
            this.clearDataOverride(id2);
        }
        this.mVarNameHashMap.put(stringName, null);
    }

    @Override
    public void setNamedIntegerOverride(@NonNull String stringName, int value) {
        if (this.mVarNameHashMap.get(stringName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)stringName).mId;
            this.overrideInt(id2, value);
        }
    }

    @Override
    public void clearNamedIntegerOverride(@NonNull String integerName) {
        if (this.mVarNameHashMap.get(integerName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)integerName).mId;
            this.clearIntegerOverride(id2);
        }
        this.mVarNameHashMap.put(integerName, null);
    }

    @Override
    public void setNamedFloatOverride(String floatName, float value) {
        if (this.mVarNameHashMap.get(floatName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)floatName).mId;
            this.overrideFloat(id2, value);
        }
    }

    @Override
    public void clearNamedFloatOverride(String floatName) {
        if (this.mVarNameHashMap.get(floatName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)floatName).mId;
            this.clearFloatOverride(id2);
        }
        this.mVarNameHashMap.put(floatName, null);
    }

    @Override
    public void setNamedLong(String name, long value) {
        VarName entry = this.mVarNameHashMap.get(name);
        if (entry != null) {
            int id2 = entry.mId;
            LongConstant longConstant = (LongConstant)this.mRemoteComposeState.getObject(id2);
            longConstant.setValue(value);
        }
    }

    @Override
    public void setNamedDataOverride(String dataName, Object value) {
        if (this.mVarNameHashMap.get(dataName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)dataName).mId;
            this.overrideData(id2, value);
        }
    }

    @Override
    public void clearNamedDataOverride(String dataName) {
        if (this.mVarNameHashMap.get(dataName) != null) {
            int id2 = this.mVarNameHashMap.get((Object)dataName).mId;
            this.clearDataOverride(id2);
        }
        this.mVarNameHashMap.put(dataName, null);
    }

    @Override
    public void setNamedColorOverride(@NonNull String colorName, int color2) {
        int id2 = this.mVarNameHashMap.get((Object)colorName).mId;
        this.mRemoteComposeState.overrideColor(id2, color2);
    }

    @Override
    public void addCollection(int id2, @NonNull ArrayAccess collection) {
        this.mRemoteComposeState.addCollection(id2, collection);
    }

    @Override
    public void putDataMap(int id2, @NonNull DataMap map) {
        this.mRemoteComposeState.putDataMap(id2, map);
    }

    @Override
    public DataMap getDataMap(int id2) {
        return this.mRemoteComposeState.getDataMap(id2);
    }

    @Override
    public void runAction(int id2, @NonNull String metadata) {
        this.mDocument.performClick(this, id2, metadata);
    }

    @Override
    public void runNamedAction(int id2, Object value) {
        String text = this.getText(id2);
        this.mDocument.runNamedAction(text, value);
    }

    @Override
    public void loadBitmap(int imageId, short encoding, short type, int width, int height, @NonNull byte[] data) {
        if (!this.mRemoteComposeState.containsId(imageId)) {
            Bitmap image = null;
            switch (encoding) {
                case 0: {
                    switch (type) {
                        case 0: {
                            image = BitmapFactory.decodeByteArray(data, 0, data.length);
                            break;
                        }
                        case 4: {
                            image = this.decodePreferringAlpha8(data);
                            if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) break;
                            Bitmap alpha8Bitmap = Bitmap.createBitmap(image.getWidth(), image.getHeight(), Bitmap.Config.ALPHA_8);
                            Canvas canvas = new Canvas(alpha8Bitmap);
                            Paint paint = new Paint();
                            paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
                            canvas.drawBitmap(image, 0.0f, 0.0f, paint);
                            image.recycle();
                            image = alpha8Bitmap;
                            break;
                        }
                        case 3: {
                            image = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                            int[] idata = new int[data.length / 4];
                            for (int i = 0; i < idata.length; ++i) {
                                int p = i * 4;
                                idata[i] = data[p] << 24 | data[p + 1] << 16 | data[p + 2] << 8 | data[p + 3];
                            }
                            image.setPixels(idata, 0, width, 0, 0, width, height);
                            break;
                        }
                        case 2: {
                            image = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                            int[] bdata = new int[data.length / 4];
                            for (int i = 0; i < bdata.length; ++i) {
                                bdata[i] = 0x1010101 * data[i];
                            }
                            image.setPixels(bdata, 0, width, 0, 0, width, height);
                        }
                    }
                    break;
                }
                case 2: {
                    image = BitmapFactory.decodeFile(new String(data));
                    break;
                }
                case 1: {
                    try {
                        image = BitmapFactory.decodeStream(new URL(new String(data)).openStream());
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.mRemoteComposeState.cacheData(imageId, image);
        }
    }

    private Bitmap decodePreferringAlpha8(@NonNull byte[] data) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ALPHA_8;
        return BitmapFactory.decodeByteArray(data, 0, data.length, options);
    }

    @Override
    public void loadText(int id2, @NonNull String text) {
        if (!this.mRemoteComposeState.containsId(id2)) {
            this.mRemoteComposeState.cacheData(id2, text);
        } else {
            this.mRemoteComposeState.updateData(id2, text);
        }
    }

    public void overrideText(int id2, String text) {
        this.mRemoteComposeState.overrideData(id2, text);
    }

    public void overrideInt(int id2, int value) {
        this.mRemoteComposeState.overrideInteger(id2, value);
    }

    public void overrideData(int id2, Object value) {
        this.mRemoteComposeState.overrideData(id2, value);
    }

    public void clearDataOverride(int id2) {
        this.mRemoteComposeState.clearDataOverride(id2);
    }

    public void clearIntegerOverride(int id2) {
        this.mRemoteComposeState.clearIntegerOverride(id2);
    }

    public void clearFloatOverride(int id2) {
        this.mRemoteComposeState.clearFloatOverride(id2);
    }

    @Override
    public String getText(int id2) {
        return (String)this.mRemoteComposeState.getFromId(id2);
    }

    @Override
    public void loadFloat(int id2, float value) {
        this.mRemoteComposeState.updateFloat(id2, value);
    }

    @Override
    public void overrideFloat(int id2, float value) {
        this.mRemoteComposeState.overrideFloat(id2, value);
    }

    @Override
    public void loadInteger(int id2, int value) {
        this.mRemoteComposeState.updateInteger(id2, value);
    }

    @Override
    public void overrideInteger(int id2, int value) {
        this.mRemoteComposeState.overrideInteger(id2, value);
    }

    @Override
    public void overrideText(int id2, int valueId) {
        String text = this.getText(valueId);
        this.overrideText(id2, text);
    }

    @Override
    public void loadColor(int id2, int color2) {
        this.mRemoteComposeState.updateColor(id2, color2);
    }

    @Override
    public void loadAnimatedFloat(int id2, @NonNull FloatExpression animatedFloat) {
        this.mRemoteComposeState.cacheData(id2, animatedFloat);
    }

    @Override
    public void loadShader(int id2, @NonNull ShaderData value) {
        this.mRemoteComposeState.cacheData(id2, value);
    }

    @Override
    public float getFloat(int id2) {
        return this.mRemoteComposeState.getFloat(id2);
    }

    @Override
    public void putObject(int id2, @NonNull Object value) {
        this.mRemoteComposeState.updateObject(id2, value);
    }

    @Override
    public Object getObject(int id2) {
        return this.mRemoteComposeState.getObject(id2);
    }

    @Override
    public int getInteger(int id2) {
        return this.mRemoteComposeState.getInteger(id2);
    }

    @Override
    public long getLong(int id2) {
        return ((LongConstant)this.mRemoteComposeState.getObject(id2)).getValue();
    }

    @Override
    public int getColor(int id2) {
        return this.mRemoteComposeState.getColor(id2);
    }

    @Override
    public void listensTo(int id2, @NonNull VariableSupport variableSupport) {
        this.mRemoteComposeState.listenToVar(id2, variableSupport);
    }

    @Override
    public int updateOps() {
        return this.mRemoteComposeState.getOpsToUpdate(this);
    }

    @Override
    @Nullable
    public ShaderData getShader(int id2) {
        return (ShaderData)this.mRemoteComposeState.getFromId(id2);
    }

    @Override
    public void addTouchListener(TouchListener touchExpression) {
        this.mDocument.addTouchListener(touchExpression);
    }

    @Override
    public void addClickArea(int id2, int contentDescriptionId, float left, float top, float right, float bottom, int metadataId) {
        String contentDescription = (String)this.mRemoteComposeState.getFromId(contentDescriptionId);
        String metadata = (String)this.mRemoteComposeState.getFromId(metadataId);
        this.mDocument.addClickArea(id2, contentDescription, left, top, right, bottom, metadata);
    }

    @Override
    public void hapticEffect(int type) {
        this.mDocument.haptic(type);
    }

    static class VarName {
        String mName;
        int mId;
        int mType;

        VarName(String name, int id2, int type) {
            this.mName = name;
            this.mId = id2;
            this.mType = type;
        }
    }
}

