/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.player.platform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.player.RemoteComposeDocument;
import com.android.internal.widget.remotecompose.player.platform.AndroidRemoteContext;
import com.android.internal.widget.remotecompose.player.platform.ClickAreaView;
import java.util.Set;

public class RemoteComposeCanvas
extends FrameLayout
implements View.OnAttachStateChangeListener {
    static final boolean USE_VIEW_AREA_CLICK = true;
    static final float DEFAULT_FRAME_RATE = 60.0f;
    static final float POST_TO_NEXT_FRAME_THRESHOLD = 60.0f;
    RemoteComposeDocument mDocument = null;
    int mTheme = -3;
    boolean mInActionDown = false;
    int mDebug = 0;
    boolean mHasClickAreas = false;
    Point mActionDownPoint = new Point(0, 0);
    AndroidRemoteContext mARContext = new AndroidRemoteContext();
    float mDensity = Float.NaN;
    long mStart = System_Delegate.nanoTime();
    long mLastFrameDelay = 1L;
    float mMaxFrameRate = 60.0f;
    long mMaxFrameDelay = (long)(1000.0f / this.mMaxFrameRate);
    long mLastFrameCall = System_Delegate.currentTimeMillis();
    private Choreographer mChoreographer;
    private Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        @Override
        public void doFrame(long frameTimeNanos) {
            RemoteComposeCanvas.this.mARContext.currentTime = frameTimeNanos / 1000000L;
            RemoteComposeCanvas.this.mARContext.setDebug(RemoteComposeCanvas.this.mDebug);
            RemoteComposeCanvas.this.postInvalidateOnAnimation();
        }
    };
    private VelocityTracker mVelocityTracker = null;
    private static final float[] sScaleOutput = new float[2];
    private int mCount;
    private long mTime = System_Delegate.nanoTime();
    private long mDuration;
    private boolean mEvalTime = false;
    private float mLastAnimationTime = 0.1f;
    private boolean mDisable = false;

    public RemoteComposeCanvas(Context context) {
        super(context);
        this.addOnAttachStateChangeListener(this);
    }

    public RemoteComposeCanvas(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addOnAttachStateChangeListener(this);
    }

    public RemoteComposeCanvas(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(-1);
        this.addOnAttachStateChangeListener(this);
    }

    public void setDebug(int value) {
        if (this.mDebug != value) {
            this.mDebug = value;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof ClickAreaView)) continue;
                ((ClickAreaView)child).setDebug(this.mDebug == 1);
            }
            this.invalidate();
        }
    }

    public void setDocument(RemoteComposeDocument value) {
        this.mDocument = value;
        this.mMaxFrameRate = 60.0f;
        this.mDocument.initializeContext(this.mARContext);
        this.mDisable = false;
        this.mARContext.setDocLoadTime();
        this.mARContext.setAnimationEnabled(true);
        this.mARContext.setDensity(this.mDensity);
        this.mARContext.setUseChoreographer(true);
        this.setContentDescription(this.mDocument.getDocument().getContentDescription());
        this.updateClickAreas();
        this.requestLayout();
        this.mARContext.loadFloat(29, -3.4028235E38f);
        this.mARContext.loadFloat(33, this.getDefaultTextSize());
        this.invalidate();
        Integer fps = (Integer)this.mDocument.getDocument().getProperty((short)8);
        if (fps != null && fps > 0) {
            this.mMaxFrameRate = fps.intValue();
            this.mMaxFrameDelay = (long)(1000.0f / this.mMaxFrameRate);
        }
    }

    @Override
    public void onViewAttachedToWindow(View view) {
        if (this.mChoreographer == null) {
            this.mChoreographer = Choreographer.getInstance();
            this.mChoreographer.postFrameCallback(this.mFrameCallback);
        }
        this.mDensity = this.getContext().getResources().getDisplayMetrics().density;
        this.mARContext.setDensity(this.mDensity);
        if (this.mDocument == null) {
            return;
        }
        this.updateClickAreas();
    }

    private void updateClickAreas() {
        if (this.mDocument != null) {
            this.mHasClickAreas = false;
            Set<CoreDocument.ClickAreaRepresentation> clickAreas = this.mDocument.getDocument().getClickAreas();
            this.removeAllViews();
            for (CoreDocument.ClickAreaRepresentation area : clickAreas) {
                ClickAreaView viewArea = new ClickAreaView(this.getContext(), this.mDebug == 1, area.getId(), area.getContentDescription(), area.getMetadata());
                int w = (int)area.width();
                int h = (int)area.height();
                FrameLayout.LayoutParams param = new FrameLayout.LayoutParams(w, h);
                param.width = w;
                param.height = h;
                param.leftMargin = (int)area.getLeft();
                param.topMargin = (int)area.getTop();
                viewArea.setOnClickListener(view1 -> this.mDocument.getDocument().performClick(this.mARContext, area.getId(), area.getMetadata()));
                this.addView((View)viewArea, param);
            }
            if (!clickAreas.isEmpty()) {
                this.mHasClickAreas = true;
            }
        }
    }

    public void setHapticEngine(CoreDocument.HapticEngine engine) {
        this.mDocument.getDocument().setHapticEngine(engine);
    }

    @Override
    public void onViewDetachedFromWindow(View view) {
        if (this.mChoreographer != null) {
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            this.mChoreographer = null;
        }
        this.removeAllViews();
    }

    public String[] getNamedColors() {
        return this.mDocument.getNamedColors();
    }

    public String[] getNamedVariables(int type) {
        return this.mDocument.getNamedVariables(type);
    }

    public void setColor(String colorName, int colorValue) {
        this.mARContext.setNamedColorOverride(colorName, colorValue);
    }

    public void setLong(String name, long value) {
        this.mARContext.setNamedLong(name, value);
    }

    public RemoteComposeDocument getDocument() {
        return this.mDocument;
    }

    public void setLocalString(String name, String content) {
        this.mARContext.setNamedStringOverride(name, content);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void clearLocalString(String name) {
        this.mARContext.clearNamedStringOverride(name);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void setLocalInt(String name, int content) {
        this.mARContext.setNamedIntegerOverride(name, content);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void clearLocalInt(String name) {
        this.mARContext.clearNamedIntegerOverride(name);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void setLocalColor(String name, int content) {
        this.mARContext.setNamedColorOverride(name, content);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void clearLocalColor(String name) {
        this.mARContext.clearNamedDataOverride(name);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void setLocalFloat(String name, Float content) {
        this.mARContext.setNamedFloatOverride(name, content.floatValue());
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void clearLocalFloat(String name) {
        this.mARContext.clearNamedFloatOverride(name);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void setLocalBitmap(String name, Bitmap content) {
        this.mARContext.setNamedDataOverride(name, content);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public void clearLocalBitmap(String name) {
        this.mARContext.clearNamedDataOverride(name);
        if (this.mDocument != null) {
            this.mDocument.invalidate();
        }
    }

    public int hasSensorListeners(int[] ids) {
        int count = 0;
        for (int id2 = 17; id2 <= 26; ++id2) {
            if (!this.mARContext.mRemoteComposeState.hasListener(id2)) continue;
            ids[count++] = id2;
        }
        return count;
    }

    public void setExternalFloat(int id2, float value) {
        this.mARContext.loadFloat(id2, value);
    }

    public boolean isDraggable() {
        if (this.mDocument == null) {
            return false;
        }
        return this.mDocument.getDocument().hasTouchListener();
    }

    public void checkShaders(CoreDocument.ShaderControl shaderControl) {
        this.mDocument.getDocument().checkShaders(this.mARContext, shaderControl);
    }

    public void setUseChoreographer(boolean value) {
        this.mARContext.setUseChoreographer(value);
    }

    public RemoteContext getRemoteContext() {
        return this.mARContext;
    }

    public void addIdActionListener(ClickCallbacks callback) {
        if (this.mDocument == null) {
            return;
        }
        this.mDocument.getDocument().addIdActionListener((int id2, String metadata) -> callback.click(id2, metadata));
    }

    public int getTheme() {
        return this.mTheme;
    }

    public void setTheme(int theme) {
        this.mTheme = theme;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int index = event.getActionIndex();
        int action = event.getActionMasked();
        int pointerId = event.getPointerId(index);
        if (this.mHasClickAreas) {
            return super.onTouchEvent(event);
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.mActionDownPoint.x = (int)event.getX();
                this.mActionDownPoint.y = (int)event.getY();
                CoreDocument doc = this.mDocument.getDocument();
                if (doc.hasTouchListener()) {
                    this.mARContext.loadFloat(29, this.mARContext.getAnimationTime());
                    this.mInActionDown = true;
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    } else {
                        this.mVelocityTracker.clear();
                    }
                    this.mVelocityTracker.addMovement(event);
                    doc.touchDown(this.mARContext, event.getX(), event.getY());
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 3: {
                this.mInActionDown = false;
                CoreDocument doc = this.mDocument.getDocument();
                if (doc.hasTouchListener()) {
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float dx = this.mVelocityTracker.getXVelocity(pointerId);
                    float dy = this.mVelocityTracker.getYVelocity(pointerId);
                    doc.touchCancel(this.mARContext, event.getX(), event.getY(), dx, dy);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 1: {
                this.mInActionDown = false;
                this.performClick();
                CoreDocument doc = this.mDocument.getDocument();
                if (doc.hasTouchListener()) {
                    this.mARContext.loadFloat(29, this.mARContext.getAnimationTime());
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float dx = this.mVelocityTracker.getXVelocity(pointerId);
                    float dy = this.mVelocityTracker.getYVelocity(pointerId);
                    doc.touchUp(this.mARContext, event.getX(), event.getY(), dx, dy);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.mInActionDown) {
                    if (this.mVelocityTracker != null) {
                        this.mARContext.loadFloat(29, this.mARContext.getAnimationTime());
                        this.mVelocityTracker.addMovement(event);
                        CoreDocument doc = this.mDocument.getDocument();
                        boolean repaint = doc.touchDrag(this.mARContext, event.getX(), event.getY());
                        if (repaint) {
                            this.invalidate();
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean performClick() {
        if (this.mHasClickAreas) {
            return super.performClick();
        }
        this.mDocument.getDocument().onClick(this.mARContext, this.mActionDownPoint.x, this.mActionDownPoint.y);
        super.performClick();
        this.invalidate();
        return true;
    }

    public int measureDimension(int measureSpec, int intrinsicSize) {
        int result = intrinsicSize;
        int mode = View.MeasureSpec.getMode(measureSpec);
        int size = View.MeasureSpec.getSize(measureSpec);
        switch (mode) {
            case 0x40000000: {
                result = size;
                break;
            }
            case -2147483648: {
                result = Integer.min(size, intrinsicSize);
                break;
            }
            case 0: {
                result = intrinsicSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mDocument == null) {
            return;
        }
        int preWidth = this.getWidth();
        int preHeight = this.getHeight();
        int w = this.measureDimension(widthMeasureSpec, this.mDocument.getWidth());
        int h = this.measureDimension(heightMeasureSpec, this.mDocument.getHeight());
        this.setMeasuredDimension(w, h);
        if (preWidth != w || preHeight != h) {
            this.mDocument.getDocument().invalidateMeasure();
        }
    }

    public float getEvalTime() {
        if (!this.mEvalTime) {
            this.mEvalTime = true;
            return 0.0f;
        }
        double avg = (double)this.mDuration / (double)this.mCount;
        if (this.mCount > 100) {
            this.mDuration /= 2L;
            this.mCount /= 2;
        }
        return (float)(avg * 1.0E-6);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDocument == null) {
            return;
        }
        if (this.mDisable) {
            this.drawDisable(canvas);
            return;
        }
        try {
            int nextFrame;
            long start = this.mEvalTime ? System_Delegate.nanoTime() : 0L;
            float animationTime = (float)(System_Delegate.nanoTime() - this.mStart) * 1.0E-9f;
            this.mARContext.setAnimationTime(animationTime);
            this.mARContext.loadFloat(30, animationTime);
            float loopTime = animationTime - this.mLastAnimationTime;
            this.mARContext.loadFloat(31, loopTime);
            this.mLastAnimationTime = animationTime;
            this.mARContext.setAnimationEnabled(true);
            this.mARContext.currentTime = System_Delegate.currentTimeMillis();
            this.mARContext.setDebug(this.mDebug);
            float density = this.getContext().getResources().getDisplayMetrics().density;
            this.mARContext.useCanvas(canvas);
            this.mARContext.mWidth = this.getWidth();
            this.mARContext.mHeight = this.getHeight();
            this.mDocument.paint(this.mARContext, this.mTheme);
            if (this.mDebug == 1) {
                ++this.mCount;
                if (System_Delegate.nanoTime() - this.mTime > 1000000000L) {
                    System.out.println(" count " + this.mCount + " fps");
                    this.mCount = 0;
                    this.mTime = System_Delegate.nanoTime();
                }
            }
            if ((nextFrame = this.mDocument.needsRepaint()) > 0) {
                this.mLastFrameDelay = this.mMaxFrameRate >= 60.0f ? (long)nextFrame : Math.max(this.mMaxFrameDelay, (long)nextFrame);
                if (this.mChoreographer != null) {
                    if (this.mDebug == 1) {
                        System.err.println("RC : POST CHOREOGRAPHER WITH " + this.mLastFrameDelay + " (nextFrame was " + nextFrame + ", max delay " + this.mMaxFrameDelay + ",  max framerate is " + this.mMaxFrameRate + ")");
                    }
                    this.mChoreographer.postFrameCallbackDelayed(this.mFrameCallback, this.mLastFrameDelay);
                }
                if (!this.mARContext.useChoreographer()) {
                    this.invalidate();
                }
            } else if (this.mChoreographer != null) {
                this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            }
            if (this.mEvalTime) {
                this.mDuration += System_Delegate.nanoTime() - start;
                ++this.mCount;
            }
        }
        catch (Exception ex) {
            this.mARContext.getLastOpCount();
            this.mDisable = true;
            this.invalidate();
        }
        if (this.mDebug == 1) {
            long frameDelay = System_Delegate.currentTimeMillis() - this.mLastFrameCall;
            System.err.println("RC : Delay since last frame " + frameDelay + " ms (" + 1000.0f / (float)frameDelay + " fps)");
            this.mLastFrameCall = System_Delegate.currentTimeMillis();
        }
    }

    private void drawDisable(Canvas canvas) {
        Rect rect = new Rect();
        canvas.drawColor(-16777216);
        Paint paint = new Paint();
        paint.setTextSize(128.0f);
        paint.setColor(-65536);
        int w = this.getWidth();
        int h = this.getHeight();
        String str = "\u26a0";
        paint.getTextBounds(str, 0, 1, rect);
        float x = (float)w / 2.0f - (float)rect.width() / 2.0f - (float)rect.left;
        float y = (float)h / 2.0f + (float)rect.height() / 2.0f - (float)rect.bottom;
        canvas.drawText(str, x, y, paint);
    }

    private float getDefaultTextSize() {
        return new TextView(this.getContext()).getTextSize();
    }

    public static interface ClickCallbacks {
        public void click(int var1, String var2);
    }
}

